/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.common.HashMapMessage;
import org.mule.api.callback.SourceCallback;

public class SalesforceBayeuxMessageListener
implements ClientSessionChannel.MessageListener {
    private static final Logger LOGGER = Logger.getLogger(SalesforceBayeuxMessageListener.class);
    private final SourceCallback callback;

    public SalesforceBayeuxMessageListener(SourceCallback callback) {
        this.callback = callback;
    }

    public void onMessage(ClientSessionChannel channel, Message message) {
        try {
            if (message instanceof HashMapMessage) {
                HashMapMessage hashMapMessage = (HashMapMessage)message;
                HashMap<String, Object> inboundProperties = new HashMap<String, Object>();
                if (!hashMapMessage.containsKey((Object)"channel")) {
                    LOGGER.error((Object)"The event does not contain the channel");
                } else {
                    inboundProperties.put("channel", hashMapMessage.get((Object)"channel"));
                }
                if (!hashMapMessage.containsKey((Object)"data")) {
                    LOGGER.error((Object)"The event does not contain any data?");
                } else {
                    HashMap data = (HashMap)hashMapMessage.get((Object)"data");
                    Map sObject = (Map)data.get("sobject");
                    Map event = (Map)data.get("event");
                    if (sObject == null) {
                        LOGGER.error((Object)"The data of the event does not contain an SObject");
                    } else if (event == null) {
                        LOGGER.error((Object)"The data of the event does not contain event information");
                    } else {
                        for (Map.Entry entry : event.entrySet()) {
                            inboundProperties.put((String)entry.getKey(), entry.getValue());
                        }
                        this.callback.process((Object)sObject, inboundProperties);
                    }
                }
            } else {
                this.callback.process(message.getData());
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
    }
}

