/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.connectivity;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.pool.KeyedObjectPool;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.api.MetadataAware;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.MuleContextAware;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.devkit.capability.Capabilities;
import org.mule.api.devkit.capability.ModuleCapability;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.api.store.ObjectStore;
import org.mule.common.DefaultResult;
import org.mule.common.DefaultTestResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.TestResult;
import org.mule.common.Testable;
import org.mule.common.metadata.ConnectorMetaDataEnabled;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataFailureType;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.NativeQueryMetadataTranslator;
import org.mule.common.query.DsqlQuery;
import org.mule.config.PoolingProfile;
import org.mule.devkit.processor.ExpressionEvaluatorSupport;
import org.mule.modules.salesforce.adapters.SalesforceConnectorConnectionIdentifierAdapter;
import org.mule.modules.salesforce.connection.ConnectionManager;
import org.mule.modules.salesforce.connection.UnableToAcquireConnectionException;
import org.mule.modules.salesforce.connectivity.ManagedConnectionProcessTemplate;
import org.mule.modules.salesforce.connectivity.SalesforceConnectorConnectionFactory;
import org.mule.modules.salesforce.connectivity.SalesforceConnectorConnectionKey;
import org.mule.modules.salesforce.pooling.DevkitGenericKeyedObjectPool;

public class SalesforceConnectorConnectionManager
extends ExpressionEvaluatorSupport
implements MetadataAware,
MuleContextAware,
ProcessAdapter<SalesforceConnectorConnectionIdentifierAdapter>,
Capabilities,
Disposable,
Initialisable,
Testable,
ConnectorMetaDataEnabled,
NativeQueryMetadataTranslator,
ConnectionManager<SalesforceConnectorConnectionKey, SalesforceConnectorConnectionIdentifierAdapter> {
    private String username;
    private String password;
    private String securityToken;
    private String url;
    private String proxyHost;
    private int proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String sessionId;
    private String serviceEndpoint;
    private ObjectStore<? extends Serializable> timeObjectStore;
    private String clientId;
    private String assignmentRuleId;
    private Boolean useDefaultRule;
    private Integer batchSobjectMaxDepth;
    private Boolean allowFieldTruncationSupport;
    protected MuleContext muleContext;
    protected FlowConstruct flowConstruct;
    private KeyedObjectPool connectionPool;
    protected PoolingProfile poolingProfile;
    protected RetryPolicyTemplate retryPolicyTemplate;
    private static final String MODULE_NAME = "Salesforce";
    private static final String MODULE_VERSION = "5.4.8";
    private static final String DEVKIT_VERSION = "3.5.1";
    private static final String DEVKIT_BUILD = "UNNAMED.1967.45d0eb0";
    private static final String MIN_MULE_VERSION = "3.5";

    public void setTimeObjectStore(ObjectStore<? extends Serializable> value) {
        this.timeObjectStore = value;
    }

    public ObjectStore<? extends Serializable> getTimeObjectStore() {
        return this.timeObjectStore;
    }

    public void setClientId(String value) {
        this.clientId = value;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setAssignmentRuleId(String value) {
        this.assignmentRuleId = value;
    }

    public String getAssignmentRuleId() {
        return this.assignmentRuleId;
    }

    public void setUseDefaultRule(Boolean value) {
        this.useDefaultRule = value;
    }

    public Boolean getUseDefaultRule() {
        return this.useDefaultRule;
    }

    public void setBatchSobjectMaxDepth(Integer value) {
        this.batchSobjectMaxDepth = value;
    }

    public Integer getBatchSobjectMaxDepth() {
        return this.batchSobjectMaxDepth;
    }

    public void setAllowFieldTruncationSupport(Boolean value) {
        this.allowFieldTruncationSupport = value;
    }

    public Boolean getAllowFieldTruncationSupport() {
        return this.allowFieldTruncationSupport;
    }

    public void setMuleContext(MuleContext value) {
        this.muleContext = value;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setFlowConstruct(FlowConstruct value) {
        this.flowConstruct = value;
    }

    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    public void setPoolingProfile(PoolingProfile value) {
        this.poolingProfile = value;
    }

    public PoolingProfile getPoolingProfile() {
        return this.poolingProfile;
    }

    public void setRetryPolicyTemplate(RetryPolicyTemplate value) {
        this.retryPolicyTemplate = value;
    }

    @Override
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    public void setProxyUsername(String value) {
        this.proxyUsername = value;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setUsername(String value) {
        this.username = value;
    }

    public String getUsername() {
        return this.username;
    }

    public void setSessionId(String value) {
        this.sessionId = value;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setProxyHost(String value) {
        this.proxyHost = value;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setSecurityToken(String value) {
        this.securityToken = value;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public void setServiceEndpoint(String value) {
        this.serviceEndpoint = value;
    }

    public String getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public void setProxyPort(int value) {
        this.proxyPort = value;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public String getPassword() {
        return this.password;
    }

    public void setProxyPassword(String value) {
        this.proxyPassword = value;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setUrl(String value) {
        this.url = value;
    }

    public String getUrl() {
        return this.url;
    }

    public void initialise() {
        this.connectionPool = new DevkitGenericKeyedObjectPool(new SalesforceConnectorConnectionFactory(this), this.poolingProfile);
        if (this.retryPolicyTemplate == null) {
            this.retryPolicyTemplate = (RetryPolicyTemplate)this.muleContext.getRegistry().lookupObject("_defaultRetryPolicyTemplate");
        }
    }

    public void dispose() {
        try {
            this.connectionPool.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public SalesforceConnectorConnectionIdentifierAdapter acquireConnection(SalesforceConnectorConnectionKey key) throws Exception {
        return (SalesforceConnectorConnectionIdentifierAdapter)this.connectionPool.borrowObject((Object)key);
    }

    @Override
    public void releaseConnection(SalesforceConnectorConnectionKey key, SalesforceConnectorConnectionIdentifierAdapter connection) throws Exception {
        this.connectionPool.returnObject((Object)key, (Object)connection);
    }

    @Override
    public void destroyConnection(SalesforceConnectorConnectionKey key, SalesforceConnectorConnectionIdentifierAdapter connection) throws Exception {
        this.connectionPool.invalidateObject((Object)key, (Object)connection);
    }

    public boolean isCapableOf(ModuleCapability capability) {
        if (capability == ModuleCapability.LIFECYCLE_CAPABLE) {
            return true;
        }
        return capability == ModuleCapability.CONNECTION_MANAGEMENT_CAPABLE;
    }

    public <P> ProcessTemplate<P, SalesforceConnectorConnectionIdentifierAdapter> getProcessTemplate() {
        return new ManagedConnectionProcessTemplate(this, this.muleContext);
    }

    @Override
    public SalesforceConnectorConnectionKey getDefaultConnectionKey() {
        return new SalesforceConnectorConnectionKey(this.getUsername(), this.getPassword(), this.getSecurityToken(), this.getUrl(), this.getProxyHost(), this.getProxyPort(), this.getProxyUsername(), this.getProxyPassword(), this.getSessionId(), this.getServiceEndpoint());
    }

    @Override
    public SalesforceConnectorConnectionKey getEvaluatedConnectionKey(MuleEvent event) throws Exception {
        if (event != null) {
            String _transformedUsername = (String)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("username").getGenericType(), null, this.getUsername());
            if (_transformedUsername == null) {
                throw new UnableToAcquireConnectionException("Parameter username in method connect can't be null because is not @Optional");
            }
            String _transformedPassword = (String)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("password").getGenericType(), null, this.getPassword());
            if (_transformedPassword == null) {
                throw new UnableToAcquireConnectionException("Parameter password in method connect can't be null because is not @Optional");
            }
            String _transformedSecurityToken = (String)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("securityToken").getGenericType(), null, this.getSecurityToken());
            String _transformedUrl = (String)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("url").getGenericType(), null, this.getUrl());
            String _transformedProxyHost = (String)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("proxyHost").getGenericType(), null, this.getProxyHost());
            Integer _transformedProxyPort = (Integer)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("proxyPort").getGenericType(), null, this.getProxyPort());
            String _transformedProxyUsername = (String)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("proxyUsername").getGenericType(), null, this.getProxyUsername());
            String _transformedProxyPassword = (String)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("proxyPassword").getGenericType(), null, this.getProxyPassword());
            String _transformedSessionId = (String)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("sessionId").getGenericType(), null, this.getSessionId());
            String _transformedServiceEndpoint = (String)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("serviceEndpoint").getGenericType(), null, this.getServiceEndpoint());
            return new SalesforceConnectorConnectionKey(_transformedUsername, _transformedPassword, _transformedSecurityToken, _transformedUrl, _transformedProxyHost, _transformedProxyPort, _transformedProxyUsername, _transformedProxyPassword, _transformedSessionId, _transformedServiceEndpoint);
        }
        return this.getDefaultConnectionKey();
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getModuleVersion() {
        return MODULE_VERSION;
    }

    public String getDevkitVersion() {
        return DEVKIT_VERSION;
    }

    public String getDevkitBuild() {
        return DEVKIT_BUILD;
    }

    public String getMinMuleVersion() {
        return MIN_MULE_VERSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult test() {
        DefaultTestResult result;
        SalesforceConnectorConnectionIdentifierAdapter connection = null;
        SalesforceConnectorConnectionKey key = this.getDefaultConnectionKey();
        try {
            connection = this.acquireConnection(key);
            result = new DefaultTestResult(Result.Status.SUCCESS);
        }
        catch (Exception e) {
            try {
                this.destroyConnection(key, connection);
            }
            catch (Exception ie) {
                // empty catch block
            }
            result = (DefaultTestResult)this.buildFailureTestResult(e);
        }
        finally {
            if (connection != null) {
                try {
                    this.releaseConnection(key, connection);
                }
                catch (Exception ie) {}
            }
        }
        return result;
    }

    public DefaultResult buildFailureTestResult(Exception exception) {
        ConnectionExceptionCode code;
        DefaultTestResult result = exception instanceof ConnectionException ? ((code = ((ConnectionException)exception).getCode()) == ConnectionExceptionCode.UNKNOWN_HOST ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.UNKNOWN_HOST, (Throwable)exception) : (code == ConnectionExceptionCode.CANNOT_REACH ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.RESOURCE_UNAVAILABLE, (Throwable)exception) : (code == ConnectionExceptionCode.INCORRECT_CREDENTIALS ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.INVALID_CREDENTIALS, (Throwable)exception) : (code == ConnectionExceptionCode.CREDENTIALS_EXPIRED ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.INVALID_CREDENTIALS, (Throwable)exception) : (code == ConnectionExceptionCode.UNKNOWN ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.UNSPECIFIED, (Throwable)exception) : new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.UNSPECIFIED, (Throwable)exception)))))) : new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.UNSPECIFIED, (Throwable)exception);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Result<List<MetaDataKey>> getMetaDataKeys() {
        SalesforceConnectorConnectionIdentifierAdapter connection = null;
        SalesforceConnectorConnectionKey key = this.getDefaultConnectionKey();
        try {
            connection = this.acquireConnection(key);
            try {
                DefaultResult defaultResult = new DefaultResult(connection.getMetaDataKeys(), Result.Status.SUCCESS);
                return defaultResult;
            }
            catch (Exception e) {
                DefaultResult ie;
                block19: {
                    ie = new DefaultResult(null, Result.Status.FAILURE, "There was an error retrieving the metadata keys from service provider after acquiring connection, for more detailed information please read the provided stacktrace", (FailureType)MetaDataFailureType.ERROR_METADATA_KEYS_RETRIEVER, (Throwable)e);
                    if (connection == null) break block19;
                    try {
                        this.releaseConnection(key, connection);
                    }
                    catch (Exception ie2) {
                        // empty catch block
                    }
                }
                return ie;
                catch (Exception e2) {
                    try {
                        this.destroyConnection(key, connection);
                    }
                    catch (Exception ie3) {
                        // empty catch block
                    }
                    DefaultResult defaultResult = this.buildFailureTestResult(e2);
                    return defaultResult;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (connection != null) {
                try {
                    this.releaseConnection(key, connection);
                }
                catch (Exception ie) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Result<MetaData> getMetaData(MetaDataKey metaDataKey) {
        SalesforceConnectorConnectionIdentifierAdapter connection = null;
        SalesforceConnectorConnectionKey key = this.getDefaultConnectionKey();
        try {
            connection = this.acquireConnection(key);
            try {
                DefaultResult defaultResult = new DefaultResult((Object)connection.getMetaData(metaDataKey));
                return defaultResult;
            }
            catch (Exception e) {
                DefaultResult ie;
                block19: {
                    ie = new DefaultResult(null, Result.Status.FAILURE, this.getMetaDataException(metaDataKey), (FailureType)MetaDataFailureType.ERROR_METADATA_RETRIEVER, (Throwable)e);
                    if (connection == null) break block19;
                    try {
                        this.releaseConnection(key, connection);
                    }
                    catch (Exception ie2) {
                        // empty catch block
                    }
                }
                return ie;
                catch (Exception e2) {
                    try {
                        this.destroyConnection(key, connection);
                    }
                    catch (Exception ie3) {
                        // empty catch block
                    }
                    DefaultResult defaultResult = this.buildFailureTestResult(e2);
                    return defaultResult;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (connection != null) {
                try {
                    this.releaseConnection(key, connection);
                }
                catch (Exception ie) {}
            }
        }
    }

    private String getMetaDataException(MetaDataKey key) {
        if (key != null && key.getId() != null) {
            return "There was an error retrieving metadata from key: " + key.getId() + " after acquiring the connection, for more detailed information please read the provided stacktrace";
        }
        return "There was an error retrieving metadata after acquiring the connection, MetaDataKey is null or its id is null, for more detailed information please read the provided stacktrace";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result<String> toNativeQuery(DsqlQuery query) {
        DefaultResult result;
        SalesforceConnectorConnectionIdentifierAdapter connection = null;
        SalesforceConnectorConnectionKey key = this.getDefaultConnectionKey();
        try {
            connection = this.acquireConnection(key);
            result = new DefaultResult((Object)connection.toNativeQuery(query).toString());
        }
        catch (Exception e) {
            try {
                this.destroyConnection(key, connection);
            }
            catch (Exception ie) {
                // empty catch block
            }
            result = new DefaultResult(null, Result.Status.FAILURE, e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    this.releaseConnection(key, connection);
                }
                catch (Exception ie) {}
            }
        }
        return result;
    }
}

