/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.oauth;

import java.io.Serializable;
import org.mule.api.store.ObjectStore;
import org.mule.common.security.oauth.OAuthState;
import org.mule.modules.salesforce.adapters.SalesforceOAuthConnectorOAuth2Adapter;
import org.mule.modules.salesforce.oauth.SalesforceOAuthConnectorOAuthManager;
import org.mule.security.oauth.BaseOAuthClientFactory;
import org.mule.security.oauth.OAuth2Adapter;
import org.mule.security.oauth.OAuth2Manager;

public class SalesforceOAuthConnectorOAuthClientFactory
extends BaseOAuthClientFactory {
    private SalesforceOAuthConnectorOAuthManager oauthManager;

    public SalesforceOAuthConnectorOAuthClientFactory(OAuth2Manager<OAuth2Adapter> oauthManager, ObjectStore<Serializable> objectStore) {
        super(oauthManager, objectStore);
        this.oauthManager = (SalesforceOAuthConnectorOAuthManager)oauthManager;
    }

    protected Class<? extends OAuth2Adapter> getAdapterClass() {
        return SalesforceOAuthConnectorOAuth2Adapter.class;
    }

    protected void setCustomAdapterProperties(OAuth2Adapter adapter, OAuthState state) {
        SalesforceOAuthConnectorOAuth2Adapter connector = (SalesforceOAuthConnectorOAuth2Adapter)adapter;
        connector.setInstanceId(state.getCustomProperty("instanceId"));
        connector.setUserId(state.getCustomProperty("userId"));
        connector.setTimeObjectStore(this.oauthManager.getTimeObjectStore());
        connector.setClientId(this.oauthManager.getClientId());
        connector.setAssignmentRuleId(this.oauthManager.getAssignmentRuleId());
        connector.setUseDefaultRule(this.oauthManager.getUseDefaultRule());
        connector.setBatchSobjectMaxDepth(this.oauthManager.getBatchSobjectMaxDepth());
        connector.setAllowFieldTruncationSupport(this.oauthManager.getAllowFieldTruncationSupport());
    }

    protected void setCustomStateProperties(OAuth2Adapter adapter, OAuthState state) {
        SalesforceOAuthConnectorOAuth2Adapter connector = (SalesforceOAuthConnectorOAuth2Adapter)adapter;
        state.setCustomProperty("instanceId", connector.getInstanceId());
        state.setCustomProperty("userId", connector.getUserId());
    }
}

