/*
 * Decompiled with CFR 0.152.
 */
package org.mule.configuration;

import java.util.HashMap;
import java.util.Map;
import org.mule.configuration.parser.ConfigurationParser;

public class Configuration {
    private static final String EXT_CONFIGURATION_FILE_PATH = "./doc/configReadme.xml";
    private static final String DEFAULT_CONFIGURATION_FILE_NAME = "default_sections.xml";
    private final Map<String, String> sections = new HashMap<String, String>();
    private final Map<String, String> placeholders = new HashMap<String, String>();
    private ConfigurationParser defaultConfigurationParser;
    private ConfigurationParser extensionConfigurationParser;

    public Configuration() {
        this(DEFAULT_CONFIGURATION_FILE_NAME, EXT_CONFIGURATION_FILE_PATH);
    }

    public Configuration(String defaultConfigurationFileName, String configurationFilePath) {
        try {
            this.defaultConfigurationParser = new ConfigurationParser(defaultConfigurationFileName);
            this.extensionConfigurationParser = new ConfigurationParser(configurationFilePath);
        }
        catch (Exception e) {
            throw new RuntimeException("There has been an error parsing the configuration file: " + e.getMessage());
        }
        this.initialise();
    }

    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    public Map<String, String> getSections() {
        return this.sections;
    }

    private void initialise() {
        this.populateSections();
        this.populatePlaceHolders();
    }

    private void populatePlaceHolders() {
        for (String key : this.defaultConfigurationParser.getPlaceHolders().keySet()) {
            this.placeholders.put(key, this.defaultConfigurationParser.getPlaceHolders().get(key));
        }
        for (String key : this.extensionConfigurationParser.getPlaceHolders().keySet()) {
            this.placeholders.put(key, this.extensionConfigurationParser.getPlaceHolders().get(key));
        }
    }

    private void populateSections() {
        for (String key : this.defaultConfigurationParser.getSections().keySet()) {
            this.sections.put(key, this.defaultConfigurationParser.getSections().get(key));
        }
        for (String key : this.extensionConfigurationParser.getSections().keySet()) {
            this.sections.put(key, this.extensionConfigurationParser.getSections().get(key));
        }
    }
}

