package org.mule.writer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import org.apache.commons.lang.StringUtils;

public class ReadMeWriter {
	private static final String DEFAULT_FILE_PATH = "./README.md";

	public static void writeContentTo(String content, String filePath) throws IOException {

		if (StringUtils.isBlank(filePath)) {
			filePath = DEFAULT_FILE_PATH;
		}

		File file = new File(filePath);

		// if file doesnt exists, then create it
		if (!file.exists()) {
			file.createNewFile();
		}

		FileWriter fw = new FileWriter(file.getAbsoluteFile());
		BufferedWriter bw = new BufferedWriter(fw);
		bw.write(content);
		bw.close();

	}
}