/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.misc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileListUtils {
    private final Log log;

    public FileListUtils(Log log) {
        this.log = log;
    }

    public FileListUtils() {
        this.log = null;
    }

    public Map<File, InputStream> toStreamsOrFail(List<String> absolutePaths) throws MojoExecutionException {
        Map<File, InputStream> streams = this.toFiles(absolutePaths);
        if ((streams == null || streams.size() == 0) && absolutePaths.size() > 0) {
            throw new MojoExecutionException("Error: None of the following files could be parsed: " + absolutePaths);
        }
        return streams;
    }

    public Map<File, InputStream> toFiles(List<String> absolutePaths) {
        HashMap<File, InputStream> fileStreams = new HashMap<File, InputStream>();
        for (String absolutePath : absolutePaths) {
            this.createFile(fileStreams, new File(absolutePath));
        }
        return fileStreams;
    }

    public Map<File, InputStream> toStreamFromFiles(List<File> files) {
        HashMap<File, InputStream> fileStreams = new HashMap<File, InputStream>();
        for (File file : files) {
            this.createFile(fileStreams, file);
        }
        return fileStreams;
    }

    void createFile(Map<File, InputStream> fileStreams, File file) {
        try {
            File absoluteFile = file.getAbsoluteFile();
            fileStreams.put(absoluteFile, new FileInputStream(absoluteFile));
        }
        catch (FileNotFoundException e) {
            if (this.log != null) {
                this.log.error((CharSequence)("Error opening file [" + file + "]"), (Throwable)e);
            }
            throw new RuntimeException(e);
        }
    }
}

