/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.input;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;
import org.mule.tools.apikit.misc.APIKitTools;
import org.mule.tools.apikit.model.API;
import org.mule.tools.apikit.model.APIFactory;
import org.mule.tools.apikit.model.ResourceActionMimeTypeTriplet;
import org.mule.tools.apikit.output.GenerationModel;
import org.raml.model.Action;
import org.raml.model.MimeType;
import org.raml.model.Raml;
import org.raml.model.Resource;
import org.raml.parser.loader.CompositeResourceLoader;
import org.raml.parser.loader.DefaultResourceLoader;
import org.raml.parser.loader.FileResourceLoader;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.tagresolver.TagResolver;
import org.raml.parser.visitor.RamlDocumentBuilder;
import org.raml.parser.visitor.RamlValidationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RAMLFilesParser {
    private Map<ResourceActionMimeTypeTriplet, GenerationModel> entries = new HashMap<ResourceActionMimeTypeTriplet, GenerationModel>();
    private final APIFactory apiFactory;
    private final Log log;

    public RAMLFilesParser(Log log, Map<File, InputStream> fileStreams, APIFactory apiFactory) {
        this.log = log;
        this.apiFactory = apiFactory;
        ArrayList<File> processedFiles = new ArrayList<File>();
        for (Map.Entry<File, InputStream> fileInputStreamEntry : fileStreams.entrySet()) {
            String content;
            File ramlFile = fileInputStreamEntry.getKey();
            try {
                content = IOUtils.toString((InputStream)fileInputStreamEntry.getValue());
            }
            catch (IOException ioe) {
                this.log.info((CharSequence)("Error loading file " + ramlFile.getName()));
                break;
            }
            CompositeResourceLoader resourceLoader = new CompositeResourceLoader(new ResourceLoader[]{new DefaultResourceLoader(), new FileResourceLoader(ramlFile.getParentFile())});
            if (!this.isValidYaml(ramlFile.getName(), content, (ResourceLoader)resourceLoader)) continue;
            RamlDocumentBuilder builderNodeHandler = new RamlDocumentBuilder((ResourceLoader)resourceLoader, new TagResolver[0]);
            try {
                Raml raml = (Raml)builderNodeHandler.build(content, ramlFile.getName());
                this.collectResources(ramlFile, raml.getResources(), "http://localhost:8081/api");
                processedFiles.add(ramlFile);
            }
            catch (Exception e) {
                log.info((CharSequence)("Could not parse [" + ramlFile + "] as root RAML file. Reason: " + e.getMessage()));
                log.debug((Throwable)e);
            }
        }
        if (processedFiles.size() > 0) {
            this.log.info((CharSequence)("The following RAML files were parsed correctly: " + processedFiles));
        } else {
            this.log.error((CharSequence)"RAML Root not found. None of the files were recognized as valid root RAML files.");
        }
    }

    private boolean isValidYaml(String fileName, String content, ResourceLoader resourceLoader) {
        List validationResults = RamlValidationService.createDefault((ResourceLoader)resourceLoader, (TagResolver[])new TagResolver[0]).validate(content, fileName);
        if (validationResults != null && !validationResults.isEmpty()) {
            this.log.info((CharSequence)("File '" + fileName + "' is not a valid root RAML file. It contains some errors/warnings. See below: "));
            int errorsFound = this.findProblems(fileName, validationResults, ValidationResult.Level.ERROR);
            this.findProblems(fileName, validationResults, ValidationResult.Level.WARN);
            if (errorsFound > 0) {
                return false;
            }
        }
        return true;
    }

    private int findProblems(String fileName, List<ValidationResult> validationResults, ValidationResult.Level problemLevel) {
        int problemCount = 0;
        for (ValidationResult validationResult : validationResults) {
            if (validationResult.getLevel() != problemLevel) continue;
            this.log.info((CharSequence)(problemLevel.name() + " " + ++problemCount + ": " + validationResult.toString()));
        }
        return problemCount;
    }

    void collectResources(File filename, Map<String, Resource> resourceMap, String baseUri) {
        for (Resource resource : resourceMap.values()) {
            for (Action action : resource.getActions().values()) {
                API api = this.apiFactory.createAPIBinding(filename, null, baseUri, null);
                String path = APIKitTools.getPathFromUri(baseUri);
                Map mimeTypes = action.getBody();
                boolean addGenericAction = false;
                if (mimeTypes != null) {
                    for (MimeType mimeType : mimeTypes.values()) {
                        if (mimeType.getSchema() != null || mimeType.getFormParameters() != null) {
                            this.addResource(api, resource, action, path, mimeType.getType());
                            continue;
                        }
                        addGenericAction = true;
                    }
                } else {
                    addGenericAction = true;
                }
                if (!addGenericAction) continue;
                this.addResource(api, resource, action, path, null);
            }
            this.collectResources(filename, resource.getResources(), baseUri);
        }
    }

    void addResource(API api, Resource resource, Action action, String path, String mimeType) {
        ResourceActionMimeTypeTriplet resourceActionTriplet = new ResourceActionMimeTypeTriplet(api, path + resource.getUri(), action.getType().toString(), mimeType);
        this.entries.put(resourceActionTriplet, new GenerationModel(api, resource, action, mimeType));
    }

    public Map<ResourceActionMimeTypeTriplet, GenerationModel> getEntries() {
        return this.entries;
    }
}

