/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.verifier.policy;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.mule.tools.api.exception.ValidationException;
import org.mule.tools.api.packager.ProjectInformation;
import org.mule.tools.api.verifier.ProjectVerifier;
import org.mule.tools.api.verifier.policy.PolicyMuleArtifactJsonVerifier;
import org.mule.tools.api.verifier.policy.PolicyYamlVerifier;

public class MulePolicyVerifier
implements ProjectVerifier {
    private static final String TEMPLATE_XML = String.join((CharSequence)File.separator, "src", "main", "mule", "template.xml");
    private final String yamlFileName;
    private final ProjectInformation projectInformation;

    public MulePolicyVerifier(ProjectInformation projectInformation) {
        this.projectInformation = projectInformation;
        this.yamlFileName = String.format("%s.yaml", projectInformation.getArtifactId());
    }

    @Override
    public void verify() throws ValidationException {
        this.allFilesPresent();
        this.validateYaml();
        this.validateJson();
    }

    private void allFilesPresent() throws ValidationException {
        for (String file : this.getNecessaryFiles()) {
            this.fileExists(this.getBaseDir(), file);
        }
    }

    private void validateYaml() throws ValidationException {
        new PolicyYamlVerifier(this.getBaseDir(), this.yamlFileName).validate();
    }

    private void validateJson() throws ValidationException {
        new PolicyMuleArtifactJsonVerifier(this.projectInformation, this.getMuleArtifactFile()).validate();
    }

    private File getMuleArtifactFile() {
        String base = String.join((CharSequence)File.separator, this.projectInformation.getBuildDirectory().toAbsolutePath().toString(), "META-INF", "mule-artifact");
        return new File(base, "mule-artifact.json");
    }

    private String getBaseDir() {
        return this.projectInformation.getProjectBaseFolder().toAbsolutePath().toString();
    }

    private List<String> getNecessaryFiles() {
        return Arrays.asList("pom.xml", "mule-artifact.json", TEMPLATE_XML, this.yamlFileName);
    }

    private void fileExists(String baseDir, String fileName) throws ValidationException {
        File file = new File(baseDir, fileName);
        if (!file.exists()) {
            throw new ValidationException(String.format("The file %s should be present.", fileName));
        }
    }
}

