#### _dw::test::Tests_
__________________________________________

This module contains all functions required to create a DataWeave test

### Example

#### Source

```dataweave
%dw 2.0
import * from dw::test::Tests
---
 "Matcher api" describedBy [
     "It should support nested matching" in  do {
         var payload = {}
         ---
         payload must [
             beObject(),
             $.foo must [
                 beNull()
             ]
         ]
     },
     "It should support simple matching" in do {
         var payload = {}
         ---
         payload must beObject()
     },

     "It should support multiple root cases" in do {
         var payload = {}
         var flowVar = {a: 123}
         ---
         [
             payload must beObject(),
             flowVar must [
                 beObject(),
                 $.a must equalTo(123)
             ]
         ]
     },
     "It should support using custom assertions" in  do {
         var payload = []
         ---
         payload must sizeOf($) > 2
     }
 ]
```

# Index

### Functions
| Name | Description|
|------|------------|
| [describedBy](#describedby ) | Defines a new test suite with the list of test cases.|
| [evalPath](#evalpath ) | Runs a specific mapping with the given context and mimetype.|
| [in](#in ) | Defines a new test case inside a test suite with its relevant context.<br>Intended to be used in combination with withConfig|
| [inputsFrom](#inputsfrom ) | Builds an object with all the inputs to be used as context for a specific mapping.|
| [outputFrom](#outputfrom ) | Returns the result of reading the expected output|
| [withConfig](#withconfig ) | Generates configuration for a test(s) that needs setup/teardown stages. Intended for it to used in combination with<br>the `in` function.|


### Variables
| Name | Description|
|------|------------|
| [ERROR_STATUS](#error_status ) | |
| [FAIL_STATUS](#fail_status ) | |
| [OK_STATUS](#ok_status ) | |
| [SKIP_STATUS](#skip_status ) | |



### Types
| Name | Description|
|------|------------|
|[TEST_STATUS](#test_status ) | Data Type that describes the result of a Test Execution|
|[TestConfig](#testconfig ) | |
|[TestResult](#testresult ) | |




### Annotations

| Name | Description|
|------|------------|
| [Skip](#skip ) | |



__________________________________________


# Functions

## **describedBy**

### _describedBy&#40;suite: String, testsToRun: Array<&#40;&#41; &#45;&#62; TestResult&#62;&#41;: TestResult_

Defines a new test suite with the list of test cases.

##### Example

###### Source

```dataweave
%dw 2.0
import * from dw::test::Tests
 ---

 "Matcher api" describedBy [
     "It should support nested matching" in  do {
         var payload = {}
         ---
         payload must [
             beObject(),
             $.foo must [
                 beNull()
             ]
         ]
     },
]
```
__________________________________________


## **evalPath**

### _evalPath&#40;dwlFilePath: String, context: Object, mimeType: String&#41;: Any_

Runs a specific mapping with the given context and mimetype.

##### Parameters

| Name | Description|
|------|------------|
| dwlFilePath   | Path inside the classpath where the runnable dataweave file is present.|
| context   | Object which contains different input values (each input name would be the key of the object).|
| mimeType   | The default mimetype if not specified on the file|


##### Example

###### Source

```dataweave
%dw 2.0
import * from dw::test::Tests
import * from dw::test::Asserts
---
"Test MyMapping" describedBy [
    "Assert SimpleScenario" in do {
        evalPath("MyMapping.dwl", inputsFrom("MyMapping/SimpleScenario"), "application/json" ) must
                  equalTo(outputFrom("MyMapping/SimpleScenario"))
    }
 ]
```
__________________________________________

### _evalPath&#40;testUrl: { content: String, url: String }, context: Object, mimeType: String&#41;: Any_

Evals a test with a given input values as a context and using the specified mimeType as default one when not specified in the file

##### Parameters

| Name | Type | Description|
|------|------|------------|
| `testUrl` | { content: String, url: String } | The test|
| `context` | Object |  The inputs|
| `mimeType` | String | The default mimetype|

__________________________________________


## **in**

### _in<Ctx <: Object&#62;&#40;testSetup: { config: TestConfig<Ctx&#62;, testName: String }, test: &#40;c: Ctx&#41; &#45;&#62; MatcherResult&#41;: TestResult_

Defines a new test case inside a test suite with its relevant context.
Intended to be used in combination with withConfig

##### Example

###### Source

```dataweave

var config = {
  setup: () -> { contextString: "context" },
  teardown: () -> {}
}
---
"It should generate context for following tests" withConfig config in do {
  $.contextString must beString()
 }

```
__________________________________________

### _in<Ctx <: Object&#62;&#40;testSetup: { config: TestConfig<Ctx&#62;, testName: String }, test: Array<&#40;c: Ctx&#41; &#45;&#62; MatcherResult&#62;&#41;: TestResult_

Defines multiple new test cases inside a test suite that share the same context.
Intended to be used in combination with withConfig

##### Example

###### Source
```dataweave

var config = {
  setup: () -> { contextString: "context" },
  teardown: () -> {}
}
---
"It should generate context for following tests" withConfig config in  [
  do { $.contextString must beString() },
  do { $.otherContext must equalTo(3) }
]
```
__________________________________________

### _in<T&#62;&#40;testName: String, testCases: &#40;Null&#41; &#45;&#62; MatcherResult&#41;: TestResult_

Defines a new test case inside a test suite with a single assertion.

##### Example

###### Source

```dataweave
"It should support nested matching" in  do {
   "foo" must beString()
}
```
__________________________________________

### _in&#40;testName: String, callback: Array<&#40;Null&#41; &#45;&#62; MatcherResult&#62;&#41;: TestResult_

Defines a new test case with multiple assertions


##### Example

###### Source

```dataweave
 "It should support multiple root cases" in do {
     var payload = {}
     var flowVar = {a: 123}
     ---
    [
        payload must beObject(),
        flowVar must [
             beObject(),
             $.a must equalTo(123)
          ]
      ]
 }
```
__________________________________________


## **inputsFrom**

### _inputsFrom&#40;dir: String&#41;: { _?: Any }_

Builds an object with all the inputs to be used as context for a specific mapping.

##### Parameters

| Name | Description|
|------|------------|
| dir | Directory where to look for the inputs folder and build the context from.|

__________________________________________


## **outputFrom**

### _outputFrom&#40;dir: String&#41;_

Returns the result of reading the expected output

##### Parameters

| Name  | Description|
|-------|------------|
| dir   | Directory where to look for the out file to make assertions on your mapping test.|

__________________________________________


## **withConfig**

### _withConfig<Ctx <: Object&#62;&#40;testName: String, config: TestConfig<Ctx&#62;&#41;_

Generates configuration for a test(s) that needs setup/teardown stages. Intended for it to used in combination with
the `in` function.

##### Example

###### Source

```dataweave

var config = {
  setup: () -> { contextString: "context", otherContext: 3 },
  teardown: () -> {}
}
---
"It should generate context for following tests" withConfig config in  [
  do { $.contextString must beString() },
  do { $.otherContext must equalTo(3) }
]
```
__________________________________________




# Variables

## **ERROR_STATUS**




## **FAIL_STATUS**




## **OK_STATUS**




## **SKIP_STATUS**





__________________________________________

# Types

### **TEST_STATUS**


Data Type that describes the result of a Test Execution

#### Definition

```dataweave
"ERROR" | "OK" | "FAIL" | "SKIP"
```


### **TestConfig**




#### Definition

```dataweave
{| setup: () -> Ctx, teardown: (c: Ctx) -> Any |}
```


### **TestResult**




#### Definition

```dataweave
{ name: String, time: Number, status: TEST_STATUS, tests?: Array<TestResult>, errorMessage?: String, skipReason?: String, location?: Location }
```



__________________________________________

# Annotations

## **Skip**



#### Annotation Definition

```dataweave
@Skip(reason: String)
```


