package org.mule.weave.v2.debugger.commands

import org.mule.weave.v2.debugger.WeaveBreakpoint
import org.mule.weave.v2.debugger.event.BreakpointAddedEvent
import org.mule.weave.v2.debugger.event.BreakpointsAddedEvent
import org.mule.weave.v2.debugger.event.DebuggerEvent

class AddBreakpointsCommand(val breakpoint: Array[WeaveBreakpoint]) extends DebuggerCommand {
  override def call(debuggingSession: WeaveDebuggerCommandInterpreter): Option[DebuggerEvent] = {
    debuggingSession.addBreakpoints(breakpoint)
    Some(BreakpointsAddedEvent(breakpoint))
  }
}
