package org.mule.weave.v2.debugger.event

import org.mule.weave.v2.debugger.DebuggerFrame
import org.mule.weave.v2.debugger.DebuggerPosition
import org.mule.weave.v2.debugger.DebuggerValue
import org.mule.weave.v2.debugger.WeaveBreakpoint
import org.mule.weave.v2.debugger.WeaveExceptionBreakpoint

sealed trait DebuggerEvent extends RemoteServerMessage {}

@SerialVersionUID(1000L)
case class BreakpointAddedEvent(breakpoint: WeaveBreakpoint) extends DebuggerEvent {}

@SerialVersionUID(1000L)
case class BreakpointsAddedEvent(breakpoint: Array[WeaveBreakpoint]) extends DebuggerEvent {}

@SerialVersionUID(1000L)
case class ExceptionBreakpointsAddedEvent(breakpoint: Array[WeaveExceptionBreakpoint]) extends DebuggerEvent {}

@SerialVersionUID(1000L)
case class BreakpointRemovedEvent(breakpoint: WeaveBreakpoint) extends DebuggerEvent {}

@SerialVersionUID(1000L)
case class BreakpointsCleanedEvent() extends DebuggerEvent {}

@SerialVersionUID(1000L)
case class NextStepDebuggerEvent() extends DebuggerEvent {}

@SerialVersionUID(1000L)
case class StepIntoDebuggerEvent() extends DebuggerEvent {}

@SerialVersionUID(1000L)
case class StepOutDebuggerEvent() extends DebuggerEvent {}

@SerialVersionUID(1000L)
case class ResumeDebuggerEvent() extends DebuggerEvent {}

@SerialVersionUID(1000L)
case class ClientInitializedEvent() extends DebuggerEvent {}

@SerialVersionUID(1000L)
case class OnFrameEvent(frames: Array[DebuggerFrame], startPosition: DebuggerPosition, endPosition: DebuggerPosition, reason: Int) extends DebuggerEvent {}

@SerialVersionUID(1000L)
case class ScriptResultEvent(script: String, result: DebuggerValue) extends DebuggerEvent {}

object ExecutionStopReason {
  val EXCEPTION = 3
  val BREAKPOINT = 2
  val STEP = 1
}
