package org.mule.weave.v2.debugger.commands

import org.mule.weave.v2.debugger.event.RemoteServerMessage

/**
  * A client command sent to a server to execute some remote task
  * @tparam ContextType The context where this remote task will be executed
  * @tparam RemoteServerResponse The response
  */
@SerialVersionUID(1000L)
trait ClientCommand[ContextType, RemoteServerResponse <: RemoteServerMessage] extends Serializable {

  /**
    * Executes this command on the server
    * @param debuggerContext The context that this command needs to be executed
    * @return The result if any
    */
  def call(debuggerContext: ContextType): Option[RemoteServerResponse]

  /**
    * An id that will identify this command
    */
  val id: String
}
