package org.mule.weave.v2.debugger.util

import java.io.File

import java.io.FileInputStream
import scala.io.Source
import scala.util.Try

@SerialVersionUID(1000L)
case class FileElement(isNode: Boolean, name: String, content: Option[String], bytes: Option[Array[Byte]], children: Array[FileElement])

object InputElementFactory {

  private def readContent(file: File): Option[String] = {
    TryClose(Source.fromFile(file), (source: Source) => Try(source.mkString).toOption)
  }

  private def readContentBinary(file: File): Option[Array[Byte]] = {
    TryClose(new FileInputStream(file), (fin: FileInputStream) => {
      Try({
        val content = new Array[Byte](file.length.asInstanceOf[Int])
        fin.read(content)
        content
      }).toOption
    })
  }

  def fromDirectory(files: Array[File]): Array[FileElement] = {
    if (files == null) {
      Array()
    } else {
      files.map(file => {
        fromFile(file)
      })
    }
  }

  def fromFile(file: File): FileElement = {
    val directory = file.isDirectory
    if (directory) {
      FileElement(isNode = true, file.getName, None, None, fromDirectory(file.listFiles()))
    } else {
      val content = readContent(file)
      val binary = readContentBinary(file)
      FileElement(isNode = false, file.getName, content, binary, fromDirectory(file.listFiles()))
    }
  }
}