package org.mule.weave.v2.module.excel

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.module.DataFormat
import org.mule.weave.v2.module.reader.Reader
import org.mule.weave.v2.module.reader.SourceProvider
import org.mule.weave.v2.module.reader.SourceProviderAwareReader

class ExcelDelegatingReader(override val sourceProvider: SourceProvider, val settings: ExcelReaderSettings)(implicit ctx: EvaluationContext) extends Reader with SourceProviderAwareReader {
  override def dataFormat: Option[DataFormat[_, _]] = Some(new ExcelDataFormat)

  lazy val reader: Reader = {
    createReader(sourceProvider)
  }

  def createReader(sourceProvider: SourceProvider): Reader = {
    if (settings.streaming) {
      new ExcelStreamingReader(sourceProvider, settings)
    } else {
      new ExcelReader(sourceProvider, settings)
    }
  }

  override protected def doRead(name: String): Value[_] = {
    reader.read(name)
  }
}
