package org.mule.weave.v2.module.excel

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.module.DataFormat
import org.mule.weave.v2.module.reader.Reader
import org.mule.weave.v2.module.reader.SourceProvider
import org.mule.weave.v2.module.writer.DeferredWriter
import org.mule.weave.v2.module.writer.TargetProvider
import org.mule.weave.v2.parser.module.MimeType

class ExcelDataFormat extends DataFormat[ExcelReaderSettings, ExcelWriterSettings] {

  /**
    * Returns true if this is data format is represented in a binary representation instead of text
    *
    * @return true if binary
    */
  override def binaryFormat = true

  /**
    * The name of this module
    *
    * @return
    */
  override def name(): String = "excel"

  /**
    * Create a new instance of the writer using the provided target if present else it will create a new target
    *
    * @param target The target where the result will be written
    * @return The writer
    */
  override def writer(target: Option[Any], outputMimeType: MimeType = defaultMimeType)(implicit ctx: EvaluationContext): DeferredWriter[ExcelWriterSettings] = {
    DeferredWriter(ExcelWriter.apply, TargetProvider(target), createWriterSettings())
  }

  /**
    * Creates a new instance of the writer using the given source provider
    *
    * @param source The source provider for this reader
    * @return The Reader
    */
  override def reader(source: SourceProvider)(implicit ctx: EvaluationContext): Reader = {
    new ExcelDelegatingReader(source, createReaderSettings())
  }

  /**
    * The content types supported by this module
    *
    * @return
    */
  override val defaultMimeType: MimeType = new MimeType("application", "xlsx")

  //

  /**
    * Returns the mimeTypes accepted by this
    *
    * @return The list of mime types
    */
  override val acceptedMimeTypes: Seq[MimeType] = Seq(new MimeType("application", "vnd.openxmlformats-officedocument.spreadsheetml.sheet"), new MimeType("application", "xlsx"))

  /**
    * The file extensions associated with this DataFormat. (".json", ".xml", etc...)
    * Note: This can be empty
    */
  override def fileExtensions: Seq[String] = Seq(".xlsx")

  override def readerSettings(): ExcelReaderSettings = new ExcelReaderSettings()

  override def writerSettings(): ExcelWriterSettings = new ExcelWriterSettings()
}
