/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.excel;

import java.io.OutputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.ArraySeq;
import org.mule.weave.v2.model.structure.KeyValuePair;
import org.mule.weave.v2.model.structure.ObjectSeq;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.types.ArrayType$;
import org.mule.weave.v2.model.types.BooleanType$;
import org.mule.weave.v2.model.types.DateTimeType$;
import org.mule.weave.v2.model.types.KeyType$;
import org.mule.weave.v2.model.types.LocalDateTimeType$;
import org.mule.weave.v2.model.types.LocalDateType$;
import org.mule.weave.v2.model.types.NumberType$;
import org.mule.weave.v2.model.types.ObjectType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.types.TimeType$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.module.ConfigurableReaderWriter;
import org.mule.weave.v2.module.DataFormat;
import org.mule.weave.v2.module.excel.ExcelCustomTempFileCreationStrategy;
import org.mule.weave.v2.module.excel.ExcelDataFormat;
import org.mule.weave.v2.module.excel.ExcelSettings;
import org.mule.weave.v2.module.excel.ExcelWriter$;
import org.mule.weave.v2.module.pojo.writer.converter.DataConverter;
import org.mule.weave.v2.module.pojo.writer.converter.DataConverter$;
import org.mule.weave.v2.module.pojo.writer.converter.JavaDataConverter;
import org.mule.weave.v2.module.writer.TargetProvider;
import org.mule.weave.v2.module.writer.Writer;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.LocationCapable;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import spire.math.Number;

@ScalaSignature(bytes="\u0006\u0001\u0005]h\u0001\u0002\r\u001a\u0001\u0019B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\ty\u0001\u0011)\u0019!C\u0001{!A!\t\u0001B\u0001B\u0003%a\b\u0003\u0005D\u0001\t\u0005\t\u0015a\u0003E\u0011\u0015Q\u0005\u0001\"\u0001L\u0011!\t\u0006\u0001#b\u0001\n\u0013\u0011\u0006\"B0\u0001\t\u0003\u0002\u0007\"\u00023\u0001\t#*\u0007\"\u0002?\u0001\t\u0003i\bbBA\u001e\u0001\u0011\u0005\u0011Q\b\u0005\b\u0003O\u0002A\u0011AA5\u0011\u001d\tY\b\u0001C\u0001\u0003{Bq!a'\u0001\t\u0003\ti\nC\u0004\u0002&\u0002!\t%a*\t\u000f\u0005%\u0006\u0001\"\u0011\u0002(\"9\u00111\u0016\u0001\u0005B\u00055vaBAf3!\u0005\u0011Q\u001a\u0004\u00071eA\t!a4\t\r)\u0013B\u0011AAi\u0011%\t\u0019N\u0005b\u0001\n\u0003\t)\u000e\u0003\u0005\u0002^J\u0001\u000b\u0011BAl\u0011\u001d\tyN\u0005C\u0005\u0003CDq!a9\u0013\t\u0003\t)OA\u0006Fq\u000e,Gn\u0016:ji\u0016\u0014(B\u0001\u000e\u001c\u0003\u0015)\u0007pY3m\u0015\taR$\u0001\u0004n_\u0012,H.\u001a\u0006\u0003=}\t!A\u001e\u001a\u000b\u0005\u0001\n\u0013!B<fCZ,'B\u0001\u0012$\u0003\u0011iW\u000f\\3\u000b\u0003\u0011\n1a\u001c:h\u0007\u0001\u00192\u0001A\u0014.!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u0019\te.\u001f*fMB\u0011a&M\u0007\u0002_)\u0011\u0001gG\u0001\u0007oJLG/\u001a:\n\u0005Iz#AB,sSR,'/\u0001\u0007pkR\u0004X\u000f^*ue\u0016\fW\u000e\u0005\u00026u5\taG\u0003\u00028q\u0005\u0011\u0011n\u001c\u0006\u0002s\u0005!!.\u0019<b\u0013\tYdG\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW.\u0001\u0005tKR$\u0018N\\4t+\u0005q\u0004CA A\u001b\u0005I\u0012BA!\u001a\u00055)\u0005pY3m'\u0016$H/\u001b8hg\u0006I1/\u001a;uS:<7\u000fI\u0001\u0004GRD\bCA#I\u001b\u00051%BA$\u001e\u0003\u0015iw\u000eZ3m\u0013\tIeIA\tFm\u0006dW/\u0019;j_:\u001cuN\u001c;fqR\fa\u0001P5oSRtDc\u0001'P!R\u0011QJ\u0014\t\u0003\u007f\u0001AQaQ\u0003A\u0004\u0011CQaM\u0003A\u0002QBQ\u0001P\u0003A\u0002y\n!a\u001e2\u0016\u0003M\u0003\"\u0001V/\u000e\u0003US!AV,\u0002\u0013M$(/Z1nS:<'B\u0001-Z\u0003\u0011A8o\u001d4\u000b\u0005i[\u0016a\u00019pS*\u0011AlI\u0001\u0007CB\f7\r[3\n\u0005y+&!D*Y'N3uk\u001c:lE>|7.\u0001\u0004sKN,H\u000e^\u000b\u0002CB\u0011\u0001FY\u0005\u0003G&\u00121!\u00118z\u00031!wn\u0016:ji\u00164\u0016\r\\;f)\t17\u000e\u0006\u0002hUB\u0011\u0001\u0006[\u0005\u0003S&\u0012A!\u00168ji\")1\t\u0003a\u0002\t\")A\u000e\u0003a\u0001[\u0006)a/\u00197vKB\u0012aN\u001e\t\u0004_J$X\"\u00019\u000b\u0005E4\u0015A\u0002<bYV,7/\u0003\u0002ta\n)a+\u00197vKB\u0011QO\u001e\u0007\u0001\t%98.!A\u0001\u0002\u000b\u0005\u0001PA\u0002`IE\n\"!_1\u0011\u0005!R\u0018BA>*\u0005\u001dqu\u000e\u001e5j]\u001e\f!b\u001e:ji\u0016\u001c\u0006.Z3u)\u0015q\u0018\u0011AA\u000e)\t9w\u0010C\u0003D\u0013\u0001\u000fA\tC\u0004\u0002\u0004%\u0001\r!!\u0002\u0002\u0013MDW-\u001a;OC6,\u0007\u0003BA\u0004\u0003+qA!!\u0003\u0002\u0012A\u0019\u00111B\u0015\u000e\u0005\u00055!bAA\bK\u00051AH]8pizJ1!a\u0005*\u0003\u0019\u0001&/\u001a3fM&!\u0011qCA\r\u0005\u0019\u0019FO]5oO*\u0019\u00111C\u0015\t\u000f\u0005u\u0011\u00021\u0001\u0002 \u0005a1\u000f[3fi\u000e{g\u000e^3oiB1\u0011\u0011EA\u0016\u0003cqA!a\t\u0002(9!\u00111BA\u0013\u0013\u0005Q\u0013bAA\u0015S\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0017\u0003_\u0011\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0004\u0003SI\u0003\u0007BA\u001a\u0003o\u0001Ba\u001c:\u00026A\u0019Q/a\u000e\u0005\u0017\u0005e\u00121DA\u0001\u0002\u0003\u0015\t\u0001\u001f\u0002\u0004?\u0012\u0012\u0014a\u00043p/JLG/\u001a$jeN$(k\\<\u0015\u0011\u0005}\u00121IA'\u0003;\"2aZA!\u0011\u0015\u0019%\u0002q\u0001E\u0011\u001d\t)E\u0003a\u0001\u0003\u000f\nQa\u001d5fKR\u00042\u0001VA%\u0013\r\tY%\u0016\u0002\u000b'b\u001b6KR*iK\u0016$\bbBA(\u0015\u0001\u0007\u0011\u0011K\u0001\te><h+\u00197vKB!\u00111KA-\u001b\t\t)FC\u0002\u0002X\u0019\u000b\u0011b\u001d;sk\u000e$XO]3\n\t\u0005m\u0013Q\u000b\u0002\n\u001f\nTWm\u0019;TKFDq!a\u0018\u000b\u0001\u0004\t\t'\u0001\u0004s_^tU/\u001c\t\u0004Q\u0005\r\u0014bAA3S\t\u0019\u0011J\u001c;\u0002\u0015\u0011|wK]5uKJ{w\u000f\u0006\u0004\u0002l\u0005=\u0014\u0011\u0010\u000b\u0004O\u00065\u0004\"B\"\f\u0001\b!\u0005bBA9\u0017\u0001\u0007\u00111O\u0001\u0004e><\bc\u0001+\u0002v%\u0019\u0011qO+\u0003\u0011MC6k\u0015$S_^Dq!a\u0014\f\u0001\u0004\t\t&A\u0005xe&$XmQ3mYR1\u0011qPAB\u0003\u001b#2aZAA\u0011\u0015\u0019E\u0002q\u0001E\u0011\u001d\t)\t\u0004a\u0001\u0003\u000f\u000bAaY3mYB\u0019A+!#\n\u0007\u0005-UKA\u0005T1N\u001bfiQ3mY\"9\u0011q\u0012\u0007A\u0002\u0005E\u0015!C2fY24\u0016\r\\;fa\u0011\t\u0019*a&\u0011\t=\u0014\u0018Q\u0013\t\u0004k\u0006]EaCAM\u0003\u001b\u000b\t\u0011!A\u0003\u0002a\u00141a\u0018\u00134\u0003E\u0019X\r^\"fY2$\u0015\r^1G_Jl\u0017\r\u001e\u000b\u0006O\u0006}\u0015\u0011\u0015\u0005\b\u0003\u000bk\u0001\u0019AAD\u0011\u001d\t\u0019+\u0004a\u0001\u0003\u000b\taAZ8s[\u0006$\u0018!B2m_N,G#A4\u0002\u000b\u0019dWo\u001d5\u0002\u0015\u0011\fG/\u0019$pe6\fG/\u0006\u0002\u00020B)\u0001&!-\u00026&\u0019\u00111W\u0015\u0003\r=\u0003H/[8oa\u0019\t9,!1\u0002HBA\u0011\u0011XA^\u0003\u007f\u000b)-D\u0001\u001c\u0013\r\til\u0007\u0002\u000b\t\u0006$\u0018MR8s[\u0006$\bcA;\u0002B\u0012Q\u00111\u0019\t\u0002\u0002\u0003\u0005)\u0011\u0001=\u0003\u0007}#C\u0007E\u0002v\u0003\u000f$!\"!3\u0011\u0003\u0003\u0005\tQ!\u0001y\u0005\ryF%N\u0001\f\u000bb\u001cW\r\\,sSR,'\u000f\u0005\u0002@%M\u0011!c\n\u000b\u0003\u0003\u001b\f1\u0004V#N!~3\u0015\nT#`\u0007J+\u0015\tV%P\u001d~\u001bFKU!U\u000b\u001eKVCAAl!\ry\u0014\u0011\\\u0005\u0004\u00037L\"aI#yG\u0016d7)^:u_6$V-\u001c9GS2,7I]3bi&|gn\u0015;sCR,w-_\u0001\u001d)\u0016k\u0005k\u0018$J\u0019\u0016{6IU#B)&{ejX*U%\u0006#ViR-!\u0003AIg.\u001b;UK6\u00048\u000b\u001e:bi\u0016<\u0017\u0010\u0006\u0002\u0002X\u0006)\u0011\r\u001d9msR1\u0011q]Av\u0003k$2!TAu\u0011\u0015\u0019u\u0003q\u0001E\u0011\u001d\tio\u0006a\u0001\u0003_\f!\u0001\u001e9\u0011\u00079\n\t0C\u0002\u0002t>\u0012a\u0002V1sO\u0016$\bK]8wS\u0012,'\u000fC\u0003=/\u0001\u0007a\b")
public class ExcelWriter
implements Writer {
    private SXSSFWorkbook wb;
    private final OutputStream outputStream;
    private final ExcelSettings settings;
    private volatile boolean bitmap$0;

    public static ExcelWriter apply(TargetProvider targetProvider, ExcelSettings excelSettings, EvaluationContext evaluationContext) {
        return ExcelWriter$.MODULE$.apply(targetProvider, excelSettings, evaluationContext);
    }

    public static ExcelCustomTempFileCreationStrategy TEMP_FILE_CREATION_STRATEGY() {
        return ExcelWriter$.MODULE$.TEMP_FILE_CREATION_STRATEGY();
    }

    public boolean supportsStreaming() {
        return Writer.supportsStreaming$((Writer)this);
    }

    public void startDocument(LocationCapable location) {
        Writer.startDocument$((Writer)this, (LocationCapable)location);
    }

    public void defineNamespace(LocationCapable location, String prefix, String uri) {
        Writer.defineNamespace$((Writer)this, (LocationCapable)location, (String)prefix, (String)uri);
    }

    public final void writeValue(Value<?> value, EvaluationContext ctx) {
        Writer.writeValue$((Writer)this, value, (EvaluationContext)ctx);
    }

    public String getName() {
        return Writer.getName$((Writer)this);
    }

    public final void endDocument(LocationCapable location) {
        Writer.endDocument$((Writer)this, (LocationCapable)location);
    }

    public void doEndDocument(LocationCapable location) {
        Writer.doEndDocument$((Writer)this, (LocationCapable)location);
    }

    public void setOption(Location location, String optionName, Object value, EvaluationContext ctx) {
        ConfigurableReaderWriter.setOption$((ConfigurableReaderWriter)this, (Location)location, (String)optionName, (Object)value, (EvaluationContext)ctx);
    }

    public ExcelSettings settings() {
        return this.settings;
    }

    /*
     * WARNING - void declaration
     */
    private SXSSFWorkbook wb$lzycompute() {
        ExcelWriter excelWriter = this;
        synchronized (excelWriter) {
            if (!this.bitmap$0) {
                void var2_2;
                SXSSFWorkbook workbook = new SXSSFWorkbook(1000);
                workbook.setCompressTempFiles(true);
                workbook.setZip64Mode(Zip64Mode.AsNeeded);
                this.wb = var2_2;
                this.bitmap$0 = true;
            }
        }
        return this.wb;
    }

    private SXSSFWorkbook wb() {
        return !this.bitmap$0 ? this.wb$lzycompute() : this.wb;
    }

    public Object result() {
        return this.outputStream;
    }

    public void doWriteValue(Value<?> value, EvaluationContext ctx) {
        ExcelWriter$.MODULE$.TEMP_FILE_CREATION_STRATEGY().setResourceManager(ctx.serviceManager().resourceManager());
        try {
            if (!this.settings().zipBombCheck()) {
                ZipSecureFile.setMinInflateRatio((double)0.0);
            }
            Iterator objectSeq = ((ObjectSeq)ObjectType$.MODULE$.coerce(value, ctx).evaluate(ctx)).toIterator(ctx);
            objectSeq.foreach((Function1 & Serializable & scala.Serializable)keyValuePair -> {
                ExcelWriter.$anonfun$doWriteValue$1(this, ctx, keyValuePair);
                return BoxedUnit.UNIT;
            });
            this.wb().write(this.outputStream);
        }
        finally {
            ExcelWriter$.MODULE$.TEMP_FILE_CREATION_STRATEGY().cleanResourceManager();
        }
    }

    public void writeSheet(String sheetName, Iterator<Value<?>> sheetContent, EvaluationContext ctx) {
        SXSSFSheet sheet = this.wb().createSheet(sheetName);
        int rowNum = this.settings().headerRowNum();
        if (this.settings().header() && sheetContent.hasNext()) {
            Value rowValue = (Value)sheetContent.next();
            ObjectSeq rowObjectSeq = (ObjectSeq)ObjectType$.MODULE$.coerce(rowValue, ctx).evaluate(ctx);
            this.doWriteFirstRow(sheet, rowObjectSeq, rowNum, ctx);
            rowNum += 2;
        }
        while (sheetContent.hasNext()) {
            SXSSFRow row = sheet.createRow(rowNum);
            Value rowValue = (Value)sheetContent.next();
            ObjectSeq rowObjectSeq = (ObjectSeq)ObjectType$.MODULE$.coerce(rowValue, ctx).evaluate(ctx);
            this.doWriteRow(row, rowObjectSeq, ctx);
            ++rowNum;
        }
    }

    public void doWriteFirstRow(SXSSFSheet sheet, ObjectSeq rowValue, int rowNum, EvaluationContext ctx) {
        SXSSFRow row0 = sheet.createRow(rowNum);
        SXSSFRow row1 = sheet.createRow(rowNum + 1);
        int colNumber = this.settings().headerColNum();
        Iterator keyValuePairs = rowValue.toIterator(ctx);
        while (keyValuePairs.hasNext()) {
            KeyValuePair keyValuePair = (KeyValuePair)keyValuePairs.next();
            SXSSFCell headerCell = row0.createCell(colNumber);
            String headerString = ((QualifiedName)KeyType$.MODULE$.coerce(keyValuePair._1(), ctx).evaluate(ctx)).name();
            headerCell.setCellValue(headerString);
            SXSSFCell cell = row1.createCell(colNumber);
            this.writeCell(cell, keyValuePair._2(), ctx);
            ++colNumber;
        }
    }

    public void doWriteRow(SXSSFRow row, ObjectSeq rowValue, EvaluationContext ctx) {
        int colNumber = this.settings().headerColNum();
        Iterator keyValuePairs = rowValue.toIterator(ctx);
        while (keyValuePairs.hasNext()) {
            SXSSFCell cell = row.createCell(colNumber);
            Value cellValue = ((KeyValuePair)keyValuePairs.next())._2();
            this.writeCell(cell, cellValue, ctx);
            ++colNumber;
        }
    }

    public void writeCell(SXSSFCell cell, Value<?> cellValue, EvaluationContext ctx) {
        Value<?> value = cellValue;
        if (StringType$.MODULE$.accepts(value, ctx)) {
            String cellStr = StringType$.MODULE$.coerce(value, ctx).evaluate(ctx).toString();
            cell.setCellValue(cellStr);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (BooleanType$.MODULE$.accepts(value, ctx)) {
            boolean booleanValue = BoxesRunTime.unboxToBoolean((Object)BooleanType$.MODULE$.coerce(value, ctx).evaluate(ctx));
            cell.setCellValue(booleanValue);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (NumberType$.MODULE$.accepts(value, ctx)) {
            Number cellNumber = (Number)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            cell.setCellValue(cellNumber.toDouble());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (TimeType$.MODULE$.accepts(value, ctx)) {
            OffsetTime timeValue = (OffsetTime)TimeType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            String timeStr = timeValue.format(DateTimeFormatter.ofPattern("HH:mm:ss"));
            double excelTime = DateUtil.convertTime((String)timeStr);
            cell.setCellValue(excelTime);
            this.setCellDataFormat(cell, "hh:mm:ss");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DateTimeType$.MODULE$.accepts(value, ctx) || LocalDateTimeType$.MODULE$.accepts(value, ctx)) {
            ZonedDateTime dateTime = (ZonedDateTime)DateTimeType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            Calendar calendar = JavaDataConverter.CalendarDataConverter$$.MODULE$.asCalendar(dateTime);
            this.setCellDataFormat(cell, "yyyy-MM-ddThh:mm:ss");
            cell.setCellValue(calendar);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (LocalDateType$.MODULE$.accepts(value, ctx)) {
            LocalDate localDate = (LocalDate)LocalDateType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            Date date = ((Calendar)DataConverter$.MODULE$.to((Object)localDate, value.valueType(ctx).schema(ctx), (DataConverter)JavaDataConverter.CalendarDataConverter$$.MODULE$, ctx).get()).getTime();
            cell.setCellValue(date);
            this.setCellDataFormat(cell, "yyyy-MM-dd");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void setCellDataFormat(SXSSFCell cell, String format) {
        CellStyle cellStyle = this.wb().createCellStyle();
        cellStyle.setDataFormat(this.wb().getCreationHelper().createDataFormat().getFormat(format));
        cell.setCellStyle(cellStyle);
    }

    public void close() {
        this.wb().dispose();
        this.outputStream.close();
    }

    public void flush() {
        this.outputStream.flush();
    }

    public Option<DataFormat<?, ?>> dataFormat() {
        return new Some((Object)new ExcelDataFormat());
    }

    public static final /* synthetic */ void $anonfun$doWriteValue$1(ExcelWriter $this, EvaluationContext ctx$1, KeyValuePair keyValuePair) {
        String sheetName = ((QualifiedName)keyValuePair._1().evaluate(ctx$1)).name();
        ArraySeq sheetContent = (ArraySeq)ArrayType$.MODULE$.coerce(keyValuePair._2(), ctx$1).evaluate(ctx$1);
        $this.writeSheet(sheetName, sheetContent.toIterator(), ctx$1);
    }

    public ExcelWriter(OutputStream outputStream, ExcelSettings settings, EvaluationContext ctx) {
        this.outputStream = outputStream;
        this.settings = settings;
        ConfigurableReaderWriter.$init$((ConfigurableReaderWriter)this);
        Writer.$init$((Writer)this);
    }
}

