/*
 * Decompiled with CFR 0.152.
 */
package com.mule.contribution;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.name.Named;
import com.mule.contribution.maven.MavenProjectKindDetector;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;
import org.mule.dx.platform.api.protocol.LSPProtocolHandler;
import org.mule.dx.platform.api.utils.eventbus.IEventBus;
import org.mule.weave.extension.api.EmptyWeaveCommandProvider;
import org.mule.weave.extension.api.WeaveCommand;
import org.mule.weave.extension.api.WeaveCommandProvider;
import org.mule.weave.lsp.WeaveLanguageServer;
import org.mule.weave.lsp.extension.client.WeaveLanguageClient;
import org.mule.weave.lsp.project.ProjectKindDetector;

public class DataWeaveLSPComponent
implements LSPProtocolHandler<LanguageClient, LanguageServer> {
    private final Injector injector;
    @Inject(optional=true)
    private Set<WeaveCommandProvider> weaveCommandProviders;

    @Inject
    public DataWeaveLSPComponent(Injector injector, @Named(value="dwbus") IEventBus dwEventBus) {
        this.injector = injector;
    }

    public LanguageServer createService(List<String> arguments) {
        MavenProjectKindDetector mavenProjectKindDetector = new MavenProjectKindDetector();
        this.injector.injectMembers((Object)mavenProjectKindDetector);
        return new WeaveLanguageServer(this.injector, new CompositeWeaveCommandProvider(this.weaveCommandProviders), new ProjectKindDetector[]{mavenProjectKindDetector});
    }

    public Class<? extends LanguageClient> getClientInterface() {
        return WeaveLanguageClient.class;
    }

    private class CompositeWeaveCommandProvider
    implements WeaveCommandProvider {
        private final Collection<WeaveCommandProvider> providers;

        public CompositeWeaveCommandProvider(Collection<WeaveCommandProvider> providers) {
            this.providers = providers;
        }

        @Override
        public WeaveCommand[] createCommands() {
            if (this.providers == null) {
                return EmptyWeaveCommandProvider.INSTANCE.createCommands();
            }
            return (WeaveCommand[])this.providers.stream().flatMap(c -> Arrays.stream(c.createCommands())).toArray(WeaveCommand[]::new);
        }
    }
}

