/*
 * Decompiled with CFR 0.152.
 */
package com.mule.contribution.maven;

import com.google.common.collect.ImmutableList;
import com.mule.contribution.maven.MavenProjectDependencyManager;
import com.mule.contribution.maven.components.DataWeaveMavenBuildManager;
import com.mule.contribution.maven.resolver.MavenModelLoader;
import com.mule.contribution.maven.resolver.strategy.BuildModel;
import com.mule.contribution.maven.resolver.strategy.BuildModelFactory;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.model.Model;
import org.mule.dx.platform.api.maven.Maven;
import org.mule.dx.platform.api.maven.MavenDependencyModelManager;
import org.mule.weave.lsp.agent.WeaveAgentService;
import org.mule.weave.lsp.jobs.JobManagerService;
import org.mule.weave.lsp.project.Project;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.components.BuildManager;
import org.mule.weave.lsp.project.components.MavenSampleDataManager;
import org.mule.weave.lsp.project.components.MetadataProvider;
import org.mule.weave.lsp.project.components.ModuleStructure;
import org.mule.weave.lsp.project.components.ProjectDependencyManager;
import org.mule.weave.lsp.project.components.ProjectStructure;
import org.mule.weave.lsp.project.components.RootKind;
import org.mule.weave.lsp.project.components.RootStructure;
import org.mule.weave.lsp.project.components.SampleBaseMetadataProvider;
import org.mule.weave.lsp.project.components.SampleDataManager;
import org.mule.weave.lsp.project.components.TargetFolder;
import org.mule.weave.lsp.project.components.TargetKind;
import org.mule.weave.lsp.services.ClientLogger;
import org.mule.weave.lsp.services.WeaveScenarioManagerService;
import org.mule.weave.lsp.utils.EventBus;
import org.mule.weave.lsp.utils.URLUtils;
import org.mule.weave.lsp.utils.WeaveDirectoryUtils;
import scala.Option;

public class MavenProjectKind
implements ProjectKind {
    private Project project;
    private EventBus eventBus;
    private File pom;
    private ClientLogger clientLogger;
    private WeaveAgentService weaveAgentService;
    private WeaveScenarioManagerService weaveScenarioManagerService;
    private JobManagerService jobManagerService;
    private Maven mavenRunner;
    private MavenDependencyModelManager mavenDependencyModelManager;
    private MavenModelLoader mavenModelLoader;
    private DataWeaveMavenBuildManager mavenBuildManager;
    private MavenSampleDataManager dataManager;
    private SampleBaseMetadataProvider sampleBaseMetadataProvider;
    private MavenProjectDependencyManager mavenProjectDependencyManager;

    public MavenProjectKind(Project project, File pom, EventBus eventBus, ClientLogger clientLogger, WeaveAgentService weaveAgentService, WeaveScenarioManagerService weaveScenarioManagerService, JobManagerService jobManagerService, Maven mavenRunner, MavenDependencyModelManager mavenDependencyModelManager, MavenModelLoader mavenModelLoader) {
        this.project = project;
        this.eventBus = eventBus;
        this.pom = pom;
        this.clientLogger = clientLogger;
        this.weaveAgentService = weaveAgentService;
        this.weaveScenarioManagerService = weaveScenarioManagerService;
        this.jobManagerService = jobManagerService;
        this.mavenRunner = mavenRunner;
        this.mavenDependencyModelManager = mavenDependencyModelManager;
        this.mavenModelLoader = mavenModelLoader;
    }

    @Override
    public String name() {
        return "DW `Maven`";
    }

    @Override
    public ProjectStructure structure() {
        return this.createProjectStructure();
    }

    private ProjectStructure createProjectStructure() {
        Model effectiveModel = this.mavenModelLoader.effectiveModel(this.pom);
        BuildModel buildModel = BuildModelFactory.createBuildModel(effectiveModel, file -> this.mavenModelLoader.effectiveModel(file));
        List<ModuleStructure> moduleStructures = buildModel.getAllModels().stream().map(module -> this.createMavenModuleStructure(module.getModel().getProjectDirectory())).collect(Collectors.toList());
        return ProjectStructure.apply(moduleStructures.toArray(new ModuleStructure[0]));
    }

    private ModuleStructure createMavenModuleStructure(File moduleFolder) {
        File targetDir = new File(moduleFolder, "target");
        ImmutableList rootStructures = ImmutableList.of((Object)this.mainRoot(moduleFolder), (Object)this.testRoot(moduleFolder));
        ImmutableList targets = ImmutableList.of((Object)TargetFolder.apply(TargetKind.CLASS(), (File[])ImmutableList.of((Object)new File(targetDir, "classes")).toArray((Object[])new File[0])), (Object)TargetFolder.apply(TargetKind.TEST_CLASS(), (File[])ImmutableList.of((Object)new File(targetDir, "test-classes")).toArray((Object[])new File[0])));
        ModuleStructure moduleStructure = ModuleStructure.apply(moduleFolder.getName(), rootStructures.toArray(new RootStructure[0]), targets.toArray(new TargetFolder[0]));
        return moduleStructure;
    }

    protected RootStructure mainRoot(File projectHome) {
        File mainDir = new File(projectHome, "src" + File.separator + "main");
        File mainSourceFolder = new File(mainDir, "dw");
        List<File> srcFolders = ImmutableList.of((Object)mainSourceFolder, (Object)new File(mainDir, "java")).stream().filter(f -> f.exists()).collect(Collectors.toList());
        List<File> resourceFolders = ImmutableList.of((Object)new File(mainDir, "resources")).stream().filter(f -> f.exists()).collect(Collectors.toList());
        return RootStructure.apply(RootKind.MAIN(), srcFolders.toArray(new File[0]), resourceFolders.toArray(new File[0]), mainSourceFolder);
    }

    protected RootStructure testRoot(File projectHome) {
        File testDir = new File(projectHome, "src" + File.separator + "test");
        File mainSourceFolder = new File(testDir, WeaveDirectoryUtils.DWTest_FOLDER());
        List<File> srcFolders = ImmutableList.of((Object)mainSourceFolder).stream().filter(f -> f.exists()).collect(Collectors.toList());
        List<File> resourceFolders = ImmutableList.of((Object)new File(testDir, "resources")).stream().filter(f -> f.exists()).collect(Collectors.toList());
        return RootStructure.apply(RootKind.TEST(), srcFolders.toArray(new File[0]), resourceFolders.toArray(new File[0]), mainSourceFolder);
    }

    @Override
    public boolean isProjectFile(String uri) {
        Model effectiveModel = this.mavenModelLoader.effectiveModel(this.pom);
        BuildModel buildModel = BuildModelFactory.createBuildModel(effectiveModel, file -> this.mavenModelLoader.effectiveModel(file));
        return URLUtils.toURI(uri).exists(v -> buildModel.isLoadedFrom(new File((URI)v))) || ProjectKind.super.isProjectFile(uri);
    }

    @Override
    public ProjectDependencyManager dependencyManager() {
        if (this.mavenProjectDependencyManager == null) {
            this.mavenProjectDependencyManager = new MavenProjectDependencyManager(this.project, this.pom, this.eventBus, this.clientLogger, this.jobManagerService, this.mavenDependencyModelManager, this.mavenModelLoader);
        }
        return this.mavenProjectDependencyManager;
    }

    @Override
    public BuildManager buildManager() {
        if (this.mavenBuildManager == null) {
            this.mavenBuildManager = new DataWeaveMavenBuildManager(this.mavenRunner, this.pom, this.clientLogger, this.jobManagerService);
        }
        return this.mavenBuildManager;
    }

    @Override
    public SampleDataManager sampleDataManager() {
        if (this.dataManager == null) {
            this.dataManager = new MavenSampleDataManager(this, this.project);
        }
        return this.dataManager;
    }

    @Override
    public Option<MetadataProvider> metadataProvider() {
        if (this.project.isStarted()) {
            if (this.sampleBaseMetadataProvider == null) {
                this.sampleBaseMetadataProvider = new SampleBaseMetadataProvider(this.weaveAgentService, this.eventBus, this.weaveScenarioManagerService);
            }
            return Option.apply(this.sampleBaseMetadataProvider);
        }
        return Option.empty();
    }
}

