/*
 * Decompiled with CFR 0.152.
 */
package com.mule.contribution.maven;

import com.google.inject.Inject;
import com.mule.contribution.maven.MavenProjectKind;
import com.mule.contribution.maven.resolver.MavenManager;
import java.io.File;
import org.mule.dx.platform.api.WorkspaceManager;
import org.mule.dx.platform.api.maven.Maven;
import org.mule.dx.platform.api.maven.MavenDependencyModelManager;
import org.mule.dx.platform.api.project.Project;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.ProjectKindContext;
import org.mule.weave.lsp.project.ProjectKindDetector;

public class MavenProjectKindDetector
implements ProjectKindDetector {
    @Inject
    private Maven maven;
    @Inject
    private WorkspaceManager workspaceManager;
    @Inject
    private MavenManager mavenManager;

    @Override
    public boolean supports(ProjectKindContext context) {
        return new File(context.project().home(), "pom.xml").exists();
    }

    @Override
    public ProjectKind createKind(ProjectKindContext context) {
        Project projectDx = this.workspaceManager.getProjects().stream().filter(p -> p.getLocation().equals(context.project().home().toURI())).findFirst().orElseThrow(() -> new IllegalStateException("No Project registered in DX workspace manager for: " + context.project().home()));
        return new MavenProjectKind(context.project(), new File(context.project().home(), "pom.xml"), context.eventBus(), context.clientLogger(), context.weaveAgentService(), context.weaveScenarioManagerService(), context.jobManagerService(), this.maven, (MavenDependencyModelManager)projectDx.getComponent(MavenDependencyModelManager.class).orElseThrow(() -> new IllegalStateException("MavenDependencyModelManager component not found for: " + context.project().home())), this.mavenManager.getMavenModelLoader());
    }
}

