/*
 * Decompiled with CFR 0.152.
 */
package com.mule.contribution.maven.components;

import java.io.File;
import java.util.Arrays;
import org.mule.dx.platform.api.maven.Maven;
import org.mule.dx.platform.api.maven.MavenExecutionResult;
import org.mule.weave.lsp.jobs.JobManagerService;
import org.mule.weave.lsp.project.components.BuildManager;
import org.mule.weave.lsp.services.ClientLogger;
import org.mule.weave.lsp.utils.LoggerOutputStream;

public class DataWeaveMavenBuildManager
implements BuildManager {
    private final Maven mavenRunner;
    private final File pom;
    private final ClientLogger loggerService;
    private final JobManagerService jobManagerService;

    public DataWeaveMavenBuildManager(Maven mavenRunner, File pom, ClientLogger loggerService, JobManagerService jobManagerService) {
        this.mavenRunner = mavenRunner;
        this.pom = pom;
        this.loggerService = loggerService;
        this.jobManagerService = jobManagerService;
    }

    @Override
    public void build() {
        this.executeGoals("clean", "compile");
    }

    @Override
    public void buildWithTests() {
        this.executeGoals("clean", "test-compile");
    }

    @Override
    public void deploy() {
        this.executeGoals("clean", "deploy");
    }

    private void executeGoals(String ... goals) {
        String tasks = String.join((CharSequence)",", goals);
        this.jobManagerService.execute(cancelable -> LoggerOutputStream.interceptStdOut(this.loggerService, () -> {
            MavenExecutionResult executionResult = this.mavenRunner.executeWithPom(this.pom.toPath(), Arrays.asList(goals));
            this.loggerService.logInfo("Maven execution result: " + executionResult);
            return null;
        }), "[Maven Task] " + tasks, "Executing maven tasks: " + tasks);
    }
}

