/*
 * Decompiled with CFR 0.152.
 */
package com.mule.contribution.maven.resolver;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mule.contribution.maven.resolver.MavenDependencyResolver;
import com.mule.contribution.maven.resolver.MavenManager;
import com.mule.contribution.maven.resolver.MavenModelLoader;
import com.mule.contribution.maven.resolver.MavenResolverModelLoader;
import eu.maveniverse.maven.mima.context.ContextOverrides;
import eu.maveniverse.maven.mima.context.Runtimes;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.mule.dx.platform.api.Context;
import org.mule.dx.platform.api.component.WorkspaceLifecycle;
import org.mule.maven.client.api.model.MavenConfiguration;

@Singleton
public class DefaultMavenManager
implements MavenManager,
WorkspaceLifecycle {
    private MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder;
    private MavenResolverModelLoader mavenResolverModelLoader;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    @Inject
    public DefaultMavenManager(MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder) {
        this.mavenConfigurationBuilder = mavenConfigurationBuilder;
    }

    @Override
    public MavenDependencyResolver getDependencyResolver() {
        try {
            this.lock.readLock().lock();
            if (this.mavenResolverModelLoader == null) {
                this.start();
            }
            MavenResolverModelLoader mavenResolverModelLoader = this.mavenResolverModelLoader;
            return mavenResolverModelLoader;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public MavenModelLoader getMavenModelLoader() {
        try {
            this.lock.readLock().lock();
            if (this.mavenResolverModelLoader == null) {
                this.start();
            }
            MavenResolverModelLoader mavenResolverModelLoader = this.mavenResolverModelLoader;
            return mavenResolverModelLoader;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MavenResolverModelLoader createMavenResolverMoldeLoader(MavenConfiguration mavenConfiguration) {
        ContextOverrides.Builder builder = ContextOverrides.create().offline(mavenConfiguration.getOfflineMode()).ignoreArtifactDescriptorRepositories(mavenConfiguration.getIgnoreArtifactDescriptorRepositories()).userProperties(mavenConfiguration.getUserProperties().map(properties -> Maps.newHashMap((Map)Maps.fromProperties((Properties)properties))).orElse(Maps.newHashMap())).withLocalRepositoryOverride(mavenConfiguration.getLocalMavenRepositoryLocation().toPath());
        mavenConfiguration.getUserSettingsLocation().ifPresent(file -> {
            builder.withUserSettingsXmlOverride(file.toPath());
            builder.withUserSettings(true);
        });
        mavenConfiguration.getSettingsSecurityLocation().ifPresent(file -> builder.withUserSettingsSecurityXmlOverride(file.toPath()));
        mavenConfiguration.getGlobalSettingsLocation().ifPresent(file -> builder.withGlobalSettingsXmlOverride(file.toPath()));
        if (mavenConfiguration.getGlobalChecksumPolicy() != null) {
            builder.checksumPolicy(ContextOverrides.ChecksumPolicy.valueOf(mavenConfiguration.getGlobalChecksumPolicy().toUpperCase()));
        }
        if (mavenConfiguration.getForcePolicyUpdateAlways()) {
            builder.snapshotUpdatePolicy(ContextOverrides.SnapshotUpdatePolicy.ALWAYS);
        }
        if (mavenConfiguration.getForcePolicyUpdateNever()) {
            builder.snapshotUpdatePolicy(ContextOverrides.SnapshotUpdatePolicy.NEVER);
        }
        mavenConfiguration.getActiveProfiles().ifPresent(profiles -> builder.withActiveProfileIds((List<String>)profiles));
        mavenConfiguration.getInactiveProfiles().ifPresent(profiles -> builder.withInactiveProfileIds((List<String>)profiles));
        builder.addRepositoriesOp(ContextOverrides.AddRepositoriesOp.PREPEND);
        mavenConfiguration.getMavenRemoteRepositories().stream().map(repositoryDescriptor -> {
            RemoteRepository.Builder repositoryBuilder = new RemoteRepository.Builder(repositoryDescriptor.getId(), "default", repositoryDescriptor.getUrl().toExternalForm());
            repositoryDescriptor.getAuthentication().ifPresent(authentication -> new AuthenticationBuilder().addUsername(authentication.getUsername()).addPassword(authentication.getPassword()).build());
            return repositoryBuilder.build();
        }).collect(Collectors.toList());
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(MavenResolverModelLoader.class.getClassLoader());
            ContextOverrides contextOverrides = builder.build();
            MavenResolverModelLoader mavenResolverModelLoader = new MavenResolverModelLoader(Runtimes.INSTANCE.getRuntime().create(contextOverrides));
            return mavenResolverModelLoader;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    public void initialize(Context context) {
    }

    public void start() {
        this.lock.writeLock().lock();
        this.mavenResolverModelLoader = this.createMavenResolverMoldeLoader(this.mavenConfigurationBuilder.build());
        this.lock.writeLock().unlock();
    }

    public void stop() {
        try {
            this.lock.writeLock().lock();
            if (this.mavenResolverModelLoader != null) {
                this.mavenResolverModelLoader.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.mavenResolverModelLoader = null;
            this.lock.writeLock().unlock();
        }
    }
}

