/*
 * Decompiled with CFR 0.152.
 */
package com.mule.contribution.maven.resolver;

import com.mule.contribution.maven.resolver.MavenDependencyResolver;
import com.mule.contribution.maven.resolver.MavenModelLoader;
import com.mule.contribution.maven.resolver.MavenResolverException;
import com.mule.contribution.maven.resolver.strategy.MultiModuleProjectResolverStrategy;
import com.mule.contribution.maven.resolver.strategy.ProjectResolverStrategy;
import com.mule.contribution.maven.resolver.strategy.ResolverStrategy;
import eu.maveniverse.maven.mima.context.Context;
import eu.maveniverse.maven.mima.extensions.mmr.MavenModelReader;
import eu.maveniverse.maven.mima.extensions.mmr.ModelRequest;
import eu.maveniverse.maven.mima.extensions.mmr.ModelResponse;
import java.io.File;
import java.io.IOException;
import org.apache.maven.model.Model;
import org.eclipse.aether.graph.DependencyNode;

public class MavenResolverModelLoader
implements MavenDependencyResolver,
MavenModelLoader,
AutoCloseable {
    private Context context;

    public MavenResolverModelLoader(Context context) {
        this.context = context;
    }

    @Override
    public DependencyNode getDependencyNodeWithTransitive(Model model, String ... scopesToExclude) throws MavenResolverException {
        try {
            ResolverStrategy resolverStrategy = model.getPackaging().equals("pom") ? new MultiModuleProjectResolverStrategy(model, this.context, scopesToExclude, pomFile -> this.effectiveModel(pomFile)) : new ProjectResolverStrategy(model, this.context, scopesToExclude);
            return resolverStrategy.resolve().getRoot();
        }
        catch (MavenResolverException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MavenResolverException(e);
        }
    }

    @Override
    public Model effectiveModel(File pomFile) throws MavenResolverException {
        try {
            MavenModelReader mmr = new MavenModelReader(this.context);
            ModelResponse response = mmr.readModel(ModelRequest.builder().setPomFile(pomFile.toPath()).build());
            Model effectiveModel = response.getEffectiveModel();
            effectiveModel.setPomFile(pomFile);
            return effectiveModel;
        }
        catch (Exception e) {
            throw new MavenResolverException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.context.close();
    }
}

