/*
 * Decompiled with CFR 0.152.
 */
package com.mule.contribution.maven.resolver.strategy;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.model.Model;
import org.eclipse.aether.artifact.Artifact;

public class BuildModel {
    private final Model model;
    private final List<BuildModel> modules;

    public BuildModel(Model model, List<BuildModel> modules) {
        this.model = model;
        this.modules = modules;
    }

    public Model getModel() {
        return this.model;
    }

    public List<BuildModel> getModules() {
        return this.modules;
    }

    public List<BuildModel> getAllModels() {
        return Stream.concat(Stream.of(this), this.getModules().stream().flatMap(m -> m.getAllModels().stream())).collect(Collectors.toList());
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return this.model.getId();
    }

    public String printTree() {
        return this.printTree("", true).trim();
    }

    private String printTree(String prefix, boolean isTail) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        sb.append(isTail ? "\u2514\u2500 " : "\u251c\u2500 ");
        sb.append(this.model.getId()).append("\n");
        for (int i = 0; i < this.modules.size() - 1; ++i) {
            sb.append(this.modules.get(i).printTree(prefix + (isTail ? "   " : "\u2502  "), false));
        }
        if (this.modules.size() > 0) {
            sb.append(this.modules.get(this.modules.size() - 1).printTree(prefix + (isTail ? "   " : "\u2502  "), true));
        }
        return sb.toString();
    }

    public File findArtifact(Artifact artifact) {
        return this.getAllModels().stream().map(bm -> bm.getModel()).filter(m -> m.getGroupId().equals(artifact.getGroupId()) && m.getArtifactId().equals(artifact.getArtifactId()) && m.getVersion().equals(artifact.getVersion())).map(m -> {
            if (artifact.getExtension().equals("pom")) {
                return m.getPomFile();
            }
            return new File(m.getBuild().getOutputDirectory().replace("${project.basedir}", m.getProjectDirectory().getAbsolutePath()));
        }).findFirst().orElse(null);
    }

    public List<String> findVersions(Artifact artifact) {
        return this.getAllModels().stream().map(bm -> bm.getModel()).filter(m -> m.getGroupId().equals(artifact.getGroupId()) && m.getArtifactId().equals(artifact.getArtifactId()) && m.getVersion().equals(artifact.getVersion())).map(m -> m.getVersion()).collect(Collectors.toList());
    }

    public boolean isLoadedFrom(File pomFile) {
        return this.getAllModels().stream().filter(module -> module.getModel().getPomFile().equals(pomFile)).findAny().isPresent();
    }

    public static class Builder {
        private Model model;
        private List<Builder> modulesBuilders = new ArrayList<Builder>();

        public Builder model(Model model) {
            this.model = model;
            return this;
        }

        public Builder module() {
            Builder builder = new Builder();
            this.modulesBuilders.add(builder);
            return builder;
        }

        public BuildModel build() {
            Objects.requireNonNull(this.model, "model cannot be null");
            return new BuildModel(this.model, this.modulesBuilders.stream().map(Builder::build).collect(Collectors.toList()));
        }
    }
}

