/*
 * Decompiled with CFR 0.152.
 */
package com.mule.contribution.maven.resolver.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.maven.model.Model;
import org.apache.maven.model.Repository;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;

public class MavenModelConverter {
    private MavenModelConverter() {
    }

    public static List<RemoteRepository> asRemoteRepositories(List<Repository> repositories) {
        ArrayList<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>();
        for (Repository repository : repositories) {
            remoteRepositories.add(MavenModelConverter.asRemoteRepository(repository));
        }
        return remoteRepositories;
    }

    private static RemoteRepository asRemoteRepository(Repository mavenRepository) {
        if (mavenRepository != null) {
            RemoteRepository.Builder builder = new RemoteRepository.Builder(mavenRepository.getId(), mavenRepository.getLayout(), mavenRepository.getUrl());
            builder.setReleasePolicy(MavenModelConverter.asRepositoryPolicy(mavenRepository.getReleases()));
            builder.setSnapshotPolicy(MavenModelConverter.asRepositoryPolicy(mavenRepository.getSnapshots()));
            return builder.build();
        }
        return null;
    }

    private static RepositoryPolicy asRepositoryPolicy(org.apache.maven.model.RepositoryPolicy policy) {
        boolean enabled = true;
        String checksums = "warn";
        String updates = "daily";
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getUpdatePolicy() != null) {
                updates = policy.getUpdatePolicy();
            }
            if (policy.getChecksumPolicy() != null) {
                checksums = policy.getChecksumPolicy();
            }
        }
        return new RepositoryPolicy(enabled, updates, checksums);
    }

    public static List<Dependency> asDependencies(List<org.apache.maven.model.Dependency> dependencies, ArtifactTypeRegistry registry) {
        ArrayList<Dependency> list = new ArrayList<Dependency>(dependencies.size());
        for (org.apache.maven.model.Dependency d : dependencies) {
            list.add(MavenModelConverter.asDependency(d, registry));
        }
        return list;
    }

    public static Dependency asDependency(Model model, ArtifactTypeRegistry registry) {
        return new Dependency(MavenModelConverter.asArtifact(model, registry), "runtime", false, Collections.emptyList());
    }

    private static Dependency asDependency(org.apache.maven.model.Dependency dependency, ArtifactTypeRegistry registry) {
        return new Dependency(MavenModelConverter.asArtifact(dependency, registry), dependency.getScope(), dependency.isOptional(), MavenModelConverter.asExclusions(dependency.getExclusions()));
    }

    private static Artifact asArtifact(org.apache.maven.model.Dependency dependency, ArtifactTypeRegistry registry) {
        ArtifactType artifactType = registry.get(dependency.getType());
        if (artifactType == null) {
            throw new IllegalArgumentException("Unable to resolve ArtifactType from dependency: " + dependency);
        }
        return new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), artifactType.getExtension(), dependency.getVersion(), "system".equals(dependency.getScope()) ? Collections.singletonMap("localPath", dependency.getSystemPath()) : Collections.emptyMap(), "system".equals(dependency.getScope()) ? new File(dependency.getSystemPath()) : null);
    }

    private static Artifact asArtifact(Model model, ArtifactTypeRegistry registry) {
        ArtifactType artifactType = registry.get(model.getPackaging());
        if (artifactType == null) {
            throw new IllegalArgumentException("Unable to resolve ArtifactType from model: " + model);
        }
        return new DefaultArtifact(model.getGroupId(), model.getArtifactId(), null, model.getPackaging(), model.getVersion(), Collections.emptyMap(), model.getPomFile());
    }

    public static Exclusion asExclusion(org.apache.maven.model.Exclusion coordinates) {
        String group = coordinates.getGroupId();
        String artifact = coordinates.getArtifactId();
        group = group == null || group.length() == 0 ? "*" : group;
        artifact = artifact == null || artifact.length() == 0 ? "*" : artifact;
        return new Exclusion(group, artifact, "*", "*");
    }

    public static List<Exclusion> asExclusions(Collection<org.apache.maven.model.Exclusion> exclusions) {
        ArrayList<Exclusion> list = new ArrayList<Exclusion>(exclusions.size());
        for (org.apache.maven.model.Exclusion coords : exclusions) {
            list.add(MavenModelConverter.asExclusion(coords));
        }
        return list;
    }
}

