/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mima.context.internal;

import eu.maveniverse.maven.mima.context.Lookup;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;

public final class IteratingLookup
implements Lookup {
    private final Collection<Lookup> lookups;

    public IteratingLookup(Lookup ... lookups) {
        this(Arrays.asList(lookups));
    }

    public IteratingLookup(Collection<Lookup> lookups) {
        this.lookups = Objects.requireNonNull(lookups);
    }

    @Override
    public <T> Optional<T> lookup(Class<T> type) {
        for (Lookup lookup : this.lookups) {
            Optional<T> result2 = lookup.lookup(type);
            if (!result2.isPresent()) continue;
            return result2;
        }
        return Optional.empty();
    }

    @Override
    public <T> Optional<T> lookup(Class<T> type, String name) {
        for (Lookup lookup : this.lookups) {
            Optional<T> result2 = lookup.lookup(type, name);
            if (!result2.isPresent()) continue;
            return result2;
        }
        return Optional.empty();
    }
}

