/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mima.extensions.mmr;

import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;

public class ModelRequest {
    private final Artifact artifact;
    private final String requestContext;
    private final RequestTrace trace;

    public static Builder builder() {
        return new Builder();
    }

    private ModelRequest(Artifact artifact, String requestContext, RequestTrace trace) {
        this.artifact = Objects.requireNonNull(artifact);
        this.requestContext = requestContext == null ? "" : requestContext;
        this.trace = trace;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public String getRequestContext() {
        return this.requestContext;
    }

    public RequestTrace getTrace() {
        return this.trace;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private Artifact artifact;
        private List<RemoteRepository> repositories;
        private String requestContext;
        private RequestTrace trace;

        private Builder() {
        }

        private Builder(ModelRequest request) {
            this.artifact = request.artifact;
            this.requestContext = request.requestContext;
            this.trace = request.trace;
        }

        public ModelRequest build() {
            return new ModelRequest(this.artifact, this.requestContext, this.trace);
        }

        public Builder setPomFile(Path pomFile) {
            Objects.requireNonNull(pomFile);
            return this.setArtifact(new DefaultArtifact("irrelevant:irrelevant:irrelevant").setFile(pomFile.toFile()));
        }

        public Builder setArtifact(Artifact artifact) {
            Objects.requireNonNull(artifact);
            this.artifact = artifact;
            return this;
        }

        public Builder setRequestContext(String requestContext) {
            this.requestContext = requestContext;
            return this;
        }

        public Builder setTrace(RequestTrace trace) {
            this.trace = trace;
            return this;
        }
    }
}

