/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mima.extensions.mmr;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.maven.model.Model;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;

public class ModelResponse {
    private final Model rawModel;
    private final Model effectiveModel;
    private final Function<Model, ArtifactDescriptorResult> converter;
    private final List<String> lineage;
    private final Function<String, Model> lineageFunction;
    private final Function<Model, Model> interpolatorFunction;

    public ModelResponse(Model rawModel, Model effectiveModel, Function<Model, ArtifactDescriptorResult> converter, List<String> lineage, Function<String, Model> lineageFunction, Function<Model, Model> interpolatorFunction) {
        this.rawModel = Objects.requireNonNull(rawModel);
        this.effectiveModel = Objects.requireNonNull(effectiveModel);
        this.converter = Objects.requireNonNull(converter);
        this.lineage = Objects.requireNonNull(lineage);
        this.lineageFunction = Objects.requireNonNull(lineageFunction);
        this.interpolatorFunction = Objects.requireNonNull(interpolatorFunction);
    }

    public Model getEffectiveModel() {
        return this.effectiveModel;
    }

    public Model getRawModel() {
        return this.rawModel;
    }

    public ArtifactDescriptorResult toArtifactDescriptorResult(Model model) {
        Objects.requireNonNull(model);
        return this.converter.apply(model);
    }

    public List<String> getLineage() {
        return this.lineage;
    }

    public Model getLineageModel(String modelId) {
        return this.lineageFunction.apply(modelId);
    }

    public Model interpolateModel(Model model) {
        return this.interpolatorFunction.apply(model);
    }
}

