/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.impl.MetadataResolver;
import org.eclipse.aether.impl.OfflineController;
import org.eclipse.aether.impl.RemoteRepositoryFilterManager;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.RepositoryConnectorProvider;
import org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.eclipse.aether.impl.UpdateCheck;
import org.eclipse.aether.impl.UpdateCheckManager;
import org.eclipse.aether.internal.impl.SafeTransferListener;
import org.eclipse.aether.internal.impl.Utils;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.LocalMetadataRegistration;
import org.eclipse.aether.repository.LocalMetadataRequest;
import org.eclipse.aether.repository.LocalMetadataResult;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.MetadataRequest;
import org.eclipse.aether.resolution.MetadataResult;
import org.eclipse.aether.spi.connector.MetadataDownload;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.connector.filter.RemoteRepositoryFilter;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.synccontext.SyncContextFactory;
import org.eclipse.aether.transfer.MetadataNotFoundException;
import org.eclipse.aether.transfer.MetadataTransferException;
import org.eclipse.aether.transfer.NoRepositoryConnectorException;
import org.eclipse.aether.transfer.RepositoryOfflineException;
import org.eclipse.aether.util.concurrency.ExecutorUtils;
import org.eclipse.aether.util.concurrency.RunnableErrorForwarder;

@Singleton
@Named
public class DefaultMetadataResolver
implements MetadataResolver,
Service {
    private static final String CONFIG_PROP_THREADS = "aether.metadataResolver.threads";
    private RepositoryEventDispatcher repositoryEventDispatcher;
    private UpdateCheckManager updateCheckManager;
    private RepositoryConnectorProvider repositoryConnectorProvider;
    private RemoteRepositoryManager remoteRepositoryManager;
    private SyncContextFactory syncContextFactory;
    private OfflineController offlineController;
    private RemoteRepositoryFilterManager remoteRepositoryFilterManager;

    @Deprecated
    public DefaultMetadataResolver() {
    }

    @Inject
    public DefaultMetadataResolver(RepositoryEventDispatcher repositoryEventDispatcher, UpdateCheckManager updateCheckManager, RepositoryConnectorProvider repositoryConnectorProvider, RemoteRepositoryManager remoteRepositoryManager, SyncContextFactory syncContextFactory, OfflineController offlineController, RemoteRepositoryFilterManager remoteRepositoryFilterManager) {
        this.setRepositoryEventDispatcher(repositoryEventDispatcher);
        this.setUpdateCheckManager(updateCheckManager);
        this.setRepositoryConnectorProvider(repositoryConnectorProvider);
        this.setRemoteRepositoryManager(remoteRepositoryManager);
        this.setSyncContextFactory(syncContextFactory);
        this.setOfflineController(offlineController);
        this.setRemoteRepositoryFilterManager(remoteRepositoryFilterManager);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setRepositoryEventDispatcher(locator.getService(RepositoryEventDispatcher.class));
        this.setUpdateCheckManager(locator.getService(UpdateCheckManager.class));
        this.setRepositoryConnectorProvider(locator.getService(RepositoryConnectorProvider.class));
        this.setRemoteRepositoryManager(locator.getService(RemoteRepositoryManager.class));
        this.setSyncContextFactory(locator.getService(SyncContextFactory.class));
        this.setOfflineController(locator.getService(OfflineController.class));
        this.setRemoteRepositoryFilterManager(locator.getService(RemoteRepositoryFilterManager.class));
    }

    public DefaultMetadataResolver setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        this.repositoryEventDispatcher = Objects.requireNonNull(repositoryEventDispatcher, "repository event dispatcher cannot be null");
        return this;
    }

    public DefaultMetadataResolver setUpdateCheckManager(UpdateCheckManager updateCheckManager) {
        this.updateCheckManager = Objects.requireNonNull(updateCheckManager, "update check manager cannot be null");
        return this;
    }

    public DefaultMetadataResolver setRepositoryConnectorProvider(RepositoryConnectorProvider repositoryConnectorProvider) {
        this.repositoryConnectorProvider = Objects.requireNonNull(repositoryConnectorProvider, "repository connector provider cannot be null");
        return this;
    }

    public DefaultMetadataResolver setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        this.remoteRepositoryManager = Objects.requireNonNull(remoteRepositoryManager, "remote repository provider cannot be null");
        return this;
    }

    public DefaultMetadataResolver setSyncContextFactory(SyncContextFactory syncContextFactory) {
        this.syncContextFactory = Objects.requireNonNull(syncContextFactory, "sync context factory cannot be null");
        return this;
    }

    public DefaultMetadataResolver setOfflineController(OfflineController offlineController) {
        this.offlineController = Objects.requireNonNull(offlineController, "offline controller cannot be null");
        return this;
    }

    public DefaultMetadataResolver setRemoteRepositoryFilterManager(RemoteRepositoryFilterManager remoteRepositoryFilterManager) {
        this.remoteRepositoryFilterManager = Objects.requireNonNull(remoteRepositoryFilterManager, "remote repository filter manager cannot be null");
        return this;
    }

    @Override
    public List<MetadataResult> resolveMetadata(RepositorySystemSession session, Collection<? extends MetadataRequest> requests) {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(requests, "requests cannot be null");
        try (SyncContext shared = this.syncContextFactory.newInstance(session, true);){
            SyncContext exclusive = this.syncContextFactory.newInstance(session, false);
            try {
                ArrayList<Metadata> metadata = new ArrayList<Metadata>(requests.size());
                for (MetadataRequest metadataRequest : requests) {
                    metadata.add(metadataRequest.getMetadata());
                }
                List<MetadataResult> list = this.resolve(shared, exclusive, metadata, session, requests);
                if (exclusive != null) {
                    exclusive.close();
                }
                return list;
            }
            catch (Throwable throwable) {
                if (exclusive != null) {
                    try {
                        exclusive.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MetadataResult> resolve(SyncContext shared, SyncContext exclusive, Collection<Metadata> subjects, RepositorySystemSession session, Collection<? extends MetadataRequest> requests) {
        try (SyncContext current = shared;){
            Metadata metadata;
            ArrayList<ResolveTask> tasks;
            ArrayList<MetadataResult> results;
            while (true) {
                current.acquire(null, subjects);
                results = new ArrayList<MetadataResult>(requests.size());
                tasks = new ArrayList<ResolveTask>(requests.size());
                HashMap<File, Long> localLastUpdates = new HashMap<File, Long>();
                RemoteRepositoryFilter remoteRepositoryFilter = this.remoteRepositoryFilterManager.getRemoteRepositoryFilter(session);
                for (MetadataRequest metadataRequest : requests) {
                    File localFile;
                    RemoteRepositoryFilter.Result result2;
                    RequestTrace trace = RequestTrace.newChild(metadataRequest.getTrace(), metadataRequest);
                    Iterator result22 = new MetadataResult(metadataRequest);
                    results.add((MetadataResult)((Object)result22));
                    metadata = metadataRequest.getMetadata();
                    RemoteRepository repository = metadataRequest.getRepository();
                    if (repository == null) {
                        LocalRepository localRepository = session.getLocalRepositoryManager().getRepository();
                        this.metadataResolving(session, trace, metadata, localRepository);
                        File localFile2 = this.getLocalFile(session, metadata);
                        if (localFile2 != null) {
                            metadata = metadata.setFile(localFile2);
                            ((MetadataResult)((Object)result22)).setMetadata(metadata);
                        } else {
                            ((MetadataResult)((Object)result22)).setException(new MetadataNotFoundException(metadata, localRepository));
                        }
                        this.metadataResolved(session, trace, metadata, localRepository, ((MetadataResult)((Object)result22)).getException());
                        continue;
                    }
                    if (remoteRepositoryFilter != null && !(result2 = remoteRepositoryFilter.acceptMetadata(repository, metadata)).isAccepted()) {
                        ((MetadataResult)((Object)result22)).setException(new MetadataNotFoundException(metadata, repository, result2.reasoning()));
                        continue;
                    }
                    List<RemoteRepository> list = this.getEnabledSourceRepositories(repository, metadata.getNature());
                    if (list.isEmpty()) continue;
                    this.metadataResolving(session, trace, metadata, repository);
                    LocalRepositoryManager lrm = session.getLocalRepositoryManager();
                    LocalMetadataRequest localRequest = new LocalMetadataRequest(metadata, repository, metadataRequest.getRequestContext());
                    LocalMetadataResult lrmResult = lrm.find(session, localRequest);
                    File metadataFile = lrmResult.getFile();
                    try {
                        Utils.checkOffline(session, this.offlineController, repository);
                    }
                    catch (RepositoryOfflineException e) {
                        if (metadataFile != null) {
                            metadata = metadata.setFile(metadataFile);
                            ((MetadataResult)((Object)result22)).setMetadata(metadata);
                        } else {
                            String msg = "Cannot access " + repository.getId() + " (" + repository.getUrl() + ") in offline mode and the metadata " + metadata + " has not been downloaded from it before";
                            ((MetadataResult)((Object)result22)).setException(new MetadataNotFoundException(metadata, repository, msg, e));
                        }
                        this.metadataResolved(session, trace, metadata, repository, ((MetadataResult)((Object)result22)).getException());
                        continue;
                    }
                    Long localLastUpdate = null;
                    if (metadataRequest.isFavorLocalRepository() && (localLastUpdate = (Long)localLastUpdates.get(localFile = this.getLocalFile(session, metadata))) == null) {
                        localLastUpdate = localFile != null ? localFile.lastModified() : 0L;
                        localLastUpdates.put(localFile, localLastUpdate);
                    }
                    ArrayList<UpdateCheck<Metadata, MetadataTransferException>> checks = new ArrayList<UpdateCheck<Metadata, MetadataTransferException>>();
                    MetadataTransferException exception = null;
                    for (RemoteRepository repo : list) {
                        UpdateCheck<Metadata, MetadataTransferException> check = new UpdateCheck<Metadata, MetadataTransferException>();
                        check.setLocalLastUpdated(localLastUpdate != null ? localLastUpdate : 0L);
                        check.setItem(metadata);
                        File checkFile = new File(session.getLocalRepository().getBasedir(), session.getLocalRepositoryManager().getPathForRemoteMetadata(metadata, repository, metadataRequest.getRequestContext()));
                        check.setFile(checkFile);
                        check.setRepository(repository);
                        check.setAuthoritativeRepository(repo);
                        check.setPolicy(this.getPolicy(session, repo, metadata.getNature()).getUpdatePolicy());
                        if (lrmResult.isStale()) {
                            checks.add(check);
                            continue;
                        }
                        this.updateCheckManager.checkMetadata(session, check);
                        if (check.isRequired()) {
                            checks.add(check);
                            continue;
                        }
                        if (exception != null) continue;
                        exception = check.getException();
                    }
                    if (!checks.isEmpty()) {
                        RepositoryPolicy policy = this.getPolicy(session, repository, metadata.getNature());
                        File installFile = new File(session.getLocalRepository().getBasedir(), session.getLocalRepositoryManager().getPathForRemoteMetadata(metadata, metadataRequest.getRepository(), metadataRequest.getRequestContext()));
                        ResolveTask task = new ResolveTask(session, trace, (MetadataResult)((Object)result22), installFile, (List<UpdateCheck<Metadata, MetadataTransferException>>)checks, policy.getChecksumPolicy());
                        tasks.add(task);
                        continue;
                    }
                    ((MetadataResult)((Object)result22)).setException(exception);
                    if (metadataFile != null) {
                        metadata = metadata.setFile(metadataFile);
                        ((MetadataResult)((Object)result22)).setMetadata(metadata);
                    }
                    this.metadataResolved(session, trace, metadata, repository, ((MetadataResult)((Object)result22)).getException());
                }
                if (tasks.isEmpty() || current != shared) break;
                current.close();
                current = exclusive;
            }
            if (!tasks.isEmpty()) {
                int threads = ExecutorUtils.threadCount(session, 4, CONFIG_PROP_THREADS);
                Executor executor = ExecutorUtils.executor(Math.min(tasks.size(), threads), this.getClass().getSimpleName() + '-');
                try {
                    RunnableErrorForwarder errorForwarder = new RunnableErrorForwarder();
                    for (ResolveTask task : tasks) {
                        this.metadataDownloading(task.session, task.trace, task.request.getMetadata(), task.request.getRepository());
                        executor.execute(errorForwarder.wrap(task));
                    }
                    errorForwarder.await();
                    for (ResolveTask task : tasks) {
                        for (UpdateCheck updateCheck : task.checks) {
                            this.updateCheckManager.touchMetadata(task.session, updateCheck.setException(task.exception));
                        }
                        this.metadataDownloaded(session, task.trace, task.request.getMetadata(), task.request.getRepository(), task.metadataFile, task.exception);
                        task.result.setException(task.exception);
                    }
                }
                finally {
                    ExecutorUtils.shutdown(executor);
                }
                for (ResolveTask task : tasks) {
                    metadata = task.request.getMetadata();
                    LocalMetadataRequest localRequest = new LocalMetadataRequest(metadata, task.request.getRepository(), task.request.getRequestContext());
                    File file = session.getLocalRepositoryManager().find(session, localRequest).getFile();
                    if (file != null) {
                        metadata = metadata.setFile(file);
                        task.result.setMetadata(metadata);
                    }
                    if (task.result.getException() == null) {
                        task.result.setUpdated(true);
                    }
                    this.metadataResolved(session, task.trace, metadata, task.request.getRepository(), task.result.getException());
                }
            }
            ArrayList<MetadataResult> arrayList = results;
            return arrayList;
        }
    }

    private File getLocalFile(RepositorySystemSession session, Metadata metadata) {
        LocalRepositoryManager lrm = session.getLocalRepositoryManager();
        LocalMetadataResult localResult = lrm.find(session, new LocalMetadataRequest(metadata, null, null));
        return localResult.getFile();
    }

    private List<RemoteRepository> getEnabledSourceRepositories(RemoteRepository repository, Metadata.Nature nature) {
        ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>();
        if (repository.isRepositoryManager()) {
            for (RemoteRepository repo : repository.getMirroredRepositories()) {
                if (!this.isEnabled(repo, nature)) continue;
                repositories.add(repo);
            }
        } else if (this.isEnabled(repository, nature)) {
            repositories.add(repository);
        }
        return repositories;
    }

    private boolean isEnabled(RemoteRepository repository, Metadata.Nature nature) {
        if (!Metadata.Nature.SNAPSHOT.equals((Object)nature) && repository.getPolicy(false).isEnabled()) {
            return true;
        }
        return !Metadata.Nature.RELEASE.equals((Object)nature) && repository.getPolicy(true).isEnabled();
    }

    private RepositoryPolicy getPolicy(RepositorySystemSession session, RemoteRepository repository, Metadata.Nature nature) {
        boolean releases = !Metadata.Nature.SNAPSHOT.equals((Object)nature);
        boolean snapshots = !Metadata.Nature.RELEASE.equals((Object)nature);
        return this.remoteRepositoryManager.getPolicy(session, repository, releases, snapshots);
    }

    private void metadataResolving(RepositorySystemSession session, RequestTrace trace, Metadata metadata, ArtifactRepository repository) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.METADATA_RESOLVING);
        event.setTrace(trace);
        event.setMetadata(metadata);
        event.setRepository(repository);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void metadataResolved(RepositorySystemSession session, RequestTrace trace, Metadata metadata, ArtifactRepository repository, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.METADATA_RESOLVED);
        event.setTrace(trace);
        event.setMetadata(metadata);
        event.setRepository(repository);
        event.setException(exception);
        event.setFile(metadata.getFile());
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void metadataDownloading(RepositorySystemSession session, RequestTrace trace, Metadata metadata, ArtifactRepository repository) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.METADATA_DOWNLOADING);
        event.setTrace(trace);
        event.setMetadata(metadata);
        event.setRepository(repository);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void metadataDownloaded(RepositorySystemSession session, RequestTrace trace, Metadata metadata, ArtifactRepository repository, File file, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.METADATA_DOWNLOADED);
        event.setTrace(trace);
        event.setMetadata(metadata);
        event.setRepository(repository);
        event.setException(exception);
        event.setFile(file);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    class ResolveTask
    implements Runnable {
        final RepositorySystemSession session;
        final RequestTrace trace;
        final MetadataResult result;
        final MetadataRequest request;
        final File metadataFile;
        final String policy;
        final List<UpdateCheck<Metadata, MetadataTransferException>> checks;
        volatile MetadataTransferException exception;

        ResolveTask(RepositorySystemSession session, RequestTrace trace, MetadataResult result2, File metadataFile, List<UpdateCheck<Metadata, MetadataTransferException>> checks, String policy) {
            this.session = session;
            this.trace = trace;
            this.result = result2;
            this.request = result2.getRequest();
            this.metadataFile = metadataFile;
            this.policy = policy;
            this.checks = checks;
        }

        @Override
        public void run() {
            Metadata metadata = this.request.getMetadata();
            RemoteRepository requestRepository = this.request.getRepository();
            try {
                ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>();
                for (UpdateCheck<Metadata, MetadataTransferException> check : this.checks) {
                    repositories.add(check.getAuthoritativeRepository());
                }
                MetadataDownload download = new MetadataDownload();
                download.setMetadata(metadata);
                download.setRequestContext(this.request.getRequestContext());
                download.setFile(this.metadataFile);
                download.setChecksumPolicy(this.policy);
                download.setRepositories(repositories);
                download.setListener(SafeTransferListener.wrap(this.session));
                download.setTrace(this.trace);
                try (RepositoryConnector connector = DefaultMetadataResolver.this.repositoryConnectorProvider.newRepositoryConnector(this.session, requestRepository);){
                    connector.get(null, Collections.singletonList(download));
                }
                this.exception = download.getException();
                if (this.exception == null) {
                    List<String> contexts = Collections.singletonList(this.request.getRequestContext());
                    LocalMetadataRegistration registration = new LocalMetadataRegistration(metadata, requestRepository, contexts);
                    this.session.getLocalRepositoryManager().add(this.session, registration);
                } else if (this.request.isDeleteLocalCopyIfMissing() && this.exception instanceof MetadataNotFoundException) {
                    download.getFile().delete();
                }
            }
            catch (NoRepositoryConnectorException e) {
                this.exception = new MetadataTransferException(metadata, requestRepository, e);
            }
        }
    }
}

