/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.commands;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.lsp4j.ConfigurationItem;
import org.eclipse.lsp4j.ConfigurationParams;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.mule.weave.extension.api.WeaveCommand;
import org.mule.weave.lsp.commands.Commands$;
import org.mule.weave.lsp.extension.client.LaunchConfiguration;
import org.mule.weave.lsp.extension.client.LaunchConfiguration$;
import org.mule.weave.lsp.extension.client.LaunchConfigurationProperty;
import org.mule.weave.lsp.extension.client.WeaveLanguageClient;
import org.mule.weave.lsp.extension.client.WeaveQuickPickItem;
import org.mule.weave.lsp.extension.client.WeaveQuickPickItem$;
import org.mule.weave.lsp.extension.client.WeaveQuickPickParams;
import org.mule.weave.lsp.extension.client.WeaveQuickPickParams$;
import org.mule.weave.lsp.extension.client.WeaveQuickPickResult;
import org.mule.weave.lsp.utils.Icons;
import org.mule.weave.lsp.utils.Icons$vscode$;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000194AAC\u0006\u0001-!Aq\u0005\u0001B\u0001B\u0003%\u0001\u0006C\u00030\u0001\u0011\u0005\u0001\u0007C\u00045\u0001\t\u0007I\u0011A\u001b\t\rq\u0002\u0001\u0015!\u00037\u0011\u0015i\u0004\u0001\"\u0011?\u0011\u0015a\u0005\u0001\"\u0011N\u0011\u0015a\u0006\u0001\"\u0003^\u0011\u0015Q\u0007\u0001\"\u0011?\u0011\u0015Y\u0007\u0001\"\u0011m\u0005Ia\u0015-\u001e8dQ^+\u0017M^3D_6l\u0017M\u001c3\u000b\u00051i\u0011\u0001C2p[6\fg\u000eZ:\u000b\u00059y\u0011a\u00017ta*\u0011\u0001#E\u0001\u0006o\u0016\fg/\u001a\u0006\u0003%M\tA!\\;mK*\tA#A\u0002pe\u001e\u001c\u0001aE\u0002\u0001/}\u0001\"\u0001G\u000f\u000e\u0003eQ!AG\u000e\u0002\t1\fgn\u001a\u0006\u00029\u0005!!.\u0019<b\u0013\tq\u0012D\u0001\u0004PE*,7\r\u001e\t\u0003A\u0015j\u0011!\t\u0006\u0003E\r\n1!\u00199j\u0015\t!s\"A\u0005fqR,gn]5p]&\u0011a%\t\u0002\r/\u0016\fg/Z\"p[6\fg\u000eZ\u0001\u000fY\u0006tw-^1hK\u000ec\u0017.\u001a8u!\tIS&D\u0001+\u0015\tYC&\u0001\u0004dY&,g\u000e\u001e\u0006\u0003I5I!A\f\u0016\u0003']+\u0017M^3MC:<W/Y4f\u00072LWM\u001c;\u0002\rqJg.\u001b;?)\t\t4\u0007\u0005\u00023\u00015\t1\u0002C\u0003(\u0005\u0001\u0007\u0001&\u0001\u0003jG>tW#\u0001\u001c\u0011\u0005]RT\"\u0001\u001d\u000b\u0005ej\u0011!B;uS2\u001c\u0018BA\u001e9\u0005\u0015I5m\u001c8t\u0003\u0015I7m\u001c8!\u0003%\u0019w.\\7b]\u0012LE\rF\u0001@!\t\u0001\u0015J\u0004\u0002B\u000fB\u0011!)R\u0007\u0002\u0007*\u0011A)F\u0001\u0007yI|w\u000e\u001e \u000b\u0003\u0019\u000bQa]2bY\u0006L!\u0001S#\u0002\rA\u0013X\rZ3g\u0013\tQ5J\u0001\u0004TiJLgn\u001a\u0006\u0003\u0011\u0016\u000bq!\u001a=fGV$X\r\u0006\u0002O%B\u0011q\nU\u0007\u0002\u000b&\u0011\u0011+\u0012\u0002\u0007\u0003:L(+\u001a4\t\u000bM3\u0001\u0019\u0001+\u0002\rA\f'/Y7t!\t)&,D\u0001W\u0015\t9\u0006,A\u0003mgB$$N\u0003\u0002Z'\u00059Qm\u00197jaN,\u0017BA.W\u0005Q)\u00050Z2vi\u0016\u001cu.\\7b]\u0012\u0004\u0016M]1ng\u0006Q2M]3bi\u0016$UMZ1vYR\u001cuN\u001c4jOV\u0014\u0018\r^5p]R!a,Y2f!\tIs,\u0003\u0002aU\t\u0019B*Y;oG\"\u001cuN\u001c4jOV\u0014\u0018\r^5p]\")!m\u0002a\u0001\u007f\u0005YQ.\u00199qS:<g*Y7f\u0011\u0015!w\u00011\u0001@\u0003)\u0019wN\u001c4jORK\b/\u001a\u0005\u0006M\u001e\u0001\raZ\u0001\b]>$UMY;h!\ty\u0005.\u0003\u0002j\u000b\n9!i\\8mK\u0006t\u0017\u0001\u00028b[\u0016\f1\u0002Z3tGJL\u0007\u000f^5p]R\u0011q(\u001c\u0005\u0006'&\u0001\r\u0001\u0016")
public class LaunchWeaveCommand
implements WeaveCommand {
    private final WeaveLanguageClient languageClient;
    private final Icons icon;

    public Icons icon() {
        return this.icon;
    }

    @Override
    public String commandId() {
        return Commands$.MODULE$.DW_LAUNCH_MAPPING();
    }

    @Override
    public Object execute(ExecuteCommandParams params) {
        String mappingName = Commands$.MODULE$.argAsString(params.getArguments(), 0);
        String configType = Commands$.MODULE$.argAsString(params.getArguments(), 1);
        boolean noDebug = Commands$.MODULE$.argAsBoolean(params.getArguments(), 2);
        ConfigurationItem item = new ConfigurationItem();
        List workspaceFolders = (List)this.languageClient.workspaceFolders().get();
        if (workspaceFolders != null && !workspaceFolders.isEmpty()) {
            item.setScopeUri(((WorkspaceFolder)workspaceFolders.get(0)).getUri());
            item.setSection(LaunchConfiguration$.MODULE$.LAUNCH_REQUEST_TYPE());
            List configurations = (List)this.languageClient.configuration(new ConfigurationParams(Arrays.asList((Object[])new ConfigurationItem[]{item}))).get();
            ArrayList<LaunchConfiguration> results = new ArrayList<LaunchConfiguration>();
            if (!configurations.isEmpty()) {
                for (int e = 0; e < configurations.size(); ++e) {
                    Object config = configurations.get(0);
                    Object e2 = config;
                    if (!(e2 instanceof JsonObject)) continue;
                    JsonObject jsonObject = (JsonObject)e2;
                    JsonArray array = jsonObject.getAsJsonArray("configurations");
                    if (array == null) continue;
                    Iterator configs = array.iterator();
                    while (configs.hasNext()) {
                        Serializable serializable;
                        JsonObject launchConfig = ((JsonElement)configs.next()).getAsJsonObject();
                        String string = launchConfig.get(LaunchConfiguration$.MODULE$.TYPE_PROP_NAME()).getAsString();
                        String string2 = configType;
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            String string3 = launchConfig.get(LaunchConfiguration$.MODULE$.MAIN_FILE_NAME()).getAsString();
                            String string4 = mappingName;
                            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                                String string5 = launchConfig.get(LaunchConfiguration$.MODULE$.REQUEST_PROP_NAME()).getAsString();
                                String string6 = LaunchConfiguration$.MODULE$.LAUNCH_REQUEST_TYPE();
                                if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                                    Iterator entries = launchConfig.entrySet().iterator();
                                    String theName = launchConfig.get(LaunchConfiguration$.MODULE$.NAME_PROP_NAME()).getAsString();
                                    String theRequest = launchConfig.get(LaunchConfiguration$.MODULE$.REQUEST_PROP_NAME()).getAsString();
                                    ArrayList<LaunchConfigurationProperty> configurationProperties = new ArrayList<LaunchConfigurationProperty>();
                                    while (entries.hasNext()) {
                                        Map.Entry entry = (Map.Entry)entries.next();
                                        Serializable serializable2 = !LaunchConfiguration$.MODULE$.DEFAULT_CONFIG_NAMES().contains(entry.getKey()) ? BoxesRunTime.boxToBoolean(configurationProperties.add(new LaunchConfigurationProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonPrimitive().getAsString()))) : BoxedUnit.UNIT;
                                    }
                                    serializable = BoxesRunTime.boxToBoolean(results.add(new LaunchConfiguration(LaunchConfiguration$.MODULE$.DATA_WEAVE_CONFIG_TYPE_NAME(), theName, theRequest, noDebug, configurationProperties)));
                                    continue;
                                }
                            }
                        }
                        serializable = BoxedUnit.UNIT;
                    }
                }
            }
            if (results.isEmpty()) {
                LaunchConfiguration launchConfiguration = this.createDefaultConfiguration(mappingName, configType, noDebug);
                this.languageClient.runConfiguration(launchConfiguration);
            } else if (results.size() == 1) {
                this.languageClient.runConfiguration((LaunchConfiguration)results.get(0));
            } else {
                ArrayList<WeaveQuickPickItem> items = new ArrayList<WeaveQuickPickItem>();
                Iterator configIterators = results.iterator();
                int i = 0;
                while (configIterators.hasNext()) {
                    LaunchConfiguration configuration = (LaunchConfiguration)configIterators.next();
                    items.add(new WeaveQuickPickItem(Integer.toString(i), new StringBuilder(0).append(this.icon().file()).append(configuration.name()).toString(), WeaveQuickPickItem$.MODULE$.apply$default$3(), WeaveQuickPickItem$.MODULE$.apply$default$4(), WeaveQuickPickItem$.MODULE$.apply$default$5(), WeaveQuickPickItem$.MODULE$.apply$default$6()));
                    ++i;
                }
                WeaveQuickPickResult result2 = this.languageClient.weaveQuickPick(new WeaveQuickPickParams(items, "Select The Configuration To Run", WeaveQuickPickParams$.MODULE$.apply$default$3(), WeaveQuickPickParams$.MODULE$.apply$default$4(), WeaveQuickPickParams$.MODULE$.apply$default$5(), WeaveQuickPickParams$.MODULE$.apply$default$6(), WeaveQuickPickParams$.MODULE$.apply$default$7(), WeaveQuickPickParams$.MODULE$.apply$default$8(), WeaveQuickPickParams$.MODULE$.apply$default$9(), WeaveQuickPickParams$.MODULE$.apply$default$10())).get();
                if (!Predef$.MODULE$.Boolean2boolean(result2.cancelled())) {
                    this.languageClient.runConfiguration((LaunchConfiguration)results.get(new StringOps(Predef$.MODULE$.augmentString(result2.itemsId().get(0))).toInt()));
                }
            }
        } else {
            LaunchConfiguration launchConfiguration = this.createDefaultConfiguration(mappingName, configType, noDebug);
            this.languageClient.runConfiguration(launchConfiguration);
        }
        return null;
    }

    private LaunchConfiguration createDefaultConfiguration(String mappingName, String configType, boolean noDebug) {
        LaunchConfigurationProperty mapping = new LaunchConfigurationProperty(LaunchConfiguration$.MODULE$.MAIN_FILE_NAME(), mappingName);
        return new LaunchConfiguration(configType, new StringBuilder(10).append("Debugging ").append(mappingName).toString(), LaunchConfiguration$.MODULE$.LAUNCH_REQUEST_TYPE(), noDebug, Arrays.asList((Object[])new LaunchConfigurationProperty[]{mapping}));
    }

    @Override
    public String name() {
        return "Launch DataWeave.";
    }

    @Override
    public String description(ExecuteCommandParams params) {
        return "Launching DataWeave File.";
    }

    public LaunchWeaveCommand(WeaveLanguageClient languageClient) {
        this.languageClient = languageClient;
        this.icon = Icons$vscode$.MODULE$;
    }
}

