/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.commands;

import java.util.concurrent.CountDownLatch;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.mule.weave.dsp.DataWeaveDebuggerAdapterProtocolLauncher$;
import org.mule.weave.extension.api.WeaveCommand;
import org.mule.weave.lsp.commands.Commands$;
import org.mule.weave.lsp.extension.client.WeaveLanguageClient;
import org.mule.weave.lsp.jobs.JobManagerService;
import org.mule.weave.lsp.project.Project;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.components.ProcessLauncher;
import org.mule.weave.lsp.project.components.ProcessLauncher$;
import org.mule.weave.lsp.services.ClientLogger;
import org.mule.weave.lsp.services.DataWeaveTestService;
import org.mule.weave.lsp.utils.NetUtils$;
import org.mule.weave.lsp.vfs.ProjectVirtualFileSystem;
import org.mule.weave.v2.editor.VirtualFileSystem;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0$mcV$sp;

@ScalaSignature(bytes="\u0006\u0001\u00055b\u0001B\b\u0011\u0001mA\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tk\u0001\u0011\t\u0011)A\u0005m!AA\b\u0001B\u0001B\u0003%Q\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003D\u0011!1\u0005A!A!\u0002\u00139\u0005\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u0011Q\u0003!\u0011!Q\u0001\nUC\u0001\u0002\u0018\u0001\u0003\u0002\u0003\u0006I!\u0018\u0005\u0006A\u0002!\t!\u0019\u0005\u0006Y\u0002!\t%\u001c\u0005\u0006w\u0002!\t\u0005 \u0005\b\u0003/\u0001A\u0011AA\r\u0011\u0019\t)\u0003\u0001C![\"9\u0011q\u0005\u0001\u0005B\u0005%\"a\u0004*v]^+\u0017M^3D_6l\u0017M\u001c3\u000b\u0005E\u0011\u0012\u0001C2p[6\fg\u000eZ:\u000b\u0005M!\u0012a\u00017ta*\u0011QCF\u0001\u0006o\u0016\fg/\u001a\u0006\u0003/a\tA!\\;mK*\t\u0011$A\u0002pe\u001e\u001c\u0001aE\u0002\u00019\u0011\u0002\"!\b\u0012\u000e\u0003yQ!a\b\u0011\u0002\t1\fgn\u001a\u0006\u0002C\u0005!!.\u0019<b\u0013\t\u0019cD\u0001\u0004PE*,7\r\u001e\t\u0003K)j\u0011A\n\u0006\u0003O!\n1!\u00199j\u0015\tIC#A\u0005fqR,gn]5p]&\u00111F\n\u0002\r/\u0016\fg/Z\"p[6\fg\u000eZ\u0001\u0012m&\u0014H/^1m\r&dWmU=ti\u0016l\u0007C\u0001\u00184\u001b\u0005y#B\u0001\u00192\u0003\u0019)G-\u001b;pe*\u0011!\u0007F\u0001\u0003mJJ!\u0001N\u0018\u0003#YK'\u000f^;bY\u001aKG.Z*zgR,W.\u0001\rqe>TWm\u0019;WSJ$X/\u00197GS2,7+_:uK6\u0004\"a\u000e\u001e\u000e\u0003aR!!\u000f\n\u0002\u0007Y47/\u0003\u0002<q\tA\u0002K]8kK\u000e$h+\u001b:uk\u0006dg)\u001b7f'f\u001cH/Z7\u0002\u000fA\u0014xN[3diB\u0011a\bQ\u0007\u0002\u007f)\u0011AHE\u0005\u0003\u0003~\u0012q\u0001\u0015:pU\u0016\u001cG/A\u0006qe>TWm\u0019;LS:$\u0007C\u0001 E\u0013\t)uHA\u0006Qe>TWm\u0019;LS:$\u0017\u0001D2mS\u0016tG\u000fT8hO\u0016\u0014\bC\u0001%L\u001b\u0005I%B\u0001&\u0013\u0003!\u0019XM\u001d<jG\u0016\u001c\u0018B\u0001'J\u00051\u0019E.[3oi2{wmZ3s\u0003EQwNY'b]\u0006<WM]*feZL7-\u001a\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#J\tAA[8cg&\u00111\u000b\u0015\u0002\u0012\u0015>\u0014W*\u00198bO\u0016\u00148+\u001a:wS\u000e,\u0017A\u00047b]\u001e,\u0018mZ3DY&,g\u000e\u001e\t\u0003-jk\u0011a\u0016\u0006\u00031f\u000baa\u00197jK:$(BA\u0015\u0013\u0013\tYvKA\nXK\u00064X\rT1oOV\fw-Z\"mS\u0016tG/\u0001\u000beCR\fw+Z1wKR+7\u000f^*feZL7-\u001a\t\u0003\u0011zK!aX%\u0003)\u0011\u000bG/Y,fCZ,G+Z:u'\u0016\u0014h/[2f\u0003\u0019a\u0014N\\5u}QI!\rZ3gO\"L'n\u001b\t\u0003G\u0002i\u0011\u0001\u0005\u0005\u0006Y%\u0001\r!\f\u0005\u0006k%\u0001\rA\u000e\u0005\u0006y%\u0001\r!\u0010\u0005\u0006\u0005&\u0001\ra\u0011\u0005\u0006\r&\u0001\ra\u0012\u0005\u0006\u001b&\u0001\rA\u0014\u0005\u0006)&\u0001\r!\u0016\u0005\u00069&\u0001\r!X\u0001\nG>lW.\u00198e\u0013\u0012$\u0012A\u001c\t\u0003_bt!\u0001\u001d<\u0011\u0005E$X\"\u0001:\u000b\u0005MT\u0012A\u0002\u001fs_>$hHC\u0001v\u0003\u0015\u00198-\u00197b\u0013\t9H/\u0001\u0004Qe\u0016$WMZ\u0005\u0003sj\u0014aa\u0015;sS:<'BA<u\u0003\u001d)\u00070Z2vi\u0016$2!`A\u0002!\tqx0D\u0001u\u0013\r\t\t\u0001\u001e\u0002\u0007\u0003:L(+\u001a4\t\u000f\u0005\u00151\u00021\u0001\u0002\b\u00051\u0001/\u0019:b[N\u0004B!!\u0003\u0002\u00145\u0011\u00111\u0002\u0006\u0005\u0003\u001b\ty!A\u0003mgB$$NC\u0002\u0002\u0012a\tq!Z2mSB\u001cX-\u0003\u0003\u0002\u0016\u0005-!\u0001F#yK\u000e,H/Z\"p[6\fg\u000e\u001a)be\u0006l7/\u0001\u0006sk:l\u0015\r\u001d9j]\u001e$B!a\u0007\u0002\"A\u0019Q$!\b\n\u0007\u0005}aDA\u0004J]R,w-\u001a:\t\r\u0005\rB\u00021\u0001o\u0003\u0019\u0019wN\u001c4jO\u0006!a.Y7f\u0003-!Wm]2sSB$\u0018n\u001c8\u0015\u00079\fY\u0003C\u0004\u0002\u00069\u0001\r!a\u0002")
public class RunWeaveCommand
implements WeaveCommand {
    private final VirtualFileSystem virtualFileSystem;
    private final ProjectVirtualFileSystem projectVirtualFileSystem;
    private final Project project;
    private final ProjectKind projectKind;
    private final ClientLogger clientLogger;
    private final JobManagerService jobManagerService;
    private final WeaveLanguageClient languageClient;
    private final DataWeaveTestService dataWeaveTestService;

    @Override
    public String commandId() {
        return Commands$.MODULE$.DW_RUN_MAPPING();
    }

    @Override
    public Object execute(ExecuteCommandParams params) {
        String configType = Commands$.MODULE$.argAsString(params.getArguments(), 0);
        return this.runMapping(configType);
    }

    public Integer runMapping(String config) {
        if (!this.project.isStarted()) {
            this.languageClient.showMessage(new MessageParams(MessageType.Warning, "Can not run a DW script until Project was initialized."));
            return Predef$.MODULE$.int2Integer(-1);
        }
        int port = NetUtils$.MODULE$.freePort();
        CountDownLatch latch = new CountDownLatch(1);
        this.jobManagerService.schedule(status -> {
            ProcessLauncher launcher = ProcessLauncher$.MODULE$.createLauncherByType(config, $this.projectKind, $this.clientLogger, $this.languageClient, $this.projectVirtualFileSystem);
            DataWeaveDebuggerAdapterProtocolLauncher$.MODULE$.launch($this.virtualFileSystem, $this.clientLogger, $this.languageClient, launcher, $this.projectKind, $this.jobManagerService, $this.dataWeaveTestService, (JFunction0$mcV$sp & Serializable)() -> latch.countDown(), port);
        }, "Starting Debugger Server", "Starting Debugger Server");
        latch.await();
        return Predef$.MODULE$.int2Integer(port);
    }

    @Override
    public String name() {
        return "Run DataWeave.";
    }

    @Override
    public String description(ExecuteCommandParams params) {
        return "Running DataWeave Command.";
    }

    public RunWeaveCommand(VirtualFileSystem virtualFileSystem, ProjectVirtualFileSystem projectVirtualFileSystem, Project project, ProjectKind projectKind, ClientLogger clientLogger, JobManagerService jobManagerService, WeaveLanguageClient languageClient, DataWeaveTestService dataWeaveTestService) {
        this.virtualFileSystem = virtualFileSystem;
        this.projectVirtualFileSystem = projectVirtualFileSystem;
        this.project = project;
        this.projectKind = projectKind;
        this.clientLogger = clientLogger;
        this.jobManagerService = jobManagerService;
        this.languageClient = languageClient;
        this.dataWeaveTestService = dataWeaveTestService;
    }
}

