/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.services;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.ApplyWorkspaceEditResponse;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.DeleteFile;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ResourceOperation;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.mule.weave.lsp.extension.client.SampleInput;
import org.mule.weave.lsp.extension.client.ShowScenariosParams;
import org.mule.weave.lsp.extension.client.WeaveLanguageClient;
import org.mule.weave.lsp.extension.client.WeaveScenario;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.components.SampleDataManager;
import org.mule.weave.lsp.project.components.Scenario;
import org.mule.weave.lsp.project.components.Scenario$;
import org.mule.weave.lsp.services.DataWeaveToolingService;
import org.mule.weave.lsp.services.ToolingService;
import org.mule.weave.lsp.services.WeaveScenarioManagerService$;
import org.mule.weave.lsp.services.events.ActiveScenarioChangedEvent;
import org.mule.weave.lsp.services.events.DocumentFocusChangedEvent$;
import org.mule.weave.lsp.services.events.OnDocumentFocused;
import org.mule.weave.lsp.utils.EventBus;
import org.mule.weave.lsp.utils.InputScaffolding;
import org.mule.weave.lsp.utils.InputScaffoldingFactory$;
import org.mule.weave.lsp.utils.LSPConverters$;
import org.mule.weave.lsp.utils.URLUtils$;
import org.mule.weave.lsp.utils.WeaveDirectoryUtils$;
import org.mule.weave.v2.editor.VirtualFile;
import org.mule.weave.v2.editor.VirtualFileSystem;
import org.mule.weave.v2.editor.WeaveDocumentToolingService;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.AstNodeHelper$;
import org.mule.weave.v2.parser.ast.WeaveLocationCapable;
import org.mule.weave.v2.parser.ast.functions.FunctionCallNode;
import org.mule.weave.v2.parser.ast.functions.FunctionCallParametersNode;
import org.mule.weave.v2.parser.ast.structure.ArrayNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier$;
import org.mule.weave.v2.parser.ast.variables.VariableReferenceNode;
import org.mule.weave.v2.sdk.NameIdentifierHelper$;
import org.mule.weave.v2.utils.StringHelper$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\tuh\u0001B\u00181\u0001mB\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0017\"A1\u000b\u0001BC\u0002\u0013\u0005A\u000b\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003V\u0011\u0015q\u0006\u0001\"\u0001`\u0011%!\u0007\u00011AA\u0002\u0013%Q\rC\u0005m\u0001\u0001\u0007\t\u0019!C\u0005[\"I1\u000f\u0001a\u0001\u0002\u0003\u0006KA\u001a\u0005\ni\u0002\u0001\r\u00111A\u0005\u0012UD\u0011\u0002 \u0001A\u0002\u0003\u0007I\u0011C?\t\u0013}\u0004\u0001\u0019!A!B\u00131\b\"CA\u0001\u0001\u0001\u0007I\u0011AA\u0002\u0011%\t)\u0004\u0001a\u0001\n\u0003\t9\u0004\u0003\u0005\u0002<\u0001\u0001\u000b\u0015BA\u0003\u0011\u001d\ti\u0004\u0001C\u0001\u0003\u007fAq!a\u001b\u0001\t\u0003\ni\u0007C\u0004\u0002t\u0001!\t!!\u001e\t\u000f\u0005m\u0004\u0001\"\u0001\u0002~!9\u00111\u0014\u0001\u0005\u0002\u0005u\u0005bBAQ\u0001\u0011\u0005\u00111\u0015\u0005\b\u0003_\u0003A\u0011AAY\u0011\u001d\tI\f\u0001C\u0001\u0003wCq!!1\u0001\t\u0003\t\u0019\rC\u0004\u0002\\\u0002!I!!8\t\u000f\u0005\u001d\b\u0001\"\u0001\u0002j\"9\u0011q\u001f\u0001\u0005\u0002\u0005e\bb\u0002B\u0002\u0001\u0011\u0005!Q\u0001\u0005\b\u0005\u001f\u0001A\u0011\u0001B\t\u0011%\u0011\t\u0003AI\u0001\n\u0003\u0011\u0019\u0003C\u0004\u0003:\u0001!\tBa\u000f\t\u000f\t\u0015\u0003\u0001\"\u0003\u0003H!9!1\u000f\u0001\u0005\n\tU\u0004b\u0002B=\u0001\u0011%!1\u0010\u0005\b\u0005#\u0003A\u0011\u0002BJ\u0011\u001d\u0011\t\n\u0001C\u0005\u0005KCqA!,\u0001\t\u0013\u0011y\u000bC\u0004\u0003:\u0002!IAa/\t\u000f\t\u0005\u0007\u0001\"\u0005\u0003D\"9!1\u001a\u0001\u0005\n\t5\u0007b\u0002Bj\u0001\u0011%!Q\u001b\u0005\b\u0005'\u0004A\u0011\u0002Bq\u000f\u001d\u0011)\u000f\rE\u0001\u0005O4aa\f\u0019\t\u0002\t%\bB\u00020,\t\u0003\u0011Y\u000fC\u0005\u0003n.\u0012\r\u0011\"\u0001\u0003p\"A!1`\u0016!\u0002\u0013\u0011\tPA\u000eXK\u00064XmU2f]\u0006\u0014\u0018n\\'b]\u0006<WM]*feZL7-\u001a\u0006\u0003cI\n\u0001b]3sm&\u001cWm\u001d\u0006\u0003gQ\n1\u0001\\:q\u0015\t)d'A\u0003xK\u00064XM\u0003\u00028q\u0005!Q.\u001e7f\u0015\u0005I\u0014aA8sO\u000e\u00011c\u0001\u0001=\u0005B\u0011Q\bQ\u0007\u0002})\tq(A\u0003tG\u0006d\u0017-\u0003\u0002B}\t1\u0011I\\=SK\u001a\u0004\"a\u0011#\u000e\u0003AJ!!\u0012\u0019\u0003\u001dQ{w\u000e\\5oON+'O^5dK\u00069B-\u0019;b/\u0016\fg/\u001a+p_2LgnZ*feZL7-\u001a\t\u0003\u0007\"K!!\u0013\u0019\u0003/\u0011\u000bG/Y,fCZ,Gk\\8mS:<7+\u001a:wS\u000e,\u0017aE<fCZ,G*\u00198hk\u0006<Wm\u00117jK:$\bC\u0001'R\u001b\u0005i%B\u0001(P\u0003\u0019\u0019G.[3oi*\u0011\u0001KM\u0001\nKb$XM\\:j_:L!AU'\u0003']+\u0017M^3MC:<W/Y4f\u00072LWM\u001c;\u0002#YL'\u000f^;bY\u001aKG.Z*zgR,W.F\u0001V!\t16,D\u0001X\u0015\tA\u0016,\u0001\u0004fI&$xN\u001d\u0006\u00035R\n!A\u001e\u001a\n\u0005q;&!\u0005,jeR,\u0018\r\u001c$jY\u0016\u001c\u0016p\u001d;f[\u0006\u0011b/\u001b:uk\u0006dg)\u001b7f'f\u001cH/Z7!\u0003\u0019a\u0014N\\5u}Q!\u0001-\u00192d!\t\u0019\u0005\u0001C\u0003G\u000b\u0001\u0007q\tC\u0003K\u000b\u0001\u00071\nC\u0003T\u000b\u0001\u0007Q+\u0001\u0005fm\u0016tGOQ;t+\u00051\u0007CA4k\u001b\u0005A'BA53\u0003\u0015)H/\u001b7t\u0013\tY\u0007N\u0001\u0005Fm\u0016tGOQ;t\u00031)g/\u001a8u\u0005V\u001cx\fJ3r)\tq\u0017\u000f\u0005\u0002>_&\u0011\u0001O\u0010\u0002\u0005+:LG\u000fC\u0004s\u000f\u0005\u0005\t\u0019\u00014\u0002\u0007a$\u0013'A\u0005fm\u0016tGOQ;tA\u0005Y\u0001O]8kK\u000e$8*\u001b8e+\u00051\bCA<{\u001b\u0005A(BA=3\u0003\u001d\u0001(o\u001c6fGRL!a\u001f=\u0003\u0017A\u0013xN[3di.Kg\u000eZ\u0001\u0010aJ|'.Z2u\u0017&tGm\u0018\u0013fcR\u0011aN \u0005\be*\t\t\u00111\u0001w\u00031\u0001(o\u001c6fGR\\\u0015N\u001c3!\u0003=\t7\r^5wKN\u001bWM\\1sS>\u001cXCAA\u0003!!\t9!!\u0005\u0002\u0016\u0005%RBAA\u0005\u0015\u0011\tY!!\u0004\u0002\u000f5,H/\u00192mK*\u0019\u0011q\u0002 \u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0014\u0005%!a\u0002%bg\"l\u0015\r\u001d\t\u0005\u0003/\t)#\u0004\u0002\u0002\u001a)!\u00111DA\u000f\u0003%1\u0018M]5bE2,7O\u0003\u0003\u0002 \u0005\u0005\u0012aA1ti*\u0019\u00111E-\u0002\rA\f'o]3s\u0013\u0011\t9#!\u0007\u0003\u001d9\u000bW.Z%eK:$\u0018NZ5feB!\u00111FA\u0019\u001b\t\tiCC\u0002\u00020a\f!bY8na>tWM\u001c;t\u0013\u0011\t\u0019$!\f\u0003\u0011M\u001bWM\\1sS>\f1#Y2uSZ,7kY3oCJLwn]0%KF$2A\\A\u001d\u0011!\u0011X\"!AA\u0002\u0005\u0015\u0011\u0001E1di&4XmU2f]\u0006\u0014\u0018n\\:!\u00031i\u0017\r]*dK:\f'/[8t)\u0019\t\t%a\u0016\u0002bA1\u00111IA'\u0003#j!!!\u0012\u000b\t\u0005\u001d\u0013\u0011J\u0001\u0005kRLGN\u0003\u0002\u0002L\u0005!!.\u0019<b\u0013\u0011\ty%!\u0012\u0003\t1K7\u000f\u001e\t\u0004\u0019\u0006M\u0013bAA+\u001b\niq+Z1wKN\u001bWM\\1sS>Dq!!\u0017\u0010\u0001\u0004\tY&A\nnCf\u0014W-Q2uSZ,7kY3oCJLw\u000eE\u0003>\u0003;\nI#C\u0002\u0002`y\u0012aa\u00149uS>t\u0007bBA2\u001f\u0001\u0007\u0011QM\u0001\rC2d7kY3oCJLwn\u001d\t\u0006{\u0005\u001d\u0014\u0011F\u0005\u0004\u0003Sr$!B!se\u0006L\u0018\u0001B5oSR$RA\\A8\u0003cBQ\u0001\u001e\tA\u0002YDQ\u0001\u001a\tA\u0002\u0019\fQ\u0002\\5tiN\u001bWM\\1sS>\u001cH\u0003BA3\u0003oBq!!\u001f\u0012\u0001\u0004\t)\"\u0001\boC6,\u0017\nZ3oi&4\u0017.\u001a:\u0002)M,\u0017M]2i'\u000e,g.\u0019:j_\nKh*Y7f)\u0019\tY&a \u0002\u0002\"9\u0011\u0011\u0010\nA\u0002\u0005U\u0001bBAB%\u0001\u0007\u0011QQ\u0001\rg\u000e,g.\u0019:j_:\u000bW.\u001a\t\u0005\u0003\u000f\u000b)J\u0004\u0003\u0002\n\u0006E\u0005cAAF}5\u0011\u0011Q\u0012\u0006\u0004\u0003\u001fS\u0014A\u0002\u001fs_>$h(C\u0002\u0002\u0014z\na\u0001\u0015:fI\u00164\u0017\u0002BAL\u00033\u0013aa\u0015;sS:<'bAAJ}\u0005q\u0011m\u0019;jm\u0016\u001c6-\u001a8be&|G\u0003BA.\u0003?Cq!!\u001f\u0014\u0001\u0004\t)\"\u0001\bd_BL8kY3oCJLw\u000eV8\u0015\u000f9\f)+!+\u0002.\"9\u0011q\u0015\u000bA\u0002\u0005U\u0011!E7baBLgnZ%eK:$\u0018NZ5fe\"9\u00111\u0016\u000bA\u0002\u0005%\u0012aC8mIN\u001bWM\\1sS>Dq!a!\u0015\u0001\u0004\t))A\ttKR\f5\r^5wKN\u001bWM\\1sS>$RA\\AZ\u0003kCq!!\u001f\u0016\u0001\u0004\t)\u0002C\u0004\u00028V\u0001\r!!\"\u0002#9\fW.Z(g)\",7kY3oCJLw.\u0001\beK2,G/Z*dK:\f'/[8\u0015\u000b9\fi,a0\t\u000f\u0005ed\u00031\u0001\u0002\u0016!9\u0011q\u0017\fA\u0002\u0005\u0015\u0015!G2sK\u0006$Xm\u0014:Va\u0012\fG/Z'baBLgn\u001a+fgR$\u0002\"!2\u0002T\u0006U\u0017q\u001b\t\u0006{\u0005u\u0013q\u0019\t\u0005\u0003\u0013\fy-\u0004\u0002\u0002L*!\u0011QZA%\u0003\tIw.\u0003\u0003\u0002R\u0006-'\u0001\u0002$jY\u0016Dq!!\u001f\u0018\u0001\u0004\t)\u0002C\u0004\u0002\u0004^\u0001\r!!\"\t\u000f\u0005ew\u00031\u0001\u0002\u0006\u0006AQ.[7f)f\u0004X-\u0001\u0006e_N\u000bg/\u001a+fgR$\u0002\"!2\u0002`\u0006\u0005\u0018Q\u001d\u0005\b\u0003sB\u0002\u0019AA\u000b\u0011\u001d\t\u0019\u000f\u0007a\u0001\u0003S\t\u0001b]2f]\u0006\u0014\u0018n\u001c\u0005\b\u00033D\u0002\u0019AAC\u0003)\u0019\u0018M^3PkR\u0004X\u000f\u001e\u000b\u000b\u0003\u000b\fY/!<\u0002p\u0006M\bbBA=3\u0001\u0007\u0011Q\u0003\u0005\b\u0003oK\u0002\u0019AAC\u0011\u001d\t\t0\u0007a\u0001\u0003\u000b\u000b!b\\;uaV$h*Y7f\u0011\u001d\t)0\u0007a\u0001\u0003\u000b\u000b!B\\3x\u0007>tG/\u001a8u\u00031!W\r\\3uK>+H\u000f];u)\u001dq\u00171`A\u007f\u0003\u007fDq!!\u001f\u001b\u0001\u0004\t)\u0002C\u0004\u00028j\u0001\r!!\"\t\u000f\t\u0005!\u00041\u0001\u0002\u0006\u0006Iq.\u001e;qkR,&\u000f\\\u0001\fI\u0016dW\r^3J]B,H\u000fF\u0004o\u0005\u000f\u0011IAa\u0003\t\u000f\u0005e4\u00041\u0001\u0002\u0016!9\u0011qW\u000eA\u0002\u0005\u0015\u0005b\u0002B\u00077\u0001\u0007\u0011QQ\u0001\tS:\u0004X\u000f^+sY\u0006q1M]3bi\u0016\u001c6-\u001a8be&|GCCAc\u0005'\u0011)Ba\u0006\u0003\u001c!9\u0011\u0011\u0010\u000fA\u0002\u0005U\u0001bBA\\9\u0001\u0007\u0011Q\u0011\u0005\b\u00053a\u0002\u0019AAC\u00035Ig\u000e];u\r&dWMT1nK\"I!Q\u0004\u000f\u0011\u0002\u0003\u0007!qD\u0001\u0012[\u0006L(-Z%oaV$8i\u001c8uK:$\b#B\u001f\u0002^\u0005\u0015\u0015\u0001G2sK\u0006$XmU2f]\u0006\u0014\u0018n\u001c\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!Q\u0005\u0016\u0005\u0005?\u00119c\u000b\u0002\u0003*A!!1\u0006B\u001b\u001b\t\u0011iC\u0003\u0003\u00030\tE\u0012!C;oG\",7m[3e\u0015\r\u0011\u0019DP\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u001c\u0005[\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035!wn\u0011:fCR,\u0017J\u001c9viRQ\u0011Q\u0019B\u001f\u0005\u007f\u0011\tEa\u0011\t\u000f\u0005ed\u00041\u0001\u0002\u0016!9!\u0011\u0004\u0010A\u0002\u0005\u0015\u0005b\u0002B\u000f=\u0001\u0007!q\u0004\u0005\b\u0003Gt\u0002\u0019AAd\u00035!W\r\\3uK\u001aKG.Z\"nIR!!\u0011\nB8!!\u0011YE!\u0018\u0003b\t%TB\u0001B'\u0015\u0011\u0011yE!\u0015\u0002\u00115,7o]1hKNTAAa\u0015\u0003V\u00059!n]8oeB\u001c'\u0002\u0002B,\u00053\nQ\u0001\\:qi)T1Aa\u00179\u0003\u001d)7\r\\5qg\u0016LAAa\u0018\u0003N\t1Q)\u001b;iKJ\u0004BAa\u0019\u0003f5\u0011!QK\u0005\u0005\u0005O\u0012)F\u0001\tUKb$Hi\\2v[\u0016tG/\u00123jiB!!1\rB6\u0013\u0011\u0011iG!\u0016\u0003#I+7o\\;sG\u0016|\u0005/\u001a:bi&|g\u000eC\u0004\u0003r}\u0001\r!a2\u0002\u001f\u0011,7\u000f^5oCRLwN\u001c$jY\u0016\fQb\u0019:fCR,g)\u001b7f\u00076$G\u0003\u0002B%\u0005oBqA!\u001d!\u0001\u0004\t9-A\u0006fI&$h)\u001b7f\u00076$GC\u0003B%\u0005{\u0012yH!#\u0003\u000e\"9!\u0011O\u0011A\u0002\u0005\u001d\u0007b\u0002BAC\u0001\u0007!1Q\u0001\tgR\f'\u000f\u001e)pgB!!1\rBC\u0013\u0011\u00119I!\u0016\u0003\u0011A{7/\u001b;j_:DqAa#\"\u0001\u0004\u0011\u0019)\u0001\u0004f]\u0012\u0004vn\u001d\u0005\b\u0005\u001f\u000b\u0003\u0019AAC\u0003\u001dqWm\u001e+fqR\f!\"\u00199qYf,E-\u001b;t)\u0011\u0011)Ja'\u0011\t\t\r$qS\u0005\u0005\u00053\u0013)F\u0001\u000eBaBd\u0017pV8sWN\u0004\u0018mY3FI&$(+Z:q_:\u001cX\rC\u0004\u0003\u001e\n\u0002\rAa(\u0002\u000b\u0015$\u0017\u000e^:\u0011\u000bu\u0012\tK!\u0013\n\u0007\t\rfH\u0001\u0006=e\u0016\u0004X-\u0019;fIz\"BA!&\u0003(\"9!\u0011V\u0012A\u0002\t-\u0016!C3eSR\u001cH*[:u!\u0019\t\u0019%!\u0014\u0003J\u0005aAm\\*bm\u0016|U\u000f\u001e9viRQ\u0011Q\u0019BY\u0005g\u0013)La.\t\u000f\u0005eD\u00051\u0001\u0002\u0016!9\u0011\u0011\u001f\u0013A\u0002\u0005\u0015\u0005bBArI\u0001\u0007\u0011q\u0019\u0005\b\u0005\u001f#\u0003\u0019AAC\u0003!yW\u000f\u001e9vi>3GCBAd\u0005{\u0013y\fC\u0004\u0002d\u0016\u0002\r!a2\t\u000f\u0005EX\u00051\u0001\u0002\u0006\u00069\u0011N\u001c9vi>3GCBAd\u0005\u000b\u00149\rC\u0004\u0002d\u001a\u0002\r!a2\t\u000f\t%g\u00051\u0001\u0002\u0006\u0006I\u0011N\u001c9vi:\u000bW.Z\u0001\u0010O\u0016$h+\u0019:jC\ndW\rU1uQR!\u0011Q\u0011Bh\u0011\u001d\u0011\tn\na\u0001\u0003\u000b\u000b\u0001BZ5mK:\u000bW.Z\u0001\u0013]>$\u0018NZ=BY2\u001c6-\u001a8be&|7\u000fF\u0002o\u0005/DqA!7)\u0001\u0004\u0011Y.\u0001\u0002wMB\u0019aK!8\n\u0007\t}wKA\u0006WSJ$X/\u00197GS2,Gc\u00018\u0003d\"9\u0011\u0011P\u0015A\u0002\u0005U\u0011aG,fCZ,7kY3oCJLw.T1oC\u001e,'oU3sm&\u001cW\r\u0005\u0002DWM\u00111\u0006\u0010\u000b\u0003\u0005O\fQ\u0002R#G\u0003VcEkX%O!V#VC\u0001By!\u0011\u0011\u0019P!?\u000e\u0005\tU(\u0002\u0002B|\u0003\u0013\nA\u0001\\1oO&!\u0011q\u0013B{\u00039!UIR!V\u0019R{\u0016J\u0014)V)\u0002\u0002")
public class WeaveScenarioManagerService
implements ToolingService {
    private final DataWeaveToolingService dataWeaveToolingService;
    private final WeaveLanguageClient weaveLanguageClient;
    private final VirtualFileSystem virtualFileSystem;
    private EventBus eventBus;
    private ProjectKind projectKind;
    private HashMap<NameIdentifier, Scenario> activeScenarios;

    public static String DEFAULT_INPUT() {
        return WeaveScenarioManagerService$.MODULE$.DEFAULT_INPUT();
    }

    public VirtualFileSystem virtualFileSystem() {
        return this.virtualFileSystem;
    }

    private EventBus eventBus() {
        return this.eventBus;
    }

    private void eventBus_$eq(EventBus x$1) {
        this.eventBus = x$1;
    }

    public ProjectKind projectKind() {
        return this.projectKind;
    }

    public void projectKind_$eq(ProjectKind x$1) {
        this.projectKind = x$1;
    }

    public HashMap<NameIdentifier, Scenario> activeScenarios() {
        return this.activeScenarios;
    }

    public void activeScenarios_$eq(HashMap<NameIdentifier, Scenario> x$1) {
        this.activeScenarios = x$1;
    }

    public List<WeaveScenario> mapScenarios(Option<Scenario> maybeActiveScenario, Scenario[] allScenarios) {
        String defaultScenarioName = (String)maybeActiveScenario.map((Function1<Scenario, String> & Serializable & scala.Serializable)x$1 -> x$1.name()).getOrElse((Function0<String> & Serializable & scala.Serializable)() -> "");
        WeaveScenario[] scenarios = (WeaveScenario[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])allScenarios)).map((Function1<Scenario, WeaveScenario> & Serializable & scala.Serializable)scenario -> {
            SampleInput[] inputsList = scenario.inputs();
            String expectedOrNull = (String)scenario.expected().map((Function1<File, String> & Serializable & scala.Serializable)file -> URLUtils$.MODULE$.toLSPUrl((File)file)).orNull(Predef$.MODULE$.$conforms());
            return new WeaveScenario(Predef$.MODULE$.boolean2Boolean(scenario.name().equals(defaultScenarioName)), scenario.name(), URLUtils$.MODULE$.toLSPUrl(scenario.file()), inputsList, expectedOrNull);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(WeaveScenario.class)));
        return JavaConverters$.MODULE$.seqAsJavaListConverter(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])scenarios)).toList()).asJava();
    }

    @Override
    public void init(ProjectKind projectKind, EventBus eventBus) {
        this.projectKind_$eq(projectKind);
        this.eventBus_$eq(eventBus);
        eventBus.register(DocumentFocusChangedEvent$.MODULE$.DOCUMENT_FOCUS_CHANGED(), new OnDocumentFocused(this, projectKind){
            private final /* synthetic */ WeaveScenarioManagerService $outer;
            private final ProjectKind projectKind$1;

            public void onDocumentFocused(VirtualFile vf) {
                boolean isPartOfTheTestResources;
                File[] resources = WeaveDirectoryUtils$.MODULE$.wtfResourcesTestFolder(this.projectKind$1.structure());
                boolean bl = isPartOfTheTestResources = !new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])resources)).exists((Function1<Object, Object>)(Function1<File, Object> & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean($anon$1.$anonfun$onDocumentFocused$1(vf, f)));
                if (URLUtils$.MODULE$.isSupportedEditableScheme(vf.url()) && isPartOfTheTestResources) {
                    this.$outer.org$mule$weave$lsp$services$WeaveScenarioManagerService$$notifyAllScenarios(vf);
                    return;
                }
            }

            public static final /* synthetic */ boolean $anonfun$onDocumentFocused$1(VirtualFile vf$1, File f) {
                return URLUtils$.MODULE$.isChildOf(vf$1.url(), f);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.projectKind$1 = projectKind$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onDocumentFocused$1$adapted(org.mule.weave.v2.editor.VirtualFile java.io.File )}, serializedLambda);
            }
        });
    }

    public Scenario[] listScenarios(NameIdentifier nameIdentifier) {
        return this.projectKind().sampleDataManager().listScenarios(nameIdentifier);
    }

    public Option<Scenario> searchScenarioByName(NameIdentifier nameIdentifier, String scenarioName) {
        return this.projectKind().sampleDataManager().searchScenarioByName(nameIdentifier, scenarioName);
    }

    public Option<Scenario> activeScenario(NameIdentifier nameIdentifier) {
        return this.activeScenarios().get(nameIdentifier).orElse((Function0<Option> & Serializable & scala.Serializable)() -> {
            Scenario[] scenarios = this.listScenarios(nameIdentifier);
            if (scenarios != null && new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])scenarios)).nonEmpty()) {
                Option maybeFirstScenario = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])scenarios)).find((Function1<Object, Object>)(Function1<Scenario, Object> & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean(WeaveScenarioManagerService.$anonfun$activeScenario$2(s))).orElse((Function0<Option> & Serializable & scala.Serializable)() -> new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])scenarios)).headOption());
                maybeFirstScenario.foreach((Function1<Scenario, Option> & Serializable & scala.Serializable)scenario -> this.activeScenarios().put(nameIdentifier, (Scenario)scenario));
                return maybeFirstScenario;
            }
            return None$.MODULE$;
        });
    }

    public void copyScenarioTo(NameIdentifier mappingIdentifier, Scenario oldScenario, String scenarioName) {
        SampleInput[] inputs = oldScenario.inputs();
        if (new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])inputs)).isEmpty()) {
            this.createScenario(mappingIdentifier, scenarioName, WeaveScenarioManagerService$.MODULE$.DEFAULT_INPUT(), None$.MODULE$);
            return;
        }
        new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])inputs)).foreach((Function1<SampleInput, Option> & Serializable & scala.Serializable)input -> URLUtils$.MODULE$.toFile(input.uri()).map((Function1<File, Option> & Serializable & scala.Serializable)oldInputFile -> {
            String inputName = new StringBuilder(1).append(input.name()).append(".").append(FilenameUtils.getExtension(oldInputFile.getName())).toString();
            String content = FileUtils.readFileToString(oldInputFile, Charset.defaultCharset());
            return this.createScenario(mappingIdentifier, scenarioName, inputName, new Some<String>(content));
        }));
    }

    public void setActiveScenario(NameIdentifier nameIdentifier, String nameOfTheScenario) {
        Option<Object> maybeScenario = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])this.projectKind().sampleDataManager().listScenarios(nameIdentifier))).find((Function1<Object, Object>)(Function1<Scenario, Object> & Serializable & scala.Serializable)scenario -> BoxesRunTime.boxToBoolean(WeaveScenarioManagerService.$anonfun$setActiveScenario$1(nameOfTheScenario, scenario)));
        maybeScenario.foreach((Function1<Scenario, Object> & Serializable & scala.Serializable)s -> {
            WeaveScenarioManagerService.$anonfun$setActiveScenario$2(this, nameIdentifier, s);
            return BoxedUnit.UNIT;
        });
        Iterator<VirtualFile> virtualFiles = JavaConverters$.MODULE$.asScalaIteratorConverter(this.virtualFileSystem().listFiles()).asScala();
        virtualFiles.find((Function1<VirtualFile, Object> & Serializable & scala.Serializable)vf -> BoxesRunTime.boxToBoolean(WeaveScenarioManagerService.$anonfun$setActiveScenario$3(nameIdentifier, vf))).foreach((Function1<VirtualFile, Object> & Serializable & scala.Serializable)vf -> {
            WeaveScenarioManagerService.$anonfun$setActiveScenario$4(this, vf);
            return BoxedUnit.UNIT;
        });
    }

    public void deleteScenario(NameIdentifier nameIdentifier, String nameOfTheScenario) {
        this.projectKind().sampleDataManager().searchScenarioByName(nameIdentifier, nameOfTheScenario).foreach((Function1<Scenario, Object> & Serializable & scala.Serializable)s -> {
            WeaveScenarioManagerService.$anonfun$deleteScenario$1(s);
            return BoxedUnit.UNIT;
        });
        this.activeScenarios().get(nameIdentifier).foreach((Function1<Scenario, Object> & Serializable & scala.Serializable)activeScenario -> {
            String string = activeScenario.name();
            String string2 = nameOfTheScenario;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return this.activeScenarios().remove(nameIdentifier);
            }
            return BoxedUnit.UNIT;
        });
        this.notifyAllScenarios(nameIdentifier);
    }

    public Option<File> createOrUpdateMappingTest(NameIdentifier nameIdentifier, String scenarioName, String mimeType) {
        Option<Scenario> maybeScenario = this.projectKind().sampleDataManager().searchScenarioByName(nameIdentifier, scenarioName);
        Option<File> maybeFile = maybeScenario.flatMap((Function1<Scenario, Option> & Serializable & scala.Serializable)scenario -> this.doSaveTest(nameIdentifier, (Scenario)scenario, mimeType));
        return maybeFile;
    }

    private Option<File> doSaveTest(NameIdentifier nameIdentifier, Scenario scenario, String mimeType) {
        File testFile = new File(WeaveDirectoryUtils$.MODULE$.wtfUnitDefaultTestSourceFolder(this.projectKind().structure())[0], new StringBuilder(9).append(WeaveDirectoryUtils$.MODULE$.toFolderName((NameIdentifier)nameIdentifier.parent().getOrElse((Function0<NameIdentifier> & Serializable & scala.Serializable)() -> new NameIdentifier("", NameIdentifier$.MODULE$.apply$default$2())))).append("/").append(nameIdentifier.localName()).append("Test.dwl").toString());
        String scenarioTemplate = StringHelper$.MODULE$.toStringTransformer(new StringBuilder(157).append("\n         |    \"Assert ").append(scenario.name()).append("\" in do {\n         |        evalPath(\"").append(new StringOps(Predef$.MODULE$.augmentString(NameIdentifierHelper$.MODULE$.toWeaveFilePath(nameIdentifier, "/"))).drop(1)).append("\", inputsFrom(\"").append(WeaveDirectoryUtils$.MODULE$.toFolderName(nameIdentifier)).append("/").append(scenario.name()).append("\"),\"").append(mimeType).append("\") must\n         |                  equalTo(outputFrom(\"").append(WeaveDirectoryUtils$.MODULE$.toFolderName(nameIdentifier)).append("/").append(scenario.name()).append("\"))\n         |    }").toString()).stripMarginAndNormalizeEOL();
        String testTemplate = StringHelper$.MODULE$.toStringTransformer(new StringBuilder(155).append("%dw ").append(this.projectKind().getWeaveVersion()).append("\n         |import * from dw::test::Tests\n         |import * from dw::test::Asserts\n         |---\n         |\"Test ").append(nameIdentifier.name()).append("\" describedBy [").append(scenarioTemplate).append("\n         |]\n         |").toString()).stripMarginAndNormalizeEOL();
        if (testFile.exists()) {
            return this.appendScenarioToExistingTest$1(testFile, scenarioTemplate, nameIdentifier);
        }
        return this.createTestWithFirstScenario$1(testFile, testTemplate, nameIdentifier);
    }

    public Option<File> saveOutput(NameIdentifier nameIdentifier, String nameOfTheScenario, String outputName, String newContent) {
        Option<Scenario> maybeScenario = this.projectKind().sampleDataManager().searchScenarioByName(nameIdentifier, nameOfTheScenario);
        Option<File> maybeFile = maybeScenario.flatMap((Function1<Scenario, Option> & Serializable & scala.Serializable)scenario -> this.doSaveOutput(nameIdentifier, outputName, scenario.file(), newContent));
        return maybeFile;
    }

    public void deleteOutput(NameIdentifier nameIdentifier, String nameOfTheScenario, String outputUrl) {
        this.projectKind().sampleDataManager().searchScenarioByName(nameIdentifier, nameOfTheScenario).foreach((Function1<Scenario, Object> & Serializable & scala.Serializable)x$3 -> {
            WeaveScenarioManagerService.$anonfun$deleteOutput$1(outputUrl, x$3);
            return BoxedUnit.UNIT;
        });
        this.notifyAllScenarios(nameIdentifier);
    }

    public void deleteInput(NameIdentifier nameIdentifier, String nameOfTheScenario, String inputUrl) {
        this.projectKind().sampleDataManager().searchScenarioByName(nameIdentifier, nameOfTheScenario).foreach((Function1<Scenario, Object> & Serializable & scala.Serializable)x$4 -> {
            WeaveScenarioManagerService.$anonfun$deleteInput$1(inputUrl, x$4);
            return BoxedUnit.UNIT;
        });
        this.notifyAllScenarios(nameIdentifier);
    }

    public Option<File> createScenario(NameIdentifier nameIdentifier, String nameOfTheScenario, String inputFileName, Option<String> maybeInputContent) {
        SampleDataManager sampleDataManager = this.projectKind().sampleDataManager();
        File sampleContainer = sampleDataManager.createSampleDataFolderFor(nameIdentifier);
        File scenario = new File(sampleContainer, nameOfTheScenario);
        Option<String> content = maybeInputContent.orElse((Function0<Option> & Serializable & scala.Serializable)() -> InputScaffoldingFactory$.MODULE$.create(inputFileName).map((Function1<InputScaffolding, String> & Serializable & scala.Serializable)x$5 -> x$5.template()));
        return this.doCreateInput(nameIdentifier, inputFileName, content, scenario);
    }

    public Option<String> createScenario$default$4() {
        return None$.MODULE$;
    }

    public Option<File> doCreateInput(NameIdentifier nameIdentifier, String inputFileName, Option<String> maybeInputContent, File scenario) {
        Serializable serializable;
        File inputFile = this.inputOf(scenario, inputFileName);
        ArrayList<Either<TextDocumentEdit, ResourceOperation>> edits = new ArrayList<Either<TextDocumentEdit, ResourceOperation>>();
        edits.add(this.createFileCmd(inputFile));
        if (maybeInputContent.isDefined()) {
            String content = maybeInputContent.get();
            Position pos = new Position(0, 0);
            serializable = BoxesRunTime.boxToBoolean(edits.add(this.editFileCmd(inputFile, pos, pos, content)));
        } else {
            serializable = BoxedUnit.UNIT;
        }
        ApplyWorkspaceEditResponse response = this.applyEdits(edits);
        this.notifyAllScenarios(nameIdentifier);
        if (response.isApplied()) {
            return new Some<File>(inputFile);
        }
        return None$.MODULE$;
    }

    private Either<TextDocumentEdit, ResourceOperation> deleteFileCmd(File destinationFile) {
        String destinationFileUrl = URLUtils$.MODULE$.toLSPUrl(destinationFile);
        Either createFile = Either.forRight((Object)new DeleteFile(destinationFileUrl));
        return createFile;
    }

    private Either<TextDocumentEdit, ResourceOperation> createFileCmd(File destinationFile) {
        String destinationFileUrl = URLUtils$.MODULE$.toLSPUrl(destinationFile);
        Either createFile = Either.forRight((Object)new CreateFile(destinationFileUrl));
        return createFile;
    }

    private Either<TextDocumentEdit, ResourceOperation> editFileCmd(File destinationFile, Position startPos, Position endPos, String newText) {
        String outputFileUrl = URLUtils$.MODULE$.toLSPUrl(destinationFile);
        TextEdit textEdit = new TextEdit(new Range(startPos, endPos), newText);
        TextDocumentEdit textDocumentEdit = new TextDocumentEdit(new VersionedTextDocumentIdentifier(outputFileUrl, Predef$.MODULE$.int2Integer(0)), Arrays.asList((Object[])new TextEdit[]{textEdit}));
        Either editFile = Either.forLeft((Object)textDocumentEdit);
        return editFile;
    }

    private ApplyWorkspaceEditResponse applyEdits(Seq<Either<TextDocumentEdit, ResourceOperation>> edits) {
        List<Object> editsList = Arrays.asList((Object[])edits.toArray(ClassTag$.MODULE$.apply(Either.class)));
        return this.applyEdits(editsList);
    }

    private ApplyWorkspaceEditResponse applyEdits(List<Either<TextDocumentEdit, ResourceOperation>> editsList) {
        return (ApplyWorkspaceEditResponse)this.weaveLanguageClient.applyEdit(new ApplyWorkspaceEditParams(new WorkspaceEdit(editsList))).get();
    }

    private Option<File> doSaveOutput(NameIdentifier nameIdentifier, String outputName, File scenario, String newText) {
        ApplyWorkspaceEditResponse result2;
        File outputFile = this.outputOf(scenario, outputName);
        Position docStart = new Position(0, 0);
        if (outputFile.exists() && !(result2 = this.applyEdits(Predef$.MODULE$.wrapRefArray((Object[])new Either[]{this.deleteFileCmd(outputFile)}))).isApplied()) {
            return None$.MODULE$;
        }
        ApplyWorkspaceEditResponse response = this.applyEdits(Predef$.MODULE$.wrapRefArray((Object[])new Either[]{this.createFileCmd(outputFile), this.editFileCmd(outputFile, docStart, docStart, newText)}));
        if (response.isApplied()) {
            this.notifyAllScenarios(nameIdentifier);
            return new Some<File>(outputFile);
        }
        return None$.MODULE$;
    }

    private File outputOf(File scenario, String outputName) {
        return new File(scenario, outputName);
    }

    public File inputOf(File scenario, String inputName) {
        File inputs = WeaveDirectoryUtils$.MODULE$.inputsFolder(scenario);
        return new File(inputs, this.getVariablePath(inputName));
    }

    private String getVariablePath(String fileName) {
        String theBaseName = FilenameUtils.getBaseName(fileName);
        String extension = FilenameUtils.getExtension(fileName);
        String variablePath = new StringBuilder(1).append(theBaseName.replace('.', File.separatorChar)).append(".").append(extension).toString();
        return variablePath;
    }

    public void org$mule$weave$lsp$services$WeaveScenarioManagerService$$notifyAllScenarios(VirtualFile vf) {
        this.notifyAllScenarios(vf.getNameIdentifier());
    }

    private void notifyAllScenarios(NameIdentifier nameIdentifier) {
        Option<Scenario> maybeActiveScenario = this.activeScenario(nameIdentifier);
        Scenario[] allScenarios = this.projectKind().sampleDataManager().listScenarios(nameIdentifier);
        this.weaveLanguageClient.showScenarios(new ShowScenariosParams(nameIdentifier.toString(), this.mapScenarios(maybeActiveScenario, allScenarios)));
    }

    public static final /* synthetic */ boolean $anonfun$activeScenario$2(Scenario s) {
        return s.name().equals(Scenario$.MODULE$.PLAYGROUND_SCENARIO());
    }

    public static final /* synthetic */ boolean $anonfun$setActiveScenario$1(String nameOfTheScenario$1, Scenario scenario) {
        return scenario.name().equals(nameOfTheScenario$1);
    }

    public static final /* synthetic */ void $anonfun$setActiveScenario$2(WeaveScenarioManagerService $this, NameIdentifier nameIdentifier$2, Scenario s) {
        $this.activeScenarios().put(nameIdentifier$2, s);
        $this.notifyAllScenarios(nameIdentifier$2);
    }

    public static final /* synthetic */ boolean $anonfun$setActiveScenario$3(NameIdentifier nameIdentifier$2, VirtualFile vf) {
        return vf.getNameIdentifier().equals(nameIdentifier$2);
    }

    public static final /* synthetic */ void $anonfun$setActiveScenario$4(WeaveScenarioManagerService $this, VirtualFile vf) {
        $this.eventBus().fire(new ActiveScenarioChangedEvent(vf));
    }

    public static final /* synthetic */ void $anonfun$deleteScenario$1(Scenario s) {
        FileUtils.deleteDirectory(s.file());
    }

    public static final /* synthetic */ boolean $anonfun$doSaveTest$3(AstNode x0$1) {
        AstNode astNode = x0$1;
        if (astNode instanceof FunctionCallNode) {
            String string;
            VariableReferenceNode variableReferenceNode;
            NameIdentifier nameIdentifier;
            FunctionCallNode functionCallNode = (FunctionCallNode)astNode;
            AstNode astNode2 = functionCallNode.function();
            FunctionCallParametersNode functionCallParametersNode = functionCallNode.args();
            if (astNode2 instanceof VariableReferenceNode && (nameIdentifier = (variableReferenceNode = (VariableReferenceNode)astNode2).variable()) != null && "describedBy".equals(string = nameIdentifier.name()) && functionCallParametersNode != null) {
                return true;
            }
        }
        return false;
    }

    private final Option appendScenarioToExistingTest$1(File testFile$1, String scenarioTemplate$1, NameIdentifier nameIdentifier$5) {
        WeaveDocumentToolingService documentToolingService = this.dataWeaveToolingService.openDocument(URLUtils$.MODULE$.toLSPUrl(testFile$1), this.dataWeaveToolingService.openDocument$default$2());
        Option maybePosition = documentToolingService.ast().flatMap((Function1<AstNode, Option> & Serializable & scala.Serializable)x$2 -> AstNodeHelper$.MODULE$.find((AstNode)x$2, (Function1<AstNode, Object> & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean(WeaveScenarioManagerService.$anonfun$doSaveTest$3(x0$1))).flatMap((Function1<AstNode, Option> & Serializable & scala.Serializable)x0$2 -> {
            AstNode astNode = x0$2;
            if (astNode instanceof FunctionCallNode) {
                ArrayNode arrayNode;
                AstNode array;
                Seq<AstNode> seq;
                Some<Seq<AstNode>> some;
                String string;
                VariableReferenceNode variableReferenceNode;
                NameIdentifier nameIdentifier;
                FunctionCallNode functionCallNode = (FunctionCallNode)astNode;
                AstNode astNode2 = functionCallNode.function();
                FunctionCallParametersNode functionCallParametersNode = functionCallNode.args();
                if (astNode2 instanceof VariableReferenceNode && (nameIdentifier = (variableReferenceNode = (VariableReferenceNode)astNode2).variable()) != null && "describedBy".equals(string = nameIdentifier.name()) && functionCallParametersNode != null && !(some = Seq$.MODULE$.unapplySeq(seq = functionCallParametersNode.args())).isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0 && (array = (AstNode)((SeqLike)some.get()).apply(1)) instanceof ArrayNode && (arrayNode = (ArrayNode)array).children().nonEmpty()) {
                    return new Some<Position>(LSPConverters$.MODULE$.toPosition(((WeaveLocationCapable)arrayNode.children().last()).location().endPosition()));
                }
            }
            return None$.MODULE$;
        }));
        return maybePosition.flatMap((Function1<Position, Option> & Serializable & scala.Serializable)p -> {
            if (this.applyEdits(Predef$.MODULE$.wrapRefArray((Object[])new Either[]{this.editFileCmd(testFile$1, (Position)p, (Position)p, new StringBuilder(1).append(",").append(scenarioTemplate$1).toString())})).isApplied()) {
                this.notifyAllScenarios(nameIdentifier$5);
                return new Some<File>(testFile$1);
            }
            return None$.MODULE$;
        });
    }

    private final Option createTestWithFirstScenario$1(File testFile$1, String testTemplate$1, NameIdentifier nameIdentifier$5) {
        Position docStart = new Position(0, 0);
        ApplyWorkspaceEditResponse response = this.applyEdits(Predef$.MODULE$.wrapRefArray((Object[])new Either[]{this.createFileCmd(testFile$1), this.editFileCmd(testFile$1, docStart, docStart, testTemplate$1)}));
        if (response.isApplied()) {
            this.notifyAllScenarios(nameIdentifier$5);
            return new Some<File>(testFile$1);
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$deleteOutput$1(String outputUrl$1, Scenario x$3) {
        URLUtils$.MODULE$.toFile(outputUrl$1).foreach((Function1<File, Object> & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean(f.delete()));
    }

    public static final /* synthetic */ void $anonfun$deleteInput$1(String inputUrl$1, Scenario x$4) {
        URLUtils$.MODULE$.toFile(inputUrl$1).foreach((Function1<File, Object> & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean(f.delete()));
    }

    public WeaveScenarioManagerService(DataWeaveToolingService dataWeaveToolingService, WeaveLanguageClient weaveLanguageClient, VirtualFileSystem virtualFileSystem) {
        this.dataWeaveToolingService = dataWeaveToolingService;
        this.weaveLanguageClient = weaveLanguageClient;
        this.virtualFileSystem = virtualFileSystem;
        ToolingService.$init$(this);
        this.activeScenarios = (HashMap)HashMap$.MODULE$.apply(Nil$.MODULE$);
    }
}

