/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.vfs;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.mule.weave.lsp.utils.URLUtils$;
import org.mule.weave.lsp.vfs.ArtifactVirtualFileSystem;
import org.mule.weave.lsp.vfs.JarFileNameIdentifierResolver;
import org.mule.weave.lsp.vfs.JarVirtualFSResourceProvider;
import org.mule.weave.lsp.vfs.JarVirtualFile;
import org.mule.weave.lsp.vfs.ReadOnlyVirtualFileSystem;
import org.mule.weave.v2.editor.VirtualFile;
import org.mule.weave.v2.editor.VirtualFileSystem;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c\u0001\u0002\n\u0014\u0001yA\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t%\u000e\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005m!A!\t\u0001BC\u0002\u0013\u00051\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003E\u0011!Y\u0005A!A!\u0002\u0013a\u0005\"B(\u0001\t\u0003\u0001\u0006bB+\u0001\u0005\u0004%IA\u0016\u0005\u0007?\u0002\u0001\u000b\u0011B,\t\u0011\u0001\u0004\u0001R1A\u0005\u0002\u0005DQ\u0001\u001b\u0001\u0005B%DQ\u0001\u001e\u0001\u0005\nUDQA \u0001\u0005\n}Dq!a\u0001\u0001\t\u0013\t)\u0001C\u0004\u0002\u0014\u0001!I!!\u0006\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\"!9\u00111\u0006\u0001\u0005B\u00055\u0002bBA\u001e\u0001\u0011\u0005\u0013Q\b\u0002\u0015\u0015\u0006\u0014h+\u001b:uk\u0006dg)\u001b7f'f\u001cH/Z7\u000b\u0005Q)\u0012a\u0001<gg*\u0011acF\u0001\u0004YN\u0004(B\u0001\r\u001a\u0003\u00159X-\u0019<f\u0015\tQ2$\u0001\u0003nk2,'\"\u0001\u000f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001yR%\u000b\u0017\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g!\t1s%D\u0001\u0014\u0013\tA3CA\rSK\u0006$wJ\u001c7z-&\u0014H/^1m\r&dWmU=ti\u0016l\u0007C\u0001\u0014+\u0013\tY3CA\rBeRLg-Y2u-&\u0014H/^1m\r&dWmU=ti\u0016l\u0007CA\u00173\u001b\u0005q#BA\u00181\u0003\u0011a\u0017M\\4\u000b\u0003E\nAA[1wC&\u00111G\f\u0002\u000e\u0003V$xn\u00117pg\u0016\f'\r\\3\u0002\u0015\u0005\u0014H/\u001b4bGRLE-F\u00017!\t9dH\u0004\u00029yA\u0011\u0011(I\u0007\u0002u)\u00111(H\u0001\u0007yI|w\u000e\u001e \n\u0005u\n\u0013A\u0002)sK\u0012,g-\u0003\u0002@\u0001\n11\u000b\u001e:j]\u001eT!!P\u0011\u0002\u0017\u0005\u0014H/\u001b4bGRLE\rI\u0001\bU\u0006\u0014h)\u001b7f+\u0005!\u0005CA#I\u001b\u00051%BA$1\u0003\tIw.\u0003\u0002J\r\n!a)\u001b7f\u0003!Q\u0017M\u001d$jY\u0016\u0004\u0013!\b6be\u001aKG.\u001a(b[\u0016LE-\u001a8uS\u001aLWM\u001d*fg>dg/\u001a:\u0011\u0005\u0019j\u0015B\u0001(\u0014\u0005uQ\u0015M\u001d$jY\u0016t\u0015-\\3JI\u0016tG/\u001b4jKJ\u0014Vm]8mm\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0003R%N#\u0006C\u0001\u0014\u0001\u0011\u0015!d\u00011\u00017\u0011\u0015\u0011e\u00011\u0001E\u0011\u0015Ye\u00011\u0001M\u0003\u0019awnZ4feV\tq\u000b\u0005\u0002Y;6\t\u0011L\u0003\u0002[7\u00069An\\4hS:<'B\u0001/1\u0003\u0011)H/\u001b7\n\u0005yK&A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002\u000fiL\u0007OR5mKV\t!\r\u0005\u0002dM6\tAM\u0003\u0002f7\u0006\u0019!0\u001b9\n\u0005\u001d$'a\u0002.ja\u001aKG.Z\u0001\u0005M&dW\r\u0006\u0002keB\u00111\u000e]\u0007\u0002Y*\u0011QN\\\u0001\u0007K\u0012LGo\u001c:\u000b\u0005=<\u0012A\u0001<3\u0013\t\tHNA\u0006WSJ$X/\u00197GS2,\u0007\"B:\u000b\u0001\u00041\u0014\u0001\u00029bi\"\fqA[1s!\u0006$\b\u000e\u0006\u00027m\")qo\u0003a\u0001q\u0006\u0019QO]5\u0011\u0005edX\"\u0001>\u000b\u0005m\u0004\u0014a\u00018fi&\u0011QP\u001f\u0002\u0004+JK\u0015\u0001\u00036be\u0016sGO]=\u0015\u0007Y\n\t\u0001C\u0003x\u0019\u0001\u0007\u00010A\u0006kCJ,&/\u001b)beR\u001cH\u0003BA\u0004\u0003#\u0001R\u0001IA\u0005\u0003\u001bI1!a\u0003\"\u0005\u0015\t%O]1z!\ri\u0013qB\u0005\u0003\u007f9BQa^\u0007A\u0002a\f\u0001C]3t_24X\rT8dC2\u0004\u0016\r\u001e5\u0015\t\u0005]\u0011Q\u0004\t\u0004M\u0005e\u0011bAA\u000e'\tq!*\u0019:WSJ$X/\u00197GS2,\u0007\"B:\u000f\u0001\u00041\u0014!\u00037jgR4\u0015\u000e\\3t)\t\t\u0019\u0003E\u0003\u0002&\u0005\u001d\".D\u0001\\\u0013\r\tIc\u0017\u0002\t\u0013R,'/\u0019;pe\u0006\u0011\u0012m\u001d*fg>,(oY3SKN|GN^3s+\t\ty\u0003\u0005\u0003\u00022\u0005]RBAA\u001a\u0015\r\t)D\\\u0001\u0004g\u0012\\\u0017\u0002BA\u001d\u0003g\u0011QcV3bm\u0016\u0014Vm]8ve\u000e,'+Z:pYZ,'/A\u0003dY>\u001cX\r\u0006\u0002\u0002@A\u0019\u0001%!\u0011\n\u0007\u0005\r\u0013E\u0001\u0003V]&$\b")
public class JarVirtualFileSystem
implements ReadOnlyVirtualFileSystem,
ArtifactVirtualFileSystem,
AutoCloseable {
    private ZipFile zipFile;
    private final String artifactId;
    private final File jarFile;
    private final JarFileNameIdentifierResolver jarFileNameIdentifierResolver;
    private final Logger logger;
    private volatile boolean bitmap$0;

    @Override
    public String artifactId() {
        return this.artifactId;
    }

    public File jarFile() {
        return this.jarFile;
    }

    private Logger logger() {
        return this.logger;
    }

    private ZipFile zipFile$lzycompute() {
        JarVirtualFileSystem jarVirtualFileSystem = this;
        synchronized (jarVirtualFileSystem) {
            if (!this.bitmap$0) {
                this.zipFile = new ZipFile(this.jarFile());
                this.bitmap$0 = true;
            }
        }
        return this.zipFile;
    }

    public ZipFile zipFile() {
        if (!this.bitmap$0) {
            return this.zipFile$lzycompute();
        }
        return this.zipFile;
    }

    @Override
    public VirtualFile file(String path) {
        this.logger().log(Level.INFO, new StringBuilder(31).append("Before creating uri, entry ").append(path).append(" in ").append(this.jarFile().getAbsolutePath()).toString());
        Option<URI> option = URLUtils$.MODULE$.toURI(path);
        if (option instanceof Some) {
            Some some = (Some)option;
            URI uri = (URI)some.value();
            String string = uri.getScheme();
            String string2 = this.jarFileNameIdentifierResolver.jarScheme();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                String string3 = URLUtils$.MODULE$.uriPath(this.jarFile().getCanonicalPath().replace(File.separatorChar, '/'));
                String string4 = this.jarPath(uri);
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    String str = this.jarEntry(uri);
                    this.logger().log(Level.INFO, new StringBuilder(20).append("Jar entry entry ").append(str).append(" in ").append(this.jarFile().getAbsolutePath()).toString());
                    return this.resolveLocalPath(str);
                }
            }
        }
        this.logger().log(Level.INFO, new StringBuilder(23).append("No jar entry entry ").append(path).append(" in ").append(this.jarFile().getAbsolutePath()).toString());
        return this.resolveLocalPath(path);
    }

    private String jarPath(URI uri) {
        String[] parts = this.jarUriParts(uri);
        return parts[0];
    }

    private String jarEntry(URI uri) {
        String[] parts = this.jarUriParts(uri);
        return parts[1];
    }

    private String[] jarUriParts(URI uri) {
        return uri.getPath().split("!");
    }

    private JarVirtualFile resolveLocalPath(String path) {
        this.logger().log(Level.FINE, new StringBuilder(9).append("file ").append(path).append(" in ").append(this.jarFile().getAbsolutePath()).toString());
        String zipEntryPath = path.startsWith("/") ? path.substring(1) : path;
        ZipEntry zipEntry = this.zipFile().getEntry(zipEntryPath);
        Option<ZipEntry> option = Option$.MODULE$.apply(zipEntry);
        if (option instanceof Some) {
            Some some = (Some)option;
            ZipEntry entry = (ZipEntry)some.value();
            this.logger().log(Level.INFO, new StringBuilder(14).append("zip entry ").append(entry.getName()).append(" in ").append(this.jarFile().getAbsolutePath()).toString());
            return new JarVirtualFile(zipEntry.getName(), entry, this.zipFile(), this, this.jarFileNameIdentifierResolver);
        }
        if (None$.MODULE$.equals(option)) {
            return null;
        }
        throw new MatchError(option);
    }

    @Override
    public java.util.Iterator<VirtualFile> listFiles() {
        Iterator<? extends ZipEntry> entries = JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(this.zipFile().entries()).asScala();
        Iterator list = entries.flatMap((Function1<ZipEntry, GenTraversableOnce> & Serializable & scala.Serializable)zipEntry -> {
            if (zipEntry.isDirectory()) {
                return Option$.MODULE$.option2Iterable(None$.MODULE$);
            }
            this.logger().log(Level.FINE, new StringBuilder(26).append("Building virtual file ").append(zipEntry.getName()).append(" in ").append(this.jarFile().getAbsolutePath()).toString());
            return Option$.MODULE$.option2Iterable(new Some<JarVirtualFile>(new JarVirtualFile(zipEntry.getName(), (ZipEntry)zipEntry, this.zipFile(), this, $this.jarFileNameIdentifierResolver)));
        });
        return JavaConverters$.MODULE$.asJavaIteratorConverter(list).asJava();
    }

    @Override
    public WeaveResourceResolver asResourceResolver() {
        return new JarVirtualFSResourceProvider(this);
    }

    @Override
    public void close() {
        this.zipFile().close();
    }

    public JarVirtualFileSystem(String artifactId, File jarFile, JarFileNameIdentifierResolver jarFileNameIdentifierResolver) {
        this.artifactId = artifactId;
        this.jarFile = jarFile;
        this.jarFileNameIdentifierResolver = jarFileNameIdentifierResolver;
        VirtualFileSystem.$init$(this);
        ReadOnlyVirtualFileSystem.$init$(this);
        this.logger = Logger.getLogger(this.getClass().getName());
    }
}

