/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.vfs.resource;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.eclipse.lsp4j.FileChangeType;
import org.mule.weave.lsp.agent.WeaveAgentService;
import org.mule.weave.lsp.project.components.DependencyArtifact;
import org.mule.weave.lsp.project.events.DependencyArtifactResolvedEvent$;
import org.mule.weave.lsp.project.events.OnDependencyArtifactResolved;
import org.mule.weave.lsp.services.events.AgentStartedEvent$;
import org.mule.weave.lsp.services.events.FileChangedEvent$;
import org.mule.weave.lsp.services.events.OnAgentStarted;
import org.mule.weave.lsp.services.events.OnFileChanged;
import org.mule.weave.lsp.utils.EventBus;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier$;
import org.mule.weave.v2.sdk.DefaultWeaveResource;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResource$;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import org.mule.weave.v2.utils.WeaveFile$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ub\u0001B\n\u0015\u0001\u0005B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\tu\u0001\u0011)\u0019!C\u0001w!Aq\t\u0001B\u0001B\u0003%A\b\u0003\u0005I\u0001\t\u0015\r\u0011\"\u0001<\u0011!I\u0005A!A!\u0002\u0013a\u0004\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011B&\t\u000bE\u0003A\u0011\u0001*\t\u000fe\u0003!\u0019!C\u00055\"1Q\u000e\u0001Q\u0001\nmCqA\u001c\u0001C\u0002\u0013%q\u000eC\u0004\u0002\u0006\u0001\u0001\u000b\u0011\u00029\t\u0013\u0005\u001d\u0001A1A\u0005\n\u0005%\u0001\u0002CA\u0007\u0001\u0001\u0006I!a\u0003\t\u0015\u0005=\u0001\u0001#b\u0001\n\u0003\t\t\u0002C\u0004\u0002$\u0001!\t!!\u0005\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002(!9\u0011q\u0006\u0001\u0005\u0002\u0005E\u0002bBA\u001b\u0001\u0011\u0005\u0013q\u0007\u0002\u001d\u0007V\u001cHo\\7M_\u0006$WM\u001d*fg>,(oY3SKN|GN^3s\u0015\t)b#\u0001\u0005sKN|WO]2f\u0015\t9\u0002$A\u0002wMNT!!\u0007\u000e\u0002\u00071\u001c\bO\u0003\u0002\u001c9\u0005)q/Z1wK*\u0011QDH\u0001\u0005[VdWMC\u0001 \u0003\ry'oZ\u0002\u0001'\r\u0001!\u0005\u000b\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005%rS\"\u0001\u0016\u000b\u0005-b\u0013aA:eW*\u0011QFG\u0001\u0003mJJ!a\f\u0016\u0003+]+\u0017M^3SKN|WO]2f%\u0016\u001cx\u000e\u001c<fe\u0006\tr/Z1wK\u0006;WM\u001c;TKJ4\u0018nY3\u0011\u0007\r\u0012D'\u0003\u00024I\tIa)\u001e8di&|g\u000e\r\t\u0003kaj\u0011A\u000e\u0006\u0003oa\tQ!Y4f]RL!!\u000f\u001c\u0003#]+\u0017M^3BO\u0016tGoU3sm&\u001cW-\u0001\u0004m_\u0006$WM]\u000b\u0002yA\u0011Q\b\u0012\b\u0003}\t\u0003\"a\u0010\u0013\u000e\u0003\u0001S!!\u0011\u0011\u0002\rq\u0012xn\u001c;?\u0013\t\u0019E%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u000b\u001a\u0013aa\u0015;sS:<'BA\"%\u0003\u001daw.\u00193fe\u0002\nQBZ5mK\u0016CH/\u001a8tS>t\u0017A\u00044jY\u0016,\u0005\u0010^3og&|g\u000eI\u0001\tKZ,g\u000e\u001e\"vgB\u0011AjT\u0007\u0002\u001b*\u0011a\nG\u0001\u0006kRLGn]\u0005\u0003!6\u0013\u0001\"\u0012<f]R\u0014Uo]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bM+fk\u0016-\u0011\u0005Q\u0003Q\"\u0001\u000b\t\u000bA:\u0001\u0019A\u0019\t\u000bi:\u0001\u0019\u0001\u001f\t\u000b!;\u0001\u0019\u0001\u001f\t\u000b);\u0001\u0019A&\u0002\u001bI,7o\\;sG\u0016\u001c\u0015m\u00195f+\u0005Y\u0006\u0003\u0002/fy\u001dl\u0011!\u0018\u0006\u0003=~\u000bQaY1dQ\u0016T!\u0001Y1\u0002\r\r|W.\\8o\u0015\t\u00117-\u0001\u0004h_><G.\u001a\u0006\u0002I\u0006\u00191m\\7\n\u0005\u0019l&!B\"bG\",\u0007cA\u0012iU&\u0011\u0011\u000e\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005%Z\u0017B\u00017+\u000559V-\u0019<f%\u0016\u001cx.\u001e:dK\u0006q!/Z:pkJ\u001cWmQ1dQ\u0016\u0004\u0013aE;sSR{g*Y7f\u0013\u0012,g\u000e^5gS\u0016\u0014X#\u00019\u0011\tE4H\b_\u0007\u0002e*\u00111\u000f^\u0001\b[V$\u0018M\u00197f\u0015\t)H%\u0001\u0006d_2dWm\u0019;j_:L!a\u001e:\u0003\u000f!\u000b7\u000f['baB\u0019\u00110!\u0001\u000e\u0003iT!a\u001f?\u0002\u0013Y\f'/[1cY\u0016\u001c(BA?\u007f\u0003\r\t7\u000f\u001e\u0006\u0003\u007f2\na\u0001]1sg\u0016\u0014\u0018bAA\u0002u\nqa*Y7f\u0013\u0012,g\u000e^5gS\u0016\u0014\u0018\u0001F;sSR{g*Y7f\u0013\u0012,g\u000e^5gS\u0016\u0014\b%\u0001\rpe&<\u0017N\\1m\r&dW-\u0016:j)>\u001cF/\u001e2Ve&,\"!a\u0003\u0011\tE4H\bP\u0001\u001a_JLw-\u001b8bY\u001aKG.Z+sSR{7\u000b^;c+JL\u0007%A\u0006tiV\u00147OR8mI\u0016\u0014XCAA\n!\u0011\t)\"a\b\u000e\u0005\u0005]!\u0002BA\r\u00037\t!![8\u000b\u0005\u0005u\u0011\u0001\u00026bm\u0006LA!!\t\u0002\u0018\t!a)\u001b7f\u0003I\u0019H/\u001e2t\u001b>$W\u000f\\3t\r>dG-\u001a:\u0002)9\fW.Z%eK:$\u0018NZ5fe>37\u000b^;c)\u0011\tI#a\u000b\u0011\u0007\rB\u0007\u0010\u0003\u0004\u0002.A\u0001\r\u0001P\u0001\u0004kJL\u0017\u0001\b8b[\u0016LE-\u001a8uS\u001aLWM](g\u001fJLw-\u001b8bY\u001aKG.\u001a\u000b\u0005\u0003S\t\u0019\u0004\u0003\u0004\u0002.E\u0001\r\u0001P\u0001\be\u0016\u001cx\u000e\u001c<f)\r9\u0017\u0011\b\u0005\u0007\u0003w\u0011\u0002\u0019\u0001=\u0002\t9\fW.\u001a")
public class CustomLoaderResourceResolver
implements WeaveResourceResolver {
    private File stubsFolder;
    private final Function0<WeaveAgentService> weaveAgentService;
    private final String loader;
    private final String fileExtension;
    private final Cache<String, Option<WeaveResource>> org$mule$weave$lsp$vfs$resource$CustomLoaderResourceResolver$$resourceCache;
    private final HashMap<String, NameIdentifier> uriToNameIdentifier;
    private final HashMap<String, String> originalFileUriToStubUri;
    private volatile boolean bitmap$0;

    public String loader() {
        return this.loader;
    }

    public String fileExtension() {
        return this.fileExtension;
    }

    public Cache<String, Option<WeaveResource>> org$mule$weave$lsp$vfs$resource$CustomLoaderResourceResolver$$resourceCache() {
        return this.org$mule$weave$lsp$vfs$resource$CustomLoaderResourceResolver$$resourceCache;
    }

    private HashMap<String, NameIdentifier> uriToNameIdentifier() {
        return this.uriToNameIdentifier;
    }

    private HashMap<String, String> originalFileUriToStubUri() {
        return this.originalFileUriToStubUri;
    }

    private File stubsFolder$lzycompute() {
        CustomLoaderResourceResolver customLoaderResourceResolver = this;
        synchronized (customLoaderResourceResolver) {
            if (!this.bitmap$0) {
                this.stubsFolder = Files.createTempDirectory(this.loader(), new FileAttribute[0]).toFile();
                this.bitmap$0 = true;
            }
        }
        return this.stubsFolder;
    }

    public File stubsFolder() {
        if (!this.bitmap$0) {
            return this.stubsFolder$lzycompute();
        }
        return this.stubsFolder;
    }

    public File stubsModulesFolder() {
        return this.stubsFolder();
    }

    public Option<NameIdentifier> nameIdentifierOfStub(String uri) {
        return this.uriToNameIdentifier().get(uri);
    }

    public Option<NameIdentifier> nameIdentifierOfOriginalFile(String uri2) {
        return this.originalFileUriToStubUri().get(uri2).flatMap((Function1<String, Option> & Serializable & scala.Serializable)uri -> this.nameIdentifierOfStub((String)uri));
    }

    @Override
    public Option<WeaveResource> resolve(NameIdentifier name) {
        if (name.loader().exists((Function1<String, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(x$1.equals(this.loader())))) {
            return (Option)this.org$mule$weave$lsp$vfs$resource$CustomLoaderResourceResolver$$resourceCache().get((Object)name.toString(), () -> {
                Option<WeaveResource> maybeResource = $this.weaveAgentService.apply().resolveModule(name.toString(), this.loader()).get(30L, TimeUnit.SECONDS);
                return maybeResource.map((Function1<WeaveResource, DefaultWeaveResource> & Serializable & scala.Serializable)wr -> {
                    File file = new File(this.stubsModulesFolder(), new StringBuilder(0).append(name.toString().replace(NameIdentifier$.MODULE$.SEPARATOR(), File.separator)).append(WeaveFile$.MODULE$.fileExtension()).toString());
                    file.getParentFile().mkdirs();
                    Path tmpFilePath = file.toPath();
                    String stubUri = tmpFilePath.toUri().toString();
                    this.uriToNameIdentifier().put(stubUri, name);
                    this.originalFileUriToStubUri().put(wr.url(), stubUri);
                    FileUtils.writeStringToFile(tmpFilePath.toFile(), wr.content(), StandardCharsets.UTF_8);
                    return WeaveResource$.MODULE$.apply(tmpFilePath.toFile().toURI().toString(), wr.content());
                });
            });
        }
        return None$.MODULE$;
    }

    public CustomLoaderResourceResolver(Function0<WeaveAgentService> weaveAgentService, String loader, String fileExtension, EventBus eventBus) {
        this.weaveAgentService = weaveAgentService;
        this.loader = loader;
        this.fileExtension = fileExtension;
        WeaveResourceResolver.$init$(this);
        this.org$mule$weave$lsp$vfs$resource$CustomLoaderResourceResolver$$resourceCache = CacheBuilder.newBuilder().build();
        this.uriToNameIdentifier = (HashMap)HashMap$.MODULE$.apply(Nil$.MODULE$);
        this.originalFileUriToStubUri = (HashMap)HashMap$.MODULE$.apply(Nil$.MODULE$);
        eventBus.register(FileChangedEvent$.MODULE$.FILE_CHANGED_EVENT(), new OnFileChanged(this){
            private final /* synthetic */ CustomLoaderResourceResolver $outer;

            public void onFileChanged(String uri, FileChangeType changeType) {
                if (uri.endsWith(new StringBuilder(1).append(".").append(this.$outer.fileExtension()).toString())) {
                    this.$outer.org$mule$weave$lsp$vfs$resource$CustomLoaderResourceResolver$$resourceCache().invalidateAll();
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(DependencyArtifactResolvedEvent$.MODULE$.ARTIFACT_RESOLVED(), new OnDependencyArtifactResolved(this){
            private final /* synthetic */ CustomLoaderResourceResolver $outer;

            public void onArtifactsResolved(DependencyArtifact[] artifacts) {
                this.$outer.org$mule$weave$lsp$vfs$resource$CustomLoaderResourceResolver$$resourceCache().invalidateAll();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(AgentStartedEvent$.MODULE$.AGENT_STARTED(), new OnAgentStarted(this){
            private final /* synthetic */ CustomLoaderResourceResolver $outer;

            public void onAgentStarted() {
                this.$outer.org$mule$weave$lsp$vfs$resource$CustomLoaderResourceResolver$$resourceCache().invalidateAll();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

