/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.ts.resolvers;

import java.io.Serializable;
import org.mule.weave.v2.parser.InvalidAmountTypeParametersMessage;
import org.mule.weave.v2.parser.InvalidDynamicReturnMessage;
import org.mule.weave.v2.parser.InvalidMethodTypesMessage;
import org.mule.weave.v2.parser.Message;
import org.mule.weave.v2.parser.MessageCollector;
import org.mule.weave.v2.parser.MultipleValidFunctions;
import org.mule.weave.v2.parser.NotEnoughArgumentMessage;
import org.mule.weave.v2.parser.TooManyArgumentMessage;
import org.mule.weave.v2.parser.TypeCoercedMessage;
import org.mule.weave.v2.parser.TypeMessage;
import org.mule.weave.v2.parser.TypeMismatch;
import org.mule.weave.v2.parser.TypeMismatch$;
import org.mule.weave.v2.parser.UnfulfilledConstraint;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.functions.FunctionCallNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.ast.variables.VariableReferenceNode;
import org.mule.weave.v2.parser.location.UnknownLocation$;
import org.mule.weave.v2.parser.location.WeaveLocation;
import org.mule.weave.v2.ts.AnyType;
import org.mule.weave.v2.ts.ConcreteTypeParamInstanceCounter$;
import org.mule.weave.v2.ts.ConstrainProblem;
import org.mule.weave.v2.ts.Constraint$;
import org.mule.weave.v2.ts.ConstraintResult;
import org.mule.weave.v2.ts.ConstraintSet;
import org.mule.weave.v2.ts.CustomTypeResolver;
import org.mule.weave.v2.ts.DynamicReturnType;
import org.mule.weave.v2.ts.Edge;
import org.mule.weave.v2.ts.Edge$;
import org.mule.weave.v2.ts.EdgeLabels$;
import org.mule.weave.v2.ts.ErrorResult;
import org.mule.weave.v2.ts.FunctionType;
import org.mule.weave.v2.ts.FunctionType$;
import org.mule.weave.v2.ts.FunctionTypeHelper$;
import org.mule.weave.v2.ts.FunctionTypeParameter;
import org.mule.weave.v2.ts.FunctionTypeParameter$;
import org.mule.weave.v2.ts.IntersectionType;
import org.mule.weave.v2.ts.NoSolutionSet;
import org.mule.weave.v2.ts.NothingType;
import org.mule.weave.v2.ts.NullType;
import org.mule.weave.v2.ts.ReferenceType;
import org.mule.weave.v2.ts.SolutionResult;
import org.mule.weave.v2.ts.Substitution;
import org.mule.weave.v2.ts.Substitution$;
import org.mule.weave.v2.ts.TypeCoercer$;
import org.mule.weave.v2.ts.TypeHelper;
import org.mule.weave.v2.ts.TypeHelper$;
import org.mule.weave.v2.ts.TypeNode;
import org.mule.weave.v2.ts.TypeParameter;
import org.mule.weave.v2.ts.TypeType;
import org.mule.weave.v2.ts.UnionType;
import org.mule.weave.v2.ts.WeaveType;
import org.mule.weave.v2.ts.WeaveTypeResolutionContext;
import org.mule.weave.v2.ts.WeaveTypeResolver;
import org.mule.weave.v2.ts.WeaveTypeTraverse$;
import org.mule.weave.v2.ts.resolvers.ResolutionResult;
import org.mule.weave.v2.ts.resolvers.ResolutionResult$;
import org.mule.weave.v2.utils.SeqUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Predef$DummyImplicit$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Seq$;
import scala.math.Ordering$Int$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

public final class FunctionCallNodeResolver$
implements WeaveTypeResolver {
    public static FunctionCallNodeResolver$ MODULE$;

    static {
        new FunctionCallNodeResolver$();
    }

    @Override
    public boolean supportsPartialResolution() {
        return WeaveTypeResolver.supportsPartialResolution$(this);
    }

    @Override
    public Option<WeaveType> resolveReturnType(TypeNode node, WeaveTypeResolutionContext ctx) {
        Edge functionEdge = this.getIncomingFunctionEdge(node);
        Seq<Edge> argEdges = this.argumentEdges(node);
        Seq<Edge> typeParamEdges = this.getTypeParamEdges(node);
        return this.resolveFunctionCall(node, ctx, functionEdge, argEdges, typeParamEdges);
    }

    public Option<WeaveType> resolveFunctionCall(TypeNode node, WeaveTypeResolutionContext ctx, Edge functionEdge, Seq<Edge> argEdges, Seq<Edge> typeParamEdges) {
        Seq typeParams = typeParamEdges.map((Function1<Edge, Option> & Serializable & scala.Serializable)tpE -> {
            WeaveType weaveType = tpE.incomingType();
            if (weaveType instanceof TypeType) {
                TypeType typeType = (TypeType)weaveType;
                WeaveType actualType = typeType.t();
                return new Some<WeaveType>(actualType.withLocation(tpE.source().astNode().location()));
            }
            return None$.MODULE$;
        }, scala.collection.Seq$.MODULE$.canBuildFrom());
        if (typeParams.exists((Function1<Option, Object> & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean(FunctionCallNodeResolver$.$anonfun$resolveFunctionCall$2(p)))) {
            return None$.MODULE$;
        }
        Seq<WeaveType> arguments = argEdges.map((Function1<Edge, WeaveType> & Serializable & scala.Serializable)paramEdge -> {
            WeaveType weaveType = paramEdge.incomingType();
            weaveType.withLocation(paramEdge.source().astNode().location());
            return weaveType;
        }, scala.collection.Seq$.MODULE$.canBuildFrom());
        return this.resolveFunctionType(node, ctx, functionEdge.incomingType(), arguments, typeParams.map((Function1<Option, WeaveType> & Serializable & scala.Serializable)x$1 -> (WeaveType)x$1.get(), scala.collection.Seq$.MODULE$.canBuildFrom()));
    }

    public Edge getIncomingFunctionEdge(TypeNode node) {
        return node.incomingEdge(EdgeLabels$.MODULE$.FUNCTION()).get();
    }

    public Seq<Edge> argumentEdges(TypeNode node) {
        return node.incomingEdges(EdgeLabels$.MODULE$.ARGUMENT());
    }

    public Seq<Edge> getTypeParamEdges(TypeNode node) {
        return node.incomingEdges(EdgeLabels$.MODULE$.TYPE_PARAMETER());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<WeaveType> calculateExpectedTypeByParameter(WeaveType functionType, Option<WeaveType> incomingExpectedType, WeaveTypeResolutionContext ctx) {
        while (true) {
            Option<WeaveType> option;
            boolean bl = false;
            TypeParameter typeParameter = null;
            WeaveType weaveType = functionType;
            if (weaveType instanceof FunctionType) {
                Seq<WeaveType> seq;
                FunctionType functionType2 = (FunctionType)weaveType;
                this.setNoImplicitBounds(functionType2);
                if (incomingExpectedType.isDefined()) {
                    ConstraintResult constraintResult;
                    FunctionType functionType3;
                    if (functionType2.isOverloaded()) {
                        Option matchedFunction = functionType2.overloads().find((Function1<FunctionType, Object> & Serializable & scala.Serializable)ft -> BoxesRunTime.boxToBoolean(FunctionCallNodeResolver$.$anonfun$calculateExpectedTypeByParameter$1(ctx, incomingExpectedType, ft)));
                        functionType3 = (FunctionType)matchedFunction.getOrElse((Function0<FunctionType> & Serializable & scala.Serializable)() -> functionType2);
                    } else {
                        functionType3 = functionType2;
                    }
                    FunctionType actualFunctionType = functionType3;
                    ConstraintSet constrains = Constraint$.MODULE$.collectConstrains(incomingExpectedType.get(), actualFunctionType.returnType(), ctx, Constraint$.MODULE$.collectConstrains$default$4(), Constraint$.MODULE$.collectConstrains$default$5());
                    Seq<TypeParameter> typeParameters = TypeHelper$.MODULE$.apply(ctx).collectTypeParameters(functionType);
                    ConstraintResult constraintResult2 = constraintResult = constrains.resolve(ctx, false, typeParameters, constrains.resolve$default$4(), constrains.resolve$default$5());
                    if (constraintResult2 instanceof ErrorResult) {
                        seq = actualFunctionType.params().map((Function1<FunctionTypeParameter, WeaveType> & Serializable & scala.Serializable)x$2 -> x$2.wtype(), scala.collection.Seq$.MODULE$.canBuildFrom());
                    } else {
                        if (!(constraintResult2 instanceof SolutionResult)) throw new MatchError(constraintResult2);
                        SolutionResult solutionResult = (SolutionResult)constraintResult2;
                        Substitution substitution = solutionResult.substitution();
                        seq = actualFunctionType.params().map((Function1<FunctionTypeParameter, WeaveType> & Serializable & scala.Serializable)param2 -> substitution.apply(ctx, param2.wtype(), substitution.apply$default$3()), scala.collection.Seq$.MODULE$.canBuildFrom());
                    }
                } else {
                    seq = functionType2.params().map((Function1<FunctionTypeParameter, WeaveType> & Serializable & scala.Serializable)x$3 -> x$3.wtype(), scala.collection.Seq$.MODULE$.canBuildFrom());
                }
                Seq<WeaveType> result2 = seq;
                this.resetImplicitBounds(functionType2);
                return result2;
            }
            if (weaveType instanceof TypeParameter) {
                bl = true;
                typeParameter = (TypeParameter)weaveType;
                Option<WeaveType> option2 = typeParameter.top();
                if (option2 instanceof Some) {
                    WeaveType topType;
                    Some some = (Some)option2;
                    functionType = topType = (WeaveType)some.value();
                    continue;
                }
            }
            if (bl && (option = typeParameter.bottom()) instanceof Some) {
                WeaveType baseType;
                Some some = (Some)option;
                functionType = baseType = (WeaveType)some.value();
                continue;
            }
            if (weaveType instanceof UnionType) {
                UnionType unionType = (UnionType)weaveType;
                Seq<WeaveType> of = unionType.of();
                Seq possibleParams = of.map((Function1<WeaveType, Seq> & Serializable & scala.Serializable)t -> MODULE$.calculateExpectedTypeByParameter((WeaveType)t, incomingExpectedType, ctx), scala.collection.Seq$.MODULE$.canBuildFrom());
                if (!possibleParams.exists((Function1<Seq, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean(x$4.isEmpty()))) return (Seq)possibleParams.reduce((Function2<Seq, Seq, Seq> & Serializable & scala.Serializable)(value, acc2) -> ((TraversableLike)value.zip(acc2, scala.collection.Seq$.MODULE$.canBuildFrom())).map((Function1<Tuple2, WeaveType> & Serializable & scala.Serializable)tuple -> TypeHelper$.MODULE$.apply(ctx).unify((Seq<WeaveType>)new $colon$colon<Nothing$>((Nothing$)((Object)((WeaveType)tuple._1())), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)((WeaveType)tuple._2())), Nil$.MODULE$))), scala.collection.Seq$.MODULE$.canBuildFrom()));
                return Nil$.MODULE$;
            }
            if (weaveType instanceof ReferenceType) {
                ReferenceType referenceType = (ReferenceType)weaveType;
                functionType = referenceType.resolveType();
                continue;
            }
            if (!(weaveType instanceof IntersectionType)) return Nil$.MODULE$;
            IntersectionType intersectionType = (IntersectionType)weaveType;
            WeaveType weaveType2 = TypeHelper$.MODULE$.resolveIntersection(intersectionType.of());
            if (weaveType2 instanceof IntersectionType) {
                return Nil$.MODULE$;
            }
            functionType = weaveType2;
        }
    }

    @Override
    public Seq<Tuple2<Edge, WeaveType>> resolveExpectedType(TypeNode node, Option<WeaveType> incomingExpectedType, WeaveTypeResolutionContext ctx) {
        Option<WeaveType> option = this.getIncomingFunctionEdge(node).mayBeIncomingType();
        if (option instanceof Some) {
            Some some = (Some)option;
            WeaveType weaveType = (WeaveType)some.value();
            Seq<WeaveType> paramsTypes = this.calculateExpectedTypeByParameter(weaveType, incomingExpectedType, ctx);
            return this.argumentEdges(node).zip(paramsTypes, scala.collection.Seq$.MODULE$.canBuildFrom());
        }
        return Nil$.MODULE$;
    }

    private Option<WeaveType> resolveFunctionType(TypeNode node, WeaveTypeResolutionContext ctx, WeaveType functionType, Seq<WeaveType> arguments, Seq<WeaveType> typeParams) {
        block11: {
            MessageCollector x$52;
            boolean x$4;
            WeaveTypeResolutionContext x$3;
            FunctionType x$2;
            WeaveType x$1;
            while (true) {
                Option<WeaveType> option;
                boolean bl = false;
                TypeParameter typeParameter = null;
                WeaveType weaveType = functionType;
                if (weaveType instanceof FunctionType) {
                    FunctionType functionType2 = (FunctionType)weaveType;
                    return this.resolveReturnType(functionType2, arguments, typeParams, node, ctx);
                }
                if (weaveType instanceof TypeParameter) {
                    bl = true;
                    typeParameter = (TypeParameter)weaveType;
                    Option<WeaveType> option2 = typeParameter.top();
                    if (option2 instanceof Some) {
                        WeaveType topType;
                        Some some = (Some)option2;
                        functionType = topType = (WeaveType)some.value();
                        continue;
                    }
                }
                if (bl && (option = typeParameter.bottom()) instanceof Some) {
                    WeaveType baseType;
                    Some some = (Some)option;
                    functionType = baseType = (WeaveType)some.value();
                    continue;
                }
                if (weaveType instanceof UnionType) {
                    UnionType unionType = (UnionType)weaveType;
                    Seq<WeaveType> of = unionType.of();
                    Seq options = of.map((Function1<WeaveType, Option> & Serializable & scala.Serializable)t -> MODULE$.resolveFunctionType(node, ctx, (WeaveType)t, arguments, typeParams), scala.collection.Seq$.MODULE$.canBuildFrom());
                    if (options.exists((Function1<Option, Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean(x$5.isEmpty()))) {
                        return None$.MODULE$;
                    }
                    return new Some<WeaveType>(TypeHelper$.MODULE$.apply(ctx).unify((Seq)options.flatten((Function1<Option, Iterable> & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))));
                }
                if (weaveType instanceof ReferenceType) {
                    ReferenceType referenceType = (ReferenceType)weaveType;
                    functionType = referenceType.resolveType();
                    continue;
                }
                if (weaveType instanceof NothingType) {
                    return None$.MODULE$;
                }
                if (weaveType instanceof AnyType) {
                    return None$.MODULE$;
                }
                if (!(weaveType instanceof IntersectionType)) break;
                IntersectionType intersectionType = (IntersectionType)weaveType;
                WeaveType weaveType2 = TypeHelper$.MODULE$.resolveIntersection(intersectionType.of());
                if (weaveType2 instanceof IntersectionType) {
                    return None$.MODULE$;
                }
                functionType = weaveType2;
            }
            FunctionType expectedType = new FunctionType(Nil$.MODULE$, arguments.map((Function1<WeaveType, FunctionTypeParameter> & Serializable & scala.Serializable)x$6 -> new FunctionTypeParameter("arg", (WeaveType)x$6, FunctionTypeParameter$.MODULE$.apply$default$3(), FunctionTypeParameter$.MODULE$.apply$default$4()), scala.collection.Seq$.MODULE$.canBuildFrom()), new AnyType(), FunctionType$.MODULE$.apply$default$4(), FunctionType$.MODULE$.apply$default$5(), FunctionType$.MODULE$.apply$default$6());
            TypeHelper qual$1 = TypeHelper$.MODULE$.apply(ctx);
            if (qual$1.canBeAssignedTo(x$1 = functionType, x$2 = expectedType, x$3 = ctx, x$4 = qual$1.canBeAssignedTo$default$4(), x$52 = qual$1.canBeAssignedTo$default$5())) break block11;
            ctx.error(new TypeMismatch(expectedType, functionType, TypeMismatch$.MODULE$.apply$default$3()), node, functionType.location());
        }
        return None$.MODULE$;
    }

    public boolean checkParametersCount(Seq<WeaveType> args, Seq<FunctionTypeParameter> params, WeaveTypeResolutionContext ctx) {
        Seq requiredParams = (Seq)params.filter((Function1<FunctionTypeParameter, Object> & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean(FunctionCallNodeResolver$.$anonfun$checkParametersCount$1(x$7)));
        if (args.size() > params.size()) {
            return false;
        }
        return args.size() >= requiredParams.size();
    }

    public boolean checkTypeParameterCount(Seq<WeaveType> types, Seq<TypeParameter> typeParams) {
        return types.isEmpty() || types.size() == typeParams.size();
    }

    public Seq<Tuple2<FunctionType, Seq<Tuple2<WeaveLocation, Message>>>> filterIrrelevantProblems(Seq<Tuple2<FunctionType, Seq<Tuple2<WeaveLocation, Message>>>> problems) {
        return (Seq)problems.filterNot((Function1<Tuple2, Object> & Serializable & scala.Serializable)pair -> BoxesRunTime.boxToBoolean(FunctionCallNodeResolver$.$anonfun$filterIrrelevantProblems$1(pair)));
    }

    /*
     * Enabled aggressive block sorting
     */
    public Option<WeaveType> resolveReturnType(FunctionType ft, Seq<WeaveType> args2, Seq<WeaveType> typeParams, TypeNode thisNode, WeaveTypeResolutionContext ctx) {
        Seq allDefinitions = ft.overloads().isEmpty() ? (Seq)new $colon$colon<Nothing$>((Nothing$)((Object)ft), Nil$.MODULE$) : ft.overloads();
        Seq withCorrectArity = (Seq)allDefinitions.filter((Function1<FunctionType, Object> & Serializable & scala.Serializable)fun -> BoxesRunTime.boxToBoolean(FunctionCallNodeResolver$.$anonfun$resolveReturnType$1(args2, ctx, typeParams, fun)));
        if (withCorrectArity.isEmpty()) {
            this.addCardinalityErrors(args2, typeParams, allDefinitions, thisNode, ctx);
            return None$.MODULE$;
        }
        Seq<WeaveType> fixedAbstractTypeParams = args2.map((Function1<WeaveType, WeaveType> & Serializable & scala.Serializable)wt -> {
            Seq<TypeParameter> typeParameters = TypeHelper$.MODULE$.collectAbstractTypeParameters((WeaveType)wt);
            Seq<Tuple2<TypeParameter, WeaveType>> abstractToConcrete = ((TraversableLike)typeParameters.filter((Function1<TypeParameter, Object> & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean(FunctionCallNodeResolver$.$anonfun$resolveReturnType$3(x$8)))).map((Function1<TypeParameter, Tuple2> & Serializable & scala.Serializable)atp -> {
                TypeParameter concreteType = atp.copy(atp.name(), atp.top(), atp.bottom(), new Some<Number>(ConcreteTypeParamInstanceCounter$.MODULE$.nextId()), atp.noImplicitBounds());
                return new Tuple2<TypeParameter, TypeParameter>((TypeParameter)atp, concreteType);
            }, scala.collection.Seq$.MODULE$.canBuildFrom());
            Substitution qual$1 = Substitution$.MODULE$.apply(abstractToConcrete);
            WeaveTypeResolutionContext x$1 = ctx;
            WeaveType x$2 = wt;
            MessageCollector x$3 = qual$1.apply$default$3();
            return qual$1.apply(x$1, x$2, x$3);
        }, scala.collection.Seq$.MODULE$.canBuildFrom());
        Seq argTypes = this.flattenUnion(fixedAbstractTypeParams);
        boolean nothingOrDynamic = argTypes.exists((Function1<Seq, Object> & Serializable & scala.Serializable)args -> BoxesRunTime.boxToBoolean(args.exists((Function1<WeaveType, Object> & Serializable & scala.Serializable)arg -> BoxesRunTime.boxToBoolean(FunctionCallNodeResolver$.$anonfun$resolveReturnType$6(arg)))));
        if (nothingOrDynamic && withCorrectArity.size() != 1) {
            return None$.MODULE$;
        }
        Seq[] argTypeCombinations = (Seq[])SeqUtils$.MODULE$.combine(argTypes).toArray(ClassTag$.MODULE$.apply(Seq.class));
        Seq responseTypes = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])argTypeCombinations)).map((Function1<Seq, ResolutionResult> & Serializable & scala.Serializable)typeCombination -> MODULE$.resolve(thisNode, withCorrectArity, (Seq<WeaveType>)typeCombination, typeParams, ctx), Array$.MODULE$.fallbackCanBuildFrom(Predef$DummyImplicit$.MODULE$.dummyImplicit()));
        if (responseTypes.exists((Function1<ResolutionResult, Object> & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean(x$9.failure()))) {
            String name = (String)ft.name().getOrElse((Function0<String> & Serializable & scala.Serializable)() -> MODULE$.calculateFunctionName(thisNode));
            Seq<Tuple2<FunctionType, Seq<Tuple2<WeaveLocation, Message>>>> problems = this.filterIrrelevantProblems(responseTypes.flatMap((Function1<ResolutionResult, Seq> & Serializable & scala.Serializable)result2 -> {
                if (result2.typeParamFailure()) {
                    return result2.messages().map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)problemMessage -> {
                        Seq wrappedProblem = ((TraversableLike)problemMessage._2()).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)msg -> {
                            Message message;
                            Message message2 = (Message)msg._2();
                            if (message2 instanceof TypeMessage) {
                                TypeMessage typeMessage = (TypeMessage)message2;
                                message = new UnfulfilledConstraint(typeMessage);
                            } else {
                                message = message2;
                            }
                            Message transformedMessage = message;
                            return new Tuple2(msg._1(), transformedMessage);
                        }, scala.collection.Seq$.MODULE$.canBuildFrom());
                        return new Tuple2(problemMessage._1(), wrappedProblem);
                    }, scala.collection.Seq$.MODULE$.canBuildFrom());
                }
                return result2.messages();
            }, scala.collection.Seq$.MODULE$.canBuildFrom()));
            if (problems.size() == 1 && ((SeqLike)((Tuple2)problems.head())._2()).size() == 1) {
                Message idr;
                Tuple2 tuple2 = (Tuple2)((IterableLike)((Tuple2)problems.head())._2()).head();
                if (tuple2 != null && (idr = (Message)tuple2._2()) instanceof InvalidDynamicReturnMessage) {
                    InvalidDynamicReturnMessage invalidDynamicReturnMessage = (InvalidDynamicReturnMessage)idr;
                    ctx.error(invalidDynamicReturnMessage.reason(), thisNode, invalidDynamicReturnMessage.messageLocation());
                    return None$.MODULE$;
                }
                if (tuple2 != null) {
                    WeaveLocation location = (WeaveLocation)tuple2._1();
                    Message typeMessage = (Message)tuple2._2();
                    if (typeMessage instanceof TypeMessage) {
                        TypeMessage typeMessage2 = (TypeMessage)typeMessage;
                        ctx.error(typeMessage2.addTrace(name, (WeaveType)((Tuple2)problems.head())._1()), thisNode, location);
                        return None$.MODULE$;
                    }
                }
                if (tuple2 == null) throw new MatchError(tuple2);
                WeaveLocation location = (WeaveLocation)tuple2._1();
                ctx.error(new InvalidMethodTypesMessage(name, args2, problems).addTrace(name, (WeaveType)((Tuple2)problems.head())._1()), thisNode, location);
                return None$.MODULE$;
            }
            Seq errorLocations = problems.flatMap((Function1<Tuple2, Seq> & Serializable & scala.Serializable)funcMessages -> ((TraversableLike)funcMessages._2()).map((Function1<Tuple2, WeaveLocation> & Serializable & scala.Serializable)x$10 -> (WeaveLocation)x$10._1(), scala.collection.Seq$.MODULE$.canBuildFrom()), scala.collection.Seq$.MODULE$.canBuildFrom());
            UnknownLocation$ startLocation = errorLocations.isEmpty() ? UnknownLocation$.MODULE$ : (WeaveLocation)errorLocations.minBy((Function1<WeaveLocation, Object> & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger(FunctionCallNodeResolver$.$anonfun$resolveReturnType$15(x$11)), Ordering$Int$.MODULE$);
            UnknownLocation$ endLocation = errorLocations.isEmpty() ? UnknownLocation$.MODULE$ : (WeaveLocation)errorLocations.maxBy((Function1<WeaveLocation, Object> & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger(FunctionCallNodeResolver$.$anonfun$resolveReturnType$16(x$12)), Ordering$Int$.MODULE$);
            WeaveLocation newLocation = new WeaveLocation(startLocation.startPosition(), endLocation.endPosition(), startLocation.resourceName());
            ctx.error(new InvalidMethodTypesMessage(name, args2, problems), thisNode, newLocation);
            return None$.MODULE$;
        }
        Seq<WeaveType> results = responseTypes.flatMap((Function1<ResolutionResult, Iterable> & Serializable & scala.Serializable)x$13 -> Option$.MODULE$.option2Iterable(x$13.result()), scala.collection.Seq$.MODULE$.canBuildFrom());
        if (results.isEmpty()) {
            return None$.MODULE$;
        }
        thisNode.incomingEdges(EdgeLabels$.MODULE$.DYNAMIC_RETURN_TYPE()).foreach((Function1<Edge, Object> & Serializable & scala.Serializable)edge -> {
            edge.remove();
            return BoxedUnit.UNIT;
        });
        Seq dynamicReturnTypes = results.flatMap((Function1<WeaveType, Seq> & Serializable & scala.Serializable)wtype -> WeaveTypeTraverse$.MODULE$.shallowCollectAll((WeaveType)wtype, (Function1<WeaveType, Seq> & Serializable & scala.Serializable)x0$1 -> {
            WeaveType weaveType = x0$1;
            if (weaveType instanceof DynamicReturnType) {
                DynamicReturnType dynamicReturnType = (DynamicReturnType)weaveType;
                return new $colon$colon<Nothing$>((Nothing$)((Object)dynamicReturnType), Nil$.MODULE$);
            }
            return Nil$.MODULE$;
        }), scala.collection.Seq$.MODULE$.canBuildFrom());
        dynamicReturnTypes.foreach((Function1<DynamicReturnType, Object> & Serializable & scala.Serializable)drt -> {
            FunctionCallNodeResolver$.$anonfun$resolveReturnType$21(ctx, thisNode, drt);
            return BoxedUnit.UNIT;
        });
        WeaveType result3 = TypeHelper$.MODULE$.apply(ctx).unify(results);
        if (this.isDynamicReturnType(result3)) return None$.MODULE$;
        return new Some<WeaveType>(result3);
    }

    private Seq<Seq<WeaveType>> flattenUnion(Seq<WeaveType> args) {
        return args.map((Function1<WeaveType, Seq> & Serializable & scala.Serializable)x0$1 -> {
            WeaveType weaveType = x0$1;
            if (weaveType instanceof UnionType) {
                UnionType unionType = (UnionType)weaveType;
                Seq<WeaveType> of = unionType.of();
                return ((TraversableLike)MODULE$.flattenUnion(of).flatten(Predef$.MODULE$.$conforms())).map((Function1<WeaveType, WeaveType> & Serializable & scala.Serializable)x$14 -> x$14.withLocation(unionType.location()), scala.collection.Seq$.MODULE$.canBuildFrom());
            }
            return new $colon$colon<Nothing$>((Nothing$)((Object)weaveType), Nil$.MODULE$);
        }, scala.collection.Seq$.MODULE$.canBuildFrom());
    }

    private boolean isDynamicReturnType(WeaveType result3) {
        WeaveType weaveType = result3;
        if (weaveType instanceof DynamicReturnType) {
            return true;
        }
        if (weaveType instanceof UnionType) {
            UnionType unionType = (UnionType)weaveType;
            Seq<WeaveType> of = unionType.of();
            return of.exists((Function1<WeaveType, Object> & Serializable & scala.Serializable)result2 -> BoxesRunTime.boxToBoolean(FunctionCallNodeResolver$.MODULE$.isDynamicReturnType(result2)));
        }
        return false;
    }

    private void addCardinalityErrors(Seq<WeaveType> args, Seq<WeaveType> typeParams, Seq<FunctionType> allDefinitions, TypeNode node, WeaveTypeResolutionContext ctx) {
        WeaveType functionType = this.getIncomingFunctionEdge(node).incomingType();
        allDefinitions.foreach((Function1<FunctionType, Object> & Serializable & scala.Serializable)fun -> {
            Seq requiredParams = (Seq)fun.params().filter((Function1<FunctionTypeParameter, Object> & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean(FunctionCallNodeResolver$.$anonfun$addCardinalityErrors$2(x$15)));
            if (args.size() > fun.params().size()) {
                ctx.error(new TooManyArgumentMessage(fun.params().map((Function1<FunctionTypeParameter, WeaveType> & Serializable & scala.Serializable)x$16 -> x$16.wtype(), scala.collection.Seq$.MODULE$.canBuildFrom()), args, (WeaveType)fun, functionType), node);
                return BoxesRunTime.boxToBoolean(false);
            }
            if (args.size() < requiredParams.size()) {
                ctx.error(new NotEnoughArgumentMessage(requiredParams.map((Function1<FunctionTypeParameter, WeaveType> & Serializable & scala.Serializable)x$17 -> x$17.wtype(), scala.collection.Seq$.MODULE$.canBuildFrom()), args, (WeaveType)fun, functionType), node);
                return BoxesRunTime.boxToBoolean(false);
            }
            if (typeParams.nonEmpty() && typeParams.size() != fun.typeParams().size()) {
                ctx.error(new InvalidAmountTypeParametersMessage(fun.typeParams().size(), typeParams.size(), (WeaveType)fun, functionType), node);
                return BoxedUnit.UNIT;
            }
            return BoxesRunTime.boxToBoolean(true);
        });
    }

    public Seq<WeaveType> expandWithDefaultValues(Seq<WeaveType> invokedArguments, Seq<FunctionTypeParameter> params) {
        Seq<WeaveType> expandedArguments = params.nonEmpty() && params.size() != invokedArguments.size() ? (((FunctionTypeParameter)params.head()).optional() ? ((TraversableLike)params.zipWithIndex(scala.collection.Seq$.MODULE$.canBuildFrom())).map((Function1<Tuple2, WeaveType> & Serializable & scala.Serializable)param2 -> {
            int delta;
            int index = param2._2$mcI$sp();
            if (index < (delta = params.length() - invokedArguments.size())) {
                return (WeaveType)((FunctionTypeParameter)param2._1()).defaultValueType().getOrElse((Function0<WeaveType> & Serializable & scala.Serializable)() -> ((FunctionTypeParameter)param2._1()).wtype());
            }
            return (WeaveType)invokedArguments.apply(index - delta);
        }, scala.collection.Seq$.MODULE$.canBuildFrom()) : ((TraversableLike)params.zipWithIndex(scala.collection.Seq$.MODULE$.canBuildFrom())).map((Function1<Tuple2, WeaveType> & Serializable & scala.Serializable)param2 -> {
            int index = param2._2$mcI$sp();
            if (invokedArguments.size() > index) {
                return (WeaveType)invokedArguments.apply(index);
            }
            return (WeaveType)((FunctionTypeParameter)param2._1()).defaultValueType().getOrElse((Function0<WeaveType> & Serializable & scala.Serializable)() -> ((FunctionTypeParameter)param2._1()).wtype());
        }, scala.collection.Seq$.MODULE$.canBuildFrom())) : invokedArguments;
        return expandedArguments;
    }

    public String calculateFunctionName(TypeNode node) {
        AstNode astNode = node.astNode();
        if (astNode instanceof FunctionCallNode) {
            AstNode astNode2 = ((Edge)node.incomingEdges().head()).source().astNode();
            if (astNode2 instanceof VariableReferenceNode) {
                VariableReferenceNode variableReferenceNode = (VariableReferenceNode)astNode2;
                NameIdentifier variable = variableReferenceNode.variable();
                return variable.name();
            }
            return FunctionTypeHelper$.MODULE$.ANONYMOUS_FUNCTION_NAME();
        }
        return FunctionTypeHelper$.MODULE$.ANONYMOUS_FUNCTION_NAME();
    }

    private ResolutionResult resolve(TypeNode node, Seq<FunctionType> operators, Seq<WeaveType> actualTypes, Seq<WeaveType> typeParams, WeaveTypeResolutionContext ctx) {
        scala.collection.mutable.Seq<ResolutionResult> matchedOperator = this.collectValidOptions(operators, actualTypes, typeParams, node, ctx, this.collectValidOptions$default$6(), this.collectValidOptions$default$7(), this.collectValidOptions$default$8());
        if (((ResolutionResult)matchedOperator.head()).success()) {
            return (ResolutionResult)matchedOperator.head();
        }
        Seq<FunctionType> x$1 = operators;
        Seq<WeaveType> x$2 = actualTypes;
        Seq<WeaveType> x$3 = typeParams;
        TypeNode x$4 = node;
        WeaveTypeResolutionContext x$5 = ctx;
        boolean x$6 = true;
        boolean x$7 = false;
        boolean x$8 = this.collectValidOptions$default$7();
        scala.collection.mutable.Seq<ResolutionResult> functionWithCoercion = this.collectValidOptions(x$1, x$2, x$3, x$4, x$5, x$6, x$8, x$7);
        if (functionWithCoercion.size() > 1) {
            return this.multipleMatches(functionWithCoercion, actualTypes, node, ctx);
        }
        if (((ResolutionResult)functionWithCoercion.head()).success()) {
            return (ResolutionResult)functionWithCoercion.head();
        }
        scala.collection.mutable.Seq<ResolutionResult> functionsWithAllCoercions = this.collectValidOptions(operators, actualTypes, typeParams, node, ctx, true, true, false);
        if (functionsWithAllCoercions.size() > 1) {
            return this.multipleMatches(functionsWithAllCoercions, actualTypes, node, ctx);
        }
        return (ResolutionResult)functionsWithAllCoercions.head();
    }

    private ResolutionResult multipleMatches(scala.collection.mutable.Seq<ResolutionResult> functionWithCoercion, Seq<WeaveType> actualTypes, TypeNode node, WeaveTypeResolutionContext ctx) {
        Seq<WeaveType> types = TypeHelper$.MODULE$.apply(ctx).dedupTypes(functionWithCoercion.flatMap((Function1<ResolutionResult, Iterable> & Serializable & scala.Serializable)x$18 -> Option$.MODULE$.option2Iterable(x$18.result()), Seq$.MODULE$.canBuildFrom()));
        if (types.size() > 1) {
            scala.collection.mutable.Seq<FunctionType> functionTypes = functionWithCoercion.flatMap((Function1<ResolutionResult, Iterable> & Serializable & scala.Serializable)x$19 -> Option$.MODULE$.option2Iterable(x$19.functionType()), Seq$.MODULE$.canBuildFrom());
            ctx.warning(new MultipleValidFunctions(actualTypes, functionTypes), node);
            return new ResolutionResult(true, true, None$.MODULE$, new Some<WeaveType>(new AnyType()), ResolutionResult$.MODULE$.apply$default$5());
        }
        return (ResolutionResult)functionWithCoercion.head();
    }

    private WeaveType substituteResult(Substitution substitution, WeaveType returnType, WeaveTypeResolutionContext ctx) {
        WeaveType substitute2 = Constraint$.MODULE$.substitute(returnType, substitution, ctx, true, Constraint$.MODULE$.substitute$default$5(), Constraint$.MODULE$.substitute$default$6());
        substitute2 = TypeHelper$.MODULE$.apply(ctx).simplifyIntersections(substitute2);
        Seq<WeaveType> parameters = TypeHelper$.MODULE$.apply(ctx).collectTypeParameters(returnType);
        return TypeHelper$.MODULE$.apply(ctx).simplifyUnions(TypeHelper$.MODULE$.apply(ctx).cleanupUnionTypeWithParameters(substitute2, parameters));
    }

    public WeaveType setNoImplicitBounds(WeaveType weaveType) {
        return WeaveTypeTraverse$.MODULE$.treeMap(weaveType, (PartialFunction<WeaveType, WeaveType>)((Object)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends WeaveType, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof TypeParameter) {
                    TypeParameter typeParameter = (TypeParameter)A1;
                    typeParameter.noImplicitBounds_$eq(true);
                    return (B1)typeParameter;
                }
                return function1.apply(x1);
            }

            public final boolean isDefinedAt(WeaveType x1) {
                WeaveType weaveType = x1;
                return weaveType instanceof TypeParameter;
            }
        }), WeaveTypeTraverse$.MODULE$.treeMap$default$3());
    }

    public WeaveType resetImplicitBounds(WeaveType weaveType) {
        return WeaveTypeTraverse$.MODULE$.treeMap(weaveType, (PartialFunction<WeaveType, WeaveType>)((Object)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends WeaveType, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof TypeParameter) {
                    TypeParameter typeParameter = (TypeParameter)A1;
                    typeParameter.noImplicitBounds_$eq(false);
                    return (B1)typeParameter;
                }
                return function1.apply(x1);
            }

            public final boolean isDefinedAt(WeaveType x1) {
                WeaveType weaveType = x1;
                return weaveType instanceof TypeParameter;
            }
        }), WeaveTypeTraverse$.MODULE$.treeMap$default$3());
    }

    private scala.collection.mutable.Seq<ResolutionResult> collectValidOptions(Seq<FunctionType> functions, Seq<WeaveType> arguments, Seq<WeaveType> typeParams, TypeNode node, WeaveTypeResolutionContext ctx, boolean coerce, boolean coerceOnSubstitution, boolean collectFirstSuccess) {
        Object object;
        ArrayBuffer validOptions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(Nil$.MODULE$);
        Seq collectedProblems = Nil$.MODULE$;
        Seq tpCollectedProblems = Nil$.MODULE$;
        Iterator functionTypes = functions.iterator();
        while (!(!functionTypes.hasNext() || collectFirstSuccess && validOptions.headOption().nonEmpty())) {
            FunctionType functionType = (FunctionType)functionTypes.next();
            ObjectRef<Seq> warningMessages = ObjectRef.create((Seq)Nil$.MODULE$);
            ObjectRef<Seq> calledArguments = ObjectRef.create((Seq)Nil$.MODULE$);
            Seq paramTypes = functionType.params().map((Function1<FunctionTypeParameter, WeaveType> & Serializable & scala.Serializable)p -> MODULE$.setNoImplicitBounds(p.wtype()), scala.collection.Seq$.MODULE$.canBuildFrom());
            Seq<WeaveType> expandedArguments = this.expandWithDefaultValues(arguments, functionType.params());
            BooleanRef alreadyMissmatch = BooleanRef.create(false);
            ConstraintSet typeParamConstraints = ((TraversableOnce)((TraversableLike)functionType.typeParams().zip(typeParams, scala.collection.Seq$.MODULE$.canBuildFrom())).map((Function1<Tuple2, ConstraintSet> & Serializable & scala.Serializable)typeParamTuple -> Constraint$.MODULE$.collectConstrains((WeaveType)typeParamTuple._1(), (WeaveType)typeParamTuple._2(), ctx, Constraint$.MODULE$.collectConstrains$default$4(), Constraint$.MODULE$.collectConstrains$default$5()), scala.collection.Seq$.MODULE$.canBuildFrom())).foldLeft(new ConstrainProblem(Nil$.MODULE$), (Function2<ConstraintSet, ConstraintSet, ConstraintSet> & Serializable & scala.Serializable)(x$20, x$21) -> x$20.merge((Function0<ConstraintSet> & Serializable & scala.Serializable)() -> x$21));
            ConstraintSet constraintSet = typeParamConstraints;
            if (constraintSet instanceof NoSolutionSet) {
                NoSolutionSet noSolutionSet = (NoSolutionSet)constraintSet;
                Seq<Tuple2<WeaveLocation, Message>> problems = noSolutionSet.problems();
                tpCollectedProblems = tpCollectedProblems.$colon$plus(new Tuple2<FunctionType, Seq<Tuple2<WeaveLocation, Message>>>(functionType, problems), scala.collection.Seq$.MODULE$.canBuildFrom());
                continue;
            }
            ConstraintResult constraintResult = typeParamConstraints.resolve(ctx, coerce, functionType.typeParams(), typeParamConstraints.resolve$default$4(), typeParamConstraints.resolve$default$5());
            if (constraintResult instanceof ErrorResult) {
                ErrorResult errorResult = (ErrorResult)constraintResult;
                Seq<Tuple2<WeaveLocation, Message>> problems = errorResult.problems();
                tpCollectedProblems = tpCollectedProblems.$colon$plus(new Tuple2<FunctionType, Seq<Tuple2<WeaveLocation, Message>>>(functionType, problems), scala.collection.Seq$.MODULE$.canBuildFrom());
                continue;
            }
            if (constraintResult instanceof SolutionResult) {
                SolutionResult solutionResult = (SolutionResult)constraintResult;
                Substitution substitution = solutionResult.substitution();
                Seq updatedParamTypes = paramTypes.map((Function1<WeaveType, WeaveType> & Serializable & scala.Serializable)x$22 -> substitution.apply(ctx, (WeaveType)x$22, substitution.apply$default$3()), scala.collection.Seq$.MODULE$.canBuildFrom());
                ConstraintSet constraintSet2 = ((TraversableOnce)((TraversableLike)updatedParamTypes.zip(expandedArguments, scala.collection.Seq$.MODULE$.canBuildFrom())).map((Function1<Tuple2, ConstraintSet> & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        WeaveType argType;
                        WeaveType paramType = (WeaveType)tuple2._1();
                        ConstraintSet constrains = Constraint$.MODULE$.collectConstrains(paramType, argType = (WeaveType)tuple2._2(), ctx, Constraint$.MODULE$.collectConstrains$default$4(), Constraint$.MODULE$.collectConstrains$default$5());
                        ConstraintSet constraintSet = constrains;
                        if (constraintSet instanceof NoSolutionSet && coerce) {
                            Option<WeaveType> maybeType = TypeCoercer$.MODULE$.coerce(paramType, argType, ctx);
                            Option<WeaveType> option = maybeType;
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                WeaveType coercedArg = (WeaveType)some.value();
                                if (!alreadyMissmatch$1.elem) {
                                    warningMessages$1.elem = ((Seq)warningMessages$1.elem).$colon$plus(new TypeCoercedMessage(paramType, argType), scala.collection.Seq$.MODULE$.canBuildFrom());
                                    calledArguments$1.elem = ((Seq)calledArguments$1.elem).$colon$plus(coercedArg, scala.collection.Seq$.MODULE$.canBuildFrom());
                                    return Constraint$.MODULE$.collectConstrains(paramType, coercedArg, ctx, Constraint$.MODULE$.collectConstrains$default$4(), Constraint$.MODULE$.collectConstrains$default$5());
                                }
                            }
                            alreadyMissmatch$1.elem = true;
                            return constrains;
                        }
                        calledArguments$1.elem = ((Seq)calledArguments$1.elem).$colon$plus(argType, scala.collection.Seq$.MODULE$.canBuildFrom());
                        return constrains;
                    }
                    throw new MatchError(tuple2);
                }, scala.collection.Seq$.MODULE$.canBuildFrom())).foldLeft(typeParamConstraints, (Function2<ConstraintSet, ConstraintSet, ConstraintSet> & Serializable & scala.Serializable)(x$23, x$24) -> x$23.merge((Function0<ConstraintSet> & Serializable & scala.Serializable)() -> x$24));
                ConstraintResult solution = constraintSet2.resolve(ctx, coerceOnSubstitution, functionType.typeParams(), constraintSet2.resolve$default$4(), constraintSet2.resolve$default$5());
                ConstraintResult constraintResult2 = solution;
                if (constraintResult2 instanceof ErrorResult) {
                    ErrorResult errorResult = (ErrorResult)constraintResult2;
                    Seq<Tuple2<WeaveLocation, Message>> problems = errorResult.problems();
                    collectedProblems = collectedProblems.$colon$plus(new Tuple2<FunctionType, Seq<Tuple2<WeaveLocation, Message>>>(functionType, problems), scala.collection.Seq$.MODULE$.canBuildFrom());
                } else if (constraintResult2 instanceof SolutionResult) {
                    SolutionResult solutionResult2 = (SolutionResult)constraintResult2;
                    Substitution substitution2 = solutionResult2.substitution();
                    Seq<Message> warnings = solutionResult2.warnings();
                    ((Seq)warningMessages.elem).foreach((Function1<Message, Object> & Serializable & scala.Serializable)warMessage -> {
                        ctx.warning(warMessage, node);
                        return BoxedUnit.UNIT;
                    });
                    Option<WeaveType> returnType = this.resolveReturnType(node, ctx, functionType, (Seq)calledArguments.elem, substitution2, warnings);
                    validOptions.$plus$eq(new ResolutionResult(true, true, new Some<FunctionType>(functionType), returnType, ResolutionResult$.MODULE$.apply$default$5()));
                } else {
                    throw new MatchError(constraintResult2);
                }
                paramTypes.map((Function1<WeaveType, WeaveType> & Serializable & scala.Serializable)weaveType -> MODULE$.resetImplicitBounds((WeaveType)weaveType), scala.collection.Seq$.MODULE$.canBuildFrom());
                continue;
            }
            throw new MatchError(constraintResult);
        }
        if (validOptions.isEmpty()) {
            if (collectedProblems.isEmpty()) {
                boolean x$1 = false;
                Seq x$2 = tpCollectedProblems;
                boolean x$3 = ResolutionResult$.MODULE$.apply$default$1();
                Option<FunctionType> x$4 = ResolutionResult$.MODULE$.apply$default$3();
                Option<WeaveType> x$5 = ResolutionResult$.MODULE$.apply$default$4();
                object = validOptions.$plus$eq(new ResolutionResult(x$3, x$1, x$4, x$5, x$2));
            } else {
                Seq x$6 = collectedProblems;
                boolean x$7 = ResolutionResult$.MODULE$.apply$default$1();
                boolean x$8 = ResolutionResult$.MODULE$.apply$default$2();
                Option<FunctionType> x$9 = ResolutionResult$.MODULE$.apply$default$3();
                Option<WeaveType> x$10 = ResolutionResult$.MODULE$.apply$default$4();
                object = validOptions.$plus$eq(new ResolutionResult(x$7, x$8, x$9, x$10, x$6));
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        return validOptions;
    }

    private boolean collectValidOptions$default$6() {
        return false;
    }

    private boolean collectValidOptions$default$7() {
        return false;
    }

    private boolean collectValidOptions$default$8() {
        return true;
    }

    private Option<WeaveType> resolveReturnType(TypeNode node, WeaveTypeResolutionContext ctx, FunctionType functionType, Seq<WeaveType> calledArguments, Substitution substitution, Seq<Message> warnings) {
        Option option;
        warnings.foreach((Function1<Message, Object> & Serializable & scala.Serializable)warMessage -> {
            ctx.warning(warMessage, node);
            return BoxedUnit.UNIT;
        });
        WeaveType resolvedReturnType = this.substituteResult(substitution, functionType.returnType(), ctx);
        Option<CustomTypeResolver> option2 = functionType.customReturnTypeResolver();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            CustomTypeResolver crtr = (CustomTypeResolver)some.value();
            option = crtr.resolve(calledArguments, ctx, node, resolvedReturnType).map((Function1<WeaveType, WeaveType> & Serializable & scala.Serializable)x$25 -> MODULE$.substituteResult(substitution, (WeaveType)x$25, ctx));
        } else {
            option = new Some<WeaveType>(resolvedReturnType);
        }
        Some<WeaveType> result2 = option;
        return result2;
    }

    public static final /* synthetic */ boolean $anonfun$resolveFunctionCall$2(Option p) {
        return !p.isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$calculateExpectedTypeByParameter$1(WeaveTypeResolutionContext ctx$1, Option incomingExpectedType$1, FunctionType ft) {
        TypeHelper qual$1 = TypeHelper$.MODULE$.apply(ctx$1);
        WeaveType x$1 = ft.returnType();
        WeaveType x$2 = (WeaveType)incomingExpectedType$1.get();
        WeaveTypeResolutionContext x$3 = ctx$1;
        MessageCollector x$4 = qual$1.canBeSubstituted$default$4();
        return qual$1.canBeSubstituted(x$1, x$2, x$3, x$4);
    }

    public static final /* synthetic */ boolean $anonfun$checkParametersCount$1(FunctionTypeParameter x$7) {
        return !x$7.optional();
    }

    public static final /* synthetic */ boolean $anonfun$filterIrrelevantProblems$2(Tuple2 x0$1) {
        Message message;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null && (message = (Message)tuple2._2()) instanceof TypeMismatch) {
            TypeMismatch typeMismatch = (TypeMismatch)message;
            WeaveType expectedType = typeMismatch.expectedType();
            return expectedType instanceof NullType;
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$filterIrrelevantProblems$1(Tuple2 pair) {
        return ((IterableLike)pair._2()).forall((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean(FunctionCallNodeResolver$.$anonfun$filterIrrelevantProblems$2(x0$1)));
    }

    public static final /* synthetic */ boolean $anonfun$resolveReturnType$1(Seq args$1, WeaveTypeResolutionContext ctx$3, Seq typeParams$2, FunctionType fun) {
        return MODULE$.checkParametersCount(args$1, fun.params(), ctx$3) && MODULE$.checkTypeParameterCount(typeParams$2, fun.typeParams());
    }

    public static final /* synthetic */ boolean $anonfun$resolveReturnType$3(TypeParameter x$8) {
        return !FunctionTypeHelper$.MODULE$.isDynamicTypeParameter(x$8);
    }

    public static final /* synthetic */ boolean $anonfun$resolveReturnType$6(WeaveType arg) {
        return arg instanceof NothingType;
    }

    public static final /* synthetic */ int $anonfun$resolveReturnType$15(WeaveLocation x$11) {
        return x$11.startPosition().index();
    }

    public static final /* synthetic */ int $anonfun$resolveReturnType$16(WeaveLocation x$12) {
        return x$12.endPosition().index();
    }

    public static final /* synthetic */ void $anonfun$resolveReturnType$21(WeaveTypeResolutionContext ctx$3, TypeNode thisNode$1, DynamicReturnType drt) {
        Option<TypeNode> maybeNode = FunctionTypeHelper$.MODULE$.getFunctionSubGraphFor(drt, ctx$3);
        maybeNode.foreach((Function1<TypeNode, Edge> & Serializable & scala.Serializable)returnType -> Edge$.MODULE$.apply((TypeNode)returnType, thisNode$1, EdgeLabels$.MODULE$.DYNAMIC_RETURN_TYPE()));
    }

    public static final /* synthetic */ boolean $anonfun$addCardinalityErrors$2(FunctionTypeParameter x$15) {
        return !x$15.optional();
    }

    private FunctionCallNodeResolver$() {
        MODULE$ = this;
        WeaveTypeResolver.$init$(this);
    }
}

