/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.utils;

import org.mule.weave.v2.utils.StringHelper;
import scala.Array$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.math.Ordering$Int$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1$mcVI$sp;

public final class StringHelper$ {
    public static StringHelper$ MODULE$;
    private final String abrevMarker;

    static {
        new StringHelper$();
    }

    public String abrevMarker() {
        return this.abrevMarker;
    }

    public int levenshtein(String str1, String str2) {
        int lenStr1 = str1.length();
        int lenStr2 = str2.length();
        int[][] d = (int[][])Array$.MODULE$.ofDim(lenStr1 + 1, lenStr2 + 1, ClassTag$.MODULE$.Int());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), lenStr1).foreach$mVc$sp((JFunction1$mcVI$sp & Serializable)i -> {
            d$1[i][0] = i;
        });
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), lenStr2).foreach$mVc$sp((JFunction1$mcVI$sp & Serializable)j -> {
            d$1[0][j] = j;
        });
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), lenStr1).foreach$mVc$sp((JFunction1$mcVI$sp & Serializable)i -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), lenStr2).foreach$mVc$sp((JFunction1$mcVI$sp & Serializable)j -> {
            int cost = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str1), i - 1) == StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str2), j - 1) ? 0 : 1;
            d$1[i$1][j] = MODULE$.min(Predef$.MODULE$.wrapIntArray(new int[]{d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + cost}));
        }));
        return d[lenStr1][lenStr2];
    }

    public String indent(String content) {
        return new StringBuilder(1).append("\t").append(content.replaceAll("\n", "\n\t")).toString();
    }

    public int min(Seq<Object> nums) {
        return BoxesRunTime.unboxToInt(nums.min(Ordering$Int$.MODULE$));
    }

    public String abbreviate(String str, int maxWidth) {
        int offset = 0;
        if (str == null) {
            return null;
        }
        if (maxWidth < 4) {
            throw new IllegalArgumentException("Minimum abbreviation width is 4");
        }
        if (str.length() <= maxWidth) {
            return str;
        }
        if (str.length() < maxWidth - 3) {
            offset = str.length() - (maxWidth - 3);
        }
        if (offset <= 4) {
            return new StringBuilder(0).append(str.substring(0, maxWidth - 3)).append(this.abrevMarker()).toString();
        }
        if (maxWidth < 7) {
            throw new IllegalArgumentException("Minimum abbreviation width with offset is 7");
        }
        if (offset + maxWidth - 3 < str.length()) {
            return new StringBuilder(0).append(this.abrevMarker()).append(this.abbreviate(str.substring(offset), maxWidth - 3)).toString();
        }
        return new StringBuilder(0).append(this.abrevMarker()).append(str.substring(str.length() - (maxWidth - 3))).toString();
    }

    public String shorten(String str, int maxWidth) {
        if (str == null) {
            return null;
        }
        if (maxWidth < 8) {
            throw new IllegalArgumentException("Minimum abbreviation width is 4");
        }
        if (str.length() <= maxWidth + 3) {
            return str;
        }
        return new StringBuilder(0).append(str.substring(0, maxWidth / 2)).append(this.abrevMarker()).append(str.substring(str.length() - maxWidth / 2)).toString();
    }

    public String rightPad(String str, int len) {
        return ((TraversableOnce)new StringOps(Predef$.MODULE$.augmentString(str)).padTo(len, " ", Predef$.MODULE$.fallbackStringCanBuildFrom())).mkString();
    }

    public String leftPad(String str, int len) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(2).append("%").append(len).append("s").toString())).format(Predef$.MODULE$.genericWrapArray(new Object[]{str}));
    }

    public StringHelper.StringTransformer toStringTransformer(String s) {
        return new StringHelper.StringTransformer(s);
    }

    private StringHelper$() {
        MODULE$ = this;
        this.abrevMarker = "...";
    }
}

