# DataWeave Extension Support (BETA)

The DataWeave extension adds language support that enables you to develop, debug, and test DataWeave scripts. 

The DataWeave extension also enables you to quickly start creating DataWeave libraries by:

* Guiding you through project creation and setup
* Easing your development efforts by offering autocompletion, navigation, and reactors features
* Facilitating testing by providing DataWeave Testing Framework (Beta) and debugger

## Features

The following table lists and provides the current status of DataWeave extension features:

| Feature               | Status | Notes                                                        |
| --------------------- | :----: | ------------------------------------------------------------------------------------------------ | 
| Validation            |   ✅   | Provides dynamic syntax errors as you type and when you save a file                                          |
| Completions           |   ✅   |                                                                                                  |
| Hover |   ✅   |                                                                                                  |
| Extract variable      |   ✅   |                                                                                                  |
| Goto definition       |   ✅  |                                   |
| Document symbols      |   ✅   |                                                                                                  |
| Formatting            |   ✅   |   Partial and complete                                                                                |
| Find references       |   ✅   |  |
| Highlight             |   ✅   |                                                                                                  |
| Rename symbol         |   ✅   |                                                                                                |
| BAT run tests         |   ✅   |                                                                                             |
| Live preview          |   ✅   |                                                                                             |
| Quick fixes           |   ✅   |   For example, auto-importing, converting `if != null` to default values                                                                                        |
| Run/Debug             |   ✅   |                                                                                             |
| Docs auto-generation   |   ✅   |                                                                                             |
| Tests                  |   ✅   |     Supports the new VSCode Tests UI                                                                                       |
| Dependency management            |   ✅   |    Navigates through all JAR files                                                                                     |


## Requirements

* Java 8 or 11 provided
* Apache Maven

### Supported Platforms
The DataWeave Beta extension is primarily developed and tested on macOS. It is also tested in Windows (*windows-latest*) and Linux (*ubuntu-latest*) using Github Actions. For further details about the virtual environments used to develop and test the Beta extension, see [this README](https://github.com/actions/virtual-environments).

## Quickstart

To create a new DataWeave project, follow these steps:

* Launch the Command Palette by pressing **``Ctrl + Shift + P``**.
* Select `DataWeave: Create new Library Project`.
* Complete the details for your project in the provided text boxes.
* When prompted, select whether to open a new window displaying the results.

To create DataWeave modules, mappings and tests, access the Command Palette again and search for the text string `dataweave` to quickly access these options.

## DataWeave Extension Screenshots

### Completion

The DataWeave extension provides completion for any visible functions, variables, types, and so on. It also suggests fields based on type inference. 

![Completion](https://raw.githubusercontent.com/mulesoft-labs/data-weave-language-server/master/docs/animations/completion.gif)

### Live Preview
The DataWeave extension enables you to set sample data so that you can benefit from live feedback as your script is working.

![Live Preview](https://raw.githubusercontent.com/mulesoft-labs/data-weave-language-server/master/docs/animations/preview.gif) 

### Testing

The DataWeave extension enables you create test scenarios and cases automatically by running `Create Unit Test` in your module function definitions.

This feature is enabled by the DataWeave Testing Framework Beta, which provides a DSL to create test suites and assert results.

![Testing](https://raw.githubusercontent.com/mulesoft-labs/data-weave-language-server/master/docs/animations/moduleTest.gif)

### Debugging
The DataWeave extension enables you to debug both mappings and mapping tests by setting breakpoints to temporarily halt flow execution so that you can evaluate expressions. You can also use all VSCode debugging capabilities.

![Debugging](https://raw.githubusercontent.com/mulesoft-labs/data-weave-language-server/master/docs/animations/debug.gif)


## Documentation
To learn more about how you can customize and use the DataWeave extension, including a complete reference to all of its features and other resources, follow these links:

* [VSCode Extension Documentation](https://beta.docs.stgx.mulesoft.com/beta-dataweave/dataweave/2.4/dataweave-extension-plugin)
* [Dataweave Share and Reuse Homepage](https://beta.docs.stgx.mulesoft.com/beta-dataweave/dataweave/2.4/dataweave-share-reuse)
* [General Dataweave Documentation](https://beta.docs.stgx.mulesoft.com/beta-dataweave/dataweave/2.4/)

## Feedback

MuleSoft welcomes you to submit questions, comments, suggestions, and requests by way of its [public Github repository](https://github.com/mulesoft-labs/data-weave-language-server).
  


