/*
 * Decompiled with CFR 0.152.
 */
package com.mule.contribution.maven;

import com.mule.contribution.maven.resolver.MavenModelLoader;
import com.mule.contribution.maven.resolver.strategy.BuildModel;
import com.mule.contribution.maven.resolver.strategy.BuildModelFactory;
import com.mule.contribution.maven.utils.FilterUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.lsp4j.FileChangeType;
import org.mule.dx.platform.api.dependency.DependencyModel;
import org.mule.dx.platform.api.maven.MavenDependencyModel;
import org.mule.dx.platform.api.maven.MavenDependencyModelManager;
import org.mule.weave.lsp.jobs.JobManagerService;
import org.mule.weave.lsp.project.Project;
import org.mule.weave.lsp.project.components.DependencyArtifact;
import org.mule.weave.lsp.project.components.ProjectDependencyManager;
import org.mule.weave.lsp.project.events.DependencyArtifactRemovedEvent;
import org.mule.weave.lsp.project.events.DependencyArtifactResolvedEvent;
import org.mule.weave.lsp.services.ClientLogger;
import org.mule.weave.lsp.services.events.FileChangedEvent;
import org.mule.weave.lsp.services.events.OnFileChanged;
import org.mule.weave.lsp.utils.EventBus;
import org.mule.weave.lsp.utils.JavaLoggerForwarder;
import org.mule.weave.lsp.utils.URLUtils;
import scala.Option;

public class MavenProjectDependencyManager
implements ProjectDependencyManager {
    private final Project project;
    private final File pomFile;
    private EventBus eventBus;
    private ClientLogger loggerService;
    private JobManagerService jobManagerService;
    private MavenDependencyModelManager mavenDependencyModelManager;
    private MavenModelLoader mavenModelLoader;
    private List<DependencyArtifact> dependenciesArray = new ArrayList<DependencyArtifact>();
    private String languageVersion;
    private BuildModel buildModel;

    public MavenProjectDependencyManager(Project project, File pomFile, EventBus eventBus, ClientLogger loggerService, JobManagerService jobManagerService, MavenDependencyModelManager mavenDependencyModelManager, MavenModelLoader mavenModelLoader) {
        this.project = project;
        this.pomFile = pomFile;
        this.eventBus = eventBus;
        this.loggerService = loggerService;
        this.jobManagerService = jobManagerService;
        this.mavenDependencyModelManager = mavenDependencyModelManager;
        this.mavenModelLoader = mavenModelLoader;
        this.languageVersion = project.settings().wlangVersion().value();
    }

    @Override
    public String languageLevel() {
        return this.languageVersion;
    }

    @Override
    public void start() {
        this.reloadArtifacts(false);
        this.eventBus.register(FileChangedEvent.FILE_CHANGED_EVENT(), new OnFileChanged(){

            @Override
            public void onFileChanged(String uri, FileChangeType changeType) {
                Option<File> maybeFile;
                if (changeType.equals((Object)FileChangeType.Changed) && (maybeFile = URLUtils.toFile(uri)).exists(f -> MavenProjectDependencyManager.this.buildModel.isLoadedFrom((File)f))) {
                    MavenProjectDependencyManager.this.reload();
                }
            }
        });
    }

    @Override
    public void reload() {
        this.jobManagerService.schedule(cancelable -> this.reloadArtifacts(true), "Loading Maven Dependencies", "Loading Maven Dependencies.");
    }

    private void reloadArtifacts(boolean notifyDependencyModelManagerFromDX) {
        try {
            this.loggerService.logDebug("Loading artifacts from: " + this.pomFile.getPath());
            new JavaLoggerForwarder(this.loggerService);
            JavaLoggerForwarder.interceptLog(this.loggerService, () -> {
                try {
                    Collection dependencies;
                    this.buildModel = BuildModelFactory.createBuildModel(this.mavenModelLoader.effectiveModel(this.pomFile), f -> this.mavenModelLoader.effectiveModel(f));
                    MavenDependencyModel mavenDependencyModel = (MavenDependencyModel)this.mavenDependencyModelManager.loadModel().get();
                    if (notifyDependencyModelManagerFromDX) {
                        this.mavenDependencyModelManager.onDependencyModelChanged(null);
                    }
                    if (!(dependencies = mavenDependencyModel.getDependencies()).isEmpty()) {
                        this.eventBus.fire(new DependencyArtifactRemovedEvent(this.dependenciesArray.toArray(new DependencyArtifact[0])));
                        List<DependencyModel> flattenedDependencies = this.flatten(dependencies);
                        this.languageVersion = flattenedDependencies.stream().map(d -> (MavenDependencyModel)d).filter(d -> d.getArtifactId().equals("wlang")).map(d -> d.getVersion()).findFirst().orElse(this.project.settings().wlangVersion().value());
                        this.dependenciesArray = flattenedDependencies.stream().map(d -> (MavenDependencyModel)d).map(d -> new DependencyArtifact(d.getGroupId(), d.getArtifactId(), d.getType(), d.getClassifier().orElse(null), d.getVersion(), new File(d.getLocation()))).collect(Collectors.toList());
                        this.eventBus.fire(new DependencyArtifactResolvedEvent(this.dependenciesArray.toArray(new DependencyArtifact[0])));
                        this.loggerService.logDebug("All dependencies were loaded successfully.");
                    } else {
                        this.loggerService.logDebug("No dependency was detected.");
                        this.eventBus.fire(new DependencyArtifactRemovedEvent(this.dependenciesArray.toArray(new DependencyArtifact[0])));
                        this.eventBus.fire(new DependencyArtifactResolvedEvent(new DependencyArtifact[0]));
                    }
                }
                catch (Exception e) {
                    this.loggerService.logError(String.format("Exception while loading model from: %s", this.pomFile.getAbsoluteFile()), e);
                }
                return null;
            });
        }
        catch (Exception e) {
            this.loggerService.logError(String.format("Exception while resolving dependencies from: %s", this.pomFile.getAbsoluteFile()), e);
        }
    }

    private List<DependencyModel> flatten(Collection<DependencyModel> dependencies) {
        return dependencies.stream().flatMap(d -> this.flatten((DependencyModel)d)).filter(FilterUtils.distinctByKey(dm -> dm.getId())).collect(Collectors.toList());
    }

    private Stream<DependencyModel> flatten(DependencyModel dependencyModel) {
        return Stream.concat(Stream.of(dependencyModel), dependencyModel.getDependencies().stream().flatMap(d -> this.flatten((DependencyModel)d)));
    }

    @Override
    public DependencyArtifact[] dependencies() {
        return this.dependenciesArray.toArray(new DependencyArtifact[0]);
    }
}

