/*
 * Decompiled with CFR 0.152.
 */
package com.mule.contribution.maven.components;

import com.google.inject.Inject;
import com.mule.contribution.maven.components.model.DefaultMavenDependencyModel;
import com.mule.contribution.maven.resolver.MavenDependencyResolver;
import com.mule.contribution.maven.resolver.MavenManager;
import com.mule.contribution.maven.resolver.MavenModelLoader;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import org.apache.maven.model.Model;
import org.eclipse.aether.graph.DependencyNode;
import org.mule.dx.platform.api.Core;
import org.mule.dx.platform.api.dependency.DependencyModel;
import org.mule.dx.platform.api.dependency.DependencyModelMutator;
import org.mule.dx.platform.api.event.DependencyModelChangeEvent;
import org.mule.dx.platform.api.event.DependencyModelChangedEventHandler;
import org.mule.dx.platform.api.event.EventTypes;
import org.mule.dx.platform.api.event.ProjectDescriptorChangedEvent;
import org.mule.dx.platform.api.maven.MavenDependencyModel;
import org.mule.dx.platform.api.maven.MavenDependencyModelManager;
import org.mule.dx.platform.api.project.Project;
import org.mule.dx.platform.api.task.Job;
import org.mule.dx.platform.api.task.JobsManager;
import org.mule.dx.platform.api.utils.eventbus.EventBusHelper;
import org.mule.dx.platform.api.utils.eventbus.EventType;
import org.mule.dx.platform.api.utils.eventbus.IEventBus;
import org.mule.dx.platform.api.utils.eventbus.IEventHandler;
import org.mule.maven.pom.parser.api.model.BundleScope;

public class DataWeaveDependencyModelManager
implements MavenDependencyModelManager {
    @Inject
    private MavenManager mavenManager;
    @Inject
    private JobsManager jobsManager;
    @Inject
    @Core
    private IEventBus eventBus;
    private final MavenDependencyModelManager platformDependencyModelManager;
    private final Project project;
    private final File pom;
    private MavenDependencyResolver mavenDependencyResolver;
    private MavenModelLoader mavenModelLoader;

    public DataWeaveDependencyModelManager(MavenDependencyModelManager platformDependencyModelManager, Project project) {
        this.platformDependencyModelManager = platformDependencyModelManager;
        this.project = project;
        this.pom = new File(project.getProjectDescriptor().getSource());
    }

    public CompletableFuture<MavenDependencyModel> loadModel() {
        Job job = this.jobsManager.createJob("Loading maven model for " + this.project.getProjectDescriptor().getName(), monitor -> {
            Model effectiveModel = this.mavenModelLoader.effectiveModel(this.pom);
            monitor.reportProgress(String.format("Resolving dependencies for [%s]", this.project.getId()));
            DependencyNode rootNode = this.mavenDependencyResolver.getDependencyNodeWithTransitive(effectiveModel, new String[0]);
            monitor.reportProgress(String.format("Mapping to actual model", new Object[0]));
            MavenDependencyModel mavenDependencyModel = this.mapToDependencyModel(this.project.getProjectDescriptor().getSource(), effectiveModel, rootNode);
            return mavenDependencyModel;
        });
        return job.schedule();
    }

    private MavenDependencyModel mapToDependencyModel(URI location, Model model, DependencyNode rootNode) {
        DefaultMavenDependencyModel.Builder modelBuilder = new DefaultMavenDependencyModel.Builder();
        modelBuilder.groupId(model.getGroupId());
        modelBuilder.artifactId(model.getArtifactId());
        modelBuilder.version(model.getVersion());
        modelBuilder.type(model.getPackaging());
        modelBuilder.location(location);
        modelBuilder.properties(model.getProperties());
        rootNode.getChildren().forEach(dep -> {
            DefaultMavenDependencyModel.Builder depBuilder = modelBuilder.dependency();
            this.populateModelBuilder(depBuilder, (DependencyNode)dep, model.getProperties());
        });
        return modelBuilder.build();
    }

    private void populateModelBuilder(DefaultMavenDependencyModel.Builder modelBuilder, DependencyNode dependencyNode, Properties properties) {
        modelBuilder.groupId(dependencyNode.getArtifact().getGroupId());
        modelBuilder.artifactId(dependencyNode.getArtifact().getArtifactId());
        modelBuilder.version(dependencyNode.getArtifact().getVersion());
        modelBuilder.baseVersion(dependencyNode.getArtifact().getBaseVersion());
        modelBuilder.type(dependencyNode.getArtifact().getExtension());
        modelBuilder.classifier(dependencyNode.getArtifact().getClassifier());
        modelBuilder.scope(BundleScope.valueOf((String)dependencyNode.getDependency().getScope().toUpperCase()));
        modelBuilder.location(dependencyNode.getArtifact().getFile().toURI());
        modelBuilder.properties(properties);
        dependencyNode.getChildren().forEach(dep -> {
            DefaultMavenDependencyModel.Builder depBuilder = modelBuilder.dependency();
            this.populateModelBuilder(depBuilder, (DependencyNode)dep, properties);
        });
    }

    public void start() {
        this.mavenDependencyResolver = this.mavenManager.getDependencyResolver();
        this.mavenModelLoader = this.mavenManager.getMavenModelLoader();
        EventBusHelper eventBusHelper = new EventBusHelper();
        eventBusHelper.registerListener(this.eventBus, EventTypes.DESCRIPTOR_CHANGED_EVENT_TYPE, (IEventHandler)this);
        eventBusHelper.registerListener(this.eventBus, EventTypes.DEPENDENCIES_CHANGED_EVENT_TYPE, (IEventHandler)this);
    }

    public void stop() {
        this.mavenDependencyResolver = null;
        this.mavenModelLoader = null;
    }

    public void onDependencyModelChanged(DependencyModelChangeEvent dependencyModelChangeEvent) {
        this.platformDependencyModelManager.onDependencyModelChanged(this.newDependencyModelChangeEvent());
    }

    private DependencyModelChangeEvent newDependencyModelChangeEvent() {
        return new DependencyModelChangeEvent(){

            public Project getProject() {
                return DataWeaveDependencyModelManager.this.project;
            }

            public List<DependencyModel> getUpdatedDependencies() {
                return List.of();
            }

            public List<DependencyModel> getRemovedDependencies() {
                return List.of();
            }

            public List<DependencyModel> getAddedDependencies() {
                return List.of();
            }

            public DependencyModel getUpdatedModel() {
                throw new UnsupportedOperationException("Not supported");
            }

            public EventType<DependencyModelChangedEventHandler> getAssociatedType() {
                return EventTypes.DEPENDENCIES_CHANGED_EVENT_TYPE;
            }

            public void dispatch(DependencyModelChangedEventHandler handler) {
                handler.onDependencyModelChanged((DependencyModelChangeEvent)this);
            }
        };
    }

    public void onProjectDescriptorContentChange(ProjectDescriptorChangedEvent projectDescriptorChangedEvent) {
    }

    public Optional<DependencyModelMutator<MavenDependencyModel>> mutator() {
        return Optional.empty();
    }
}

