/*
 * Decompiled with CFR 0.152.
 */
package com.mule.contribution.maven.components.model;

import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.mule.dx.platform.api.dependency.DependencyModel;
import org.mule.dx.platform.api.maven.MavenDependencyModel;
import org.mule.dx.platform.api.maven.MavenDependencyModelBuilder;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleScope;

public final class DefaultMavenDependencyModel
implements MavenDependencyModel {
    private String artifactId;
    private String groupId;
    private String version;
    private String classifier;
    private String baseVersion;
    private String type;
    private URI location;
    private BundleScope scope;
    private Collection<DependencyModel> dependencies;
    private Properties properties;

    private DefaultMavenDependencyModel(Builder builder) {
        this.scope = builder.scope;
        this.artifactId = builder.artifactId;
        this.groupId = builder.groupId;
        this.version = builder.version;
        this.classifier = builder.classifier;
        this.baseVersion = builder.baseVersion;
        this.type = builder.type;
        this.location = builder.location;
        this.dependencies = builder.dependencies;
        this.properties = builder.properties;
    }

    private DefaultMavenDependencyModel(DefaultMavenDependencyModelBuilder builder) {
        this.scope = builder.scope;
        this.artifactId = builder.artifactId;
        this.groupId = builder.groupId;
        this.version = builder.version;
        this.classifier = builder.classifier;
        this.baseVersion = builder.baseVersion;
        this.type = builder.type;
        this.location = builder.location;
        this.dependencies = builder.mavenDependencyModels;
        this.properties = builder.properties;
    }

    public static MavenDependencyModel buildFromBundleDependencyModel(BundleDependency dependency) {
        Builder builder = new Builder();
        Optional dependencyClassifier = dependency.getDescriptor().getClassifier();
        builder.artifactId(dependency.getDescriptor().getArtifactId()).groupId(dependency.getDescriptor().getGroupId()).version(dependency.getDescriptor().getVersion()).classifier(dependencyClassifier.orElse("")).type(dependency.getDescriptor().getType()).scope(dependency.getScope()).location(URI.create("file://" + dependency.getDescriptor().getSystemPath()));
        return builder.build();
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getBaseVersion() {
        return this.baseVersion;
    }

    public String getType() {
        return this.type;
    }

    public Optional<String> getClassifier() {
        return Optional.ofNullable(this.classifier);
    }

    public BundleScope getScope() {
        return this.scope;
    }

    public Dependency toMavenNativeModel() {
        Dependency dependency = new Dependency();
        dependency.setArtifactId(this.getArtifactId());
        dependency.setGroupId(this.getGroupId());
        dependency.setVersion(this.getVersion());
        this.getClassifier().ifPresent(arg_0 -> ((Dependency)dependency).setClassifier(arg_0));
        dependency.setScope(this.getScope().name().toLowerCase());
        if (this.getLocation() != null) {
            dependency.setSystemPath(Paths.get(this.getLocation()).toAbsolutePath().toString());
        }
        dependency.setType(this.getType());
        return dependency;
    }

    public String getId() {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(this.getGroupId());
        parts.add(this.getArtifactId());
        parts.add(this.getVersion());
        this.getClassifier().ifPresent(parts::add);
        parts.add(this.getType());
        BundleScope scope = this.getScope();
        if (!BundleScope.COMPILE.equals((Object)scope)) {
            parts.add(scope.name().toLowerCase());
        }
        return parts.stream().collect(Collectors.joining(":"));
    }

    public Collection<DependencyModel> getDependencies() {
        return this.dependencies;
    }

    public String getSystemID() {
        return "maven";
    }

    public String getVersion() {
        return this.version;
    }

    public URI getLocation() {
        return this.location;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.artifactId, this.classifier, this.groupId, this.scope, this.location, this.type, this.version});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultMavenDependencyModel other = (DefaultMavenDependencyModel)obj;
        return com.google.common.base.Objects.equal((Object)this.artifactId, (Object)other.artifactId) && com.google.common.base.Objects.equal((Object)this.classifier, (Object)other.classifier) && com.google.common.base.Objects.equal((Object)this.groupId, (Object)other.groupId) && com.google.common.base.Objects.equal((Object)this.version, (Object)other.version) && com.google.common.base.Objects.equal((Object)this.scope, (Object)other.scope) && com.google.common.base.Objects.equal((Object)this.location, (Object)other.location) && com.google.common.base.Objects.equal((Object)this.type, (Object)other.type);
    }

    public static class Builder {
        private Collection<DependencyModel> dependencies;
        private Collection<Builder> dependenciesBuilders = new ArrayList<Builder>();
        private String artifactId;
        private String groupId;
        private String version;
        private String classifier;
        private String baseVersion;
        private String type = "jar";
        private URI location;
        private BundleScope scope = BundleScope.COMPILE;
        private Properties properties = new Properties();

        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder classifier(String classifier) {
            this.classifier = classifier;
            return this;
        }

        public Builder baseVersion(String baseVersion) {
            this.baseVersion = baseVersion;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder location(URI location) {
            this.location = location;
            return this;
        }

        public Builder scope(BundleScope scope) {
            this.scope = scope;
            return this;
        }

        public Builder properties(Properties properties) {
            this.properties = properties;
            return this;
        }

        public Builder dependency() {
            Builder builder = new Builder();
            this.dependenciesBuilders.add(builder);
            return builder;
        }

        public MavenDependencyModel build() {
            Objects.requireNonNull(this.artifactId, "artifactId must be specified");
            Objects.requireNonNull(this.groupId, "groupId must be specified");
            Objects.requireNonNull(this.version, "version must be specified");
            this.dependencies = this.dependenciesBuilders.stream().map(Builder::build).collect(Collectors.toList());
            return new DefaultMavenDependencyModel(this);
        }
    }

    public static final class DefaultMavenDependencyModelBuilder
    implements MavenDependencyModelBuilder {
        private Collection<DefaultMavenDependencyModelBuilder> dependenciesBuilders = new ArrayList<DefaultMavenDependencyModelBuilder>();
        private Collection<DependencyModel> mavenDependencyModels;
        private String artifactId;
        private String groupId;
        private String version;
        private String classifier;
        private String baseVersion;
        private String type = "jar";
        private BundleScope scope = BundleScope.COMPILE;
        private URI location;
        private Properties properties = new Properties();

        public MavenDependencyModelBuilder withGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public MavenDependencyModelBuilder withArtifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public MavenDependencyModelBuilder withVersion(String version) {
            this.version = version;
            return this;
        }

        public MavenDependencyModelBuilder withBaseVersion(String baseVersion) {
            this.baseVersion = baseVersion;
            return this;
        }

        public MavenDependencyModelBuilder withType(String type) {
            this.type = type;
            return this;
        }

        public MavenDependencyModelBuilder getClassifier(String classifier) {
            this.classifier = classifier;
            return this;
        }

        public MavenDependencyModelBuilder withScope(BundleScope scope) {
            this.scope = scope;
            return this;
        }

        public MavenDependencyModelBuilder withLocation(URI location) {
            this.location = location;
            return this;
        }

        public MavenDependencyModelBuilder withProperties(Properties properties) {
            this.properties = properties;
            return this;
        }

        public MavenDependencyModelBuilder withDependency() {
            DefaultMavenDependencyModelBuilder dependencyModelBuilder = new DefaultMavenDependencyModelBuilder();
            this.dependenciesBuilders.add(dependencyModelBuilder);
            return dependencyModelBuilder;
        }

        public MavenDependencyModel build() {
            this.mavenDependencyModels = this.dependenciesBuilders.stream().map(DefaultMavenDependencyModelBuilder::build).collect(Collectors.toList());
            return new DefaultMavenDependencyModel(this);
        }
    }
}

