/*
 * Decompiled with CFR 0.152.
 */
package com.mule.contribution.maven.resolver.strategy;

import com.mule.contribution.maven.resolver.strategy.BuildModel;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.model.Model;

public class BuildModelFactory {
    public static BuildModel createBuildModel(Model rootModel, ModelLoader modelLoader) {
        BuildModel.Builder builder = BuildModel.builder();
        ArrayList<String> visitedModels = new ArrayList<String>();
        BuildModelFactory.buildModel(rootModel, builder, visitedModels, modelLoader);
        return builder.build();
    }

    private static void buildModel(Model model, BuildModel.Builder builder, List<String> visitedModels, ModelLoader modelLoader) {
        String artifactId = model.getId();
        visitedModels.add(artifactId);
        builder.model(model);
        BuildModelFactory.getModules(model, modelLoader).forEach(subModule -> {
            String subMNoduleArtifactId = subModule.getId();
            if (!visitedModels.contains(subMNoduleArtifactId)) {
                BuildModelFactory.buildModel(subModule, builder.module(), visitedModels, modelLoader);
            }
        });
    }

    private static List<Model> getModules(Model model, ModelLoader modelLoader) {
        File projectDirectory = model.getProjectDirectory();
        return model.getModules().stream().map(module -> BuildModelFactory.getSubmodule(projectDirectory + File.separator + module + File.separator + "pom.xml", modelLoader)).collect(Collectors.toList());
    }

    private static Model getSubmodule(String pomFile, ModelLoader modelLoader) {
        Model submodule = modelLoader.effectiveModel(new File(pomFile));
        submodule.setPomFile(new File(pomFile));
        return submodule;
    }

    public static interface ModelLoader {
        public Model effectiveModel(File var1);
    }
}

