/*
 * Decompiled with CFR 0.152.
 */
package com.mule.contribution.maven.resolver.strategy;

import com.mule.contribution.maven.resolver.strategy.BuildModel;
import com.mule.contribution.maven.resolver.strategy.BuildModelFactory;
import com.mule.contribution.maven.resolver.strategy.ResolverStrategy;
import com.mule.contribution.maven.resolver.utils.MavenModelConverter;
import com.mule.contribution.maven.utils.FilterUtils;
import eu.maveniverse.maven.mima.context.Context;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.model.Model;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.eclipse.aether.util.filter.ScopeDependencyFilter;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;

public class MultiModuleProjectResolverStrategy
implements ResolverStrategy {
    private final Model rootProjectModel;
    private final Context context;
    private final String[] scopesToExclude;
    private final BuildModelFactory.ModelLoader modelLoader;

    public MultiModuleProjectResolverStrategy(Model rootProjectModel, Context context, String[] scopesToExclude, BuildModelFactory.ModelLoader modelLoader) {
        this.rootProjectModel = rootProjectModel;
        this.context = context;
        this.scopesToExclude = scopesToExclude;
        this.modelLoader = modelLoader;
    }

    @Override
    public DependencyResult resolve() throws DependencyResolutionException {
        BuildModel buildModel = BuildModelFactory.createBuildModel(this.rootProjectModel, this.modelLoader);
        DefaultRepositorySystemSession repositorySystemSession = new DefaultRepositorySystemSession(this.context.repositorySystemSession()).setWorkspaceReader(new MultiModuleWorkspaceReader(buildModel));
        ArrayList<DependencyResult> dependencyResults = new ArrayList<DependencyResult>();
        for (BuildModel module : buildModel.getAllModels()) {
            dependencyResults.add(this.resolve(repositorySystemSession, module.getModel(), this.scopesToExclude));
        }
        DependencyResult flattenedResult = new DependencyResult(((DependencyResult)dependencyResults.stream().findFirst().orElseThrow(() -> new IllegalStateException("There is no dependency result, this is probable a bug"))).getRequest());
        DefaultDependencyNode rootNode = new DefaultDependencyNode(MavenModelConverter.asDependency(buildModel.getModel(), this.context.repositorySystemSession().getArtifactTypeRegistry()));
        rootNode.setChildren(dependencyResults.stream().flatMap(d -> d.getRoot().getChildren().stream()).collect(Collectors.toList()));
        PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
        rootNode.accept(nlg);
        List reactorArtifactIds = buildModel.getAllModels().stream().map(m -> m.getModel()).map(m -> m.getGroupId() + ":" + m.getArtifactId() + ":" + m.getVersion()).collect(Collectors.toList());
        rootNode.setChildren(nlg.getNodes().stream().filter(d -> !reactorArtifactIds.contains(d.getArtifact().getGroupId() + ":" + d.getArtifact().getArtifactId() + ":" + d.getArtifact().getVersion())).filter(FilterUtils.distinctByKey(dependencyNode -> ArtifactIdUtils.toId(dependencyNode.getArtifact()))).collect(Collectors.toList()));
        flattenedResult.setRoot(rootNode);
        return flattenedResult;
    }

    public DependencyResult resolve(RepositorySystemSession repositorySystemSession, Model model, String ... scopesToExclude) throws DependencyResolutionException {
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setDependencies(MavenModelConverter.asDependencies(model.getDependencies(), this.context.repositorySystemSession().getArtifactTypeRegistry()));
        if (model.getDependencyManagement() != null) {
            collectRequest.setManagedDependencies(MavenModelConverter.asDependencies(model.getDependencyManagement().getDependencies(), this.context.repositorySystemSession().getArtifactTypeRegistry()));
        }
        if (this.context.contextOverrides().isIgnoreArtifactDescriptorRepositories()) {
            collectRequest.setRepositories(this.context.remoteRepositories());
        } else {
            List<RemoteRepository> newRemoteRepositories = this.context.lookup().lookup(RemoteRepositoryManager.class).orElseThrow(() -> new IllegalStateException("RemoteRepositoryManager not available")).aggregateRepositories(this.context.repositorySystemSession(), this.context.remoteRepositories(), MavenModelConverter.asRemoteRepositories(model.getRepositories()), true);
            collectRequest.setRepositories(newRemoteRepositories);
        }
        DependencyRequest dependencyRequest = new DependencyRequest();
        dependencyRequest.setCollectRequest(collectRequest);
        dependencyRequest.setFilter(new ScopeDependencyFilter(scopesToExclude));
        return this.context.repositorySystem().resolveDependencies(repositorySystemSession, dependencyRequest);
    }

    private class MultiModuleWorkspaceReader
    implements WorkspaceReader {
        private BuildModel buildModel;
        private WorkspaceRepository repository = new WorkspaceRepository();

        public MultiModuleWorkspaceReader(BuildModel buildModel) {
            this.buildModel = buildModel;
        }

        @Override
        public WorkspaceRepository getRepository() {
            return this.repository;
        }

        @Override
        public File findArtifact(Artifact artifact) {
            return this.buildModel.findArtifact(artifact);
        }

        @Override
        public List<String> findVersions(Artifact artifact) {
            return this.buildModel.findVersions(artifact);
        }
    }
}

