/*
 * Decompiled with CFR 0.152.
 */
package com.mule.contribution.maven.resolver.strategy;

import com.mule.contribution.maven.resolver.strategy.ResolverStrategy;
import com.mule.contribution.maven.resolver.utils.MavenModelConverter;
import eu.maveniverse.maven.mima.context.Context;
import java.util.List;
import org.apache.maven.model.Model;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.util.filter.ScopeDependencyFilter;

public class ProjectResolverStrategy
implements ResolverStrategy {
    private final Model effectiveModel;
    private final Context context;
    private final String[] scopesToExclude;

    public ProjectResolverStrategy(Model effectiveModel, Context context, String[] scopesToExclude) {
        this.effectiveModel = effectiveModel;
        this.context = context;
        this.scopesToExclude = scopesToExclude;
    }

    @Override
    public DependencyResult resolve() throws DependencyResolutionException {
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setDependencies(MavenModelConverter.asDependencies(this.effectiveModel.getDependencies(), this.context.repositorySystemSession().getArtifactTypeRegistry()));
        if (this.effectiveModel.getDependencyManagement() != null) {
            collectRequest.setManagedDependencies(MavenModelConverter.asDependencies(this.effectiveModel.getDependencyManagement().getDependencies(), this.context.repositorySystemSession().getArtifactTypeRegistry()));
        }
        if (this.context.contextOverrides().isIgnoreArtifactDescriptorRepositories()) {
            collectRequest.setRepositories(this.context.remoteRepositories());
        } else {
            List<RemoteRepository> newRemoteRepositories = this.context.lookup().lookup(RemoteRepositoryManager.class).orElseThrow(() -> new IllegalStateException("RemoteRepositoryManager not available")).aggregateRepositories(this.context.repositorySystemSession(), this.context.remoteRepositories(), MavenModelConverter.asRemoteRepositories(this.effectiveModel.getRepositories()), true);
            collectRequest.setRepositories(newRemoteRepositories);
        }
        DependencyRequest dependencyRequest = new DependencyRequest();
        dependencyRequest.setCollectRequest(collectRequest);
        dependencyRequest.setFilter(new ScopeDependencyFilter(this.scopesToExclude));
        return this.context.repositorySystem().resolveDependencies(this.context.repositorySystemSession(), dependencyRequest);
    }
}

