/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mima.runtime.shared;

import eu.maveniverse.maven.mima.context.Context;
import eu.maveniverse.maven.mima.context.ContextOverrides;
import eu.maveniverse.maven.mima.context.HTTPProxy;
import eu.maveniverse.maven.mima.context.Lookup;
import eu.maveniverse.maven.mima.context.MavenSystemHome;
import eu.maveniverse.maven.mima.context.MavenUserHome;
import eu.maveniverse.maven.mima.context.internal.MavenSystemHomeImpl;
import eu.maveniverse.maven.mima.context.internal.MavenUserHomeImpl;
import eu.maveniverse.maven.mima.context.internal.RuntimeSupport;
import eu.maveniverse.maven.mima.runtime.shared.PreBoot;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemCollectorRequest;
import org.apache.maven.model.profile.DefaultProfileActivationContext;
import org.apache.maven.model.profile.ProfileSelector;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.settings.ActivationFile;
import org.apache.maven.settings.IdentifiableBase;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.apache.maven.settings.merge.MavenSettingsMerger;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.util.artifact.DefaultArtifactTypeRegistry;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.DefaultAuthenticationSelector;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;
import org.eclipse.aether.util.repository.DefaultProxySelector;
import org.eclipse.aether.util.repository.SimpleResolutionErrorPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StandaloneRuntimeSupport
extends RuntimeSupport {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected StandaloneRuntimeSupport(String name, int priority) {
        super(name, StandaloneRuntimeSupport.discoverVersion(), priority, StandaloneRuntimeSupport.discoverMavenVersion());
    }

    private static String discoverVersion() {
        Map<String, String> version = StandaloneRuntimeSupport.loadClasspathProperties("/eu/maveniverse/maven/mima/runtime/shared/internal/version.properties");
        String result2 = version.get("version");
        if (result2 == null || result2.trim().isEmpty() || result2.startsWith("${")) {
            return "(unknown)";
        }
        return result2;
    }

    protected PreBoot preBoot(ContextOverrides overrides) {
        Path mavenSystemHome;
        String localRepoPath;
        Map<String, String> systemProperties = StandaloneRuntimeSupport.defaultSystemProperties();
        systemProperties.putAll(overrides.getSystemProperties());
        HashMap<String, String> userProperties = new HashMap<String, String>(overrides.getUserProperties());
        HashMap<String, Object> configProperties = new HashMap<String, Object>(systemProperties);
        configProperties.putAll(userProperties);
        configProperties.putAll(overrides.getConfigProperties());
        Path localRepositoryOverride = StandaloneRuntimeSupport.safeAbsolute(overrides.getLocalRepositoryOverride());
        if (localRepositoryOverride == null && (localRepoPath = (String)configProperties.get("maven.repo.local")) != null) {
            localRepositoryOverride = Paths.get(localRepoPath, new String[0]).toAbsolutePath();
        }
        if ((mavenSystemHome = StandaloneRuntimeSupport.safeAbsolute(overrides.getMavenSystemHomeOverride())) == null) {
            String mavenHome = (String)configProperties.get("maven.home");
            if (mavenHome == null) {
                mavenHome = (String)configProperties.get("env.MAVEN_HOME");
            }
            if (mavenHome != null) {
                mavenSystemHome = Paths.get(mavenHome, new String[0]).toAbsolutePath();
            }
        }
        ContextOverrides alteredOverrides = overrides.toBuilder().systemProperties(systemProperties).userProperties(userProperties).configProperties(configProperties).withLocalRepositoryOverride(localRepositoryOverride).build();
        MavenUserHomeImpl mavenUserHomeImpl = this.defaultMavenUserHome().derive(alteredOverrides);
        MavenSystemHomeImpl mavenSystemHomeImpl = mavenSystemHome != null ? new MavenSystemHomeImpl(mavenSystemHome).derive(alteredOverrides) : null;
        Path baseDir = alteredOverrides.getBasedirOverride() != null ? alteredOverrides.getBasedirOverride() : DEFAULT_BASEDIR;
        return new PreBoot(alteredOverrides, mavenUserHomeImpl, mavenSystemHomeImpl, baseDir);
    }

    protected Context buildContext(StandaloneRuntimeSupport runtime, PreBoot preBoot, RepositorySystem repositorySystem, SettingsBuilder settingsBuilder, SettingsDecrypter settingsDecrypter, ProfileSelector profileSelector, Lookup lookup, Runnable managedCloser) {
        try {
            List<Profile> activeProfiles;
            ContextOverrides alteredOverrides = preBoot.getOverrides();
            MavenUserHomeImpl mavenUserHomeImpl = preBoot.getMavenUserHome();
            MavenSystemHomeImpl mavenSystemHomeImpl = preBoot.getMavenSystemHome();
            Path baseDir = preBoot.getBaseDir();
            Settings settings2 = this.newEffectiveSettings(alteredOverrides, mavenUserHomeImpl, mavenSystemHomeImpl, settingsBuilder);
            if (settings2.getLocalRepository() != null && alteredOverrides.getLocalRepositoryOverride() == null) {
                mavenUserHomeImpl = mavenUserHomeImpl.withLocalRepository(Paths.get(settings2.getLocalRepository(), new String[0]).toAbsolutePath());
            }
            org.apache.maven.settings.Proxy proxy = settings2.getActiveProxy();
            HTTPProxy httpProxy = null;
            if (proxy != null) {
                httpProxy = this.toHTTPProxy(proxy);
            }
            if (!(activeProfiles = this.activeProfilesByActivation(alteredOverrides, baseDir, settings2, profileSelector)).isEmpty()) {
                alteredOverrides = alteredOverrides.toBuilder().withActiveProfileIds(activeProfiles.stream().map(IdentifiableBase::getId).collect(Collectors.toList())).build();
            }
            HashMap<String, String> profileProperties = new HashMap<String, String>();
            for (Profile profile : activeProfiles) {
                profile.getProperties().stringPropertyNames().forEach(n -> profileProperties.put((String)n, profile.getProperties().getProperty((String)n)));
            }
            if (!profileProperties.isEmpty()) {
                HashMap<String, String> profileUserProperties = new HashMap<String, String>(alteredOverrides.getUserProperties());
                profileProperties.forEach(profileUserProperties::putIfAbsent);
                alteredOverrides = alteredOverrides.toBuilder().userProperties(profileUserProperties).build();
            }
            DefaultRepositorySystemSession session = this.newRepositorySession(alteredOverrides, mavenUserHomeImpl, repositorySystem, settings2, settingsDecrypter);
            LinkedHashMap<String, RemoteRepository> remoteRepositories = new LinkedHashMap<String, RemoteRepository>();
            if (alteredOverrides.addRepositoriesOp() != ContextOverrides.AddRepositoriesOp.REPLACE) {
                if (alteredOverrides.addRepositoriesOp() == ContextOverrides.AddRepositoriesOp.PREPEND) {
                    alteredOverrides.getRepositories().forEach(r -> remoteRepositories.put(r.getId(), (RemoteRepository)r));
                }
                for (Profile profile : activeProfiles) {
                    for (Repository repository : profile.getRepositories()) {
                        RemoteRepository.Builder builder = new RemoteRepository.Builder(repository.getId(), repository.getLayout(), repository.getUrl());
                        if (repository.getReleases() != null) {
                            builder.setReleasePolicy(new RepositoryPolicy(repository.getReleases().isEnabled(), "daily", "warn"));
                        } else {
                            builder.setReleasePolicy(new RepositoryPolicy());
                        }
                        if (repository.getSnapshots() != null) {
                            builder.setSnapshotPolicy(new RepositoryPolicy(repository.getSnapshots().isEnabled(), "daily", "warn"));
                        } else {
                            builder.setSnapshotPolicy(new RepositoryPolicy(false, null, null));
                        }
                        RemoteRepository remoteRepository = builder.build();
                        remoteRepositories.put(remoteRepository.getId(), remoteRepository);
                    }
                }
                if (alteredOverrides.addRepositoriesOp() == ContextOverrides.AddRepositoriesOp.APPEND) {
                    alteredOverrides.getRepositories().forEach(r -> remoteRepositories.put(r.getId(), (RemoteRepository)r));
                }
            } else {
                alteredOverrides.getRepositories().forEach(r -> remoteRepositories.put(r.getId(), (RemoteRepository)r));
            }
            return new Context(runtime, alteredOverrides, baseDir, mavenUserHomeImpl, mavenSystemHomeImpl, repositorySystem, session, Collections.unmodifiableList(repositorySystem.newResolutionRepositories(session, new ArrayList<RemoteRepository>(remoteRepositories.values()))), httpProxy, lookup, managedCloser);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create context from scratch", e);
        }
    }

    private HTTPProxy toHTTPProxy(org.apache.maven.settings.Proxy proxy) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (proxy.getUsername() != null) {
            data.put("username", proxy.getUsername());
        }
        if (proxy.getPassword() != null) {
            data.put("password", proxy.getPassword());
        }
        return new HTTPProxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), proxy.getNonProxyHosts(), data);
    }

    protected Settings newEffectiveSettings(ContextOverrides overrides, MavenUserHome mavenUserHome, MavenSystemHome mavenSystemHome, SettingsBuilder settingsBuilder) throws SettingsBuildingException {
        if (!overrides.isWithUserSettings()) {
            return new Settings();
        }
        if (overrides.getEffectiveSettings() instanceof Settings) {
            return (Settings)overrides.getEffectiveSettings();
        }
        DefaultSettingsBuildingRequest settingsBuilderRequest = new DefaultSettingsBuildingRequest();
        Properties systemProperties = new Properties();
        systemProperties.putAll(overrides.getSystemProperties());
        settingsBuilderRequest.setSystemProperties(systemProperties);
        Properties userProperties = new Properties();
        userProperties.putAll(overrides.getUserProperties());
        settingsBuilderRequest.setUserProperties(userProperties);
        if (mavenSystemHome != null) {
            settingsBuilderRequest.setGlobalSettingsFile(mavenSystemHome.settingsXml().toFile());
        }
        settingsBuilderRequest.setUserSettingsFile(mavenUserHome.settingsXml().toFile());
        Settings result2 = settingsBuilder.build(settingsBuilderRequest).getEffectiveSettings();
        if (overrides.getEffectiveSettingsMixin() instanceof Settings) {
            this.settingsMixin(result2, (Settings)overrides.getEffectiveSettingsMixin());
        }
        return result2;
    }

    protected void settingsMixin(Settings settings2, Settings mixin) {
        boolean mixinAddsProxy;
        boolean bl = mixinAddsProxy = !mixin.getProxies().isEmpty();
        if (mixinAddsProxy) {
            for (org.apache.maven.settings.Proxy proxy : settings2.getProxies()) {
                proxy.setActive(false);
            }
            settings2.flushActiveProxy();
        }
        new MavenSettingsMerger().merge(settings2, mixin, "global-level");
    }

    protected List<Profile> activeProfilesByActivation(ContextOverrides overrides, Path basedir, Settings settings2, ProfileSelector profileSelector) {
        if (profileSelector == null) {
            return this.activeProfiles(settings2);
        }
        DefaultProfileActivationContext context = new DefaultProfileActivationContext();
        context.setProjectDirectory(basedir.toFile());
        context.setActiveProfileIds(Stream.concat(settings2.getActiveProfiles().stream(), overrides.getActiveProfileIds().stream()).distinct().collect(Collectors.toList()));
        context.setInactiveProfileIds(overrides.getInactiveProfileIds());
        context.setSystemProperties(overrides.getSystemProperties());
        context.setUserProperties(overrides.getUserProperties());
        ModelProblemCollector collector = new ModelProblemCollector(){

            @Override
            public void add(ModelProblemCollectorRequest req) {
            }
        };
        return profileSelector.getActiveProfiles(settings2.getProfiles().stream().map(StandaloneRuntimeSupport::convertFromSettingsProfile).collect(Collectors.toList()), context, collector).stream().map(StandaloneRuntimeSupport::convertToSettingsProfile).collect(Collectors.toList());
    }

    protected List<Profile> activeProfiles(Settings settings2) {
        HashMap<String, Profile> result2 = new HashMap<String, Profile>();
        Map<String, Profile> profileMap = settings2.getProfilesAsMap();
        for (String profileId : settings2.getActiveProfiles()) {
            Profile profile = profileMap.get(profileId);
            if (profile == null) continue;
            result2.put(profile.getId(), profile);
        }
        for (Profile profile : settings2.getProfiles()) {
            org.apache.maven.settings.Activation activation = profile.getActivation();
            if (activation == null || !activation.isActiveByDefault()) continue;
            result2.put(profile.getId(), profile);
        }
        return new ArrayList<Profile>(result2.values());
    }

    protected DefaultRepositorySystemSession newRepositorySession(ContextOverrides overrides, MavenUserHome mavenUserHome, RepositorySystem repositorySystem, Settings settings2, SettingsDecrypter settingsDecrypter) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        if (!overrides.extraArtifactTypes().isEmpty()) {
            DefaultArtifactTypeRegistry registry = (DefaultArtifactTypeRegistry)session.getArtifactTypeRegistry();
            overrides.extraArtifactTypes().forEach(registry::add);
        }
        session.setCache(new DefaultRepositoryCache());
        LinkedHashMap<String, Object> configProps = new LinkedHashMap<String, Object>(overrides.getConfigProperties());
        configProps.putIfAbsent("aether.connector.userAgent", this.getUserAgent());
        configProps.put("aether.interactive", false);
        configProps.put("maven.startTime", new Date());
        session.setOffline(overrides.isOffline());
        session.setIgnoreArtifactDescriptorRepositories(overrides.isIgnoreArtifactDescriptorRepositories());
        this.customizeChecksumPolicy(overrides, session);
        this.customizeSnapshotUpdatePolicy(overrides, session);
        session.setResolutionErrorPolicy(new SimpleResolutionErrorPolicy(false, false));
        DefaultSettingsDecryptionRequest decrypt = new DefaultSettingsDecryptionRequest();
        decrypt.setProxies((List)settings2.getProxies());
        decrypt.setServers((List)settings2.getServers());
        SettingsDecryptionResult decrypted = settingsDecrypter.decrypt(decrypt);
        if (this.logger.isDebugEnabled()) {
            for (SettingsProblem settingsProblem : decrypted.getProblems()) {
                this.logger.debug(settingsProblem.getMessage(), (Throwable)settingsProblem.getException());
            }
        }
        DefaultMirrorSelector mirrorSelector = new DefaultMirrorSelector();
        for (Mirror mirror : settings2.getMirrors()) {
            mirrorSelector.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirror.isBlocked(), mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
        }
        session.setMirrorSelector(mirrorSelector);
        DefaultProxySelector defaultProxySelector = new DefaultProxySelector();
        for (org.apache.maven.settings.Proxy proxy : decrypted.getProxies()) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            authBuilder.addUsername(proxy.getUsername()).addPassword(proxy.getPassword());
            defaultProxySelector.add(new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), authBuilder.build()), proxy.getNonProxyHosts());
        }
        session.setProxySelector(defaultProxySelector);
        DefaultAuthenticationSelector defaultAuthenticationSelector = new DefaultAuthenticationSelector();
        for (Server server : decrypted.getServers()) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            authBuilder.addUsername(server.getUsername()).addPassword(server.getPassword());
            authBuilder.addPrivateKey(server.getPrivateKey(), server.getPassphrase());
            defaultAuthenticationSelector.add(server.getId(), authBuilder.build());
            if (server.getConfiguration() != null) {
                Xpp3Dom requestTimeoutXml;
                Xpp3Dom connectTimeoutXml;
                Xpp3Dom[] properties;
                Xpp3Dom dom = (Xpp3Dom)server.getConfiguration();
                for (int i = dom.getChildCount() - 1; i >= 0; --i) {
                    Xpp3Dom child = dom.getChild(i);
                    if (!"wagonProvider".equals(child.getName())) continue;
                    dom.removeChild(i);
                }
                HashMap<String, String> headers = null;
                Integer connectTimeout = null;
                Integer requestTimeout = null;
                Xpp3Dom httpHeaders = dom.getChild("httpHeaders");
                if (httpHeaders != null && (properties = httpHeaders.getChildren("property")) != null && properties.length > 0) {
                    headers = new HashMap<String, String>();
                    for (Xpp3Dom property : properties) {
                        headers.put(property.getChild("name").getValue(), property.getChild("value").getValue());
                    }
                }
                if ((connectTimeoutXml = dom.getChild("connectTimeout")) != null) {
                    connectTimeout = Integer.parseInt(connectTimeoutXml.getValue());
                }
                if ((requestTimeoutXml = dom.getChild("requestTimeout")) != null) {
                    requestTimeout = Integer.parseInt(requestTimeoutXml.getValue());
                }
                if (headers != null) {
                    configProps.put("aether.connector.http.headers." + server.getId(), headers);
                }
                if (connectTimeout != null) {
                    configProps.put("aether.connector.connectTimeout." + server.getId(), connectTimeout);
                }
                if (requestTimeout != null) {
                    configProps.put("aether.connector.requestTimeout." + server.getId(), requestTimeout);
                }
            }
            configProps.put("aether.connector.perms.fileMode." + server.getId(), server.getFilePermissions());
            configProps.put("aether.connector.perms.dirMode." + server.getId(), server.getDirectoryPermissions());
        }
        session.setAuthenticationSelector(defaultAuthenticationSelector);
        session.setSystemProperties(overrides.getSystemProperties());
        session.setUserProperties(overrides.getUserProperties());
        session.setConfigProperties(configProps);
        if (overrides.getTransferListener() != null) {
            session.setTransferListener(overrides.getTransferListener());
        }
        if (overrides.getRepositoryListener() != null) {
            session.setRepositoryListener(overrides.getRepositoryListener());
        }
        this.newLocalRepositoryManager(mavenUserHome.localRepository(), repositorySystem, session);
        return session;
    }

    protected String getUserAgent() {
        return "Apache-Maven/" + this.mavenVersion() + " (Java " + System.getProperty("java.version") + "; " + System.getProperty("os.name") + " " + System.getProperty("os.version") + "; MIMA " + this.version() + ")";
    }

    protected static Map<String, String> defaultSystemProperties() {
        HashMap<String, String> result2 = new HashMap<String, String>();
        result2.putAll(System.getenv().entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, String>("env." + (String)e.getKey(), (String)e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        result2.putAll(System.getProperties().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue())));
        return result2;
    }

    protected static Path safeAbsolute(Path path) {
        if (path == null) {
            return null;
        }
        return path.toAbsolutePath();
    }

    protected static Profile convertToSettingsProfile(org.apache.maven.model.Profile modelProfile) {
        List pluginRepos;
        Profile profile = new Profile();
        profile.setId(modelProfile.getId());
        Activation modelActivation = modelProfile.getActivation();
        if (modelActivation != null) {
            org.apache.maven.model.ActivationFile modelFile;
            ActivationOS modelOs;
            org.apache.maven.settings.Activation activation = new org.apache.maven.settings.Activation();
            activation.setActiveByDefault(modelActivation.isActiveByDefault());
            activation.setJdk(modelActivation.getJdk());
            ActivationProperty modelProp = modelActivation.getProperty();
            if (modelProp != null) {
                org.apache.maven.settings.ActivationProperty prop = new org.apache.maven.settings.ActivationProperty();
                prop.setName(modelProp.getName());
                prop.setValue(modelProp.getValue());
                activation.setProperty(prop);
            }
            if ((modelOs = modelActivation.getOs()) != null) {
                org.apache.maven.settings.ActivationOS os = new org.apache.maven.settings.ActivationOS();
                os.setArch(modelOs.getArch());
                os.setFamily(modelOs.getFamily());
                os.setName(modelOs.getName());
                os.setVersion(modelOs.getVersion());
                activation.setOs(os);
            }
            if ((modelFile = modelActivation.getFile()) != null) {
                ActivationFile file = new ActivationFile();
                file.setExists(modelFile.getExists());
                file.setMissing(modelFile.getMissing());
                activation.setFile(file);
            }
            profile.setActivation(activation);
        }
        profile.setProperties(modelProfile.getProperties());
        List repos = modelProfile.getRepositories();
        if (repos != null) {
            for (org.apache.maven.model.Repository repo : repos) {
                profile.addRepository(StandaloneRuntimeSupport.convertToSettingsRepository(repo));
            }
        }
        if ((pluginRepos = modelProfile.getPluginRepositories()) != null) {
            for (org.apache.maven.model.Repository pluginRepo : pluginRepos) {
                profile.addPluginRepository(StandaloneRuntimeSupport.convertToSettingsRepository(pluginRepo));
            }
        }
        return profile;
    }

    protected static org.apache.maven.model.Profile convertFromSettingsProfile(Profile settingsProfile) {
        List<Repository> pluginRepos;
        org.apache.maven.model.Profile profile = new org.apache.maven.model.Profile();
        profile.setId(settingsProfile.getId());
        profile.setSource("settings.xml");
        org.apache.maven.settings.Activation settingsActivation = settingsProfile.getActivation();
        if (settingsActivation != null) {
            ActivationFile settingsFile;
            org.apache.maven.settings.ActivationOS settingsOs;
            Activation activation = new Activation();
            activation.setActiveByDefault(settingsActivation.isActiveByDefault());
            activation.setJdk(settingsActivation.getJdk());
            org.apache.maven.settings.ActivationProperty settingsProp = settingsActivation.getProperty();
            if (settingsProp != null) {
                ActivationProperty prop = new ActivationProperty();
                prop.setName(settingsProp.getName());
                prop.setValue(settingsProp.getValue());
                activation.setProperty(prop);
            }
            if ((settingsOs = settingsActivation.getOs()) != null) {
                ActivationOS os = new ActivationOS();
                os.setArch(settingsOs.getArch());
                os.setFamily(settingsOs.getFamily());
                os.setName(settingsOs.getName());
                os.setVersion(settingsOs.getVersion());
                activation.setOs(os);
            }
            if ((settingsFile = settingsActivation.getFile()) != null) {
                org.apache.maven.model.ActivationFile file = new org.apache.maven.model.ActivationFile();
                file.setExists(settingsFile.getExists());
                file.setMissing(settingsFile.getMissing());
                activation.setFile(file);
            }
            profile.setActivation(activation);
        }
        profile.setProperties(settingsProfile.getProperties());
        List<Repository> repos = settingsProfile.getRepositories();
        if (repos != null) {
            for (Repository repo : repos) {
                profile.addRepository(StandaloneRuntimeSupport.convertFromSettingsRepository(repo));
            }
        }
        if ((pluginRepos = settingsProfile.getPluginRepositories()) != null) {
            for (Repository pluginRepo : pluginRepos) {
                profile.addPluginRepository(StandaloneRuntimeSupport.convertFromSettingsRepository(pluginRepo));
            }
        }
        return profile;
    }

    protected static org.apache.maven.model.Repository convertFromSettingsRepository(Repository settingsRepo) {
        org.apache.maven.model.Repository repo = new org.apache.maven.model.Repository();
        repo.setId(settingsRepo.getId());
        repo.setLayout(settingsRepo.getLayout());
        repo.setName(settingsRepo.getName());
        repo.setUrl(settingsRepo.getUrl());
        if (settingsRepo.getSnapshots() != null) {
            repo.setSnapshots(StandaloneRuntimeSupport.convertFromSettingsRepositoryPolicy(settingsRepo.getSnapshots()));
        }
        if (settingsRepo.getReleases() != null) {
            repo.setReleases(StandaloneRuntimeSupport.convertFromSettingsRepositoryPolicy(settingsRepo.getReleases()));
        }
        return repo;
    }

    protected static org.apache.maven.model.RepositoryPolicy convertFromSettingsRepositoryPolicy(org.apache.maven.settings.RepositoryPolicy settingsPolicy) {
        org.apache.maven.model.RepositoryPolicy policy = new org.apache.maven.model.RepositoryPolicy();
        policy.setEnabled(settingsPolicy.isEnabled());
        policy.setUpdatePolicy(settingsPolicy.getUpdatePolicy());
        policy.setChecksumPolicy(settingsPolicy.getChecksumPolicy());
        return policy;
    }

    protected static Repository convertToSettingsRepository(org.apache.maven.model.Repository modelRepo) {
        Repository repo = new Repository();
        repo.setId(modelRepo.getId());
        repo.setLayout(modelRepo.getLayout());
        repo.setName(modelRepo.getName());
        repo.setUrl(modelRepo.getUrl());
        if (modelRepo.getSnapshots() != null) {
            repo.setSnapshots(StandaloneRuntimeSupport.convertToSettingsRepositoryPolicy(modelRepo.getSnapshots()));
        }
        if (modelRepo.getReleases() != null) {
            repo.setReleases(StandaloneRuntimeSupport.convertToSettingsRepositoryPolicy(modelRepo.getReleases()));
        }
        return repo;
    }

    protected static org.apache.maven.settings.RepositoryPolicy convertToSettingsRepositoryPolicy(org.apache.maven.model.RepositoryPolicy modelPolicy) {
        org.apache.maven.settings.RepositoryPolicy policy = new org.apache.maven.settings.RepositoryPolicy();
        policy.setEnabled(modelPolicy.isEnabled());
        policy.setUpdatePolicy(modelPolicy.getUpdatePolicy());
        policy.setChecksumPolicy(modelPolicy.getChecksumPolicy());
        return policy;
    }
}

