/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Objects;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.io.SettingsWriter;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Writer;
import org.codehaus.plexus.util.WriterFactory;

@Named
@Singleton
public class DefaultSettingsWriter
implements SettingsWriter {
    @Override
    public void write(File output, Map<String, Object> options, Settings settings2) throws IOException {
        Objects.requireNonNull(output, "output cannot be null");
        Objects.requireNonNull(settings2, "settings cannot be null");
        output.getParentFile().mkdirs();
        this.write((Writer)WriterFactory.newXmlWriter((File)output), options, settings2);
    }

    @Override
    public void write(Writer output, Map<String, Object> options, Settings settings2) throws IOException {
        Objects.requireNonNull(output, "output cannot be null");
        Objects.requireNonNull(settings2, "settings cannot be null");
        try (Writer out = output;){
            new SettingsXpp3Writer().write(out, settings2);
        }
    }

    @Override
    public void write(OutputStream output, Map<String, Object> options, Settings settings2) throws IOException {
        Objects.requireNonNull(output, "output cannot be null");
        Objects.requireNonNull(settings2, "settings cannot be null");
        String encoding = settings2.getModelEncoding();
        if (encoding == null || encoding.length() <= 0) {
            encoding = "UTF-8";
        }
        try (OutputStreamWriter out = new OutputStreamWriter(output, encoding);){
            this.write(out, options, settings2);
        }
    }
}

