/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.http;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.eclipse.aether.transport.http.ChecksumExtractor;

@Singleton
@Named(value="x-checksum")
public class XChecksumChecksumExtractor
extends ChecksumExtractor {
    public static final String NAME = "x-checksum";

    @Override
    public Map<String, String> extractChecksums(HttpResponse response) {
        HashMap<String, String> result2 = new HashMap<String, String>();
        String value = this.extractChecksum(response, "x-checksum-sha1");
        if (value != null) {
            result2.put("SHA-1", value);
        }
        if ((value = this.extractChecksum(response, "x-checksum-md5")) != null) {
            result2.put("MD5", value);
        }
        if (!result2.isEmpty()) {
            return result2;
        }
        value = this.extractChecksum(response, "x-goog-meta-checksum-sha1");
        if (value != null) {
            result2.put("SHA-1", value);
        }
        if ((value = this.extractChecksum(response, "x-goog-meta-checksum-md5")) != null) {
            result2.put("MD5", value);
        }
        return result2.isEmpty() ? null : result2;
    }

    private String extractChecksum(HttpResponse response, String name) {
        Header header = response.getFirstHeader(name);
        return header != null ? header.getValue() : null;
    }
}

