/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp;

import com.google.inject.Injector;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.mule.dx.platform.api.WorkspaceManager;
import org.mule.dx.platform.api.project.ProjectBuilder;
import org.mule.dx.platform.api.project.ProjectDescriptor;
import org.mule.dx.platform.api.project.ProjectDescriptorBuilder;
import org.mule.weave.lsp.project.Project;
import org.mule.weave.lsp.services.ClientLogger;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001B\u0006\r\u0001UA\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!\b\u0005\tO\u0001\u0011\t\u0011)A\u0005Q!)a\u0006\u0001C\u0001_!9A\u0007\u0001b\u0001\n\u0003)\u0004B\u0002!\u0001A\u0003%a\u0007C\u0003B\u0001\u0011\u0005!\tC\u0003O\u0001\u0011%q\nC\u0003^\u0001\u0011%a\fC\u0003\u007f\u0001\u0011%q\u0010C\u0004\u0002\u0014\u0001!I!!\u0006\u0003\u001d\u0011C\bK]8kK\u000e$X\u000b^5mg*\u0011QBD\u0001\u0004YN\u0004(BA\b\u0011\u0003\u00159X-\u0019<f\u0015\t\t\"#\u0001\u0003nk2,'\"A\n\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u00011\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g-\u0001\u0005j]*,7\r^8s!\tqR%D\u0001 \u0015\t\u0001\u0013%\u0001\u0004j]*,7\r\u001e\u0006\u0003E\r\naaZ8pO2,'\"\u0001\u0013\u0002\u0007\r|W.\u0003\u0002'?\tA\u0011J\u001c6fGR|'/\u0001\u0007dY&,g\u000e\u001e'pO\u001e,'\u000f\u0005\u0002*Y5\t!F\u0003\u0002,\u0019\u0005A1/\u001a:wS\u000e,7/\u0003\u0002.U\ta1\t\\5f]RdunZ4fe\u00061A(\u001b8jiz\"2\u0001\r\u001a4!\t\t\u0004!D\u0001\r\u0011\u0015a2\u00011\u0001\u001e\u0011\u001593\u00011\u0001)\u0003A9xN]6ta\u0006\u001cW-T1oC\u001e,'/F\u00017!\t9d(D\u00019\u0015\tI$(A\u0002ba&T!a\u000f\u001f\u0002\u0011Ad\u0017\r\u001e4pe6T!!\u0010\t\u0002\u0005\u0011D\u0018BA 9\u0005A9vN]6ta\u0006\u001cW-T1oC\u001e,'/A\tx_J\\7\u000f]1dK6\u000bg.Y4fe\u0002\n!#\\5he\u0006$X\rV8EqB\u0013xN[3diR\u00111)\u0013\t\u0003\t\u001ek\u0011!\u0012\u0006\u0003\rb\nq\u0001\u001d:pU\u0016\u001cG/\u0003\u0002I\u000b\n9\u0001K]8kK\u000e$\b\"\u0002$\u0007\u0001\u0004Q\u0005CA&N\u001b\u0005a%B\u0001$\r\u0013\tAE*\u0001\u0006bI\u0012\u0004&o\u001c6fGR$\"a\u0011)\t\u000bE;\u0001\u0019\u0001*\u0002\u001f]|'o[:qC\u000e,gi\u001c7eKJ\u0004\"a\u0015.\u000f\u0005QC\u0006CA+\u0019\u001b\u00051&BA,\u0015\u0003\u0019a$o\\8u}%\u0011\u0011\fG\u0001\u0007!J,G-\u001a4\n\u0005mc&AB*ue&twM\u0003\u0002Z1\u000592M]3bi\u0016\u0004&o\u001c6fGR$Um]2sSB$xN\u001d\u000b\u0005?\n<7\u000f\u0005\u0002EA&\u0011\u0011-\u0012\u0002\u0012!J|'.Z2u\t\u0016\u001c8M]5qi>\u0014\b\"B2\t\u0001\u0004!\u0017a\u00022vS2$WM\u001d\t\u0003\t\u0016L!AZ#\u00031A\u0013xN[3di\u0012+7o\u0019:jaR|'OQ;jY\u0012,'\u000fC\u0003i\u0011\u0001\u0007\u0011.A\u0004q_64\u0015\u000e\\3\u0011\u0005)\fX\"A6\u000b\u00051l\u0017\u0001\u00024jY\u0016T!A\\8\u0002\u00079LwNC\u0001q\u0003\u0011Q\u0017M^1\n\u0005I\\'\u0001\u0002)bi\"DQ\u0001\u001e\u0005A\u0002U\fQ!\\8eK2\u0004\"A\u001e?\u000e\u0003]T!\u0001\u001e=\u000b\u0005eT\u0018!B7bm\u0016t'BA>\u0013\u0003\u0019\t\u0007/Y2iK&\u0011Qp\u001e\u0002\u0006\u001b>$W\r\\\u0001\u0016C\u0012$\u0007K]8kK\u000e$Hk\\,pe.\u001c\b/Y2f)%\u0019\u0015\u0011AA\u0002\u0003\u000b\ty\u0001C\u0003R\u0013\u0001\u0007!\u000bC\u0003u\u0013\u0001\u0007Q\u000fC\u0004\u0002\b%\u0001\r!!\u0003\u0002\u001dA\u0014xN[3di\n+\u0018\u000e\u001c3feB\u0019A)a\u0003\n\u0007\u00055QI\u0001\bQe>TWm\u0019;Ck&dG-\u001a:\t\r\u0005E\u0011\u00021\u0001`\u0003)!Wm]2sSB$xN]\u0001\u0012O\u0016$hj\u001c:nC2L'0\u001a3QCRDGcA5\u0002\u0018!)\u0011K\u0003a\u0001%\u0002")
public class DxProjectUtils {
    private final Injector injector;
    private final ClientLogger clientLogger;
    private final WorkspaceManager workspaceManager;

    public WorkspaceManager workspaceManager() {
        return this.workspaceManager;
    }

    public org.mule.dx.platform.api.project.Project migrateToDxProject(Project project) {
        this.clientLogger.logDebug(new StringBuilder(53).append("[DataWeave] Migrating DataWeave Project to Mule-DX: ").append(project.url()).append(".").toString());
        if (!this.workspaceManager().toString().startsWith("Mock")) {
            return this.addProject(project.home().getAbsolutePath());
        }
        return null;
    }

    private org.mule.dx.platform.api.project.Project addProject(String workspaceFolder) {
        block8: {
            org.mule.dx.platform.api.project.Project project;
            block7: {
                Path pomFile = Paths.get(workspaceFolder, "pom.xml");
                if (!pomFile.toFile().exists()) break block8;
                try (FileInputStream stream = new FileInputStream(pomFile.toFile());){
                    try {
                        Model model;
                        block10: {
                            ProjectBuilder projectBuilder;
                            ProjectDescriptorBuilder descriptorBuilder;
                            block9: {
                                MavenXpp3Reader mavenXpp3Reader = new MavenXpp3Reader();
                                model = mavenXpp3Reader.read((InputStream)stream);
                                descriptorBuilder = (ProjectDescriptorBuilder)this.injector.getInstance(ProjectDescriptorBuilder.class);
                                projectBuilder = (ProjectBuilder)this.injector.getInstance(ProjectBuilder.class);
                                String string = model.getPackaging();
                                String string2 = "dw-library";
                                if (!(string == null ? string2 != null : !string.equals(string2))) break block9;
                                String string3 = model.getPackaging();
                                String string4 = "pom";
                                if (string3 != null ? !string3.equals(string4) : string4 != null) break block10;
                            }
                            ProjectDescriptor descriptor = this.createProjectDescriptor(descriptorBuilder, pomFile, model);
                            project = this.addProjectToWorkspace(workspaceFolder, model, projectBuilder, descriptor);
                            break block7;
                        }
                        throw new RuntimeException(new StringBuilder(31).append("Unsupported project packaging: ").append(model.getPackaging()).toString());
                    }
                    catch (Exception e) {
                        this.clientLogger.logError("Unexpected error parsing pom file.", e);
                        break block8;
                    }
                }
            }
            return project;
        }
        throw new RuntimeException("Could not create DX project");
    }

    private ProjectDescriptor createProjectDescriptor(ProjectDescriptorBuilder builder, Path pomFile, Model model) {
        builder.name(model.getName() != null ? model.getName() : model.getArtifactId());
        builder.description(model.getDescription());
        builder.version(model.getVersion());
        builder.nature("dw_nature");
        builder.source(pomFile.toUri());
        ProjectDescriptor descriptor = builder.build();
        descriptor.getMutator().persist();
        return descriptor;
    }

    private org.mule.dx.platform.api.project.Project addProjectToWorkspace(String workspaceFolder, Model model, ProjectBuilder projectBuilder, ProjectDescriptor descriptor) {
        projectBuilder.id(new StringBuilder(2).append(model.getGroupId()).append(":").append(model.getArtifactId()).append(":").append(model.getVersion()).toString());
        projectBuilder.descriptor(descriptor);
        Path path = this.getNormalizedPath(workspaceFolder);
        projectBuilder.location(path.toUri());
        org.mule.dx.platform.api.project.Project instance = projectBuilder.build();
        this.workspaceManager().addProject(instance);
        return instance;
    }

    private Path getNormalizedPath(String workspaceFolder) {
        Path path = Paths.get(workspaceFolder, new String[0]).normalize();
        if (!path.isAbsolute()) {
            throw new RuntimeException("Path should be absolute");
        }
        return path;
    }

    public DxProjectUtils(Injector injector, ClientLogger clientLogger) {
        this.injector = injector;
        this.clientLogger = clientLogger;
        this.workspaceManager = (WorkspaceManager)injector.getInstance(WorkspaceManager.class);
    }
}

