/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.actions;

import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.mule.weave.lsp.actions.CodeActionProvider;
import org.mule.weave.lsp.commands.CommandManager;
import org.mule.weave.lsp.commands.ExtractConstantCommand$;
import org.mule.weave.lsp.commands.ExtractFunctionCommand$;
import org.mule.weave.lsp.commands.ExtractVariableCommand$;
import org.mule.weave.lsp.project.components.ContextMetadata;
import org.mule.weave.lsp.services.DataWeaveToolingService;
import org.mule.weave.v2.editor.WeaveDocumentToolingService;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.AstNodeHelper$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001!4Aa\u0002\u0005\u0001'!A\u0001\u0004\u0001B\u0001B\u0003%\u0011\u0004\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003!\u0011\u00151\u0003\u0001\"\u0001(\u0011\u0015Y\u0003\u0001\"\u0011-\u0011\u0015Q\u0005\u0001\"\u0003L\u0011\u0015q\u0006\u0001\"\u0011`\u0005Y\u0011VMZ1di>\u0014\u0018i\u0019;j_:\u0004&o\u001c<jI\u0016\u0014(BA\u0005\u000b\u0003\u001d\t7\r^5p]NT!a\u0003\u0007\u0002\u00071\u001c\bO\u0003\u0002\u000e\u001d\u0005)q/Z1wK*\u0011q\u0002E\u0001\u0005[VdWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u0016-5\t\u0001\"\u0003\u0002\u0018\u0011\t\u00112i\u001c3f\u0003\u000e$\u0018n\u001c8Qe>4\u0018\u000eZ3s\u00039!xn\u001c7j]\u001e\u001cVM\u001d<jG\u0016\u0004\"AG\u000f\u000e\u0003mQ!\u0001\b\u0006\u0002\u0011M,'O^5dKNL!AH\u000e\u0003/\u0011\u000bG/Y,fCZ,Gk\\8mS:<7+\u001a:wS\u000e,\u0017AD2p[6\fg\u000eZ'b]\u0006<WM\u001d\t\u0003C\u0011j\u0011A\t\u0006\u0003G)\t\u0001bY8n[\u0006tGm]\u0005\u0003K\t\u0012abQ8n[\u0006tG-T1oC\u001e,'/\u0001\u0004=S:LGO\u0010\u000b\u0004Q%R\u0003CA\u000b\u0001\u0011\u0015A2\u00011\u0001\u001a\u0011\u0015y2\u00011\u0001!\u0003%!w\u000eS1oI2,7\u000fF\u0002.gu\u0002\"AL\u0019\u000e\u0003=R\u0011\u0001M\u0001\u0006g\u000e\fG.Y\u0005\u0003e=\u0012qAQ8pY\u0016\fg\u000eC\u00035\t\u0001\u0007Q'\u0001\u0004qCJ\fWn\u001d\t\u0003mmj\u0011a\u000e\u0006\u0003qe\nQ\u0001\\:qi)T!A\u000f\t\u0002\u000f\u0015\u001cG.\u001b9tK&\u0011Ah\u000e\u0002\u0011\u0007>$W-Q2uS>t\u0007+\u0019:b[NDQA\u0010\u0003A\u0002}\nA\"\\1zE\u0016\u001cuN\u001c;fqR\u00042A\f!C\u0013\t\tuF\u0001\u0004PaRLwN\u001c\t\u0003\u0007\"k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000b!bY8na>tWM\u001c;t\u0015\t9%\"A\u0004qe>TWm\u0019;\n\u0005%#%aD\"p]R,\u0007\u0010^'fi\u0006$\u0017\r^1\u0002\u0011Q|wJ\u001a4tKR$2\u0001T(Z!\tqS*\u0003\u0002O_\t\u0019\u0011J\u001c;\t\u000bA+\u0001\u0019A)\u0002-\u0011|7-^7f]R$vn\u001c7j]\u001e\u001cVM\u001d<jG\u0016\u0004\"AU,\u000e\u0003MS!\u0001V+\u0002\r\u0015$\u0017\u000e^8s\u0015\t1F\"\u0001\u0002we%\u0011\u0001l\u0015\u0002\u001c/\u0016\fg/\u001a#pGVlWM\u001c;U_>d\u0017N\\4TKJ4\u0018nY3\t\u000bi+\u0001\u0019A.\u0002\u001bM$\u0018M\u001d;Q_NLG/[8o!\t1D,\u0003\u0002^o\tA\u0001k\\:ji&|g.A\u0005e_\u0006\u001bG/[8ogR\u0019\u0001MZ4\u0011\u00079\n7-\u0003\u0002c_\t)\u0011I\u001d:bsB\u0011a\u0007Z\u0005\u0003K^\u0012!bQ8eK\u0006\u001bG/[8o\u0011\u0015!d\u00011\u00016\u0011\u0015qd\u00011\u0001@\u0001")
public class RefactorActionProvider
extends CodeActionProvider {
    private final DataWeaveToolingService toolingService;
    private final CommandManager commandManager;

    @Override
    public boolean doHandles(CodeActionParams params, Option<ContextMetadata> maybeContext) {
        int endOffset;
        WeaveDocumentToolingService documentToolingService = this.toolingService.openDocument(params.getTextDocument().getUri(), maybeContext, true);
        Range range = params.getRange();
        Position startPosition = range.getStart();
        Position endPosition = range.getEnd();
        int startOffset = this.toOffset(documentToolingService, startPosition);
        Option<AstNode> maybeNode = documentToolingService.nodeAt(startOffset, endOffset = this.toOffset(documentToolingService, endPosition));
        Option<AstNode> option = maybeNode;
        if (option instanceof Some) {
            Some some = (Some)option;
            AstNode nodeToExtract = (AstNode)some.value();
            return AstNodeHelper$.MODULE$.isExpressionNode(nodeToExtract) || AstNodeHelper$.MODULE$.isWeaveTypeNode(nodeToExtract);
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError(option);
    }

    private int toOffset(WeaveDocumentToolingService documentToolingService, Position startPosition) {
        return documentToolingService.offsetOf(startPosition.getLine(), startPosition.getCharacter());
    }

    @Override
    public CodeAction[] doActions(CodeActionParams params, Option<ContextMetadata> maybeContext) {
        WeaveDocumentToolingService documentToolingService = this.toolingService.openDocument(params.getTextDocument().getUri(), maybeContext, true);
        Range range = params.getRange();
        Position startPosition = range.getStart();
        Position endPosition = range.getEnd();
        int startOffset = this.toOffset(documentToolingService, startPosition);
        int endOffset = this.toOffset(documentToolingService, endPosition);
        CodeAction extractVariable = new CodeAction("Extract Variable (Local Scope)");
        extractVariable.setCommand(ExtractVariableCommand$.MODULE$.createCommand(startOffset, endOffset, params.getTextDocument().getUri(), this.commandManager));
        extractVariable.setKind("refactor.extract.variable");
        CodeAction extractConstant = new CodeAction("Extract Variable (Global Scope)");
        extractConstant.setCommand(ExtractConstantCommand$.MODULE$.createCommand(startOffset, endOffset, params.getTextDocument().getUri(), this.commandManager));
        extractConstant.setKind("refactor.extract.constant");
        CodeAction extractFunction = new CodeAction("Extract Function");
        extractFunction.setCommand(ExtractFunctionCommand$.MODULE$.createCommand(startOffset, endOffset, params.getTextDocument().getUri(), this.commandManager));
        extractFunction.setKind("refactor.extract.function");
        return (CodeAction[])((Object[])new CodeAction[]{extractVariable, extractConstant, extractFunction});
    }

    public RefactorActionProvider(DataWeaveToolingService toolingService, CommandManager commandManager) {
        this.toolingService = toolingService;
        this.commandManager = commandManager;
    }
}

