/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.agent;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.mule.weave.lsp.agent.AgentClasspathResolver;
import org.mule.weave.lsp.agent.FolderBasedAgentClasspathResolver;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0$mcI$sp;
import scala.runtime.java8.JFunction1$mcVI$sp;
import scala.runtime.java8.JFunction1$mcZI$sp;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001\u0002\n\u0014\u0001yAQ!\u000b\u0001\u0005\u0002)Bq\u0001\f\u0001C\u0002\u0013%Q\u0006\u0003\u00049\u0001\u0001\u0006IA\f\u0005\bs\u0001\u0011\r\u0011\"\u0003;\u0011\u0019\t\u0005\u0001)A\u0005w!9!\t\u0001b\u0001\n\u0013\u0019\u0005B\u0002&\u0001A\u0003%A\tC\u0004L\u0001\t\u0007I\u0011B\"\t\r1\u0003\u0001\u0015!\u0003E\u0011\u001di\u0005A1A\u0005\n9Caa\u0018\u0001!\u0002\u0013y\u0005b\u00021\u0001\u0005\u0004%Ia\u0011\u0005\u0007C\u0002\u0001\u000b\u0011\u0002#\t\u0011\t\u0004\u0001R1A\u0005\u0002\rDQa\u001a\u0001\u0005\n!DQA\u001b\u0001\u0005\n-DQa\u001f\u0001\u0005Bq\u00141EU3t_V\u00148-\u001a\"bg\u0016$\u0017iZ3oi\u000ec\u0017m]:qCRD'+Z:pYZ,'O\u0003\u0002\u0015+\u0005)\u0011mZ3oi*\u0011acF\u0001\u0004YN\u0004(B\u0001\r\u001a\u0003\u00159X-\u0019<f\u0015\tQ2$\u0001\u0003nk2,'\"\u0001\u000f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001yR\u0005\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VM\u001a\t\u0003M\u001dj\u0011aE\u0005\u0003QM\u0011a#Q4f]R\u001cE.Y:ta\u0006$\bNU3t_24XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003-\u0002\"A\n\u0001\u0002\r1{uiR#S+\u0005q\u0003CA\u00187\u001b\u0005\u0001$BA\u00193\u0003\u001dawnZ4j]\u001eT!a\r\u001b\u0002\tU$\u0018\u000e\u001c\u0006\u0002k\u0005!!.\u0019<b\u0013\t9\u0004G\u0001\u0004M_\u001e<WM]\u0001\b\u0019>;u)\u0012*!\u0003\u001d!V\nU0E\u0013J+\u0012a\u000f\t\u0003y}j\u0011!\u0010\u0006\u0003}Q\n!![8\n\u0005\u0001k$\u0001\u0002$jY\u0016\f\u0001\u0002V'Q?\u0012K%\u000bI\u0001\r\u0003\u001e+e\nV0G\u001f2#UIU\u000b\u0002\tB\u0011Q\tS\u0007\u0002\r*\u0011q\tN\u0001\u0005Y\u0006tw-\u0003\u0002J\r\n11\u000b\u001e:j]\u001e\fQ\"Q$F\u001dR{fi\u0014'E\u000bJ\u0003\u0013A\u0005#F'RKe*\u0011+J\u001f:{fi\u0014'E\u000bJ\u000b1\u0003R#T)&s\u0015\tV%P\u001d~3u\n\u0014#F%\u0002\n\u0011BU#T\u001fV\u00136)R*\u0016\u0003=\u00032\u0001U*V\u001b\u0005\t&B\u0001*\"\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003)F\u00131aU3r!\t1VL\u0004\u0002X7B\u0011\u0001,I\u0007\u00023*\u0011!,H\u0001\u0007yI|w\u000e\u001e \n\u0005q\u000b\u0013A\u0002)sK\u0012,g-\u0003\u0002J=*\u0011A,I\u0001\u000b%\u0016\u001bv*\u0016*D\u000bN\u0003\u0013!\u0004&B%~+\u0005\fV#O'&{e*\u0001\bK\u0003J{V\t\u0017+F\u001dNKuJ\u0014\u0011\u0002\u001b5\f\u0017PY3SKN|GN^3s+\u0005!\u0007c\u0001\u0011fK%\u0011a-\t\u0002\u0007\u001fB$\u0018n\u001c8\u0002'\r\u0014X-\u0019;f\u0019&\u00147\u000fR5sK\u000e$xN]=\u0015\u0003%\u00042\u0001I3<\u0003\u001d\u0019w\u000e]=KCJ$2\u0001\\8r!\t\u0001S.\u0003\u0002oC\t!QK\\5u\u0011\u0015\u0001\b\u00031\u0001V\u0003!\u0011Xm]8ve\u000e,\u0007\"\u0002:\u0011\u0001\u0004\u0019\u0018a\u0004;be\u001e,G\u000fR5sK\u000e$xN]=\u0011\u0005QLX\"A;\u000b\u0005Y<\u0018\u0001\u00024jY\u0016T!\u0001\u001f\u001b\u0002\u00079Lw.\u0003\u0002{k\n!\u0001+\u0019;i\u0003Q\u0011Xm]8mm\u0016\u001cE.Y:ta\u0006$\bNS1sgR\tQ\u0010\u0005\u0003\u007f\u0003\u000f)fbA@\u0002\u00049\u0019\u0001,!\u0001\n\u0003\tJ1!!\u0002\"\u0003\u001d\u0001\u0018mY6bO\u0016L1\u0001VA\u0005\u0015\r\t)!\t")
public class ResourceBasedAgentClasspathResolver
implements AgentClasspathResolver {
    private Option<AgentClasspathResolver> maybeResolver;
    private final Logger LOGGER = Logger.getLogger(this.getClass().getName());
    private final File TMP_DIR = new File(System.getProperty("java.io.tmpdir"));
    private final String AGENT_FOLDER;
    private final String DESTINATION_FOLDER;
    private final Seq<String> RESOURCES = new $colon$colon<Nothing$>((Nothing$)((Object)new StringBuilder(17).append(this.AGENT_FOLDER()).append("/agent-server.zip").toString()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new StringBuilder(14).append(this.AGENT_FOLDER()).append("/agent-api.zip").toString()), Nil$.MODULE$));
    private final String JAR_EXTENSION;
    private volatile boolean bitmap$0;

    private Logger LOGGER() {
        return this.LOGGER;
    }

    private File TMP_DIR() {
        return this.TMP_DIR;
    }

    private String AGENT_FOLDER() {
        return this.AGENT_FOLDER;
    }

    private String DESTINATION_FOLDER() {
        return this.DESTINATION_FOLDER;
    }

    private Seq<String> RESOURCES() {
        return this.RESOURCES;
    }

    private String JAR_EXTENSION() {
        return this.JAR_EXTENSION;
    }

    private Option<AgentClasspathResolver> maybeResolver$lzycompute() {
        ResourceBasedAgentClasspathResolver resourceBasedAgentClasspathResolver = this;
        synchronized (resourceBasedAgentClasspathResolver) {
            if (!this.bitmap$0) {
                Option<File> maybeLibsDirectory = this.createLibsDirectory();
                this.maybeResolver = maybeLibsDirectory.map((Function1<File, FolderBasedAgentClasspathResolver> & Serializable & scala.Serializable)dir -> new FolderBasedAgentClasspathResolver((File)dir));
                this.bitmap$0 = true;
            }
        }
        return this.maybeResolver;
    }

    public Option<AgentClasspathResolver> maybeResolver() {
        if (!this.bitmap$0) {
            return this.maybeResolver$lzycompute();
        }
        return this.maybeResolver;
    }

    private Option<File> createLibsDirectory() {
        URL url = this.getClass().getClassLoader().getResource(this.AGENT_FOLDER());
        if (url != null) {
            if (!this.TMP_DIR().exists()) {
                throw new RuntimeException(new StringBuilder(106).append("The specified temporary ").append(this.TMP_DIR().getAbsolutePath()).append(" directory does not exits. Please create the directory or provide a different one.").toString());
            }
            Path targetDirectory = Files.createTempDirectory(this.DESTINATION_FOLDER(), new FileAttribute[0]);
            this.RESOURCES().foreach((Function1<String, Object> & Serializable & scala.Serializable)resource -> {
                this.copyJar(resource, targetDirectory);
                return BoxedUnit.UNIT;
            });
            return new Some<File>(targetDirectory.toFile());
        }
        return None$.MODULE$;
    }

    private void copyJar(String resource, Path targetDirectory) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(resource);
        if (is != null) {
            try {
                String baseName = FilenameUtils.getBaseName(resource);
                File destination = targetDirectory.resolve(new StringBuilder(0).append(baseName).append(this.JAR_EXTENSION()).toString()).toFile();
                destination.createNewFile();
                destination.deleteOnExit();
                try (FileOutputStream out = new FileOutputStream(destination);){
                    byte[] buffer = new byte[1024];
                    ((Stream)package$.MODULE$.Stream().continually((JFunction0$mcI$sp & scala.Serializable)() -> is.read(buffer)).takeWhile((JFunction1$mcZI$sp & scala.Serializable)x$2 -> x$2 != -1)).foreach((JFunction1$mcVI$sp & scala.Serializable)x$3 -> out.write(buffer, 0, x$3));
                }
            }
            finally {
                is.close();
            }
            return;
        }
    }

    @Override
    public Seq<String> resolveClasspathJars() {
        Seq<String> jars;
        block0: {
            Seq<String> seq = jars = this.maybeResolver().isDefined() ? this.maybeResolver().get().resolveClasspathJars() : (Seq<String>)Nil$.MODULE$;
            if (!jars.isEmpty()) break block0;
            this.LOGGER().log(Level.SEVERE, "Could not resolve agent classpath jars");
        }
        return jars;
    }

    public ResourceBasedAgentClasspathResolver() {
        this.AGENT_FOLDER = "agent-server-libs";
        this.DESTINATION_FOLDER = "data-weave-agent";
        this.JAR_EXTENSION = ".jar";
    }
}

