/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.commands;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ResourceOperation;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.mule.weave.extension.api.WeaveCommand;
import org.mule.weave.lsp.commands.CommandManager;
import org.mule.weave.lsp.commands.Commands$;
import org.mule.weave.lsp.commands.CreateUnitTest$;
import org.mule.weave.lsp.extension.client.OpenTextDocumentParams;
import org.mule.weave.lsp.extension.client.OpenTextDocumentParams$;
import org.mule.weave.lsp.extension.client.WeaveLanguageClient;
import org.mule.weave.lsp.i18n.UserMessages$;
import org.mule.weave.lsp.project.Project;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.components.ProjectStructure$;
import org.mule.weave.lsp.services.DataWeaveToolingService;
import org.mule.weave.lsp.utils.URLUtils$;
import org.mule.weave.lsp.utils.WeaveDirectoryUtils$;
import org.mule.weave.v2.editor.WeaveDocumentToolingService;
import org.mule.weave.v2.editor.WeaveUnitTestAddition;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.location.Position;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.io.BufferedSource;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\t%a\u0001\u0002\r\u001a\u0001\u0011B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\ty\u0001\u0011\t\u0011)A\u0005{!AA\t\u0001B\u0001B\u0003%Q\t\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003L\u0011\u0015q\u0005\u0001\"\u0001P\u0011\u00151\u0006\u0001\"\u0011X\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u0015)\b\u0001\"\u0003w\u0011\u001d\tY\u0003\u0001C\u0005\u0003[)a!!\u000f\u0001\u0001\u0005m\u0002bBA,\u0001\u0011%\u0011\u0011\f\u0005\b\u0003K\u0002A\u0011BA4\u0011\u001d\ty\b\u0001C\u0005\u0003\u0003C\u0011\"!&\u0001#\u0003%I!a&\t\u000f\u00055\u0006\u0001\"\u0003\u00020\"9\u00111\u0018\u0001\u0005\n\u0005u\u0006bBAd\u0001\u0011%\u0011\u0011\u001a\u0005\u0007\u0003\u001b\u0004A\u0011I,\t\u000f\u0005=\u0007\u0001\"\u0011\u0002R\u001e9\u0011Q[\r\t\u0002\u0005]gA\u0002\r\u001a\u0011\u0003\tI\u000e\u0003\u0004O+\u0011\u0005\u00111\u001c\u0005\b\u0003;,B\u0011AAp\u00059\u0019%/Z1uKVs\u0017\u000e\u001e+fgRT!AG\u000e\u0002\u0011\r|W.\\1oINT!\u0001H\u000f\u0002\u00071\u001c\bO\u0003\u0002\u001f?\u0005)q/Z1wK*\u0011\u0001%I\u0001\u0005[VdWMC\u0001#\u0003\ry'oZ\u0002\u0001'\r\u0001Q%\f\t\u0003M-j\u0011a\n\u0006\u0003Q%\nA\u0001\\1oO*\t!&\u0001\u0003kCZ\f\u0017B\u0001\u0017(\u0005\u0019y%M[3diB\u0011afM\u0007\u0002_)\u0011\u0001'M\u0001\u0004CBL'B\u0001\u001a\u001e\u0003%)\u0007\u0010^3og&|g.\u0003\u00025_\taq+Z1wK\u000e{W.\\1oI\u0006\tb/\u00197jI\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0011\u0005]RT\"\u0001\u001d\u000b\u0005eZ\u0012\u0001C:feZL7-Z:\n\u0005mB$a\u0006#bi\u0006<V-\u0019<f)>|G.\u001b8h'\u0016\u0014h/[2f\u0003M9X-\u0019<f\u0019\u0006tw-^1hK\u000ec\u0017.\u001a8u!\tq$)D\u0001@\u0015\t\u0001\u0015)\u0001\u0004dY&,g\u000e\u001e\u0006\u0003emI!aQ \u0003']+\u0017M^3MC:<W/Y4f\u00072LWM\u001c;\u0002\u0017A\u0014xN[3di.Kg\u000e\u001a\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011n\tq\u0001\u001d:pU\u0016\u001cG/\u0003\u0002K\u000f\nY\u0001K]8kK\u000e$8*\u001b8e!\t1E*\u0003\u0002N\u000f\n9\u0001K]8kK\u000e$\u0018A\u0002\u001fj]&$h\bF\u0003Q%N#V\u000b\u0005\u0002R\u00015\t\u0011\u0004C\u00036\u000b\u0001\u0007a\u0007C\u0003=\u000b\u0001\u0007Q\bC\u0003E\u000b\u0001\u0007Q\tC\u0003I\u000b\u0001\u00071*A\u0005d_6l\u0017M\u001c3JIR\t\u0001\f\u0005\u0002ZE:\u0011!\f\u0019\t\u00037zk\u0011\u0001\u0018\u0006\u0003;\u000e\na\u0001\u0010:p_Rt$\"A0\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005t\u0016A\u0002)sK\u0012,g-\u0003\u0002dI\n11\u000b\u001e:j]\u001eT!!\u00190\u0002\u000f\u0015DXmY;uKR\u0011qm\u001b\t\u0003Q&l\u0011AX\u0005\u0003Uz\u0013a!\u00118z%\u00164\u0007\"\u00027\b\u0001\u0004i\u0017A\u00029be\u0006l7\u000f\u0005\u0002og6\tqN\u0003\u0002qc\u0006)An\u001d95U*\u0011!/I\u0001\bK\u000ed\u0017\u000e]:f\u0013\t!xN\u0001\u000bFq\u0016\u001cW\u000f^3D_6l\u0017M\u001c3QCJ\fWn]\u0001\rI>\u001c%/Z1uKR+7\u000f\u001e\u000b\u000boj\f)!!\u0003\u0002\u001e\u0005\u001d\u0002C\u00015y\u0013\tIhL\u0001\u0003V]&$\b\"B>\t\u0001\u0004a\u0018\u0001\u0003;fgR4\u0015\u000e\\3\u0011\u0007u\f\t!D\u0001\u007f\u0015\ty\u0018&\u0001\u0002j_&\u0019\u00111\u0001@\u0003\t\u0019KG.\u001a\u0005\u0007\u0003\u000fA\u0001\u0019\u0001-\u0002\u0017Q,7\u000f\u001e$jY\u0016,&\u000b\u0014\u0005\b\u0003\u0017A\u0001\u0019AA\u0007\u0003Y!wnY;nK:$Hk\\8mS:<7+\u001a:wS\u000e,\u0007\u0003BA\b\u00033i!!!\u0005\u000b\t\u0005M\u0011QC\u0001\u0007K\u0012LGo\u001c:\u000b\u0007\u0005]Q$\u0001\u0002we%!\u00111DA\t\u0005m9V-\u0019<f\t>\u001cW/\\3oiR{w\u000e\\5oON+'O^5dK\"9\u0011q\u0004\u0005A\u0002\u0005\u0005\u0012aC:uCJ$xJ\u001a4tKR\u00042\u0001[A\u0012\u0013\r\t)C\u0018\u0002\u0004\u0013:$\bbBA\u0015\u0011\u0001\u0007\u0011\u0011E\u0001\nK:$wJ\u001a4tKR\f!#\u00193e)\u0016\u001cH\u000fV8CY\u0006t7NR5mKRYq/a\f\u00022\u0005M\u0012QGA\u001c\u0011\u0015Y\u0018\u00021\u0001}\u0011\u0019\t9!\u0003a\u00011\"9\u00111B\u0005A\u0002\u00055\u0001bBA\u0010\u0013\u0001\u0007\u0011\u0011\u0005\u0005\b\u0003SI\u0001\u0019AA\u0011\u0005\u0011)E-\u001b;\u0011\u0011\u0005u\u0012qIA&\u0003#j!!a\u0010\u000b\t\u0005\u0005\u00131I\u0001\t[\u0016\u001c8/Y4fg*\u0019\u0011QI8\u0002\u000f)\u001cxN\u001c:qG&!\u0011\u0011JA \u0005\u0019)\u0015\u000e\u001e5feB\u0019a.!\u0014\n\u0007\u0005=sN\u0001\tUKb$Hi\\2v[\u0016tG/\u00123jiB\u0019a.a\u0015\n\u0007\u0005UsNA\tSKN|WO]2f\u001fB,'/\u0019;j_:\f\u0011$\u00193e)\u0016\u001cH\u000fV8Fq&\u001cH/\u001b8h)\u0016\u001cHoQ8eKRYq/a\u0017\u0002^\u0005}\u0013\u0011MA2\u0011\u0015Y8\u00021\u0001}\u0011\u0019\t9a\u0003a\u00011\"9\u00111B\u0006A\u0002\u00055\u0001bBA\u0010\u0017\u0001\u0007\u0011\u0011\u0005\u0005\b\u0003SY\u0001\u0019AA\u0011\u0003=9W\r\u001e+fgR\fE\rZ5uS>tGCCA5\u0003k\nI(a\u001f\u0002~A)\u0001.a\u001b\u0002p%\u0019\u0011Q\u000e0\u0003\r=\u0003H/[8o!\u0011\ty!!\u001d\n\t\u0005M\u0014\u0011\u0003\u0002\u0016/\u0016\fg/Z+oSR$Vm\u001d;BI\u0012LG/[8o\u0011\u001d\t9\b\u0004a\u0001\u0003\u001b\t!\u0003^3tiR{w\u000e\\5oON+'O^5dK\"9\u00111\u0002\u0007A\u0002\u00055\u0001bBA\u0010\u0019\u0001\u0007\u0011\u0011\u0005\u0005\b\u0003Sa\u0001\u0019AA\u0011\u00039Ign]3siR+\u0007\u0010^#eSR$\"\"a!\u0002\b\u0006%\u0015QRAI!\r\t)IC\u0007\u0002\u0001!1\u0011qA\u0007A\u0002aCa!a#\u000e\u0001\u0004A\u0016\u0001\u0002;fgRDq!a$\u000e\u0001\u0004\t\t#\u0001\u0003mS:,\u0007\"CAJ\u001bA\u0005\t\u0019AA\u0011\u0003\u0019\u0019w\u000e\\;n]\u0006A\u0012N\\:feR$V\r\u001f;FI&$H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005e%\u0006BA\u0011\u00037[#!!(\u0011\t\u0005}\u0015\u0011V\u0007\u0003\u0003CSA!a)\u0002&\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003Os\u0016AC1o]>$\u0018\r^5p]&!\u00111VAQ\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000bCB\u0004H._#eSR\u001cHcA<\u00022\"9\u00111W\bA\u0002\u0005U\u0016!B3eSR\u001c\b#\u00025\u00028\u0006m\u0012bAA]=\nQAH]3qK\u0006$X\r\u001a \u0002\u0017%\u001c(\t\\1oW\u001aKG.\u001a\u000b\u0005\u0003\u007f\u000b)\rE\u0002i\u0003\u0003L1!a1_\u0005\u001d\u0011un\u001c7fC:DQa\u001f\tA\u0002q\fq\"\u001e8bE2,Gk\u001c*v]R+7\u000f\u001e\u000b\u0004o\u0006-\u0007\"B>\u0012\u0001\u0004a\u0018\u0001\u00028b[\u0016\f1\u0002Z3tGJL\u0007\u000f^5p]R\u0019\u0001,a5\t\u000b1\u001c\u0002\u0019A7\u0002\u001d\r\u0013X-\u0019;f+:LG\u000fV3tiB\u0011\u0011+F\n\u0003+\u001d$\"!a6\u0002\u001b\r\u0014X-\u0019;f\u0007>lW.\u00198e)!\t\t/a:\u0002l\u0006}\bc\u00018\u0002d&\u0019\u0011Q]8\u0003\u000f\r{W.\\1oI\"1\u0011\u0011^\fA\u0002a\u000b1!\u001e:j\u0011\u001d\tio\u0006a\u0001\u0003_\fq!Y:u\u001d>$W\r\u0005\u0003\u0002r\u0006mXBAAz\u0015\u0011\t)0a>\u0002\u0007\u0005\u001cHO\u0003\u0003\u0002z\u0006U\u0011A\u00029beN,'/\u0003\u0003\u0002~\u0006M(aB!ti:{G-\u001a\u0005\b\u0005\u00039\u0002\u0019\u0001B\u0002\u00039\u0019w.\\7b]\u0012l\u0015M\\1hKJ\u00042!\u0015B\u0003\u0013\r\u00119!\u0007\u0002\u000f\u0007>lW.\u00198e\u001b\u0006t\u0017mZ3s\u0001")
public class CreateUnitTest
implements WeaveCommand {
    private final DataWeaveToolingService validationService;
    private final WeaveLanguageClient weaveLanguageClient;
    private final ProjectKind projectKind;
    private final Project project;

    public static Command createCommand(String string, AstNode astNode, CommandManager commandManager) {
        return CreateUnitTest$.MODULE$.createCommand(string, astNode, commandManager);
    }

    @Override
    public String commandId() {
        return Commands$.MODULE$.DW_CREATE_UNIT_TEST();
    }

    @Override
    public Object execute(ExecuteCommandParams params) {
        java.util.List args = params.getArguments();
        String uri = Commands$.MODULE$.argAsString(args, 0);
        int startOffset = Commands$.MODULE$.argAsInt(args, 1);
        int endOffset = Commands$.MODULE$.argAsInt(args, 2);
        WeaveDocumentToolingService documentToolingService = this.validationService.openDocument(uri, this.validationService.openDocument$default$2());
        String testPath = documentToolingService.getTestPathFromDefinition();
        File[] files2 = ProjectStructure$.MODULE$.testsSourceFolders(this.projectKind.structure());
        File weaveTestFolder = (File)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])files2)).find((Function1<Object, Object>)(Function1<File, Object> & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean(CreateUnitTest.$anonfun$execute$1(f))).getOrElse((Function0<File> & Serializable & scala.Serializable)() -> $this.projectKind.projectFolderFactory().createTestSourceFolder($this.project));
        File testFile = new File(weaveTestFolder, testPath);
        String testFileURL = URLUtils$.MODULE$.toLSPUrl(testFile);
        this.doCreateTest(testFile, testFileURL, documentToolingService, startOffset, endOffset);
        return null;
    }

    private void doCreateTest(File testFile, String testFileURL, WeaveDocumentToolingService documentToolingService, int startOffset, int endOffset) {
        if (this.isBlankFile(testFile)) {
            this.addTestToBlankFile(testFile, testFileURL, documentToolingService, startOffset, endOffset);
            return;
        }
        this.addTestToExistingTestCode(testFile, testFileURL, documentToolingService, startOffset, endOffset);
    }

    private void addTestToBlankFile(File testFile, String testFileURL, WeaveDocumentToolingService documentToolingService, int startOffset, int endOffset) {
        Option<String> maybeTest = documentToolingService.createUnitTestFromDefinition(startOffset, endOffset);
        maybeTest.foreach((Function1<String, Object> & Serializable & scala.Serializable)test -> {
            CreateUnitTest.$anonfun$addTestToBlankFile$1(this, testFileURL, testFile, test);
            return BoxedUnit.UNIT;
        });
    }

    private void addTestToExistingTestCode(File testFile, String testFileURL, WeaveDocumentToolingService documentToolingService, int startOffset, int endOffset) {
        Object object;
        WeaveDocumentToolingService testToolingService = this.validationService.openDocument(testFileURL, this.validationService.openDocument$default$2());
        Option<WeaveUnitTestAddition> maybeAddition = this.getTestAddition(testToolingService, documentToolingService, startOffset, endOffset);
        if (maybeAddition.isEmpty()) {
            this.unableToRunTest(testFile);
            return;
        }
        WeaveUnitTestAddition testAddition = maybeAddition.get();
        String testStr = testAddition.test();
        int line = testAddition.replacementLine() - 1;
        ArrayBuffer edits = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(Nil$.MODULE$);
        if (testAddition.needsCommaBefore()) {
            Position commaPosition = testAddition.commaPosition();
            object = edits.$plus$eq(this.insertTextEdit(testFileURL, ",", commaPosition.line() - 1, commaPosition.column() - 1));
        } else {
            object = BoxedUnit.UNIT;
        }
        edits.$plus$eq(this.insertTextEdit(testFileURL, testStr, line, this.insertTextEdit$default$4()));
        this.applyEdits(edits);
        this.weaveLanguageClient.openTextDocument(new OpenTextDocumentParams(testFileURL, new Range(new org.eclipse.lsp4j.Position(line, 0), new org.eclipse.lsp4j.Position(line + new StringOps(Predef$.MODULE$.augmentString(testStr)).count((Function1<Object, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(CreateUnitTest.$anonfun$addTestToExistingTestCode$1(BoxesRunTime.unboxToChar(x$1)))), 0))));
    }

    private Option<WeaveUnitTestAddition> getTestAddition(WeaveDocumentToolingService testToolingService, WeaveDocumentToolingService documentToolingService, int startOffset, int endOffset) {
        Option<AstNode> maybeAst = testToolingService.ast();
        return maybeAst.flatMap((Function1<AstNode, Option> & Serializable & scala.Serializable)ast -> documentToolingService.addUnitTestFromDefinition(startOffset, endOffset, (AstNode)ast));
    }

    private Either<TextDocumentEdit, ResourceOperation> insertTextEdit(String testFileURL, String test, int line, int column) {
        org.eclipse.lsp4j.Position position = new org.eclipse.lsp4j.Position(line, column);
        TextEdit textEdit = new TextEdit(new Range(position, position), test);
        TextDocumentEdit textDocumentEdit = new TextDocumentEdit(new VersionedTextDocumentIdentifier(testFileURL, Predef$.MODULE$.int2Integer(0)), Arrays.asList((Object[])new TextEdit[]{textEdit}));
        return Either.forLeft((Object)textDocumentEdit);
    }

    private int insertTextEdit$default$4() {
        return 0;
    }

    private void applyEdits(Seq<Either<TextDocumentEdit, ResourceOperation>> edits) {
        java.util.List<Object> editList = Arrays.asList((Object[])edits.toArray(ClassTag$.MODULE$.apply(Either.class)));
        this.weaveLanguageClient.applyEdit(new ApplyWorkspaceEditParams(new WorkspaceEdit(editList))).get();
    }

    private boolean isBlankFile(File testFile) {
        boolean bl;
        if (!testFile.exists()) {
            return true;
        }
        try (BufferedSource source = Source$.MODULE$.fromFile(testFile, "UTF-8");){
            bl = source.mkString().trim().isEmpty();
        }
        return bl;
    }

    private void unableToRunTest(File testFile) {
        this.weaveLanguageClient.showMessage(new MessageParams(MessageType.Error, UserMessages$.MODULE$.invalidTestFileSyntax(testFile)));
    }

    @Override
    public String name() {
        return "Creates Unit.";
    }

    @Override
    public String description(ExecuteCommandParams params) {
        return "Creating Unit Test.";
    }

    public static final /* synthetic */ boolean $anonfun$execute$1(File f) {
        String string = f.getName();
        String string2 = WeaveDirectoryUtils$.MODULE$.DWTest_FOLDER();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$addTestToBlankFile$1(CreateUnitTest $this, String testFileURL$1, File testFile$1, String test) {
        Either<TextDocumentEdit, ResourceOperation> insertText = $this.insertTextEdit(testFileURL$1, test, 0, $this.insertTextEdit$default$4());
        Either createFile = Either.forRight((Object)new CreateFile(testFileURL$1));
        Seq edits = !testFile$1.exists() ? (Seq)new $colon$colon<Nothing$>((Nothing$)createFile, (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)insertText, Nil$.MODULE$)) : (Seq)new $colon$colon<Nothing$>((Nothing$)insertText, Nil$.MODULE$);
        $this.applyEdits(edits);
        $this.weaveLanguageClient.openTextDocument(new OpenTextDocumentParams(testFileURL$1, OpenTextDocumentParams$.MODULE$.apply$default$2()));
    }

    public static final /* synthetic */ boolean $anonfun$addTestToExistingTestCode$1(char x$1) {
        return x$1 == '\n';
    }

    public CreateUnitTest(DataWeaveToolingService validationService, WeaveLanguageClient weaveLanguageClient, ProjectKind projectKind, Project project) {
        this.validationService = validationService;
        this.weaveLanguageClient = weaveLanguageClient;
        this.projectKind = projectKind;
        this.project = project;
    }
}

