/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.services;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeRequestParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.ParameterInformation;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureHelpParams;
import org.eclipse.lsp4j.SignatureInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.mule.weave.lsp.actions.CodeActionProvider;
import org.mule.weave.lsp.actions.CodeActions;
import org.mule.weave.lsp.actions.CoreWeaveCodeActions$;
import org.mule.weave.lsp.commands.CommandManager;
import org.mule.weave.lsp.commands.Commands$;
import org.mule.weave.lsp.commands.CreateUnitTest$;
import org.mule.weave.lsp.commands.InsertDocumentationCommand$;
import org.mule.weave.lsp.commands.LSPWeaveTextDocument;
import org.mule.weave.lsp.extension.client.LaunchConfiguration$;
import org.mule.weave.lsp.extension.client.SampleInput;
import org.mule.weave.lsp.extension.services.DidFocusChangeParams;
import org.mule.weave.lsp.extension.services.WeaveTextDocumentService;
import org.mule.weave.lsp.i18n.UserMessages$;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.components.ContextMetadata;
import org.mule.weave.lsp.project.components.MetadataProvider;
import org.mule.weave.lsp.project.components.ProjectStructure$;
import org.mule.weave.lsp.project.components.Scenario;
import org.mule.weave.lsp.project.components.Scenario$;
import org.mule.weave.lsp.services.DataWeaveToolingService;
import org.mule.weave.lsp.services.ToolingService;
import org.mule.weave.lsp.services.WeaveScenarioManagerService;
import org.mule.weave.lsp.services.events.DocumentChangedEvent;
import org.mule.weave.lsp.services.events.DocumentClosedEvent;
import org.mule.weave.lsp.services.events.DocumentFocusChangedEvent;
import org.mule.weave.lsp.services.events.DocumentOpenedEvent;
import org.mule.weave.lsp.services.events.DocumentSavedEvent;
import org.mule.weave.lsp.utils.EventBus;
import org.mule.weave.lsp.utils.LSPConverters$;
import org.mule.weave.lsp.utils.URLUtils$;
import org.mule.weave.lsp.utils.WeaveASTQueryUtils$;
import org.mule.weave.lsp.vfs.ProjectVirtualFileSystem;
import org.mule.weave.v2.completion.Suggestion;
import org.mule.weave.v2.completion.SuggestionResult;
import org.mule.weave.v2.completion.SuggestionType$;
import org.mule.weave.v2.editor.FoldingRegion;
import org.mule.weave.v2.editor.Link;
import org.mule.weave.v2.editor.RegionKind$;
import org.mule.weave.v2.editor.SymbolInformation;
import org.mule.weave.v2.editor.SymbolKind$;
import org.mule.weave.v2.editor.VirtualFile;
import org.mule.weave.v2.editor.VirtualFileSystem;
import org.mule.weave.v2.editor.WeaveDocumentToolingService;
import org.mule.weave.v2.formatting.FormattingOptions;
import org.mule.weave.v2.hover.HoverMessage;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.AstNodeHelper$;
import org.mule.weave.v2.parser.ast.functions.OverloadedFunctionNode;
import org.mule.weave.v2.parser.ast.header.directives.ContentType;
import org.mule.weave.v2.parser.ast.header.directives.DataFormatId;
import org.mule.weave.v2.parser.ast.header.directives.FunctionDirectiveNode;
import org.mule.weave.v2.parser.ast.header.directives.InputDirective;
import org.mule.weave.v2.parser.ast.module.ModuleNode;
import org.mule.weave.v2.parser.ast.structure.DocumentNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier$;
import org.mule.weave.v2.scope.Reference;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import org.mule.weave.v2.signature.FunctionParameterData;
import org.mule.weave.v2.signature.FunctionSignatureData;
import org.mule.weave.v2.signature.FunctionSignatureResult;
import org.mule.weave.v2.ts.WeaveType;
import org.mule.weave.v2.utils.WeaveTypeEmitterConfig;
import org.mule.weave.v2.utils.WeaveTypeEmitterConfig$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$DummyImplicit$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0011Mc\u0001B\u001a5\u0001}B\u0001b\u0015\u0001\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\t/\u0002\u0011\t\u0011)A\u00051\"A\u0001\r\u0001B\u0001B\u0003%\u0011\r\u0003\u0005h\u0001\t\u0005\t\u0015!\u0003i\u0011!!\u0007A!A!\u0002\u0013Y\u0007\u0002C:\u0001\u0005\u0003\u0005\u000b\u0011\u0002;\t\u000bi\u0004A\u0011A>\t\u0013\u0005\u001d\u0001A1A\u0005\n\u0005%\u0001\u0002CA\f\u0001\u0001\u0006I!a\u0003\t\u0017\u0005e\u0001\u00011AA\u0002\u0013%\u00111\u0004\u0005\f\u0003S\u0001\u0001\u0019!a\u0001\n\u0013\tY\u0003C\u0006\u0002>\u0001\u0001\r\u0011!Q!\n\u0005u\u0001bCA \u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0003B1\"a\u0014\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002R!Y\u0011Q\u000b\u0001A\u0002\u0003\u0005\u000b\u0015BA\"\u0011-\t9\u0006\u0001a\u0001\u0002\u0004%I!!\u0017\t\u0017\u0005\u001d\u0004\u00011AA\u0002\u0013%\u0011\u0011\u000e\u0005\f\u0003[\u0002\u0001\u0019!A!B\u0013\tY\u0006C\u0004\u0002p\u0001!\t%!\u001d\t\u000f\u0005]\u0004\u0001\"\u0011\u0002z!9\u0011q\u0012\u0001\u0005B\u0005E\u0005bBAO\u0001\u0011\u0005\u0013q\u0014\u0005\b\u0003S\u0003A\u0011IAV\u0011\u001d\t)\f\u0001C!\u0003oCq!!1\u0001\t\u0003\n\u0019\rC\u0004\u0002z\u0002!\t\"a?\t\u000f\t%\u0001\u0001\"\u0011\u0003\f!9!Q\u0004\u0001\u0005\n\t}\u0001b\u0002B,\u0001\u0011\u0005!\u0011\f\u0005\b\u0005\u0003\u0003A\u0011\tBB\u0011\u001d\u0011\u0019\u000b\u0001C\u0001\u0005KCqA!9\u0001\t\u0013\u0011\u0019\u000fC\u0004\u0003l\u0002!IA!<\t\u000f\tE\b\u0001\"\u0003\u0003t\"9!Q \u0001\u0005\n\t}\bbBB\u0003\u0001\u0011%1q\u0001\u0005\b\u0007\u001b\u0001A\u0011IB\b\u0011\u001d\u00199\u0002\u0001C!\u00073Aqa!\f\u0001\t\u0003\u001ay\u0003C\u0004\u0004L\u0001!\te!\u0014\t\u000f\rM\u0003\u0001\"\u0011\u0004V!91q\r\u0001\u0005\u0002\r%\u0004bBB>\u0001\u0011\u00053Q\u0010\u0005\b\u00073\u0003A\u0011IBN\u0011\u001d\u0019i\r\u0001C\u0005\u0007\u001fDqaa6\u0001\t\u0003\u001aI\u000eC\u0004\u0004x\u0002!\te!?\t\u000f\u0011=\u0001\u0001\"\u0011\u0005\u0012!9A1\u0005\u0001\u0005B\u0011\u0015\u0002b\u0002C\u001e\u0001\u0011%AQ\b\u0002\u0019\t\u0006$\u0018mV3bm\u0016$unY;nK:$8+\u001a:wS\u000e,'BA\u001b7\u0003!\u0019XM\u001d<jG\u0016\u001c(BA\u001c9\u0003\ra7\u000f\u001d\u0006\u0003si\nQa^3bm\u0016T!a\u000f\u001f\u0002\t5,H.\u001a\u0006\u0002{\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0011%P!\t\te)D\u0001C\u0015\t\u0019E)\u0001\u0003mC:<'\"A#\u0002\t)\fg/Y\u0005\u0003\u000f\n\u0013aa\u00142kK\u000e$\bCA%N\u001b\u0005Q%BA\u001bL\u0015\tae'A\u0005fqR,gn]5p]&\u0011aJ\u0013\u0002\u0019/\u0016\fg/\u001a+fqR$unY;nK:$8+\u001a:wS\u000e,\u0007C\u0001)R\u001b\u0005!\u0014B\u0001*5\u00059!vn\u001c7j]\u001e\u001cVM\u001d<jG\u0016\fq\u0002^8pY&twmU3sm&\u001cWm\u001d\t\u0003!VK!A\u0016\u001b\u0003/\u0011\u000bG/Y,fCZ,Gk\\8mS:<7+\u001a:wS\u000e,\u0017\u0001C3yK\u000e,Ho\u001c:\u0011\u0005esV\"\u0001.\u000b\u0005mc\u0016AC2p]\u000e,(O]3oi*\u0011Q\fR\u0001\u0005kRLG.\u0003\u0002`5\nAQ\t_3dkR|'/A\u0005qe>TWm\u0019;G'B\u0011!-Z\u0007\u0002G*\u0011AMN\u0001\u0004m\u001a\u001c\u0018B\u00014d\u0005a\u0001&o\u001c6fGR4\u0016N\u001d;vC24\u0015\u000e\\3TsN$X-\\\u0001\u0011g\u000e,g.\u0019:j_N\u001cVM\u001d<jG\u0016\u0004\"\u0001U5\n\u0005)$$aG,fCZ,7kY3oCJLw.T1oC\u001e,'oU3sm&\u001cW\r\u0005\u0002mc6\tQN\u0003\u0002o_\u00061Q\rZ5u_JT!\u0001\u001d\u001d\u0002\u0005Y\u0014\u0014B\u0001:n\u0005E1\u0016N\u001d;vC24\u0015\u000e\\3TsN$X-\\\u0001\u000fG>lW.\u00198e\u001b\u0006t\u0017mZ3s!\t)\b0D\u0001w\u0015\t9h'\u0001\u0005d_6l\u0017M\u001c3t\u0013\tIhO\u0001\bD_6l\u0017M\u001c3NC:\fw-\u001a:\u0002\rqJg.\u001b;?))aXP`@\u0002\u0002\u0005\r\u0011Q\u0001\t\u0003!\u0002AQaU\u0004A\u0002QCQaV\u0004A\u0002aCQ\u0001Y\u0004A\u0002\u0005DQaZ\u0004A\u0002!DQ\u0001Z\u0004A\u0002-DQa]\u0004A\u0002Q\fa\u0001\\8hO\u0016\u0014XCAA\u0006!\u0011\ti!a\u0005\u000e\u0005\u0005=!bAA\t9\u00069An\\4hS:<\u0017\u0002BA\u000b\u0003\u001f\u0011a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\fG>$W-Q2uS>t7/\u0006\u0002\u0002\u001eA!\u0011qDA\u0013\u001b\t\t\tCC\u0002\u0002$Y\nq!Y2uS>t7/\u0003\u0003\u0002(\u0005\u0005\"aC\"pI\u0016\f5\r^5p]N\fqbY8eK\u0006\u001bG/[8og~#S-\u001d\u000b\u0005\u0003[\tI\u0004\u0005\u0003\u00020\u0005URBAA\u0019\u0015\t\t\u0019$A\u0003tG\u0006d\u0017-\u0003\u0003\u00028\u0005E\"\u0001B+oSRD\u0011\"a\u000f\f\u0003\u0003\u0005\r!!\b\u0002\u0007a$\u0013'\u0001\u0007d_\u0012,\u0017i\u0019;j_:\u001c\b%A\u0006qe>TWm\u0019;LS:$WCAA\"!\u0011\t)%a\u0013\u000e\u0005\u0005\u001d#bAA%m\u00059\u0001O]8kK\u000e$\u0018\u0002BA'\u0003\u000f\u00121\u0002\u0015:pU\u0016\u001cGoS5oI\u0006y\u0001O]8kK\u000e$8*\u001b8e?\u0012*\u0017\u000f\u0006\u0003\u0002.\u0005M\u0003\"CA\u001e\u001d\u0005\u0005\t\u0019AA\"\u00031\u0001(o\u001c6fGR\\\u0015N\u001c3!\u0003!)g/\u001a8u\u0005V\u001cXCAA.!\u0011\ti&a\u0019\u000e\u0005\u0005}#bAA1m\u0005)Q\u000f^5mg&!\u0011QMA0\u0005!)e/\u001a8u\u0005V\u001c\u0018\u0001D3wK:$()^:`I\u0015\fH\u0003BA\u0017\u0003WB\u0011\"a\u000f\u0012\u0003\u0003\u0005\r!a\u0017\u0002\u0013\u00154XM\u001c;CkN\u0004\u0013\u0001B5oSR$b!!\f\u0002t\u0005U\u0004bBA '\u0001\u0007\u00111\t\u0005\b\u0003/\u001a\u0002\u0019AA.\u0003\u001d!\u0017\u000eZ(qK:$B!!\f\u0002|!9\u0011Q\u0010\u000bA\u0002\u0005}\u0014!C8qK:\u0004\u0016M]1n!\u0011\t\t)a#\u000e\u0005\u0005\r%\u0002BAC\u0003\u000f\u000bQ\u0001\\:qi)T1!!#=\u0003\u001d)7\r\\5qg\u0016LA!!$\u0002\u0004\nIB)\u001b3Pa\u0016tG+\u001a=u\t>\u001cW/\\3oiB\u000b'/Y7t\u0003%!\u0017\u000eZ\"iC:<W\r\u0006\u0003\u0002.\u0005M\u0005bBAK+\u0001\u0007\u0011qS\u0001\u0007a\u0006\u0014\u0018-\\:\u0011\t\u0005\u0005\u0015\u0011T\u0005\u0005\u00037\u000b\u0019IA\u000eES\u0012\u001c\u0005.\u00198hKR+\u0007\u0010\u001e#pGVlWM\u001c;QCJ\fWn]\u0001\tI&$7\t\\8tKR!\u0011QFAQ\u0011\u001d\t)J\u0006a\u0001\u0003G\u0003B!!!\u0002&&!\u0011qUAB\u0005i!\u0015\u000eZ\"m_N,G+\u001a=u\t>\u001cW/\\3oiB\u000b'/Y7t\u0003\u001d!\u0017\u000eZ*bm\u0016$B!!\f\u0002.\"9\u0011QS\fA\u0002\u0005=\u0006\u0003BAA\u0003cKA!a-\u0002\u0004\nIB)\u001b3TCZ,G+\u001a=u\t>\u001cW/\\3oiB\u000b'/Y7t\u00039!\u0017\u000e\u001a$pGV\u001c8\t[1oO\u0016$B!!\f\u0002:\"9\u0011Q\u0013\rA\u0002\u0005m\u0006cA%\u0002>&\u0019\u0011q\u0018&\u0003)\u0011KGMR8dkN\u001c\u0005.\u00198hKB\u000b'/Y7t\u0003)\u0019w.\u001c9mKRLwN\u001c\u000b\u0005\u0003\u000b\fy\u000fE\u0003Z\u0003\u000f\fY-C\u0002\u0002Jj\u0013\u0011cQ8na2,G/\u00192mK\u001a+H/\u001e:f!!\ti-a6\u0002\\\u0006%XBAAh\u0015\u0011\t\t.a5\u0002\u00115,7o]1hKNTA!!6\u0002\u0004\u00069!n]8oeB\u001c\u0017\u0002BAm\u0003\u001f\u0014a!R5uQ\u0016\u0014\bCBAo\u0003?\f\u0019/D\u0001]\u0013\r\t\t\u000f\u0018\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002\u0002\u0006\u0015\u0018\u0002BAt\u0003\u0007\u0013abQ8na2,G/[8o\u0013R,W\u000e\u0005\u0003\u0002\u0002\u0006-\u0018\u0002BAw\u0003\u0007\u0013abQ8na2,G/[8o\u0019&\u001cH\u000fC\u0004\u0002rf\u0001\r!a=\u0002\u0011A|7/\u001b;j_:\u0004B!!!\u0002v&!\u0011q_AB\u0005A\u0019u.\u001c9mKRLwN\u001c)be\u0006l7/A\u0013hKR\u001cVoZ4fgRLwN\\:B]\u0012\u001c%/Z1uK\u000e{W\u000e\u001d7fi&|g\u000eT5tiR1\u00111ZA\u007f\u0005\u000fAq!a@\u001b\u0001\u0004\u0011\t!\u0001\bu_>d\u0017N\\4TKJ4\u0018nY3\u0011\u00071\u0014\u0019!C\u0002\u0003\u00065\u00141dV3bm\u0016$unY;nK:$Hk\\8mS:<7+\u001a:wS\u000e,\u0007bBAy5\u0001\u0007\u00111_\u0001\u000eg&<g.\u0019;ve\u0016DU\r\u001c9\u0015\t\t5!Q\u0003\t\u00063\u0006\u001d'q\u0002\t\u0005\u0003\u0003\u0013\t\"\u0003\u0003\u0003\u0014\u0005\r%!D*jO:\fG/\u001e:f\u0011\u0016d\u0007\u000fC\u0004\u0002\u0016n\u0001\rAa\u0006\u0011\t\u0005\u0005%\u0011D\u0005\u0005\u00057\t\u0019IA\nTS\u001et\u0017\r^;sK\"+G\u000e\u001d)be\u0006l7/\u0001\nhKRLe\u000e];u\t&\u0014Xm\u0019;jm\u0016\u001cH\u0003\u0002B\u0011\u0005\u000b\u0002bAa\t\u0003*\t5RB\u0001B\u0013\u0015\u0011\u00119#!\r\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003,\t\u0015\"aA*fcB!!q\u0006B!\u001b\t\u0011\tD\u0003\u0003\u00034\tU\u0012A\u00033je\u0016\u001cG/\u001b<fg*!!q\u0007B\u001d\u0003\u0019AW-\u00193fe*!!1\bB\u001f\u0003\r\t7\u000f\u001e\u0006\u0004\u0005\u007fy\u0017A\u00029beN,'/\u0003\u0003\u0003D\tE\"AD%oaV$H)\u001b:fGRLg/\u001a\u0005\b\u0005\u000fb\u0002\u0019\u0001B%\u00031i\u0017-\u001f2f\u0003N$hj\u001c3f!\u0019\tyCa\u0013\u0003P%!!QJA\u0019\u0005\u0019y\u0005\u000f^5p]B!!\u0011\u000bB*\u001b\t\u0011I$\u0003\u0003\u0003V\te\"aB!ti:{G-Z\u0001\u0017GJ,\u0017\r^3NCB\u0004\u0018N\\4UKN$H*\u001a8tKR!!1\fB4!\u0019\tiN!\u0018\u0003b%\u0019!q\f/\u0003\u0013\u0005\u0013(/Y=MSN$\b\u0003BAA\u0005GJAA!\u001a\u0002\u0004\nA1i\u001c3f\u0019\u0016t7\u000fC\u0004\u0003ju\u0001\rAa\u001b\u0002\u0007U\u0014H\u000e\u0005\u0003\u0003n\tmd\u0002\u0002B8\u0005o\u0002BA!\u001d\u000225\u0011!1\u000f\u0006\u0004\u0005kr\u0014A\u0002\u001fs_>$h(\u0003\u0003\u0003z\u0005E\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0003~\t}$AB*ue&twM\u0003\u0003\u0003z\u0005E\u0012\u0001C2pI\u0016dUM\\:\u0015\t\t\u0015%1\u0014\t\u00063\u0006\u001d'q\u0011\u0019\u0005\u0005\u0013\u0013y\t\u0005\u0004\u0002^\u0006}'1\u0012\t\u0005\u0005\u001b\u0013y\t\u0004\u0001\u0005\u0017\tEe$!A\u0001\u0002\u000b\u0005!1\u0013\u0002\u0004?\u0012\n\u0014\u0003\u0002BK\u0005C\u0002B!a\f\u0003\u0018&!!\u0011TA\u0019\u0005\u001dqu\u000e\u001e5j]\u001eDq!!&\u001f\u0001\u0004\u0011i\n\u0005\u0003\u0002\u0002\n}\u0015\u0002\u0002BQ\u0003\u0007\u0013abQ8eK2+gn\u001d)be\u0006l7/\u0001\ttC6\u0004H.\u001a#bi\u0006dUM\\:fgRQ!1\fBT\u0005s\u0013IM!8\t\u000f\t%v\u00041\u0001\u0003,\u0006iQ.Y=cKN\u001bWM\\1sS>\u0004b!a\f\u0003L\t5\u0006\u0003\u0002BX\u0005kk!A!-\u000b\t\tM\u0016qI\u0001\u000bG>l\u0007o\u001c8f]R\u001c\u0018\u0002\u0002B\\\u0005c\u0013\u0001bU2f]\u0006\u0014\u0018n\u001c\u0005\b\u0005w{\u0002\u0019\u0001B_\u00039q\u0017-\\3JI\u0016tG/\u001b4jKJ\u0004BAa0\u0003F6\u0011!\u0011\u0019\u0006\u0005\u0005\u0007\u0014I$A\u0005wCJL\u0017M\u00197fg&!!q\u0019Ba\u00059q\u0015-\\3JI\u0016tG/\u001b4jKJDqAa3 \u0001\u0004\u0011i-A\bj]B,H\u000fR5sK\u000e$\u0018N^3t!\u0019\u0011yM!7\u0003.9!!\u0011\u001bBk\u001d\u0011\u0011\tHa5\n\u0005\u0005M\u0012\u0002\u0002Bl\u0003c\tq\u0001]1dW\u0006<W-\u0003\u0003\u0003,\tm'\u0002\u0002Bl\u0003cAqAa8 \u0001\u0004\u0011Y'A\u0002ve&\fQ\u0002Z8d'R\f'\u000f\u001e*b]\u001e,GC\u0001Bs!\u0011\t\tIa:\n\t\t%\u00181\u0011\u0002\u0006%\u0006tw-Z\u0001\u000feVtW*\u00199qS:<G*\u001a8t)\u0011\u0011\tGa<\t\u000f\tm\u0016\u00051\u0001\u0003>\u0006i\u0011N\u001c9vi\u001aKG.\u001a(b[\u0016$BA!>\u0003zB\u0019\u0011Ia>\n\u0007\tu$\tC\u0004\u0003|\n\u0002\rA!\f\u0002\u0005%$\u0017AF1eI\u0012{7-^7f]R\fG/[8o\u0019\u0016t7/Z:\u0015\r\tm3\u0011AB\u0002\u0011\u001d\u0011Yd\ta\u0001\u0005\u001fBqAa8$\u0001\u0004\u0011Y'A\tbI\u0012,f.\u001b;UKN$H*\u001a8tKN$bAa\u0017\u0004\n\r-\u0001b\u0002B\u001eI\u0001\u0007!q\n\u0005\b\u0005?$\u0003\u0019\u0001B6\u0003=\u0011Xm]8mm\u0016\u001cu\u000eZ3MK:\u001cH\u0003BB\t\u0007'\u0001R!WAd\u0005CBqa!\u0006&\u0001\u0004\u0011\t'\u0001\u0006v]J,7o\u001c7wK\u0012\fABZ8mI&twMU1oO\u0016$Baa\u0007\u0004&A)\u0011,a2\u0004\u001eA1\u0011Q\\Ap\u0007?\u0001B!!!\u0004\"%!11EAB\u000511u\u000e\u001c3j]\u001e\u0014\u0016M\\4f\u0011\u001d\t)J\na\u0001\u0007O\u0001B!!!\u0004*%!11FAB\u0005e1u\u000e\u001c3j]\u001e\u0014\u0016M\\4f%\u0016\fX/Z:u!\u0006\u0014\u0018-\\:\u0002\u0015\r|G-Z!di&|g\u000e\u0006\u0003\u00042\r\r\u0003#B-\u0002H\u000eM\u0002CBAo\u0003?\u001c)\u0004\u0005\u0005\u0002N\u0006]7qGB\u001f!\u0011\t\ti!\u000f\n\t\rm\u00121\u0011\u0002\b\u0007>lW.\u00198e!\u0011\t\tia\u0010\n\t\r\u0005\u00131\u0011\u0002\u000b\u0007>$W-Q2uS>t\u0007bBAKO\u0001\u00071Q\t\t\u0005\u0003\u0003\u001b9%\u0003\u0003\u0004J\u0005\r%\u0001E\"pI\u0016\f5\r^5p]B\u000b'/Y7t\u0003U\u0011Xm]8mm\u0016\u001cu.\u001c9mKRLwN\\%uK6$Baa\u0014\u0004RA)\u0011,a2\u0002d\"91Q\u0003\u0015A\u0002\u0005\r\u0018!\u00025pm\u0016\u0014H\u0003BB,\u0007?\u0002R!WAd\u00073\u0002B!!!\u0004\\%!1QLAB\u0005\u0015AuN^3s\u0011\u001d\t)*\u000ba\u0001\u0007C\u0002B!!!\u0004d%!1QMAB\u0005-AuN^3s!\u0006\u0014\u0018-\\:\u0002\u0019Q|7+_7c_2\\\u0015N\u001c3\u0015\t\r-4\u0011\u000f\t\u0005\u0003\u0003\u001bi'\u0003\u0003\u0004p\u0005\r%AC*z[\n|GnS5oI\"911\u000f\u0016A\u0002\rU\u0014\u0001B6j]\u0012\u0004B!a\f\u0004x%!1\u0011PA\u0019\u0005\rIe\u000e^\u0001\u000fI>\u001cW/\\3oiNKXNY8m)\u0011\u0019yh!%\u0011\u000be\u000b9m!!\u0011\r\u0005u\u0017q\\BB!!\ti-a6\u0004\u0006\u000e-\u0005\u0003BAA\u0007\u000fKAa!#\u0002\u0004\n\t2+_7c_2LeNZ8s[\u0006$\u0018n\u001c8\u0011\t\u0005\u00055QR\u0005\u0005\u0007\u001f\u000b\u0019I\u0001\bE_\u000e,X.\u001a8u'fl'm\u001c7\t\u000f\u0005U5\u00061\u0001\u0004\u0014B!\u0011\u0011QBK\u0013\u0011\u00199*a!\u0003)\u0011{7-^7f]R\u001c\u00160\u001c2pYB\u000b'/Y7t\u0003)!WMZ5oSRLwN\u001c\u000b\u0005\u0007;\u001b)\rE\u0003Z\u0003\u000f\u001cy\n\u0005\u0005\u0002N\u0006]7\u0011UBZa\u0011\u0019\u0019ka*\u0011\r\u0005u\u0017q\\BS!\u0011\u0011iia*\u0005\u0017\r%F&!A\u0001\u0002\u000b\u000511\u0016\u0002\u0004?\u0012\u0012\u0014\u0003\u0002BK\u0007[\u0003B!!!\u00040&!1\u0011WAB\u0005!aunY1uS>t\u0007\u0007BB[\u0007s\u0003b!!8\u0002`\u000e]\u0006\u0003\u0002BG\u0007s#1ba/-\u0003\u0003\u0005\tQ!\u0001\u0004>\n\u0019q\fJ\u001a\u0012\t\tU5q\u0018\t\u0005\u0003\u0003\u001b\t-\u0003\u0003\u0004D\u0006\r%\u0001\u0004'pG\u0006$\u0018n\u001c8MS:\\\u0007bBAKY\u0001\u00071q\u0019\t\u0005\u0003\u0003\u001bI-\u0003\u0003\u0004L\u0006\r%\u0001\u0005#fM&t\u0017\u000e^5p]B\u000b'/Y7t\u0003)\u0011Xm]8mm\u0016,&\u000f\u001c\u000b\u0005\u0007#\u001c\u0019\u000e\u0005\u0004\u00020\t-#1\u000e\u0005\b\u0007+l\u0003\u0019\u0001B_\u0003)iw\u000eZ;mK:\u000bW.Z\u0001\u000bM>\u0014X.\u0019;uS:<G\u0003BBn\u0007_\u0004R!WAd\u0007;\u0004Daa8\u0004dB1\u0011Q\\Ap\u0007C\u0004BA!$\u0004d\u0012Y1Q\u001d\u0018\u0002\u0002\u0003\u0005)\u0011ABt\u0005\ryF\u0005N\t\u0005\u0005+\u001bI\u000f\u0005\u0003\u0002\u0002\u000e-\u0018\u0002BBw\u0003\u0007\u0013\u0001\u0002V3yi\u0016#\u0017\u000e\u001e\u0005\b\u0003+s\u0003\u0019ABy!\u0011\t\tia=\n\t\rU\u00181\u0011\u0002\u0019\t>\u001cW/\\3oi\u001a{'/\\1ui&tw\rU1sC6\u001c\u0018a\u0004:b]\u001e,gi\u001c:nCR$\u0018N\\4\u0015\t\rmHq\u0001\t\u00063\u0006\u001d7Q \u0019\u0005\u0007\u007f$\u0019\u0001\u0005\u0004\u0002^\u0006}G\u0011\u0001\t\u0005\u0005\u001b#\u0019\u0001B\u0006\u0005\u0006=\n\t\u0011!A\u0003\u0002\r\u001d(aA0%k!9\u0011QS\u0018A\u0002\u0011%\u0001\u0003BAA\t\u0017IA\u0001\"\u0004\u0002\u0004\niBi\\2v[\u0016tGOU1oO\u00164uN]7biRLgn\u001a)be\u0006l7/\u0001\u0004sK:\fW.\u001a\u000b\u0005\t'!Y\u0002E\u0003Z\u0003\u000f$)\u0002\u0005\u0003\u0002\u0002\u0012]\u0011\u0002\u0002C\r\u0003\u0007\u0013QbV8sWN\u0004\u0018mY3FI&$\bbBAKa\u0001\u0007AQ\u0004\t\u0005\u0003\u0003#y\"\u0003\u0003\u0005\"\u0005\r%\u0001\u0004*f]\u0006lW\rU1sC6\u001c\u0018A\u0003:fM\u0016\u0014XM\\2fgR!Aq\u0005C\u001a!\u0015I\u0016q\u0019C\u0015a\u0011!Y\u0003b\f\u0011\r\u0005u\u0017q\u001cC\u0017!\u0011\u0011i\tb\f\u0005\u0017\u0011E\u0012'!A\u0001\u0002\u000b\u000511\u0016\u0002\u0004?\u00122\u0004bBAKc\u0001\u0007AQ\u0007\t\u0005\u0003\u0003#9$\u0003\u0003\u0005:\u0005\r%a\u0004*fM\u0016\u0014XM\\2f!\u0006\u0014\u0018-\\:\u0002#\u001d,GoQ8na2,G/[8o)f\u0004X\r\u0006\u0003\u0005@\u0011\u0015\u0003\u0003BAA\t\u0003JA\u0001b\u0011\u0002\u0004\n\u00112i\\7qY\u0016$\u0018n\u001c8Ji\u0016l7*\u001b8e\u0011\u001d!9E\ra\u0001\t\u0013\n1a];h!\u0011!Y\u0005b\u0014\u000e\u0005\u00115#bAAa_&!A\u0011\u000bC'\u0005)\u0019VoZ4fgRLwN\u001c")
public class DataWeaveDocumentService
implements WeaveTextDocumentService,
ToolingService {
    private final DataWeaveToolingService toolingServices;
    private final Executor executor;
    private final ProjectVirtualFileSystem projectFS;
    private final WeaveScenarioManagerService scenariosService;
    private final VirtualFileSystem vfs;
    private final CommandManager commandManager;
    private final Logger logger;
    private CodeActions codeActions;
    private ProjectKind projectKind;
    private EventBus eventBus;

    private Logger logger() {
        return this.logger;
    }

    private CodeActions codeActions() {
        return this.codeActions;
    }

    private void codeActions_$eq(CodeActions x$1) {
        this.codeActions = x$1;
    }

    private ProjectKind projectKind() {
        return this.projectKind;
    }

    private void projectKind_$eq(ProjectKind x$1) {
        this.projectKind = x$1;
    }

    private EventBus eventBus() {
        return this.eventBus;
    }

    private void eventBus_$eq(EventBus x$1) {
        this.eventBus = x$1;
    }

    @Override
    public void init(ProjectKind projectKind, EventBus eventBus) {
        this.projectKind_$eq(projectKind);
        this.eventBus_$eq(eventBus);
        this.codeActions_$eq(new CodeActions(CoreWeaveCodeActions$.MODULE$.codeActions(this.toolingServices, this.commandManager), projectKind));
    }

    public void didOpen(DidOpenTextDocumentParams openParam) {
        Option<VirtualFile> maybeVirtualFile;
        TextDocumentItem textDocument = openParam.getTextDocument();
        String uri = textDocument.getUri();
        this.logger().log(Level.INFO, new StringBuilder(9).append("DidOpen: ").append(uri).toString());
        Option<VirtualFile> option = maybeVirtualFile = this.projectFS.update(uri, openParam.getTextDocument().getText());
        if (option instanceof Some) {
            Some some = (Some)option;
            VirtualFile value = (VirtualFile)some.value();
            this.eventBus().fire(new DocumentOpenedEvent(value));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            VirtualFile virtualFile = this.vfs.file(uri);
            if (virtualFile != null) {
                this.eventBus().fire(new DocumentOpenedEvent(virtualFile));
                return;
            }
            return;
        }
        throw new MatchError(option);
    }

    public void didChange(DidChangeTextDocumentParams params) {
        Option<VirtualFile> maybeVirtualFile;
        VersionedTextDocumentIdentifier textDocument = params.getTextDocument();
        String uri = textDocument.getUri();
        this.logger().log(Level.INFO, new StringBuilder(12).append(System.nanoTime()).append(" DidChange: ").append(uri).toString());
        Option<VirtualFile> option = maybeVirtualFile = this.projectFS.update(uri, ((TextDocumentContentChangeEvent)params.getContentChanges().get(0)).getText());
        if (option instanceof Some) {
            Some some = (Some)option;
            VirtualFile value = (VirtualFile)some.value();
            this.eventBus().fire(new DocumentChangedEvent(value));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    public void didClose(DidCloseTextDocumentParams params) {
        Option<VirtualFile> maybeVirtualFile;
        String uri = params.getTextDocument().getUri();
        this.logger().log(Level.INFO, new StringBuilder(10).append("DidClose: ").append(uri).toString());
        this.toolingServices.closeDocument(uri);
        Option<VirtualFile> option = maybeVirtualFile = this.projectFS.closed(uri);
        if (option instanceof Some) {
            Some some = (Some)option;
            VirtualFile value = (VirtualFile)some.value();
            this.eventBus().fire(new DocumentClosedEvent(value));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            VirtualFile virtualFile = this.vfs.file(uri);
            if (virtualFile != null) {
                this.eventBus().fire(new DocumentClosedEvent(virtualFile));
                return;
            }
            return;
        }
        throw new MatchError(option);
    }

    public void didSave(DidSaveTextDocumentParams params) {
        Option<VirtualFile> maybeVirtualFile;
        String uri = params.getTextDocument().getUri();
        this.logger().log(Level.INFO, new StringBuilder(9).append("DidSave: ").append(uri).toString());
        Option<VirtualFile> option = maybeVirtualFile = this.projectFS.saved(params.getTextDocument().getUri());
        if (option instanceof Some) {
            Some some = (Some)option;
            VirtualFile value = (VirtualFile)some.value();
            this.eventBus().fire(new DocumentSavedEvent(value));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            VirtualFile virtualFile = this.vfs.file(uri);
            if (virtualFile != null) {
                this.eventBus().fire(new DocumentSavedEvent(virtualFile));
                return;
            }
            return;
        }
        throw new MatchError(option);
    }

    @Override
    public void didFocusChange(DidFocusChangeParams params) {
        Option<VirtualFile> maybeVirtualFile;
        String uri = params.textDocumentIdentifier().getUri();
        this.logger().log(Level.INFO, new StringBuilder(16).append("DidFocusChange: ").append(uri).toString());
        Option<VirtualFile> option = maybeVirtualFile = Option$.MODULE$.apply(this.projectFS.file(uri));
        if (option instanceof Some) {
            Some some = (Some)option;
            VirtualFile value = (VirtualFile)some.value();
            this.eventBus().fire(new DocumentFocusChangedEvent(value));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            VirtualFile virtualFile = this.vfs.file(uri);
            if (virtualFile != null) {
                this.eventBus().fire(new DocumentFocusChangedEvent(virtualFile));
                return;
            }
            return;
        }
        throw new MatchError(option);
    }

    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams position) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = $this.toolingServices.openDocument(position.getTextDocument().getUri(), true);
            return this.getSuggestionsAndCreateCompletionList(toolingService, position);
        }, this.executor);
    }

    public Either<List<CompletionItem>, CompletionList> getSuggestionsAndCreateCompletionList(WeaveDocumentToolingService toolingService, CompletionParams position) {
        int offset = toolingService.offsetOf(position.getPosition().getLine(), position.getPosition().getCharacter());
        SuggestionResult suggestionResult = toolingService.completion(offset);
        ArrayList result2 = new ArrayList();
        IntRef i = IntRef.create(0);
        Suggestion[] suggestions = suggestionResult.suggestions();
        new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])suggestions)).foreach((Function1<Suggestion, Object> & Serializable & scala.Serializable)sug -> {
            DataWeaveDocumentService.$anonfun$getSuggestionsAndCreateCompletionList$1(this, i, suggestionResult, toolingService, result2, sug);
            return BoxedUnit.UNIT;
        });
        return Either.forRight((Object)new CompletionList(false, result2));
    }

    public CompletableFuture<SignatureHelp> signatureHelp(SignatureHelpParams params) {
        return CompletableFuture.supplyAsync(() -> {
            Position position;
            int offset;
            WeaveDocumentToolingService toolingService = $this.toolingServices.openDocument(params.getTextDocument().getUri(), true);
            Option<FunctionSignatureResult> maybeResult = toolingService.signatureInfo(offset = toolingService.offsetOf((position = params.getPosition()).getLine(), position.getCharacter()));
            Option<FunctionSignatureResult> option = maybeResult;
            if (option instanceof Some) {
                Some some = (Some)option;
                FunctionSignatureResult signatureResult = (FunctionSignatureResult)some.value();
                SignatureInformation[] signatures = (SignatureInformation[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])signatureResult.signatures())).map((Function1<FunctionSignatureData, SignatureInformation> & Serializable & scala.Serializable)s -> {
                    ParameterInformation[] informations = (ParameterInformation[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])s.parameters())).map((Function1<FunctionParameterData, ParameterInformation> & Serializable & scala.Serializable)p -> new ParameterInformation(new StringBuilder(2).append(p.name()).append(": ").append(p.wtype().toString()).toString(), ""), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ParameterInformation.class)));
                    MarkupContent documentation = (MarkupContent)s.docAsMarkdown().map((Function1<String, MarkupContent> & Serializable & scala.Serializable)d -> new MarkupContent("markdown", d)).orNull(Predef$.MODULE$.$conforms());
                    String arguments = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])informations)).map((Function1<ParameterInformation, String> & Serializable & scala.Serializable)i -> (String)i.getLabel().getLeft(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",");
                    return new SignatureInformation(new StringBuilder(2).append(signatureResult.name()).append("(").append(arguments).append(")").toString(), documentation, Arrays.asList((Object[])informations));
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SignatureInformation.class)));
                int i = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])signatureResult.signatures())).indexWhere((Function1<Object, Object>)(Function1<FunctionSignatureData, Object> & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean(s.active()));
                return new SignatureHelp(Arrays.asList((Object[])signatures), Predef$.MODULE$.int2Integer(i), Predef$.MODULE$.int2Integer(signatureResult.currentArgIndex()));
            }
            if (None$.MODULE$.equals(option)) {
                return new SignatureHelp();
            }
            throw new MatchError(option);
        });
    }

    private Seq<InputDirective> getInputDirectives(Option<AstNode> maybeAstNode) {
        return (Seq)maybeAstNode.collect(new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends AstNode, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof DocumentNode) {
                    DocumentNode documentNode = (DocumentNode)A1;
                    return (B1)documentNode;
                }
                return function1.apply(x1);
            }

            public final boolean isDefinedAt(AstNode x1) {
                AstNode astNode = x1;
                return astNode instanceof DocumentNode;
            }
        }).map((Function1<DocumentNode, Seq> & Serializable & scala.Serializable)documentNode -> (Seq)AstNodeHelper$.MODULE$.getInputs((DocumentNode)documentNode).filter((Function1<InputDirective, Object> & Serializable & scala.Serializable)inputDirective -> BoxesRunTime.boxToBoolean(DataWeaveDocumentService.$anonfun$getInputDirectives$3(inputDirective)))).getOrElse((Function0<Seq> & Serializable & scala.Serializable)() -> Nil$.MODULE$);
    }

    public ArrayList<CodeLens> createMappingTestLense(String url) {
        Serializable serializable;
        ArrayList<CodeLens> lenses = new ArrayList<CodeLens>();
        Option<File> maybeFile = ProjectStructure$.MODULE$.defaultTestSourceFolder(this.projectKind().structure());
        if (maybeFile.isDefined()) {
            Command command = new Command("Create Integration Mapping", this.commandManager.prefixCommandBaseId(Commands$.MODULE$.DW_CREATE_TEST_MAPPING()), Arrays.asList(URLUtils$.MODULE$.toLSPUrl(maybeFile.get()), url));
            serializable = BoxesRunTime.boxToBoolean(lenses.add(new CodeLens(this.docStartRange(), command, null)));
        } else {
            serializable = BoxedUnit.UNIT;
        }
        return lenses;
    }

    public CompletableFuture<List<? extends CodeLens>> codeLens(CodeLensParams params) {
        return CompletableFuture.supplyAsync(() -> DataWeaveDocumentService.$anonfun$codeLens$1(this, params));
    }

    public ArrayList<CodeLens> sampleDataLenses(Option<Scenario> maybeScenario, NameIdentifier nameIdentifier, Seq<InputDirective> inputDirectives, String uri) {
        Serializable serializable;
        ArrayList<CodeLens> lenses = new ArrayList<CodeLens>();
        if (maybeScenario.isEmpty()) {
            Serializable serializable2;
            if (inputDirectives.isEmpty()) {
                Command command = new Command(UserMessages$.MODULE$.defineSampleData(), this.commandManager.prefixCommandBaseId(Commands$.MODULE$.DW_CREATE_SCENARIO()), Arrays.asList(nameIdentifier.name(), Scenario$.MODULE$.PLAYGROUND_SCENARIO()));
                serializable2 = BoxesRunTime.boxToBoolean(lenses.add(new CodeLens(this.docStartRange(), command, null)));
            } else {
                serializable2 = BoxedUnit.UNIT;
            }
            inputDirectives.foreach((Function1<InputDirective, Object> & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean(DataWeaveDocumentService.$anonfun$sampleDataLenses$1(this, nameIdentifier, uri, lenses, id)));
            serializable = BoxedUnit.UNIT;
        } else {
            SampleInput[] scenarioInputs = maybeScenario.get().inputs();
            GenMap inputs = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])scenarioInputs)).groupBy((Function1<SampleInput, String> & Serializable & scala.Serializable)x$1 -> x$1.name());
            if (new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])scenarioInputs)).isEmpty() && inputDirectives.isEmpty()) {
                Command command = new Command(UserMessages$.MODULE$.defineSampleData(), this.commandManager.prefixCommandBaseId(Commands$.MODULE$.DW_CREATE_SCENARIO()), Arrays.asList(nameIdentifier.name(), maybeScenario.get().name()));
                serializable = BoxesRunTime.boxToBoolean(lenses.add(new CodeLens(this.docStartRange(), command, null)));
            } else {
                inputDirectives.foreach(arg_0 -> DataWeaveDocumentService.$anonfun$sampleDataLenses$3(this, (Map)inputs, nameIdentifier, maybeScenario, uri, lenses, arg_0));
                serializable = BoxedUnit.UNIT;
            }
        }
        return lenses;
    }

    private Range docStartRange() {
        Position docStart = new Position(0, 0);
        return new Range(docStart, docStart);
    }

    private CodeLens runMappingLens(NameIdentifier nameIdentifier) {
        Command runMappingCommand = new Command("Run Mapping", this.commandManager.prefixCommandBaseId(Commands$.MODULE$.DW_LAUNCH_MAPPING()), Arrays.asList(nameIdentifier.name(), LaunchConfiguration$.MODULE$.DATA_WEAVE_CONFIG_TYPE_NAME(), "false"));
        return new CodeLens(this.docStartRange(), runMappingCommand, null);
    }

    private String inputFileName(InputDirective id) {
        String extension = (String)id.mime().map((Function1<ContentType, String> & Serializable & scala.Serializable)mime -> {
            String string = mime.mime();
            if ("application/json".equals(string)) {
                return ".json";
            }
            if ("application/java".equals(string)) {
                return ".dwl";
            }
            if ("application/xml".equals(string)) {
                return ".xml";
            }
            if ("application/yaml".equals(string)) {
                return ".yaml";
            }
            if ("application/x-ndjson".equals(string)) {
                return ".ndjson";
            }
            if ("application/octet-stream".equals(string)) {
                return ".bin";
            }
            if ("application/x-java-properties".equals(string)) {
                return ".properties";
            }
            if ("multipart/form-data".equals(string)) {
                return ".multipart";
            }
            if ("multipart/x-www-form-urlencoded".equals(string)) {
                return ".urlencoded";
            }
            if ("application/csv".equals(string) ? true : "text/csv".equals(string)) {
                return ".csv";
            }
            if ("text/plain".equals(string)) {
                return ".txt";
            }
            return new StringBuilder(1).append(".").append(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])string.split("/"))).last()).toString();
        }).orElse((Function0<Option> & Serializable & scala.Serializable)() -> id.dataFormat().map((Function1<DataFormatId, String> & Serializable & scala.Serializable)id -> {
            boolean bl = false;
            String string = null;
            String string2 = id.id();
            if ("text".equals(string2)) {
                return ".txt";
            }
            if ("java".equals(string2)) {
                bl = true;
                string = string2;
                return ".dwl";
            }
            if ("excel".equals(string2)) {
                return ".xlsx";
            }
            if (bl) {
                return ".json";
            }
            if ("binary".equals(string2)) {
                return ".bin";
            }
            return new StringBuilder(1).append(".").append(string2).toString();
        })).getOrElse((Function0<String> & Serializable & scala.Serializable)() -> ".json");
        return new StringBuilder(0).append(id.variable().name()).append(extension).toString();
    }

    private ArrayList<CodeLens> addDocumentationLenses(AstNode ast, String uri) {
        ArrayList<CodeLens> result2 = new ArrayList<CodeLens>();
        Seq<FunctionDirectiveNode> functionNodes = AstNodeHelper$.MODULE$.collectChildrenWith(ast, FunctionDirectiveNode.class);
        ((IterableLike)functionNodes.filter((Function1<FunctionDirectiveNode, Object> & Serializable & scala.Serializable)fd -> BoxesRunTime.boxToBoolean(DataWeaveDocumentService.$anonfun$addDocumentationLenses$1(fd)))).foreach((Function1<FunctionDirectiveNode, Object> & Serializable & scala.Serializable)astNode -> BoxesRunTime.boxToBoolean(DataWeaveDocumentService.$anonfun$addDocumentationLenses$2(this, uri, result2, astNode)));
        return result2;
    }

    private ArrayList<CodeLens> addUnitTestLenses(AstNode ast, String uri) {
        ArrayList<CodeLens> result2;
        block0: {
            result2 = new ArrayList<CodeLens>();
            AstNode astNode2 = ast;
            if (!(astNode2 instanceof ModuleNode)) break block0;
            ModuleNode moduleNode = (ModuleNode)astNode2;
            Seq<FunctionDirectiveNode> topLevelFunctions = AstNodeHelper$.MODULE$.collectDirectChildrenWith(moduleNode, FunctionDirectiveNode.class);
            topLevelFunctions.foreach((Function1<FunctionDirectiveNode, Object> & Serializable & scala.Serializable)astNode -> BoxesRunTime.boxToBoolean(DataWeaveDocumentService.$anonfun$addUnitTestLenses$1(this, uri, result2, astNode)));
        }
        return result2;
    }

    public CompletableFuture<CodeLens> resolveCodeLens(CodeLens unresolved) {
        return CompletableFuture.completedFuture(unresolved);
    }

    public CompletableFuture<List<FoldingRange>> foldingRange(FoldingRangeRequestParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService service = $this.toolingServices.openDocument(params.getTextDocument().getUri(), $this.toolingServices.openDocument$default$2());
            FoldingRange[] regions = (FoldingRange[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])service.foldingRegions())).map((Function1<FoldingRegion, FoldingRange> & Serializable & scala.Serializable)fr -> {
                FoldingRange range = new FoldingRange(fr.location().startPosition().line() - 1, fr.location().endPosition().line() - 1);
                int n = fr.kind();
                String kind = RegionKind$.MODULE$.COMMENTS() == n ? "comment" : "region";
                range.setKind(kind);
                return range;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FoldingRange.class)));
            return Arrays.asList((Object[])regions);
        });
    }

    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        this.logger().log(Level.INFO, new StringBuilder(6).append("code: ").append(params).toString());
        String uri = params.getTextDocument().getUri();
        Option contextMetadata = this.projectKind().metadataProvider().map((Function1<MetadataProvider, ContextMetadata> & Serializable & scala.Serializable)x$2 -> x$2.metadataFor($this.vfs.file(uri), true));
        return CompletableFuture.supplyAsync(() -> {
            Seq actions = this.codeActions().actionsFor(params, contextMetadata).flatMap((Function1<CodeActionProvider, Object> & Serializable & scala.Serializable)actionProvider -> new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])actionProvider.actions(params, contextMetadata))), Seq$.MODULE$.canBuildFrom());
            ArrayList result2 = new ArrayList();
            actions.foreach((Function1<CodeAction, Object> & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean(result2.add(Either.forRight((Object)a))));
            return result2;
        });
    }

    public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem unresolved) {
        return CompletableFuture.completedFuture(unresolved);
    }

    public CompletableFuture<Hover> hover(HoverParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = $this.toolingServices.openDocument(params.getTextDocument().getUri(), true);
            Position position = params.getPosition();
            int offset = toolingService.offsetOf(position.getLine(), position.getCharacter());
            return (Hover)toolingService.hoverResult(offset).map((Function1<HoverMessage, Hover> & Serializable & scala.Serializable)hm -> {
                Hover hoverResult = new Hover();
                boolean x$1 = false;
                boolean x$2 = true;
                boolean x$3 = false;
                Seq x$4 = new $colon$colon<Nothing$>((Nothing$)((Object)"Documentation"), Nil$.MODULE$);
                boolean x$5 = true;
                boolean x$6 = WeaveTypeEmitterConfig$.MODULE$.apply$default$3();
                boolean x$7 = WeaveTypeEmitterConfig$.MODULE$.apply$default$4();
                boolean x$8 = WeaveTypeEmitterConfig$.MODULE$.apply$default$5();
                boolean x$9 = WeaveTypeEmitterConfig$.MODULE$.apply$default$7();
                boolean x$10 = WeaveTypeEmitterConfig$.MODULE$.apply$default$9();
                boolean x$11 = WeaveTypeEmitterConfig$.MODULE$.apply$default$10();
                boolean x$12 = WeaveTypeEmitterConfig$.MODULE$.apply$default$11();
                boolean x$13 = WeaveTypeEmitterConfig$.MODULE$.apply$default$12();
                boolean x$14 = WeaveTypeEmitterConfig$.MODULE$.apply$default$14();
                boolean x$15 = WeaveTypeEmitterConfig$.MODULE$.apply$default$15();
                Option<Object> x$16 = WeaveTypeEmitterConfig$.MODULE$.apply$default$16();
                WeaveTypeEmitterConfig typeEmitterConfig = new WeaveTypeEmitterConfig(x$1, x$2, x$6, x$7, x$8, x$3, x$9, x$5, x$10, x$11, x$12, x$13, x$4, x$14, x$15, x$16);
                String expressionType = (String)Option$.MODULE$.apply(hm.resultType()).map((Function1<WeaveType, String> & Serializable & scala.Serializable)wt -> new StringBuilder(9).append("Type: `").append(wt.toString(typeEmitterConfig)).append("`\n").toString()).getOrElse((Function0<String> & Serializable & scala.Serializable)() -> "");
                String documentation = new StringBuilder(1).append(expressionType).append("\n").append(hm.markdownDocs().getOrElse((Function0<String> & Serializable & scala.Serializable)() -> "")).toString();
                hoverResult.setContents(new MarkupContent("markdown", documentation));
                hoverResult.setRange(LSPConverters$.MODULE$.toRange(hm.weaveLocation()));
                return hoverResult;
            }).orElse((Function0<Option> & Serializable & scala.Serializable)() -> Option$.MODULE$.apply(toolingService.typeOf(offset)).map((Function1<WeaveType, Hover> & Serializable & scala.Serializable)wt -> {
                Hover hoverResult;
                block0: {
                    hoverResult = new Hover();
                    boolean x$17 = false;
                    boolean x$18 = true;
                    boolean x$19 = false;
                    boolean x$20 = true;
                    boolean x$21 = WeaveTypeEmitterConfig$.MODULE$.apply$default$3();
                    boolean x$22 = WeaveTypeEmitterConfig$.MODULE$.apply$default$4();
                    boolean x$23 = WeaveTypeEmitterConfig$.MODULE$.apply$default$5();
                    boolean x$24 = WeaveTypeEmitterConfig$.MODULE$.apply$default$7();
                    boolean x$25 = WeaveTypeEmitterConfig$.MODULE$.apply$default$9();
                    boolean x$26 = WeaveTypeEmitterConfig$.MODULE$.apply$default$10();
                    boolean x$27 = WeaveTypeEmitterConfig$.MODULE$.apply$default$11();
                    boolean x$28 = WeaveTypeEmitterConfig$.MODULE$.apply$default$12();
                    Seq<String> x$29 = WeaveTypeEmitterConfig$.MODULE$.apply$default$13();
                    boolean x$30 = WeaveTypeEmitterConfig$.MODULE$.apply$default$14();
                    boolean x$31 = WeaveTypeEmitterConfig$.MODULE$.apply$default$15();
                    Option<Object> x$32 = WeaveTypeEmitterConfig$.MODULE$.apply$default$16();
                    WeaveTypeEmitterConfig typeEmitterConfig = new WeaveTypeEmitterConfig(x$17, x$18, x$21, x$22, x$23, x$19, x$24, x$20, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32);
                    String expressionType = new StringBuilder(8).append("Type: `").append(wt.toString(typeEmitterConfig)).append("`").toString();
                    hoverResult.setContents(new MarkupContent("markdown", expressionType));
                    if (wt.location().startPosition().index() < 0) break block0;
                    hoverResult.setRange(LSPConverters$.MODULE$.toRange(wt.location()));
                }
                return hoverResult;
            })).orNull(Predef$.MODULE$.$conforms());
        }, this.executor);
    }

    public SymbolKind toSymbolKind(int kind) {
        int n = kind;
        if (SymbolKind$.MODULE$.Array() == n) {
            return SymbolKind.Array;
        }
        if (SymbolKind$.MODULE$.Boolean() == n) {
            return SymbolKind.Boolean;
        }
        if (SymbolKind$.MODULE$.Class() == n) {
            return SymbolKind.Class;
        }
        if (SymbolKind$.MODULE$.Constant() == n) {
            return SymbolKind.Constant;
        }
        if (SymbolKind$.MODULE$.Field() == n) {
            return SymbolKind.Field;
        }
        if (SymbolKind$.MODULE$.Module() == n) {
            return SymbolKind.Module;
        }
        if (SymbolKind$.MODULE$.Property() == n) {
            return SymbolKind.Property;
        }
        if (SymbolKind$.MODULE$.Namespace() == n) {
            return SymbolKind.Namespace;
        }
        if (SymbolKind$.MODULE$.String() == n) {
            return SymbolKind.String;
        }
        if (SymbolKind$.MODULE$.Variable() == n) {
            return SymbolKind.Variable;
        }
        if (SymbolKind$.MODULE$.Constructor() == n) {
            return SymbolKind.Constructor;
        }
        if (SymbolKind$.MODULE$.Enum() == n) {
            return SymbolKind.Enum;
        }
        if (SymbolKind$.MODULE$.Method() == n) {
            return SymbolKind.Method;
        }
        if (SymbolKind$.MODULE$.Function() == n) {
            return SymbolKind.Function;
        }
        if (SymbolKind$.MODULE$.File() == n) {
            return SymbolKind.File;
        }
        if (SymbolKind$.MODULE$.Package() == n) {
            return SymbolKind.Package;
        }
        if (SymbolKind$.MODULE$.Interface() == n) {
            return SymbolKind.Interface;
        }
        return SymbolKind.Property;
    }

    public CompletableFuture<List<Either<org.eclipse.lsp4j.SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        return CompletableFuture.supplyAsync(() -> {
            TextDocumentIdentifier document = params.getTextDocument();
            WeaveDocumentToolingService toolingService = $this.toolingServices.openDocument(document.getUri(), true);
            ArrayList result2 = new ArrayList();
            new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])toolingService.documentSymbol())).foreach((Function1<SymbolInformation, Object> & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean(DataWeaveDocumentService.$anonfun$documentSymbol$2(this, result2, e)));
            return result2;
        }, this.executor);
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> definition(DefinitionParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = $this.toolingServices.openDocument(params.getTextDocument().getUri(), true);
            int offset = toolingService.offsetOf(params.getPosition().getLine(), params.getPosition().getCharacter());
            ArrayList result2 = new ArrayList();
            Link[] definitions = toolingService.definitions(offset);
            new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])definitions)).foreach((Function1<Link, Object> & Serializable & scala.Serializable)ll -> BoxesRunTime.boxToBoolean(DataWeaveDocumentService.$anonfun$definition$2(this, params, result2, ll)));
            return Either.forRight(result2);
        }, this.executor);
    }

    private Option<String> resolveUrl(NameIdentifier moduleName) {
        WeaveResourceResolver resourceResolver = this.vfs.asResourceResolver();
        Option<String> maybeUrl = resourceResolver.resolve(moduleName).map((Function1<WeaveResource, String> & Serializable & scala.Serializable)x$3 -> x$3.url());
        return maybeUrl;
    }

    public CompletableFuture<List<? extends TextEdit>> formatting(DocumentFormattingParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = $this.toolingServices.openDocument(params.getTextDocument().getUri(), true);
            LSPWeaveTextDocument textDocument = new LSPWeaveTextDocument(toolingService);
            toolingService.formatDocument(textDocument, new FormattingOptions(params.getOptions().getTabSize(), params.getOptions().isInsertSpaces()));
            return textDocument.edits();
        }, this.executor);
    }

    public CompletableFuture<List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = $this.toolingServices.openDocument(params.getTextDocument().getUri(), true);
            LSPWeaveTextDocument textDocument = new LSPWeaveTextDocument(toolingService);
            Range range = params.getRange();
            int startOffset = toolingService.offsetOf(range.getStart().getLine(), range.getStart().getCharacter());
            int endOffset = toolingService.offsetOf(range.getEnd().getLine(), range.getEnd().getCharacter());
            toolingService.format(startOffset, endOffset, textDocument, new FormattingOptions(params.getOptions().getTabSize(), params.getOptions().isInsertSpaces()));
            return textDocument.edits();
        }, this.executor);
    }

    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = $this.toolingServices.openDocument(params.getTextDocument().getUri(), true);
            int offset = toolingService.offsetOf(params.getPosition().getLine(), params.getPosition().getCharacter());
            Reference[] ref2 = toolingService.rename(offset, params.getNewName());
            WorkspaceEdit edit = new WorkspaceEdit();
            NameIdentifier localNameIdentifier = toolingService.file().getNameIdentifier();
            GenMap renamesByDocument = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])ref2)).groupBy((Function1<Reference, NameIdentifier> & Serializable & scala.Serializable)ref -> (NameIdentifier)ref.moduleSource().getOrElse((Function0<NameIdentifier> & Serializable & scala.Serializable)() -> localNameIdentifier));
            renamesByDocument.foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)references -> {
                TextEdit[] edits = (TextEdit[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])references._2())).map((Function1<Reference, TextEdit> & Serializable & scala.Serializable)reference -> new TextEdit(LSPConverters$.MODULE$.toRange(reference.referencedNode().location()), params.getNewName()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TextEdit.class)));
                Option<String> maybeUrl = this.resolveUrl((NameIdentifier)references._1());
                Option<String> option = maybeUrl;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String url = (String)some.value();
                    return edit.getChanges().put(url, Arrays.asList((Object[])edits));
                }
                if (None$.MODULE$.equals(option)) {
                    return BoxedUnit.UNIT;
                }
                throw new MatchError(option);
            });
            return edit;
        }, this.executor);
    }

    public CompletableFuture<List<? extends Location>> references(ReferenceParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = $this.toolingServices.openDocument(params.getTextDocument().getUri(), true);
            int offset = toolingService.offsetOf(params.getPosition().getLine(), params.getPosition().getCharacter());
            Reference[] referencesResult = toolingService.references(offset);
            return JavaConverters$.MODULE$.seqAsJavaList(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])referencesResult)).map((Function1<Reference, Location> & Serializable & scala.Serializable)r -> {
                Location location = new Location();
                location.setRange(LSPConverters$.MODULE$.toRange(r.referencedNode().location()));
                String url = r.isLocalReference() ? params.getTextDocument().getUri() : (String)this.resolveUrl(r.moduleSource().get()).getOrElse((Function0<String> & Serializable & scala.Serializable)() -> "");
                location.setUri(url);
                return location;
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef$DummyImplicit$.MODULE$.dummyImplicit())));
        }, this.executor);
    }

    private CompletionItemKind getCompletionType(Suggestion sug) {
        int n = sug.itemType();
        if (SuggestionType$.MODULE$.Class() == n) {
            return CompletionItemKind.Class;
        }
        if (SuggestionType$.MODULE$.Constructor() == n) {
            return CompletionItemKind.Constructor;
        }
        if (SuggestionType$.MODULE$.Field() == n) {
            return CompletionItemKind.Field;
        }
        if (SuggestionType$.MODULE$.Enum() == n) {
            return CompletionItemKind.Enum;
        }
        if (SuggestionType$.MODULE$.Function() == n) {
            return CompletionItemKind.Function;
        }
        if (SuggestionType$.MODULE$.Keyword() == n) {
            return CompletionItemKind.Keyword;
        }
        if (SuggestionType$.MODULE$.Module() == n) {
            return CompletionItemKind.Module;
        }
        if (SuggestionType$.MODULE$.Method() == n) {
            return CompletionItemKind.Method;
        }
        if (SuggestionType$.MODULE$.Property() == n) {
            return CompletionItemKind.Property;
        }
        if (SuggestionType$.MODULE$.Variable() == n) {
            return CompletionItemKind.Variable;
        }
        return CompletionItemKind.Property;
    }

    public static final /* synthetic */ void $anonfun$getSuggestionsAndCreateCompletionList$1(DataWeaveDocumentService $this, IntRef i$1, SuggestionResult suggestionResult$1, WeaveDocumentToolingService toolingService$1, ArrayList result$1, Suggestion sug) {
        String index = Integer.toString(i$1.elem);
        String prefix = new StringOps(Predef$.MODULE$.augmentString("0")).$times(suggestionResult$1.suggestions().length - index.length());
        CompletionItem item = new CompletionItem(sug.name());
        item.setDetail((String)sug.wtype().map((Function1<WeaveType, String> & Serializable & scala.Serializable)wt -> {
            boolean x$1 = false;
            boolean x$2 = true;
            boolean x$3 = true;
            boolean x$4 = false;
            boolean x$5 = false;
            boolean x$6 = WeaveTypeEmitterConfig$.MODULE$.apply$default$5();
            boolean x$7 = WeaveTypeEmitterConfig$.MODULE$.apply$default$7();
            boolean x$8 = WeaveTypeEmitterConfig$.MODULE$.apply$default$8();
            boolean x$9 = WeaveTypeEmitterConfig$.MODULE$.apply$default$9();
            boolean x$10 = WeaveTypeEmitterConfig$.MODULE$.apply$default$10();
            boolean x$11 = WeaveTypeEmitterConfig$.MODULE$.apply$default$11();
            boolean x$12 = WeaveTypeEmitterConfig$.MODULE$.apply$default$12();
            Seq<String> x$13 = WeaveTypeEmitterConfig$.MODULE$.apply$default$13();
            boolean x$14 = WeaveTypeEmitterConfig$.MODULE$.apply$default$14();
            boolean x$15 = WeaveTypeEmitterConfig$.MODULE$.apply$default$15();
            Option<Object> x$16 = WeaveTypeEmitterConfig$.MODULE$.apply$default$16();
            WeaveTypeEmitterConfig emitterConfig = new WeaveTypeEmitterConfig(x$1, x$3, x$4, x$2, x$6, x$5, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
            return wt.toString(emitterConfig);
        }).orNull(Predef$.MODULE$.$conforms()));
        item.setSortText(new StringBuilder(0).append(prefix).append(index).toString());
        item.setDocumentation(new MarkupContent("markdown", (String)sug.markdownDocumentation().getOrElse((Function0<String> & Serializable & scala.Serializable)() -> "")));
        int startIndex = suggestionResult$1.replacementStart();
        int endIndex = suggestionResult$1.replacementEnd();
        org.mule.weave.v2.parser.location.Position startPosition = toolingService$1.file().asResource().positionOf(startIndex);
        org.mule.weave.v2.parser.location.Position endPosition = toolingService$1.file().asResource().positionOf(endIndex);
        TextEdit edit = new TextEdit(new Range(LSPConverters$.MODULE$.toPosition(startPosition), LSPConverters$.MODULE$.toPosition(endPosition)), sug.template().toVSCodeString());
        item.setTextEdit(Either.forLeft((Object)edit));
        item.setFilterText(sug.template().toVSCodeString());
        item.setInsertTextFormat(InsertTextFormat.Snippet);
        item.setKind($this.getCompletionType(sug));
        result$1.add(item);
        ++i$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$getInputDirectives$3(InputDirective inputDirective) {
        return !NameIdentifier$.MODULE$.INSERTED_FAKE_VARIABLE().equals(inputDirective.variable()) && AstNodeHelper$.MODULE$.notInjectedNode(inputDirective);
    }

    public static final /* synthetic */ boolean $anonfun$codeLens$2(DataWeaveDocumentService $this, ArrayList result$2, String uri$1, AstNode ast) {
        result$2.addAll($this.addDocumentationLenses(ast, uri$1));
        return result$2.addAll($this.addUnitTestLenses(ast, uri$1));
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ List $anonfun$codeLens$1(DataWeaveDocumentService $this, CodeLensParams params$2) {
        block4: {
            block6: {
                block5: {
                    uri = params$2.getTextDocument().getUri();
                    result = new ArrayList<CodeLens>();
                    documentToolingService = $this.toolingServices.openDocument(params$2.getTextDocument().getUri(), true);
                    nameIdentifier = documentToolingService.file().getNameIdentifier();
                    maybeAstNode = documentToolingService.ast();
                    maybeString = WeaveASTQueryUtils$.MODULE$.fileKind(maybeAstNode);
                    if (documentToolingService.file().readOnly()) break block4;
                    var9_8 = false;
                    var10_9 = null;
                    var11_10 = maybeString;
                    if (!(var11_10 instanceof Some)) break block5;
                    var9_8 = true;
                    var10_9 = (Some)var11_10;
                    var12_11 = (String)var10_9.value();
                    v0 = WeaveASTQueryUtils$.MODULE$.MODULE();
                    var13_12 = var12_11;
                    if (v0 != null ? v0.equals(var13_12) == false : var13_12 != null) break block5;
                    BoxesRunTime.boxToBoolean(result.addAll($this.createMappingTestLense(documentToolingService.file().url())));
                    break block6;
                }
                if (!var9_8) ** GOTO lbl-1000
                var14_13 = (String)var10_9.value();
                v1 = WeaveASTQueryUtils$.MODULE$.MAPPING();
                var15_14 = var14_13;
                if (!(v1 != null ? v1.equals(var15_14) == false : var15_14 != null)) {
                    maybeScenario = $this.scenariosService.activeScenario(nameIdentifier);
                    inputDirectives = $this.getInputDirectives(maybeAstNode);
                    result.addAll($this.sampleDataLenses(maybeScenario, nameIdentifier, inputDirectives, uri));
                    BoxesRunTime.boxToBoolean(result.add($this.runMappingLens(nameIdentifier)));
                } else if (var9_8) {
                    var18_17 = (String)var10_9.value();
                    v2 = WeaveASTQueryUtils$.MODULE$.BAT();
                    var19_18 = var18_17;
                    if (!(v2 != null ? v2.equals(var19_18) == false : var19_18 != null)) {
                        command = new Command("Run BAT Test", $this.commandManager.prefixCommandBaseId(Commands$.MODULE$.DW_LAUNCH_MAPPING()), Arrays.asList(new Object[]{nameIdentifier.name(), LaunchConfiguration$.MODULE$.BAT_CONFIG_TYPE_NAME(), "false"}));
                        BoxesRunTime.boxToBoolean(result.add(new CodeLens($this.docStartRange(), command, null)));
                    }
                }
            }
            maybeAstNode.foreach((Function1<AstNode, Object> & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$codeLens$2$adapted(org.mule.weave.lsp.services.DataWeaveDocumentService java.util.ArrayList java.lang.String org.mule.weave.v2.parser.ast.AstNode ), (Lorg/mule/weave/v2/parser/ast/AstNode;)Ljava/lang/Object;)((DataWeaveDocumentService)$this, result, (String)uri));
        }
        return result;
    }

    public static final /* synthetic */ boolean $anonfun$sampleDataLenses$1(DataWeaveDocumentService $this, NameIdentifier nameIdentifier$1, String uri$2, ArrayList lenses$1, InputDirective id) {
        Command command = new Command(UserMessages$.MODULE$.defineSampleData(), $this.commandManager.prefixCommandBaseId(Commands$.MODULE$.DW_CREATE_INPUT_SAMPLE()), Arrays.asList(nameIdentifier$1.name(), Scenario$.MODULE$.PLAYGROUND_SCENARIO(), uri$2, id.variable().name(), $this.inputFileName(id)));
        return lenses$1.add(new CodeLens(LSPConverters$.MODULE$.toRange(id.location()), command, null));
    }

    public static final /* synthetic */ Object $anonfun$sampleDataLenses$3(DataWeaveDocumentService $this, Map inputs$1, NameIdentifier nameIdentifier$1, Option maybeScenario$1, String uri$2, ArrayList lenses$1, InputDirective id) {
        if (!inputs$1.contains(id.variable().name())) {
            Command command = new Command(UserMessages$.MODULE$.defineSampleData(), $this.commandManager.prefixCommandBaseId(Commands$.MODULE$.DW_CREATE_INPUT_SAMPLE()), Arrays.asList(nameIdentifier$1.name(), ((Scenario)maybeScenario$1.get()).name(), uri$2, id.variable().name(), $this.inputFileName(id)));
            return BoxesRunTime.boxToBoolean(lenses$1.add(new CodeLens(LSPConverters$.MODULE$.toRange(id.location()), command, null)));
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$addDocumentationLenses$1(FunctionDirectiveNode fd) {
        return fd.weaveDoc().isEmpty() && !(fd.literal() instanceof OverloadedFunctionNode);
    }

    public static final /* synthetic */ boolean $anonfun$addDocumentationLenses$2(DataWeaveDocumentService $this, String uri$3, ArrayList result$3, FunctionDirectiveNode astNode) {
        Command command = InsertDocumentationCommand$.MODULE$.createCommand(uri$3, astNode, $this.commandManager);
        Range range = new Range(LSPConverters$.MODULE$.toPosition(astNode.location().startPosition()), LSPConverters$.MODULE$.toPosition(astNode.location().startPosition()));
        return result$3.add(new CodeLens(range, command, null));
    }

    public static final /* synthetic */ boolean $anonfun$addUnitTestLenses$1(DataWeaveDocumentService $this, String uri$4, ArrayList result$4, FunctionDirectiveNode astNode) {
        Command command = CreateUnitTest$.MODULE$.createCommand(uri$4, astNode, $this.commandManager);
        Range range = new Range(LSPConverters$.MODULE$.toPosition(astNode.location().startPosition()), LSPConverters$.MODULE$.toPosition(astNode.location().startPosition()));
        return result$4.add(new CodeLens(range, command, null));
    }

    public static final /* synthetic */ boolean $anonfun$documentSymbol$2(DataWeaveDocumentService $this, ArrayList result$6, SymbolInformation e) {
        DocumentSymbol symbol = new DocumentSymbol();
        symbol.setName(e.name());
        symbol.setSelectionRange(LSPConverters$.MODULE$.toRange(e.location()));
        symbol.setRange(LSPConverters$.MODULE$.toRange(e.location()));
        symbol.setKind($this.toSymbolKind(e.kind()));
        return result$6.add(Either.forRight((Object)symbol));
    }

    public static final /* synthetic */ boolean $anonfun$definition$4(Link ll$1, SampleInput sampleInput) {
        return sampleInput.name().equals(ll$1.linkLocation().name());
    }

    public static final /* synthetic */ void $anonfun$definition$5(LocationLink link$1, SampleInput sampleInput) {
        Position position = new Position(0, 0);
        link$1.setTargetRange(new Range(position, position));
        link$1.setTargetSelectionRange(new Range(position, position));
        link$1.setTargetUri(sampleInput.uri());
    }

    public static final /* synthetic */ void $anonfun$definition$3(Link ll$1, LocationLink link$1, Scenario activeScenario) {
        new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])activeScenario.inputs())).find((Function1<Object, Object>)(Function1<SampleInput, Object> & Serializable & scala.Serializable)sampleInput -> BoxesRunTime.boxToBoolean(DataWeaveDocumentService.$anonfun$definition$4(ll$1, sampleInput))).foreach((Function1<SampleInput, Object> & Serializable & scala.Serializable)sampleInput -> {
            DataWeaveDocumentService.$anonfun$definition$5(link$1, sampleInput);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$definition$2(DataWeaveDocumentService $this, DefinitionParams params$7, ArrayList result$7, Link ll) {
        LocationLink link = new LocationLink();
        link.setOriginSelectionRange(LSPConverters$.MODULE$.toRange(ll.linkLocation().location()));
        Reference reference = ll.reference();
        link.setTargetRange(LSPConverters$.MODULE$.toRange(reference.referencedNode().location()));
        link.setTargetSelectionRange(LSPConverters$.MODULE$.toRange(reference.referencedNode().location()));
        if (reference.isLocalReference()) {
            link.setTargetUri(params$7.getTextDocument().getUri());
            $this.scenariosService.activeScenario($this.vfs.file(params$7.getTextDocument().getUri()).getNameIdentifier()).foreach((Function1<Scenario, Object> & Serializable & scala.Serializable)activeScenario -> {
                DataWeaveDocumentService.$anonfun$definition$3(ll, link, activeScenario);
                return BoxedUnit.UNIT;
            });
        } else {
            NameIdentifier moduleName = reference.moduleSource().get();
            Option<String> maybeUrl = $this.resolveUrl(moduleName);
            Option<String> option = maybeUrl;
            if (option instanceof Some) {
                Some some = (Some)option;
                String url = (String)some.value();
                link.setTargetUri(url);
            } else if (None$.MODULE$.equals(option)) {
                $this.logger().log(Level.INFO, new StringBuilder(23).append("Resource not found for ").append(moduleName).toString());
            } else {
                throw new MatchError(option);
            }
        }
        return result$7.add(link);
    }

    public DataWeaveDocumentService(DataWeaveToolingService toolingServices, Executor executor, ProjectVirtualFileSystem projectFS, WeaveScenarioManagerService scenariosService, VirtualFileSystem vfs, CommandManager commandManager) {
        this.toolingServices = toolingServices;
        this.executor = executor;
        this.projectFS = projectFS;
        this.scenariosService = scenariosService;
        this.vfs = vfs;
        this.commandManager = commandManager;
        ToolingService.$init$(this);
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    public static final /* synthetic */ Object $anonfun$codeLens$2$adapted(DataWeaveDocumentService $this, ArrayList result$2, String uri$1, AstNode ast) {
        return BoxesRunTime.boxToBoolean(DataWeaveDocumentService.$anonfun$codeLens$2($this, result$2, uri$1, ast));
    }
}

